% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_analysis}
\alias{quicksight_update_analysis}
\title{Updates an analysis in Amazon QuickSight}
\usage{
quicksight_update_analysis(
  AwsAccountId,
  AnalysisId,
  Name,
  Parameters = NULL,
  SourceEntity,
  ThemeArn = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the Amazon Web Services account that contains the analysis
that you're updating.}

\item{AnalysisId}{[required] The ID for the analysis that you're updating. This ID displays in the
URL of the analysis.}

\item{Name}{[required] A descriptive name for the analysis that you're updating. This name
displays for the analysis in the Amazon QuickSight console.}

\item{Parameters}{The parameter names and override values that you want to use. An
analysis can have any parameter type, and some parameters might accept
multiple values.}

\item{SourceEntity}{[required] A source entity to use for the analysis that you're updating. This
metadata structure contains details that describe a source template and
one or more datasets.}

\item{ThemeArn}{The Amazon Resource Name (ARN) for the theme to apply to the analysis
that you're creating. To see the theme in the Amazon QuickSight console,
make sure that you have access to it.}
}
\description{
Updates an analysis in Amazon QuickSight

See \url{https://paws-r.github.io/docs/quicksight/update_analysis.html} for full documentation.
}
\keyword{internal}
