% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_analysis}
\alias{quicksight_create_analysis}
\title{Creates an analysis in Amazon QuickSight}
\usage{
quicksight_create_analysis(
  AwsAccountId,
  AnalysisId,
  Name,
  Parameters = NULL,
  Permissions = NULL,
  SourceEntity = NULL,
  ThemeArn = NULL,
  Tags = NULL,
  Definition = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the Amazon Web Services account where you are creating an
analysis.}

\item{AnalysisId}{[required] The ID for the analysis that you're creating. This ID displays in the
URL of the analysis.}

\item{Name}{[required] A descriptive name for the analysis that you're creating. This name
displays for the analysis in the Amazon QuickSight console.}

\item{Parameters}{The parameter names and override values that you want to use. An
analysis can have any parameter type, and some parameters might accept
multiple values.}

\item{Permissions}{A structure that describes the principals and the resource-level
permissions on an analysis. You can use the \code{Permissions} structure to
grant permissions by providing a list of Identity and Access Management
(IAM) action information for each principal listed by Amazon Resource
Name (ARN).

To specify no permissions, omit \code{Permissions}.}

\item{SourceEntity}{A source entity to use for the analysis that you're creating. This
metadata structure contains details that describe a source template and
one or more datasets.

Either a \code{SourceEntity} or a \code{Definition} must be provided in order for
the request to be valid.}

\item{ThemeArn}{The ARN for the theme to apply to the analysis that you're creating. To
see the theme in the Amazon QuickSight console, make sure that you have
access to it.}

\item{Tags}{Contains a map of the key-value pairs for the resource tag or tags
assigned to the analysis.}

\item{Definition}{The definition of an analysis.

A definition is the data model of all features in a Dashboard, Template,
or Analysis.

Either a \code{SourceEntity} or a \code{Definition} must be provided in order for
the request to be valid.}
}
\description{
Creates an analysis in Amazon QuickSight. Analyses can be created either from a template or from an \code{AnalysisDefinition}.

See \url{https://www.paws-r-sdk.com/docs/quicksight_create_analysis/} for full documentation.
}
\keyword{internal}
