% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_update_job_from_source_control}
\alias{glue_update_job_from_source_control}
\title{Synchronizes a job from the source control repository}
\usage{
glue_update_job_from_source_control(
  JobName = NULL,
  Provider = NULL,
  RepositoryName = NULL,
  RepositoryOwner = NULL,
  BranchName = NULL,
  Folder = NULL,
  CommitId = NULL,
  AuthStrategy = NULL,
  AuthToken = NULL
)
}
\arguments{
\item{JobName}{The name of the Glue job to be synchronized to or from the remote
repository.}

\item{Provider}{The provider for the remote repository.}

\item{RepositoryName}{The name of the remote repository that contains the job artifacts.}

\item{RepositoryOwner}{The owner of the remote repository that contains the job artifacts.}

\item{BranchName}{An optional branch in the remote repository.}

\item{Folder}{An optional folder in the remote repository.}

\item{CommitId}{A commit ID for a commit in the remote repository.}

\item{AuthStrategy}{The type of authentication, which can be an authentication token stored
in Amazon Web Services Secrets Manager, or a personal access token.}

\item{AuthToken}{The value of the authorization token.}
}
\description{
Synchronizes a job from the source control repository. This operation takes the job artifacts that are located in the remote repository and updates the Glue internal stores with these artifacts.

See \url{https://www.paws-r-sdk.com/docs/glue_update_job_from_source_control/} for full documentation.
}
\keyword{internal}
