# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include opensearchserviceserverless_service.R
NULL

#' Returns attributes for one or more collections, including the collection
#' endpoint and the OpenSearch Dashboards endpoint
#'
#' @description
#' Returns attributes for one or more collections, including the collection endpoint and the OpenSearch Dashboards endpoint. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_batch_get_collection/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_batch_get_collection/) for full documentation.
#'
#' @param ids A list of collection IDs. You can't provide names and IDs in the same
#' request. The ID is part of the collection endpoint. You can also
#' retrieve it using the
#' [`list_collections`][opensearchserviceserverless_list_collections] API.
#' @param names A list of collection names. You can't provide names and IDs in the same
#' request.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_batch_get_collection
opensearchserviceserverless_batch_get_collection <- function(ids = NULL, names = NULL) {
  op <- new_operation(
    name = "BatchGetCollection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$batch_get_collection_input(ids = ids, names = names)
  output <- .opensearchserviceserverless$batch_get_collection_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$batch_get_collection <- opensearchserviceserverless_batch_get_collection

#' Returns a list of successful and failed retrievals for the OpenSearch
#' Serverless indexes
#'
#' @description
#' Returns a list of successful and failed retrievals for the OpenSearch Serverless indexes. For more information, see [Viewing data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_batch_get_effective_lifecycle_policy/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_batch_get_effective_lifecycle_policy/) for full documentation.
#'
#' @param resourceIdentifiers &#91;required&#93; The unique identifiers of policy types and resource names.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_batc_get_effe_life_poli
opensearchserviceserverless_batch_get_effective_lifecycle_policy <- function(resourceIdentifiers) {
  op <- new_operation(
    name = "BatchGetEffectiveLifecyclePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$batch_get_effective_lifecycle_policy_input(resourceIdentifiers = resourceIdentifiers)
  output <- .opensearchserviceserverless$batch_get_effective_lifecycle_policy_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$batch_get_effective_lifecycle_policy <- opensearchserviceserverless_batch_get_effective_lifecycle_policy

#' Returns one or more configured OpenSearch Serverless lifecycle policies
#'
#' @description
#' Returns one or more configured OpenSearch Serverless lifecycle policies. For more information, see [Viewing data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_batch_get_lifecycle_policy/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_batch_get_lifecycle_policy/) for full documentation.
#'
#' @param identifiers &#91;required&#93; The unique identifiers of policy types and policy names.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_batch_get_lifecycle_policy
opensearchserviceserverless_batch_get_lifecycle_policy <- function(identifiers) {
  op <- new_operation(
    name = "BatchGetLifecyclePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$batch_get_lifecycle_policy_input(identifiers = identifiers)
  output <- .opensearchserviceserverless$batch_get_lifecycle_policy_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$batch_get_lifecycle_policy <- opensearchserviceserverless_batch_get_lifecycle_policy

#' Returns attributes for one or more VPC endpoints associated with the
#' current account
#'
#' @description
#' Returns attributes for one or more VPC endpoints associated with the current account. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_batch_get_vpc_endpoint/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_batch_get_vpc_endpoint/) for full documentation.
#'
#' @param ids &#91;required&#93; A list of VPC endpoint identifiers.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_batch_get_vpc_endpoint
opensearchserviceserverless_batch_get_vpc_endpoint <- function(ids) {
  op <- new_operation(
    name = "BatchGetVpcEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$batch_get_vpc_endpoint_input(ids = ids)
  output <- .opensearchserviceserverless$batch_get_vpc_endpoint_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$batch_get_vpc_endpoint <- opensearchserviceserverless_batch_get_vpc_endpoint

#' Creates a data access policy for OpenSearch Serverless
#'
#' @description
#' Creates a data access policy for OpenSearch Serverless. Access policies limit access to collections and the resources within them, and allow a user to access that data irrespective of the access mechanism or network source. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_create_access_policy/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_create_access_policy/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param description A description of the policy. Typically used to store information about
#' the permissions defined in the policy.
#' @param name &#91;required&#93; The name of the policy.
#' @param policy &#91;required&#93; The JSON policy document to use as the content for the policy.
#' @param type &#91;required&#93; The type of policy.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_create_access_policy
opensearchserviceserverless_create_access_policy <- function(clientToken = NULL, description = NULL, name, policy, type) {
  op <- new_operation(
    name = "CreateAccessPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$create_access_policy_input(clientToken = clientToken, description = description, name = name, policy = policy, type = type)
  output <- .opensearchserviceserverless$create_access_policy_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$create_access_policy <- opensearchserviceserverless_create_access_policy

#' Creates a new OpenSearch Serverless collection
#'
#' @description
#' Creates a new OpenSearch Serverless collection. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_create_collection/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_create_collection/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param description Description of the collection.
#' @param name &#91;required&#93; Name of the collection.
#' @param standbyReplicas Indicates whether standby replicas should be used for a collection.
#' @param tags An arbitrary set of tags (key–value pairs) to associate with the
#' OpenSearch Serverless collection.
#' @param type The type of collection.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_create_collection
opensearchserviceserverless_create_collection <- function(clientToken = NULL, description = NULL, name, standbyReplicas = NULL, tags = NULL, type = NULL) {
  op <- new_operation(
    name = "CreateCollection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$create_collection_input(clientToken = clientToken, description = description, name = name, standbyReplicas = standbyReplicas, tags = tags, type = type)
  output <- .opensearchserviceserverless$create_collection_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$create_collection <- opensearchserviceserverless_create_collection

#' Creates a lifecyle policy to be applied to OpenSearch Serverless indexes
#'
#' @description
#' Creates a lifecyle policy to be applied to OpenSearch Serverless indexes. Lifecycle policies define the number of days or hours to retain the data on an OpenSearch Serverless index. For more information, see [Creating data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-create).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_create_lifecycle_policy/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_create_lifecycle_policy/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure idempotency of the
#' request.
#' @param description A description of the lifecycle policy.
#' @param name &#91;required&#93; The name of the lifecycle policy.
#' @param policy &#91;required&#93; The JSON policy document to use as the content for the lifecycle policy.
#' @param type &#91;required&#93; The type of lifecycle policy.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_create_lifecycle_policy
opensearchserviceserverless_create_lifecycle_policy <- function(clientToken = NULL, description = NULL, name, policy, type) {
  op <- new_operation(
    name = "CreateLifecyclePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$create_lifecycle_policy_input(clientToken = clientToken, description = description, name = name, policy = policy, type = type)
  output <- .opensearchserviceserverless$create_lifecycle_policy_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$create_lifecycle_policy <- opensearchserviceserverless_create_lifecycle_policy

#' Specifies a security configuration for OpenSearch Serverless
#'
#' @description
#' Specifies a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_create_security_config/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_create_security_config/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param description A description of the security configuration.
#' @param name &#91;required&#93; The name of the security configuration.
#' @param samlOptions Describes SAML options in in the form of a key-value map. This field is
#' required if you specify `saml` for the `type` parameter.
#' @param type &#91;required&#93; The type of security configuration.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_create_security_config
opensearchserviceserverless_create_security_config <- function(clientToken = NULL, description = NULL, name, samlOptions = NULL, type) {
  op <- new_operation(
    name = "CreateSecurityConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$create_security_config_input(clientToken = clientToken, description = description, name = name, samlOptions = samlOptions, type = type)
  output <- .opensearchserviceserverless$create_security_config_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$create_security_config <- opensearchserviceserverless_create_security_config

#' Creates a security policy to be used by one or more OpenSearch
#' Serverless collections
#'
#' @description
#' Creates a security policy to be used by one or more OpenSearch Serverless collections. Security policies provide access to a collection and its OpenSearch Dashboards endpoint from public networks or specific VPC endpoints. They also allow you to secure a collection with a KMS encryption key. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_create_security_policy/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_create_security_policy/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param description A description of the policy. Typically used to store information about
#' the permissions defined in the policy.
#' @param name &#91;required&#93; The name of the policy.
#' @param policy &#91;required&#93; The JSON policy document to use as the content for the new policy.
#' @param type &#91;required&#93; The type of security policy.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_create_security_policy
opensearchserviceserverless_create_security_policy <- function(clientToken = NULL, description = NULL, name, policy, type) {
  op <- new_operation(
    name = "CreateSecurityPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$create_security_policy_input(clientToken = clientToken, description = description, name = name, policy = policy, type = type)
  output <- .opensearchserviceserverless$create_security_policy_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$create_security_policy <- opensearchserviceserverless_create_security_policy

#' Creates an OpenSearch Serverless-managed interface VPC endpoint
#'
#' @description
#' Creates an OpenSearch Serverless-managed interface VPC endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_create_vpc_endpoint/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_create_vpc_endpoint/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param name &#91;required&#93; The name of the interface endpoint.
#' @param securityGroupIds The unique identifiers of the security groups that define the ports,
#' protocols, and sources for inbound traffic that you are authorizing into
#' your endpoint.
#' @param subnetIds &#91;required&#93; The ID of one or more subnets from which you'll access OpenSearch
#' Serverless.
#' @param vpcId &#91;required&#93; The ID of the VPC from which you'll access OpenSearch Serverless.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_create_vpc_endpoint
opensearchserviceserverless_create_vpc_endpoint <- function(clientToken = NULL, name, securityGroupIds = NULL, subnetIds, vpcId) {
  op <- new_operation(
    name = "CreateVpcEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$create_vpc_endpoint_input(clientToken = clientToken, name = name, securityGroupIds = securityGroupIds, subnetIds = subnetIds, vpcId = vpcId)
  output <- .opensearchserviceserverless$create_vpc_endpoint_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$create_vpc_endpoint <- opensearchserviceserverless_create_vpc_endpoint

#' Deletes an OpenSearch Serverless access policy
#'
#' @description
#' Deletes an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_delete_access_policy/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_delete_access_policy/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param name &#91;required&#93; The name of the policy to delete.
#' @param type &#91;required&#93; The type of policy.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_delete_access_policy
opensearchserviceserverless_delete_access_policy <- function(clientToken = NULL, name, type) {
  op <- new_operation(
    name = "DeleteAccessPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$delete_access_policy_input(clientToken = clientToken, name = name, type = type)
  output <- .opensearchserviceserverless$delete_access_policy_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$delete_access_policy <- opensearchserviceserverless_delete_access_policy

#' Deletes an OpenSearch Serverless collection
#'
#' @description
#' Deletes an OpenSearch Serverless collection. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_delete_collection/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_delete_collection/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure idempotency of the
#' request.
#' @param id &#91;required&#93; The unique identifier of the collection. For example, `1iu5usc406kd`.
#' The ID is part of the collection endpoint. You can also retrieve it
#' using the
#' [`list_collections`][opensearchserviceserverless_list_collections] API.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_delete_collection
opensearchserviceserverless_delete_collection <- function(clientToken = NULL, id) {
  op <- new_operation(
    name = "DeleteCollection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$delete_collection_input(clientToken = clientToken, id = id)
  output <- .opensearchserviceserverless$delete_collection_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$delete_collection <- opensearchserviceserverless_delete_collection

#' Deletes an OpenSearch Serverless lifecycle policy
#'
#' @description
#' Deletes an OpenSearch Serverless lifecycle policy. For more information, see [Deleting data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-delete).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_delete_lifecycle_policy/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_delete_lifecycle_policy/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param name &#91;required&#93; The name of the policy to delete.
#' @param type &#91;required&#93; The type of lifecycle policy.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_delete_lifecycle_policy
opensearchserviceserverless_delete_lifecycle_policy <- function(clientToken = NULL, name, type) {
  op <- new_operation(
    name = "DeleteLifecyclePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$delete_lifecycle_policy_input(clientToken = clientToken, name = name, type = type)
  output <- .opensearchserviceserverless$delete_lifecycle_policy_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$delete_lifecycle_policy <- opensearchserviceserverless_delete_lifecycle_policy

#' Deletes a security configuration for OpenSearch Serverless
#'
#' @description
#' Deletes a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_delete_security_config/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_delete_security_config/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param id &#91;required&#93; The security configuration identifier. For SAML the ID will be
#' `saml/<accountId>/<idpProviderName>`. For example,
#' `saml/123456789123/OKTADev`.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_delete_security_config
opensearchserviceserverless_delete_security_config <- function(clientToken = NULL, id) {
  op <- new_operation(
    name = "DeleteSecurityConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$delete_security_config_input(clientToken = clientToken, id = id)
  output <- .opensearchserviceserverless$delete_security_config_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$delete_security_config <- opensearchserviceserverless_delete_security_config

#' Deletes an OpenSearch Serverless security policy
#'
#' @description
#' Deletes an OpenSearch Serverless security policy.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_delete_security_policy/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_delete_security_policy/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param name &#91;required&#93; The name of the policy to delete.
#' @param type &#91;required&#93; The type of policy.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_delete_security_policy
opensearchserviceserverless_delete_security_policy <- function(clientToken = NULL, name, type) {
  op <- new_operation(
    name = "DeleteSecurityPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$delete_security_policy_input(clientToken = clientToken, name = name, type = type)
  output <- .opensearchserviceserverless$delete_security_policy_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$delete_security_policy <- opensearchserviceserverless_delete_security_policy

#' Deletes an OpenSearch Serverless-managed interface endpoint
#'
#' @description
#' Deletes an OpenSearch Serverless-managed interface endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_delete_vpc_endpoint/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_delete_vpc_endpoint/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param id &#91;required&#93; The VPC endpoint identifier.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_delete_vpc_endpoint
opensearchserviceserverless_delete_vpc_endpoint <- function(clientToken = NULL, id) {
  op <- new_operation(
    name = "DeleteVpcEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$delete_vpc_endpoint_input(clientToken = clientToken, id = id)
  output <- .opensearchserviceserverless$delete_vpc_endpoint_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$delete_vpc_endpoint <- opensearchserviceserverless_delete_vpc_endpoint

#' Returns an OpenSearch Serverless access policy
#'
#' @description
#' Returns an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_get_access_policy/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_get_access_policy/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the access policy.
#' @param type &#91;required&#93; Tye type of policy. Currently, the only supported value is `data`.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_get_access_policy
opensearchserviceserverless_get_access_policy <- function(name, type) {
  op <- new_operation(
    name = "GetAccessPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$get_access_policy_input(name = name, type = type)
  output <- .opensearchserviceserverless$get_access_policy_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$get_access_policy <- opensearchserviceserverless_get_access_policy

#' Returns account-level settings related to OpenSearch Serverless
#'
#' @description
#' Returns account-level settings related to OpenSearch Serverless.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_get_account_settings/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_get_account_settings/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_get_account_settings
opensearchserviceserverless_get_account_settings <- function() {
  op <- new_operation(
    name = "GetAccountSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$get_account_settings_input()
  output <- .opensearchserviceserverless$get_account_settings_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$get_account_settings <- opensearchserviceserverless_get_account_settings

#' Returns statistical information about your OpenSearch Serverless access
#' policies, security configurations, and security policies
#'
#' @description
#' Returns statistical information about your OpenSearch Serverless access policies, security configurations, and security policies.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_get_policies_stats/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_get_policies_stats/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_get_policies_stats
opensearchserviceserverless_get_policies_stats <- function() {
  op <- new_operation(
    name = "GetPoliciesStats",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$get_policies_stats_input()
  output <- .opensearchserviceserverless$get_policies_stats_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$get_policies_stats <- opensearchserviceserverless_get_policies_stats

#' Returns information about an OpenSearch Serverless security
#' configuration
#'
#' @description
#' Returns information about an OpenSearch Serverless security configuration. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_get_security_config/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_get_security_config/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier of the security configuration.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_get_security_config
opensearchserviceserverless_get_security_config <- function(id) {
  op <- new_operation(
    name = "GetSecurityConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$get_security_config_input(id = id)
  output <- .opensearchserviceserverless$get_security_config_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$get_security_config <- opensearchserviceserverless_get_security_config

#' Returns information about a configured OpenSearch Serverless security
#' policy
#'
#' @description
#' Returns information about a configured OpenSearch Serverless security policy. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_get_security_policy/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_get_security_policy/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the security policy.
#' @param type &#91;required&#93; The type of security policy.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_get_security_policy
opensearchserviceserverless_get_security_policy <- function(name, type) {
  op <- new_operation(
    name = "GetSecurityPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$get_security_policy_input(name = name, type = type)
  output <- .opensearchserviceserverless$get_security_policy_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$get_security_policy <- opensearchserviceserverless_get_security_policy

#' Returns information about a list of OpenSearch Serverless access
#' policies
#'
#' @description
#' Returns information about a list of OpenSearch Serverless access policies.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_list_access_policies/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_list_access_policies/) for full documentation.
#'
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results. The
#' default is 20.
#' @param nextToken If your initial
#' [`list_access_policies`][opensearchserviceserverless_list_access_policies]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`list_access_policies`][opensearchserviceserverless_list_access_policies]
#' operations, which returns results in the next page.
#' @param resource Resource filters (can be collections or indexes) that policies can apply
#' to.
#' @param type &#91;required&#93; The type of access policy.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_list_access_policies
opensearchserviceserverless_list_access_policies <- function(maxResults = NULL, nextToken = NULL, resource = NULL, type) {
  op <- new_operation(
    name = "ListAccessPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .opensearchserviceserverless$list_access_policies_input(maxResults = maxResults, nextToken = nextToken, resource = resource, type = type)
  output <- .opensearchserviceserverless$list_access_policies_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$list_access_policies <- opensearchserviceserverless_list_access_policies

#' Lists all OpenSearch Serverless collections
#'
#' @description
#' Lists all OpenSearch Serverless collections. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_list_collections/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_list_collections/) for full documentation.
#'
#' @param collectionFilters A list of filter names and values that you can use for requests.
#' @param maxResults The maximum number of results to return. Default is 20. You can use
#' `nextToken` to get the next page of results.
#' @param nextToken If your initial
#' [`list_collections`][opensearchserviceserverless_list_collections]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`list_collections`][opensearchserviceserverless_list_collections]
#' operations, which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_list_collections
opensearchserviceserverless_list_collections <- function(collectionFilters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListCollections",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .opensearchserviceserverless$list_collections_input(collectionFilters = collectionFilters, maxResults = maxResults, nextToken = nextToken)
  output <- .opensearchserviceserverless$list_collections_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$list_collections <- opensearchserviceserverless_list_collections

#' Returns a list of OpenSearch Serverless lifecycle policies
#'
#' @description
#' Returns a list of OpenSearch Serverless lifecycle policies. For more information, see [Viewing data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_list_lifecycle_policies/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_list_lifecycle_policies/) for full documentation.
#'
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. You can use use `nextToken` to get the next page of results. The
#' default is 10.
#' @param nextToken If your initial
#' [`list_lifecycle_policies`][opensearchserviceserverless_list_lifecycle_policies]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`list_lifecycle_policies`][opensearchserviceserverless_list_lifecycle_policies]
#' operations, which returns results in the next page.
#' @param resources Resource filters that policies can apply to. Currently, the only
#' supported resource type is `index`.
#' @param type &#91;required&#93; The type of lifecycle policy.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_list_lifecycle_policies
opensearchserviceserverless_list_lifecycle_policies <- function(maxResults = NULL, nextToken = NULL, resources = NULL, type) {
  op <- new_operation(
    name = "ListLifecyclePolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .opensearchserviceserverless$list_lifecycle_policies_input(maxResults = maxResults, nextToken = nextToken, resources = resources, type = type)
  output <- .opensearchserviceserverless$list_lifecycle_policies_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$list_lifecycle_policies <- opensearchserviceserverless_list_lifecycle_policies

#' Returns information about configured OpenSearch Serverless security
#' configurations
#'
#' @description
#' Returns information about configured OpenSearch Serverless security configurations. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_list_security_configs/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_list_security_configs/) for full documentation.
#'
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results. The
#' default is 20.
#' @param nextToken If your initial
#' [`list_security_configs`][opensearchserviceserverless_list_security_configs]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`list_security_configs`][opensearchserviceserverless_list_security_configs]
#' operations, which returns results in the next page.
#' @param type &#91;required&#93; The type of security configuration.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_list_security_configs
opensearchserviceserverless_list_security_configs <- function(maxResults = NULL, nextToken = NULL, type) {
  op <- new_operation(
    name = "ListSecurityConfigs",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .opensearchserviceserverless$list_security_configs_input(maxResults = maxResults, nextToken = nextToken, type = type)
  output <- .opensearchserviceserverless$list_security_configs_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$list_security_configs <- opensearchserviceserverless_list_security_configs

#' Returns information about configured OpenSearch Serverless security
#' policies
#'
#' @description
#' Returns information about configured OpenSearch Serverless security policies.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_list_security_policies/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_list_security_policies/) for full documentation.
#'
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results. The
#' default is 20.
#' @param nextToken If your initial
#' [`list_security_policies`][opensearchserviceserverless_list_security_policies]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`list_security_policies`][opensearchserviceserverless_list_security_policies]
#' operations, which returns results in the next page.
#' @param resource Resource filters (can be collection or indexes) that policies can apply
#' to.
#' @param type &#91;required&#93; The type of policy.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_list_security_policies
opensearchserviceserverless_list_security_policies <- function(maxResults = NULL, nextToken = NULL, resource = NULL, type) {
  op <- new_operation(
    name = "ListSecurityPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .opensearchserviceserverless$list_security_policies_input(maxResults = maxResults, nextToken = nextToken, resource = resource, type = type)
  output <- .opensearchserviceserverless$list_security_policies_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$list_security_policies <- opensearchserviceserverless_list_security_policies

#' Returns the tags for an OpenSearch Serverless resource
#'
#' @description
#' Returns the tags for an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource. The resource must be
#' active (not in the `DELETING` state), and must be owned by the account
#' ID included in the request.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_list_tags_for_resource
opensearchserviceserverless_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .opensearchserviceserverless$list_tags_for_resource_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$list_tags_for_resource <- opensearchserviceserverless_list_tags_for_resource

#' Returns the OpenSearch Serverless-managed interface VPC endpoints
#' associated with the current account
#'
#' @description
#' Returns the OpenSearch Serverless-managed interface VPC endpoints associated with the current account. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_list_vpc_endpoints/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_list_vpc_endpoints/) for full documentation.
#'
#' @param maxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results. The
#' default is 20.
#' @param nextToken If your initial
#' [`list_vpc_endpoints`][opensearchserviceserverless_list_vpc_endpoints]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`list_vpc_endpoints`][opensearchserviceserverless_list_vpc_endpoints]
#' operations, which returns results in the next page.
#' @param vpcEndpointFilters Filter the results according to the current status of the VPC endpoint.
#' Possible statuses are `CREATING`, `DELETING`, `UPDATING`, `ACTIVE`, and
#' `FAILED`.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_list_vpc_endpoints
opensearchserviceserverless_list_vpc_endpoints <- function(maxResults = NULL, nextToken = NULL, vpcEndpointFilters = NULL) {
  op <- new_operation(
    name = "ListVpcEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .opensearchserviceserverless$list_vpc_endpoints_input(maxResults = maxResults, nextToken = nextToken, vpcEndpointFilters = vpcEndpointFilters)
  output <- .opensearchserviceserverless$list_vpc_endpoints_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$list_vpc_endpoints <- opensearchserviceserverless_list_vpc_endpoints

#' Associates tags with an OpenSearch Serverless resource
#'
#' @description
#' Associates tags with an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_tag_resource/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource. The resource must be
#' active (not in the `DELETING` state), and must be owned by the account
#' ID included in the request.
#' @param tags &#91;required&#93; A list of tags (key-value pairs) to add to the resource. All tag keys in
#' the request must be unique.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_tag_resource
opensearchserviceserverless_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .opensearchserviceserverless$tag_resource_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$tag_resource <- opensearchserviceserverless_tag_resource

#' Removes a tag or set of tags from an OpenSearch Serverless resource
#'
#' @description
#' Removes a tag or set of tags from an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_untag_resource/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to remove tags from. The
#' resource must be active (not in the `DELETING` state), and must be owned
#' by the account ID included in the request.
#' @param tagKeys &#91;required&#93; The tag or set of tags to remove from the resource. All tag keys in the
#' request must be unique.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_untag_resource
opensearchserviceserverless_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .opensearchserviceserverless$untag_resource_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$untag_resource <- opensearchserviceserverless_untag_resource

#' Updates an OpenSearch Serverless access policy
#'
#' @description
#' Updates an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_access_policy/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_access_policy/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param description A description of the policy. Typically used to store information about
#' the permissions defined in the policy.
#' @param name &#91;required&#93; The name of the policy.
#' @param policy The JSON policy document to use as the content for the policy.
#' @param policyVersion &#91;required&#93; The version of the policy being updated.
#' @param type &#91;required&#93; The type of policy.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_update_access_policy
opensearchserviceserverless_update_access_policy <- function(clientToken = NULL, description = NULL, name, policy = NULL, policyVersion, type) {
  op <- new_operation(
    name = "UpdateAccessPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$update_access_policy_input(clientToken = clientToken, description = description, name = name, policy = policy, policyVersion = policyVersion, type = type)
  output <- .opensearchserviceserverless$update_access_policy_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$update_access_policy <- opensearchserviceserverless_update_access_policy

#' Update the OpenSearch Serverless settings for the current Amazon Web
#' Services account
#'
#' @description
#' Update the OpenSearch Serverless settings for the current Amazon Web Services account. For more information, see [Managing capacity limits for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-scaling.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_account_settings/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_account_settings/) for full documentation.
#'
#' @param capacityLimits 
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_update_account_settings
opensearchserviceserverless_update_account_settings <- function(capacityLimits = NULL) {
  op <- new_operation(
    name = "UpdateAccountSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$update_account_settings_input(capacityLimits = capacityLimits)
  output <- .opensearchserviceserverless$update_account_settings_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$update_account_settings <- opensearchserviceserverless_update_account_settings

#' Updates an OpenSearch Serverless collection
#'
#' @description
#' Updates an OpenSearch Serverless collection.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_collection/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_collection/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param description A description of the collection.
#' @param id &#91;required&#93; The unique identifier of the collection.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_update_collection
opensearchserviceserverless_update_collection <- function(clientToken = NULL, description = NULL, id) {
  op <- new_operation(
    name = "UpdateCollection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$update_collection_input(clientToken = clientToken, description = description, id = id)
  output <- .opensearchserviceserverless$update_collection_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$update_collection <- opensearchserviceserverless_update_collection

#' Updates an OpenSearch Serverless access policy
#'
#' @description
#' Updates an OpenSearch Serverless access policy. For more information, see [Updating data lifecycle policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-update).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_lifecycle_policy/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_lifecycle_policy/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure idempotency of the
#' request.
#' @param description A description of the lifecycle policy.
#' @param name &#91;required&#93; The name of the policy.
#' @param policy The JSON policy document to use as the content for the lifecycle policy.
#' @param policyVersion &#91;required&#93; The version of the policy being updated.
#' @param type &#91;required&#93; The type of lifecycle policy.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_update_lifecycle_policy
opensearchserviceserverless_update_lifecycle_policy <- function(clientToken = NULL, description = NULL, name, policy = NULL, policyVersion, type) {
  op <- new_operation(
    name = "UpdateLifecyclePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$update_lifecycle_policy_input(clientToken = clientToken, description = description, name = name, policy = policy, policyVersion = policyVersion, type = type)
  output <- .opensearchserviceserverless$update_lifecycle_policy_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$update_lifecycle_policy <- opensearchserviceserverless_update_lifecycle_policy

#' Updates a security configuration for OpenSearch Serverless
#'
#' @description
#' Updates a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_security_config/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_security_config/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param configVersion &#91;required&#93; The version of the security configuration to be updated. You can find
#' the most recent version of a security configuration using the
#' [`get_security_policy`][opensearchserviceserverless_get_security_policy]
#' command.
#' @param description A description of the security configuration.
#' @param id &#91;required&#93; The security configuration identifier. For SAML the ID will be
#' `saml/<accountId>/<idpProviderName>`. For example,
#' `saml/123456789123/OKTADev`.
#' @param samlOptions SAML options in in the form of a key-value map.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_update_security_config
opensearchserviceserverless_update_security_config <- function(clientToken = NULL, configVersion, description = NULL, id, samlOptions = NULL) {
  op <- new_operation(
    name = "UpdateSecurityConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$update_security_config_input(clientToken = clientToken, configVersion = configVersion, description = description, id = id, samlOptions = samlOptions)
  output <- .opensearchserviceserverless$update_security_config_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$update_security_config <- opensearchserviceserverless_update_security_config

#' Updates an OpenSearch Serverless security policy
#'
#' @description
#' Updates an OpenSearch Serverless security policy. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_security_policy/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_security_policy/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param description A description of the policy. Typically used to store information about
#' the permissions defined in the policy.
#' @param name &#91;required&#93; The name of the policy.
#' @param policy The JSON policy document to use as the content for the new policy.
#' @param policyVersion &#91;required&#93; The version of the policy being updated.
#' @param type &#91;required&#93; The type of access policy.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_update_security_policy
opensearchserviceserverless_update_security_policy <- function(clientToken = NULL, description = NULL, name, policy = NULL, policyVersion, type) {
  op <- new_operation(
    name = "UpdateSecurityPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$update_security_policy_input(clientToken = clientToken, description = description, name = name, policy = policy, policyVersion = policyVersion, type = type)
  output <- .opensearchserviceserverless$update_security_policy_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$update_security_policy <- opensearchserviceserverless_update_security_policy

#' Updates an OpenSearch Serverless-managed interface endpoint
#'
#' @description
#' Updates an OpenSearch Serverless-managed interface endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_vpc_endpoint/](https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_vpc_endpoint/) for full documentation.
#'
#' @param addSecurityGroupIds The unique identifiers of the security groups to add to the endpoint.
#' Security groups define the ports, protocols, and sources for inbound
#' traffic that you are authorizing into your endpoint.
#' @param addSubnetIds The ID of one or more subnets to add to the endpoint.
#' @param clientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#' @param id &#91;required&#93; The unique identifier of the interface endpoint to update.
#' @param removeSecurityGroupIds The unique identifiers of the security groups to remove from the
#' endpoint.
#' @param removeSubnetIds The unique identifiers of the subnets to remove from the endpoint.
#'
#' @keywords internal
#'
#' @rdname opensearchserviceserverless_update_vpc_endpoint
opensearchserviceserverless_update_vpc_endpoint <- function(addSecurityGroupIds = NULL, addSubnetIds = NULL, clientToken = NULL, id, removeSecurityGroupIds = NULL, removeSubnetIds = NULL) {
  op <- new_operation(
    name = "UpdateVpcEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opensearchserviceserverless$update_vpc_endpoint_input(addSecurityGroupIds = addSecurityGroupIds, addSubnetIds = addSubnetIds, clientToken = clientToken, id = id, removeSecurityGroupIds = removeSecurityGroupIds, removeSubnetIds = removeSubnetIds)
  output <- .opensearchserviceserverless$update_vpc_endpoint_output()
  config <- get_config()
  svc <- .opensearchserviceserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchserviceserverless$operations$update_vpc_endpoint <- opensearchserviceserverless_update_vpc_endpoint
