# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include glue_service.R
NULL

#' Creates one or more partitions in a batch operation
#'
#' @description
#' Creates one or more partitions in a batch operation.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_create_partition/](https://www.paws-r-sdk.com/docs/glue_batch_create_partition/) for full documentation.
#'
#' @param CatalogId The ID of the catalog in which the partition is to be created.
#' Currently, this should be the Amazon Web Services account ID.
#' @param DatabaseName &#91;required&#93; The name of the metadata database in which the partition is to be
#' created.
#' @param TableName &#91;required&#93; The name of the metadata table in which the partition is to be created.
#' @param PartitionInputList &#91;required&#93; A list of `PartitionInput` structures that define the partitions to be
#' created.
#'
#' @keywords internal
#'
#' @rdname glue_batch_create_partition
glue_batch_create_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionInputList) {
  op <- new_operation(
    name = "BatchCreatePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_create_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionInputList = PartitionInputList)
  output <- .glue$batch_create_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_create_partition <- glue_batch_create_partition

#' Deletes a list of connection definitions from the Data Catalog
#'
#' @description
#' Deletes a list of connection definitions from the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_delete_connection/](https://www.paws-r-sdk.com/docs/glue_batch_delete_connection/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog in which the connections reside. If none is
#' provided, the Amazon Web Services account ID is used by default.
#' @param ConnectionNameList &#91;required&#93; A list of names of the connections to delete.
#'
#' @keywords internal
#'
#' @rdname glue_batch_delete_connection
glue_batch_delete_connection <- function(CatalogId = NULL, ConnectionNameList) {
  op <- new_operation(
    name = "BatchDeleteConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_delete_connection_input(CatalogId = CatalogId, ConnectionNameList = ConnectionNameList)
  output <- .glue$batch_delete_connection_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_delete_connection <- glue_batch_delete_connection

#' Deletes one or more partitions in a batch operation
#'
#' @description
#' Deletes one or more partitions in a batch operation.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_delete_partition/](https://www.paws-r-sdk.com/docs/glue_batch_delete_partition/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the partition to be deleted resides. If
#' none is provided, the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table in question resides.
#' @param TableName &#91;required&#93; The name of the table that contains the partitions to be deleted.
#' @param PartitionsToDelete &#91;required&#93; A list of `PartitionInput` structures that define the partitions to be
#' deleted.
#'
#' @keywords internal
#'
#' @rdname glue_batch_delete_partition
glue_batch_delete_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionsToDelete) {
  op <- new_operation(
    name = "BatchDeletePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_delete_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionsToDelete = PartitionsToDelete)
  output <- .glue$batch_delete_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_delete_partition <- glue_batch_delete_partition

#' Deletes multiple tables at once
#'
#' @description
#' Deletes multiple tables at once.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_delete_table/](https://www.paws-r-sdk.com/docs/glue_batch_delete_table/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the table resides. If none is provided,
#' the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the tables to delete reside.
#' For Hive compatibility, this name is entirely lowercase.
#' @param TablesToDelete &#91;required&#93; A list of the table to delete.
#' @param TransactionId The transaction ID at which to delete the table contents.
#'
#' @keywords internal
#'
#' @rdname glue_batch_delete_table
glue_batch_delete_table <- function(CatalogId = NULL, DatabaseName, TablesToDelete, TransactionId = NULL) {
  op <- new_operation(
    name = "BatchDeleteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_delete_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TablesToDelete = TablesToDelete, TransactionId = TransactionId)
  output <- .glue$batch_delete_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_delete_table <- glue_batch_delete_table

#' Deletes a specified batch of versions of a table
#'
#' @description
#' Deletes a specified batch of versions of a table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_delete_table_version/](https://www.paws-r-sdk.com/docs/glue_batch_delete_table_version/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is provided,
#' the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableName &#91;required&#93; The name of the table. For Hive compatibility, this name is entirely
#' lowercase.
#' @param VersionIds &#91;required&#93; A list of the IDs of versions to be deleted. A `VersionId` is a string
#' representation of an integer. Each version is incremented by 1.
#'
#' @keywords internal
#'
#' @rdname glue_batch_delete_table_version
glue_batch_delete_table_version <- function(CatalogId = NULL, DatabaseName, TableName, VersionIds) {
  op <- new_operation(
    name = "BatchDeleteTableVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_delete_table_version_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, VersionIds = VersionIds)
  output <- .glue$batch_delete_table_version_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_delete_table_version <- glue_batch_delete_table_version

#' Retrieves information about a list of blueprints
#'
#' @description
#' Retrieves information about a list of blueprints.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_get_blueprints/](https://www.paws-r-sdk.com/docs/glue_batch_get_blueprints/) for full documentation.
#'
#' @param Names &#91;required&#93; A list of blueprint names.
#' @param IncludeBlueprint Specifies whether or not to include the blueprint in the response.
#' @param IncludeParameterSpec Specifies whether or not to include the parameters, as a JSON string,
#' for the blueprint in the response.
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_blueprints
glue_batch_get_blueprints <- function(Names, IncludeBlueprint = NULL, IncludeParameterSpec = NULL) {
  op <- new_operation(
    name = "BatchGetBlueprints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_blueprints_input(Names = Names, IncludeBlueprint = IncludeBlueprint, IncludeParameterSpec = IncludeParameterSpec)
  output <- .glue$batch_get_blueprints_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_blueprints <- glue_batch_get_blueprints

#' Returns a list of resource metadata for a given list of crawler names
#'
#' @description
#' Returns a list of resource metadata for a given list of crawler names. After calling the [`list_crawlers`][glue_list_crawlers] operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_get_crawlers/](https://www.paws-r-sdk.com/docs/glue_batch_get_crawlers/) for full documentation.
#'
#' @param CrawlerNames &#91;required&#93; A list of crawler names, which might be the names returned from the
#' [`list_crawlers`][glue_list_crawlers] operation.
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_crawlers
glue_batch_get_crawlers <- function(CrawlerNames) {
  op <- new_operation(
    name = "BatchGetCrawlers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_crawlers_input(CrawlerNames = CrawlerNames)
  output <- .glue$batch_get_crawlers_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_crawlers <- glue_batch_get_crawlers

#' Retrieves the details for the custom patterns specified by a list of
#' names
#'
#' @description
#' Retrieves the details for the custom patterns specified by a list of names.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_get_custom_entity_types/](https://www.paws-r-sdk.com/docs/glue_batch_get_custom_entity_types/) for full documentation.
#'
#' @param Names &#91;required&#93; A list of names of the custom patterns that you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_custom_entity_types
glue_batch_get_custom_entity_types <- function(Names) {
  op <- new_operation(
    name = "BatchGetCustomEntityTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_custom_entity_types_input(Names = Names)
  output <- .glue$batch_get_custom_entity_types_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_custom_entity_types <- glue_batch_get_custom_entity_types

#' Retrieves a list of data quality results for the specified result IDs
#'
#' @description
#' Retrieves a list of data quality results for the specified result IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_get_data_quality_result/](https://www.paws-r-sdk.com/docs/glue_batch_get_data_quality_result/) for full documentation.
#'
#' @param ResultIds &#91;required&#93; A list of unique result IDs for the data quality results.
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_data_quality_result
glue_batch_get_data_quality_result <- function(ResultIds) {
  op <- new_operation(
    name = "BatchGetDataQualityResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_data_quality_result_input(ResultIds = ResultIds)
  output <- .glue$batch_get_data_quality_result_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_data_quality_result <- glue_batch_get_data_quality_result

#' Returns a list of resource metadata for a given list of development
#' endpoint names
#'
#' @description
#' Returns a list of resource metadata for a given list of development endpoint names. After calling the [`list_dev_endpoints`][glue_list_dev_endpoints] operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_get_dev_endpoints/](https://www.paws-r-sdk.com/docs/glue_batch_get_dev_endpoints/) for full documentation.
#'
#' @param DevEndpointNames &#91;required&#93; The list of `DevEndpoint` names, which might be the names returned from
#' the `ListDevEndpoint` operation.
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_dev_endpoints
glue_batch_get_dev_endpoints <- function(DevEndpointNames) {
  op <- new_operation(
    name = "BatchGetDevEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_dev_endpoints_input(DevEndpointNames = DevEndpointNames)
  output <- .glue$batch_get_dev_endpoints_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_dev_endpoints <- glue_batch_get_dev_endpoints

#' Returns a list of resource metadata for a given list of job names
#'
#' @description
#' Returns a list of resource metadata for a given list of job names. After calling the [`list_jobs`][glue_list_jobs] operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_get_jobs/](https://www.paws-r-sdk.com/docs/glue_batch_get_jobs/) for full documentation.
#'
#' @param JobNames &#91;required&#93; A list of job names, which might be the names returned from the
#' [`list_jobs`][glue_list_jobs] operation.
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_jobs
glue_batch_get_jobs <- function(JobNames) {
  op <- new_operation(
    name = "BatchGetJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_jobs_input(JobNames = JobNames)
  output <- .glue$batch_get_jobs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_jobs <- glue_batch_get_jobs

#' Retrieves partitions in a batch request
#'
#' @description
#' Retrieves partitions in a batch request.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_get_partition/](https://www.paws-r-sdk.com/docs/glue_batch_get_partition/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param PartitionsToGet &#91;required&#93; A list of partition values identifying the partitions to retrieve.
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_partition
glue_batch_get_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionsToGet) {
  op <- new_operation(
    name = "BatchGetPartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionsToGet = PartitionsToGet)
  output <- .glue$batch_get_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_partition <- glue_batch_get_partition

#' Returns the configuration for the specified table optimizers
#'
#' @description
#' Returns the configuration for the specified table optimizers.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_get_table_optimizer/](https://www.paws-r-sdk.com/docs/glue_batch_get_table_optimizer/) for full documentation.
#'
#' @param Entries &#91;required&#93; A list of `BatchGetTableOptimizerEntry` objects specifying the table
#' optimizers to retrieve.
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_table_optimizer
glue_batch_get_table_optimizer <- function(Entries) {
  op <- new_operation(
    name = "BatchGetTableOptimizer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_table_optimizer_input(Entries = Entries)
  output <- .glue$batch_get_table_optimizer_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_table_optimizer <- glue_batch_get_table_optimizer

#' Returns a list of resource metadata for a given list of trigger names
#'
#' @description
#' Returns a list of resource metadata for a given list of trigger names. After calling the [`list_triggers`][glue_list_triggers] operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_get_triggers/](https://www.paws-r-sdk.com/docs/glue_batch_get_triggers/) for full documentation.
#'
#' @param TriggerNames &#91;required&#93; A list of trigger names, which may be the names returned from the
#' [`list_triggers`][glue_list_triggers] operation.
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_triggers
glue_batch_get_triggers <- function(TriggerNames) {
  op <- new_operation(
    name = "BatchGetTriggers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_triggers_input(TriggerNames = TriggerNames)
  output <- .glue$batch_get_triggers_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_triggers <- glue_batch_get_triggers

#' Returns a list of resource metadata for a given list of workflow names
#'
#' @description
#' Returns a list of resource metadata for a given list of workflow names. After calling the [`list_workflows`][glue_list_workflows] operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_get_workflows/](https://www.paws-r-sdk.com/docs/glue_batch_get_workflows/) for full documentation.
#'
#' @param Names &#91;required&#93; A list of workflow names, which may be the names returned from the
#' [`list_workflows`][glue_list_workflows] operation.
#' @param IncludeGraph Specifies whether to include a graph when returning the workflow
#' resource metadata.
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_workflows
glue_batch_get_workflows <- function(Names, IncludeGraph = NULL) {
  op <- new_operation(
    name = "BatchGetWorkflows",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_workflows_input(Names = Names, IncludeGraph = IncludeGraph)
  output <- .glue$batch_get_workflows_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_workflows <- glue_batch_get_workflows

#' Stops one or more job runs for a specified job definition
#'
#' @description
#' Stops one or more job runs for a specified job definition.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_stop_job_run/](https://www.paws-r-sdk.com/docs/glue_batch_stop_job_run/) for full documentation.
#'
#' @param JobName &#91;required&#93; The name of the job definition for which to stop job runs.
#' @param JobRunIds &#91;required&#93; A list of the `JobRunIds` that should be stopped for that job
#' definition.
#'
#' @keywords internal
#'
#' @rdname glue_batch_stop_job_run
glue_batch_stop_job_run <- function(JobName, JobRunIds) {
  op <- new_operation(
    name = "BatchStopJobRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_stop_job_run_input(JobName = JobName, JobRunIds = JobRunIds)
  output <- .glue$batch_stop_job_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_stop_job_run <- glue_batch_stop_job_run

#' Updates one or more partitions in a batch operation
#'
#' @description
#' Updates one or more partitions in a batch operation.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_batch_update_partition/](https://www.paws-r-sdk.com/docs/glue_batch_update_partition/) for full documentation.
#'
#' @param CatalogId The ID of the catalog in which the partition is to be updated.
#' Currently, this should be the Amazon Web Services account ID.
#' @param DatabaseName &#91;required&#93; The name of the metadata database in which the partition is to be
#' updated.
#' @param TableName &#91;required&#93; The name of the metadata table in which the partition is to be updated.
#' @param Entries &#91;required&#93; A list of up to 100 `BatchUpdatePartitionRequestEntry` objects to
#' update.
#'
#' @keywords internal
#'
#' @rdname glue_batch_update_partition
glue_batch_update_partition <- function(CatalogId = NULL, DatabaseName, TableName, Entries) {
  op <- new_operation(
    name = "BatchUpdatePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_update_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, Entries = Entries)
  output <- .glue$batch_update_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_update_partition <- glue_batch_update_partition

#' Cancels the specified recommendation run that was being used to generate
#' rules
#'
#' @description
#' Cancels the specified recommendation run that was being used to generate rules.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_cancel_data_quality_rule_recommendation_run/](https://www.paws-r-sdk.com/docs/glue_cancel_data_quality_rule_recommendation_run/) for full documentation.
#'
#' @param RunId &#91;required&#93; The unique run identifier associated with this run.
#'
#' @keywords internal
#'
#' @rdname glue_cancel_data_quality_rule_recommendation_run
glue_cancel_data_quality_rule_recommendation_run <- function(RunId) {
  op <- new_operation(
    name = "CancelDataQualityRuleRecommendationRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$cancel_data_quality_rule_recommendation_run_input(RunId = RunId)
  output <- .glue$cancel_data_quality_rule_recommendation_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$cancel_data_quality_rule_recommendation_run <- glue_cancel_data_quality_rule_recommendation_run

#' Cancels a run where a ruleset is being evaluated against a data source
#'
#' @description
#' Cancels a run where a ruleset is being evaluated against a data source.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_cancel_data_quality_ruleset_evaluation_run/](https://www.paws-r-sdk.com/docs/glue_cancel_data_quality_ruleset_evaluation_run/) for full documentation.
#'
#' @param RunId &#91;required&#93; The unique run identifier associated with this run.
#'
#' @keywords internal
#'
#' @rdname glue_cancel_data_quality_ruleset_evaluation_run
glue_cancel_data_quality_ruleset_evaluation_run <- function(RunId) {
  op <- new_operation(
    name = "CancelDataQualityRulesetEvaluationRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$cancel_data_quality_ruleset_evaluation_run_input(RunId = RunId)
  output <- .glue$cancel_data_quality_ruleset_evaluation_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$cancel_data_quality_ruleset_evaluation_run <- glue_cancel_data_quality_ruleset_evaluation_run

#' Cancels (stops) a task run
#'
#' @description
#' Cancels (stops) a task run. Machine learning task runs are asynchronous tasks that Glue runs on your behalf as part of various machine learning workflows. You can cancel a machine learning task run at any time by calling [`cancel_ml_task_run`][glue_cancel_ml_task_run] with a task run's parent transform's `TransformID` and the task run's `TaskRunId`.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_cancel_ml_task_run/](https://www.paws-r-sdk.com/docs/glue_cancel_ml_task_run/) for full documentation.
#'
#' @param TransformId &#91;required&#93; The unique identifier of the machine learning transform.
#' @param TaskRunId &#91;required&#93; A unique identifier for the task run.
#'
#' @keywords internal
#'
#' @rdname glue_cancel_ml_task_run
glue_cancel_ml_task_run <- function(TransformId, TaskRunId) {
  op <- new_operation(
    name = "CancelMLTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$cancel_ml_task_run_input(TransformId = TransformId, TaskRunId = TaskRunId)
  output <- .glue$cancel_ml_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$cancel_ml_task_run <- glue_cancel_ml_task_run

#' Cancels the statement
#'
#' @description
#' Cancels the statement.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_cancel_statement/](https://www.paws-r-sdk.com/docs/glue_cancel_statement/) for full documentation.
#'
#' @param SessionId &#91;required&#93; The Session ID of the statement to be cancelled.
#' @param Id &#91;required&#93; The ID of the statement to be cancelled.
#' @param RequestOrigin The origin of the request to cancel the statement.
#'
#' @keywords internal
#'
#' @rdname glue_cancel_statement
glue_cancel_statement <- function(SessionId, Id, RequestOrigin = NULL) {
  op <- new_operation(
    name = "CancelStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$cancel_statement_input(SessionId = SessionId, Id = Id, RequestOrigin = RequestOrigin)
  output <- .glue$cancel_statement_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$cancel_statement <- glue_cancel_statement

#' Validates the supplied schema
#'
#' @description
#' Validates the supplied schema. This call has no side effects, it simply validates using the supplied schema using `DataFormat` as the format. Since it does not take a schema set name, no compatibility checks are performed.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_check_schema_version_validity/](https://www.paws-r-sdk.com/docs/glue_check_schema_version_validity/) for full documentation.
#'
#' @param DataFormat &#91;required&#93; The data format of the schema definition. Currently `AVRO`, `JSON` and
#' `PROTOBUF` are supported.
#' @param SchemaDefinition &#91;required&#93; The definition of the schema that has to be validated.
#'
#' @keywords internal
#'
#' @rdname glue_check_schema_version_validity
glue_check_schema_version_validity <- function(DataFormat, SchemaDefinition) {
  op <- new_operation(
    name = "CheckSchemaVersionValidity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$check_schema_version_validity_input(DataFormat = DataFormat, SchemaDefinition = SchemaDefinition)
  output <- .glue$check_schema_version_validity_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$check_schema_version_validity <- glue_check_schema_version_validity

#' Registers a blueprint with Glue
#'
#' @description
#' Registers a blueprint with Glue.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_blueprint/](https://www.paws-r-sdk.com/docs/glue_create_blueprint/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the blueprint.
#' @param Description A description of the blueprint.
#' @param BlueprintLocation &#91;required&#93; Specifies a path in Amazon S3 where the blueprint is published.
#' @param Tags The tags to be applied to this blueprint.
#'
#' @keywords internal
#'
#' @rdname glue_create_blueprint
glue_create_blueprint <- function(Name, Description = NULL, BlueprintLocation, Tags = NULL) {
  op <- new_operation(
    name = "CreateBlueprint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_blueprint_input(Name = Name, Description = Description, BlueprintLocation = BlueprintLocation, Tags = Tags)
  output <- .glue$create_blueprint_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_blueprint <- glue_create_blueprint

#' Creates a classifier in the user's account
#'
#' @description
#' Creates a classifier in the user's account. This can be a `GrokClassifier`, an `XMLClassifier`, a `JsonClassifier`, or a `CsvClassifier`, depending on which field of the request is present.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_classifier/](https://www.paws-r-sdk.com/docs/glue_create_classifier/) for full documentation.
#'
#' @param GrokClassifier A `GrokClassifier` object specifying the classifier to create.
#' @param XMLClassifier An `XMLClassifier` object specifying the classifier to create.
#' @param JsonClassifier A `JsonClassifier` object specifying the classifier to create.
#' @param CsvClassifier A `CsvClassifier` object specifying the classifier to create.
#'
#' @keywords internal
#'
#' @rdname glue_create_classifier
glue_create_classifier <- function(GrokClassifier = NULL, XMLClassifier = NULL, JsonClassifier = NULL, CsvClassifier = NULL) {
  op <- new_operation(
    name = "CreateClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_classifier_input(GrokClassifier = GrokClassifier, XMLClassifier = XMLClassifier, JsonClassifier = JsonClassifier, CsvClassifier = CsvClassifier)
  output <- .glue$create_classifier_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_classifier <- glue_create_classifier

#' Creates a connection definition in the Data Catalog
#'
#' @description
#' Creates a connection definition in the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_connection/](https://www.paws-r-sdk.com/docs/glue_create_connection/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog in which to create the connection. If none is
#' provided, the Amazon Web Services account ID is used by default.
#' @param ConnectionInput &#91;required&#93; A `ConnectionInput` object defining the connection to create.
#' @param Tags The tags you assign to the connection.
#'
#' @keywords internal
#'
#' @rdname glue_create_connection
glue_create_connection <- function(CatalogId = NULL, ConnectionInput, Tags = NULL) {
  op <- new_operation(
    name = "CreateConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_connection_input(CatalogId = CatalogId, ConnectionInput = ConnectionInput, Tags = Tags)
  output <- .glue$create_connection_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_connection <- glue_create_connection

#' Creates a new crawler with specified targets, role, configuration, and
#' optional schedule
#'
#' @description
#' Creates a new crawler with specified targets, role, configuration, and optional schedule. At least one crawl target must be specified, in the `s3Targets` field, the `jdbcTargets` field, or the `DynamoDBTargets` field.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_crawler/](https://www.paws-r-sdk.com/docs/glue_create_crawler/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the new crawler.
#' @param Role &#91;required&#93; The IAM role or Amazon Resource Name (ARN) of an IAM role used by the
#' new crawler to access customer resources.
#' @param DatabaseName The Glue database where results are written, such as:
#' `arn:aws:daylight:us-east-1::database/sometable/*`.
#' @param Description A description of the new crawler.
#' @param Targets &#91;required&#93; A list of collection of targets to crawl.
#' @param Schedule A `cron` expression used to specify the schedule (see [Time-Based
#' Schedules for Jobs and
#' Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
#' For example, to run something every day at 12:15 UTC, you would specify:
#' `cron(15 12 * * ? *)`.
#' @param Classifiers A list of custom classifiers that the user has registered. By default,
#' all built-in classifiers are included in a crawl, but these custom
#' classifiers always override the default classifiers for a given
#' classification.
#' @param TablePrefix The table prefix used for catalog tables that are created.
#' @param SchemaChangePolicy The policy for the crawler's update and deletion behavior.
#' @param RecrawlPolicy A policy that specifies whether to crawl the entire dataset again, or to
#' crawl only folders that were added since the last crawler run.
#' @param LineageConfiguration Specifies data lineage configuration settings for the crawler.
#' @param LakeFormationConfiguration Specifies Lake Formation configuration settings for the crawler.
#' @param Configuration Crawler configuration information. This versioned JSON string allows
#' users to specify aspects of a crawler's behavior. For more information,
#' see [Setting crawler configuration
#' options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
#' @param CrawlerSecurityConfiguration The name of the `SecurityConfiguration` structure to be used by this
#' crawler.
#' @param Tags The tags to use with this crawler request. You may use tags to limit
#' access to the crawler. For more information about tags in Glue, see
#' [Amazon Web Services Tags in
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in
#' the developer guide.
#'
#' @keywords internal
#'
#' @rdname glue_create_crawler
glue_create_crawler <- function(Name, Role, DatabaseName = NULL, Description = NULL, Targets, Schedule = NULL, Classifiers = NULL, TablePrefix = NULL, SchemaChangePolicy = NULL, RecrawlPolicy = NULL, LineageConfiguration = NULL, LakeFormationConfiguration = NULL, Configuration = NULL, CrawlerSecurityConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_crawler_input(Name = Name, Role = Role, DatabaseName = DatabaseName, Description = Description, Targets = Targets, Schedule = Schedule, Classifiers = Classifiers, TablePrefix = TablePrefix, SchemaChangePolicy = SchemaChangePolicy, RecrawlPolicy = RecrawlPolicy, LineageConfiguration = LineageConfiguration, LakeFormationConfiguration = LakeFormationConfiguration, Configuration = Configuration, CrawlerSecurityConfiguration = CrawlerSecurityConfiguration, Tags = Tags)
  output <- .glue$create_crawler_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_crawler <- glue_create_crawler

#' Creates a custom pattern that is used to detect sensitive data across
#' the columns and rows of your structured data
#'
#' @description
#' Creates a custom pattern that is used to detect sensitive data across the columns and rows of your structured data.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_custom_entity_type/](https://www.paws-r-sdk.com/docs/glue_create_custom_entity_type/) for full documentation.
#'
#' @param Name &#91;required&#93; A name for the custom pattern that allows it to be retrieved or deleted
#' later. This name must be unique per Amazon Web Services account.
#' @param RegexString &#91;required&#93; A regular expression string that is used for detecting sensitive data in
#' a custom pattern.
#' @param ContextWords A list of context words. If none of these context words are found within
#' the vicinity of the regular expression the data will not be detected as
#' sensitive data.
#' 
#' If no context words are passed only a regular expression is checked.
#' @param Tags A list of tags applied to the custom entity type.
#'
#' @keywords internal
#'
#' @rdname glue_create_custom_entity_type
glue_create_custom_entity_type <- function(Name, RegexString, ContextWords = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateCustomEntityType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_custom_entity_type_input(Name = Name, RegexString = RegexString, ContextWords = ContextWords, Tags = Tags)
  output <- .glue$create_custom_entity_type_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_custom_entity_type <- glue_create_custom_entity_type

#' Creates a data quality ruleset with DQDL rules applied to a specified
#' Glue table
#'
#' @description
#' Creates a data quality ruleset with DQDL rules applied to a specified Glue table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_data_quality_ruleset/](https://www.paws-r-sdk.com/docs/glue_create_data_quality_ruleset/) for full documentation.
#'
#' @param Name &#91;required&#93; A unique name for the data quality ruleset.
#' @param Description A description of the data quality ruleset.
#' @param Ruleset &#91;required&#93; A Data Quality Definition Language (DQDL) ruleset. For more information,
#' see the Glue developer guide.
#' @param Tags A list of tags applied to the data quality ruleset.
#' @param TargetTable A target table associated with the data quality ruleset.
#' @param ClientToken Used for idempotency and is recommended to be set to a random ID (such
#' as a UUID) to avoid creating or starting multiple instances of the same
#' resource.
#'
#' @keywords internal
#'
#' @rdname glue_create_data_quality_ruleset
glue_create_data_quality_ruleset <- function(Name, Description = NULL, Ruleset, Tags = NULL, TargetTable = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateDataQualityRuleset",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_data_quality_ruleset_input(Name = Name, Description = Description, Ruleset = Ruleset, Tags = Tags, TargetTable = TargetTable, ClientToken = ClientToken)
  output <- .glue$create_data_quality_ruleset_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_data_quality_ruleset <- glue_create_data_quality_ruleset

#' Creates a new database in a Data Catalog
#'
#' @description
#' Creates a new database in a Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_database/](https://www.paws-r-sdk.com/docs/glue_create_database/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog in which to create the database. If none is
#' provided, the Amazon Web Services account ID is used by default.
#' @param DatabaseInput &#91;required&#93; The metadata for the database.
#' @param Tags The tags you assign to the database.
#'
#' @keywords internal
#'
#' @rdname glue_create_database
glue_create_database <- function(CatalogId = NULL, DatabaseInput, Tags = NULL) {
  op <- new_operation(
    name = "CreateDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_database_input(CatalogId = CatalogId, DatabaseInput = DatabaseInput, Tags = Tags)
  output <- .glue$create_database_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_database <- glue_create_database

#' Creates a new development endpoint
#'
#' @description
#' Creates a new development endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_dev_endpoint/](https://www.paws-r-sdk.com/docs/glue_create_dev_endpoint/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name to be assigned to the new `DevEndpoint`.
#' @param RoleArn &#91;required&#93; The IAM role for the `DevEndpoint`.
#' @param SecurityGroupIds Security group IDs for the security groups to be used by the new
#' `DevEndpoint`.
#' @param SubnetId The subnet ID for the new `DevEndpoint` to use.
#' @param PublicKey The public key to be used by this `DevEndpoint` for authentication. This
#' attribute is provided for backward compatibility because the recommended
#' attribute to use is public keys.
#' @param PublicKeys A list of public keys to be used by the development endpoints for
#' authentication. The use of this attribute is preferred over a single
#' public key because the public keys allow you to have a different private
#' key per client.
#' 
#' If you previously created an endpoint with a public key, you must remove
#' that key to be able to set a list of public keys. Call the
#' [`update_dev_endpoint`][glue_update_dev_endpoint] API with the public
#' key content in the `deletePublicKeys` attribute, and the list of new
#' keys in the `addPublicKeys` attribute.
#' @param NumberOfNodes The number of Glue Data Processing Units (DPUs) to allocate to this
#' `DevEndpoint`.
#' @param WorkerType The type of predefined worker that is allocated to the development
#' endpoint. Accepts a value of Standard, G.1X, or G.2X.
#' 
#' -   For the `Standard` worker type, each worker provides 4 vCPU, 16 GB
#'     of memory and a 50GB disk, and 2 executors per worker.
#' 
#' -   For the `G.1X` worker type, each worker maps to 1 DPU (4 vCPU, 16 GB
#'     of memory, 64 GB disk), and provides 1 executor per worker. We
#'     recommend this worker type for memory-intensive jobs.
#' 
#' -   For the `G.2X` worker type, each worker maps to 2 DPU (8 vCPU, 32 GB
#'     of memory, 128 GB disk), and provides 1 executor per worker. We
#'     recommend this worker type for memory-intensive jobs.
#' 
#' Known issue: when a development endpoint is created with the `G.2X`
#' `WorkerType` configuration, the Spark drivers for the development
#' endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB disk.
#' @param GlueVersion Glue version determines the versions of Apache Spark and Python that
#' Glue supports. The Python version indicates the version supported for
#' running your ETL scripts on development endpoints.
#' 
#' For more information about the available Glue versions and corresponding
#' Spark and Python versions, see [Glue
#' version](https://docs.aws.amazon.com/glue/latest/dg/add-job.html) in the
#' developer guide.
#' 
#' Development endpoints that are created without specifying a Glue version
#' default to Glue 0.9.
#' 
#' You can specify a version of Python support for development endpoints by
#' using the `Arguments` parameter in the
#' [`create_dev_endpoint`][glue_create_dev_endpoint] or
#' [`update_dev_endpoint`][glue_update_dev_endpoint] APIs. If no arguments
#' are provided, the version defaults to Python 2.
#' @param NumberOfWorkers The number of workers of a defined `workerType` that are allocated to
#' the development endpoint.
#' 
#' The maximum number of workers you can define are 299 for `G.1X`, and 149
#' for `G.2X`.
#' @param ExtraPythonLibsS3Path The paths to one or more Python libraries in an Amazon S3 bucket that
#' should be loaded in your `DevEndpoint`. Multiple values must be complete
#' paths separated by a comma.
#' 
#' You can only use pure Python libraries with a `DevEndpoint`. Libraries
#' that rely on C extensions, such as the
#' [pandas](http://pandas.pydata.org/) Python data analysis library, are
#' not yet supported.
#' @param ExtraJarsS3Path The path to one or more Java `.jar` files in an S3 bucket that should be
#' loaded in your `DevEndpoint`.
#' @param SecurityConfiguration The name of the `SecurityConfiguration` structure to be used with this
#' `DevEndpoint`.
#' @param Tags The tags to use with this DevEndpoint. You may use tags to limit access
#' to the DevEndpoint. For more information about tags in Glue, see [Amazon
#' Web Services Tags in
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in
#' the developer guide.
#' @param Arguments A map of arguments used to configure the `DevEndpoint`.
#'
#' @keywords internal
#'
#' @rdname glue_create_dev_endpoint
glue_create_dev_endpoint <- function(EndpointName, RoleArn, SecurityGroupIds = NULL, SubnetId = NULL, PublicKey = NULL, PublicKeys = NULL, NumberOfNodes = NULL, WorkerType = NULL, GlueVersion = NULL, NumberOfWorkers = NULL, ExtraPythonLibsS3Path = NULL, ExtraJarsS3Path = NULL, SecurityConfiguration = NULL, Tags = NULL, Arguments = NULL) {
  op <- new_operation(
    name = "CreateDevEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_dev_endpoint_input(EndpointName = EndpointName, RoleArn = RoleArn, SecurityGroupIds = SecurityGroupIds, SubnetId = SubnetId, PublicKey = PublicKey, PublicKeys = PublicKeys, NumberOfNodes = NumberOfNodes, WorkerType = WorkerType, GlueVersion = GlueVersion, NumberOfWorkers = NumberOfWorkers, ExtraPythonLibsS3Path = ExtraPythonLibsS3Path, ExtraJarsS3Path = ExtraJarsS3Path, SecurityConfiguration = SecurityConfiguration, Tags = Tags, Arguments = Arguments)
  output <- .glue$create_dev_endpoint_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_dev_endpoint <- glue_create_dev_endpoint

#' Creates a new job definition
#'
#' @description
#' Creates a new job definition.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_job/](https://www.paws-r-sdk.com/docs/glue_create_job/) for full documentation.
#'
#' @param Name &#91;required&#93; The name you assign to this job definition. It must be unique in your
#' account.
#' @param Description Description of the job being defined.
#' @param LogUri This field is reserved for future use.
#' @param Role &#91;required&#93; The name or Amazon Resource Name (ARN) of the IAM role associated with
#' this job.
#' @param ExecutionProperty An `ExecutionProperty` specifying the maximum number of concurrent runs
#' allowed for this job.
#' @param Command &#91;required&#93; The `JobCommand` that runs this job.
#' @param DefaultArguments The default arguments for every run of this job, specified as name-value
#' pairs.
#' 
#' You can specify arguments here that your own job-execution script
#' consumes, as well as arguments that Glue itself consumes.
#' 
#' Job arguments may be logged. Do not pass plaintext secrets as arguments.
#' Retrieve secrets from a Glue Connection, Secrets Manager or other secret
#' management mechanism if you intend to keep them within the Job.
#' 
#' For information about how to specify and consume your own Job arguments,
#' see the [Calling Glue APIs in
#' Python](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
#' topic in the developer guide.
#' 
#' For information about the arguments you can provide to this field when
#' configuring Spark jobs, see the [Special Parameters Used by
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
#' topic in the developer guide.
#' 
#' For information about the arguments you can provide to this field when
#' configuring Ray jobs, see [Using job parameters in Ray
#' jobs](https://docs.aws.amazon.com/glue/latest/dg/author-job-ray-job-parameters.html)
#' in the developer guide.
#' @param NonOverridableArguments Arguments for this job that are not overridden when providing job
#' arguments in a job run, specified as name-value pairs.
#' @param Connections The connections used for this job.
#' @param MaxRetries The maximum number of times to retry this job if it fails.
#' @param AllocatedCapacity This parameter is deprecated. Use `MaxCapacity` instead.
#' 
#' The number of Glue data processing units (DPUs) to allocate to this Job.
#' You can allocate a minimum of 2 DPUs; the default is 10. A DPU is a
#' relative measure of processing power that consists of 4 vCPUs of compute
#' capacity and 16 GB of memory. For more information, see the [Glue
#' pricing page](https://aws.amazon.com/glue/pricing/).
#' @param Timeout The job timeout in minutes. This is the maximum time that a job run can
#' consume resources before it is terminated and enters `TIMEOUT` status.
#' The default is 2,880 minutes (48 hours).
#' @param MaxCapacity For Glue version 1.0 or earlier jobs, using the standard worker type,
#' the number of Glue data processing units (DPUs) that can be allocated
#' when this job runs. A DPU is a relative measure of processing power that
#' consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
#' information, see the [Glue pricing
#' page](https://aws.amazon.com/glue/pricing/).
#' 
#' For Glue version 2.0+ jobs, you cannot specify a `Maximum capacity`.
#' Instead, you should specify a `Worker type` and the `Number of workers`.
#' 
#' Do not set `MaxCapacity` if using `WorkerType` and `NumberOfWorkers`.
#' 
#' The value that can be allocated for `MaxCapacity` depends on whether you
#' are running a Python shell job, an Apache Spark ETL job, or an Apache
#' Spark streaming ETL job:
#' 
#' -   When you specify a Python shell job
#'     (`JobCommand.Name`="pythonshell"), you can allocate either 0.0625 or
#'     1 DPU. The default is 0.0625 DPU.
#' 
#' -   When you specify an Apache Spark ETL job
#'     (`JobCommand.Name`="glueetl") or Apache Spark streaming ETL job
#'     (`JobCommand.Name`="gluestreaming"), you can allocate from 2 to 100
#'     DPUs. The default is 10 DPUs. This job type cannot have a fractional
#'     DPU allocation.
#' @param SecurityConfiguration The name of the `SecurityConfiguration` structure to be used with this
#' job.
#' @param Tags The tags to use with this job. You may use tags to limit access to the
#' job. For more information about tags in Glue, see [Amazon Web Services
#' Tags in
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in
#' the developer guide.
#' @param NotificationProperty Specifies configuration properties of a job notification.
#' @param GlueVersion In Spark jobs, `GlueVersion` determines the versions of Apache Spark and
#' Python that Glue available in a job. The Python version indicates the
#' version supported for jobs of type Spark.
#' 
#' Ray jobs should set `GlueVersion` to `4.0` or greater. However, the
#' versions of Ray, Python and additional libraries available in your Ray
#' job are determined by the `Runtime` parameter of the Job command.
#' 
#' For more information about the available Glue versions and corresponding
#' Spark and Python versions, see [Glue
#' version](https://docs.aws.amazon.com/glue/latest/dg/add-job.html) in the
#' developer guide.
#' 
#' Jobs that are created without specifying a Glue version default to Glue
#' 0.9.
#' @param NumberOfWorkers The number of workers of a defined `workerType` that are allocated when
#' a job runs.
#' @param WorkerType The type of predefined worker that is allocated when a job runs. Accepts
#' a value of G.1X, G.2X, G.4X, G.8X or G.025X for Spark jobs. Accepts the
#' value Z.2X for Ray jobs.
#' 
#' -   For the `G.1X` worker type, each worker maps to 1 DPU (4 vCPUs, 16
#'     GB of memory) with 84GB disk (approximately 34GB free), and provides
#'     1 executor per worker. We recommend this worker type for workloads
#'     such as data transforms, joins, and queries, to offers a scalable
#'     and cost effective way to run most jobs.
#' 
#' -   For the `G.2X` worker type, each worker maps to 2 DPU (8 vCPUs, 32
#'     GB of memory) with 128GB disk (approximately 77GB free), and
#'     provides 1 executor per worker. We recommend this worker type for
#'     workloads such as data transforms, joins, and queries, to offers a
#'     scalable and cost effective way to run most jobs.
#' 
#' -   For the `G.4X` worker type, each worker maps to 4 DPU (16 vCPUs, 64
#'     GB of memory) with 256GB disk (approximately 235GB free), and
#'     provides 1 executor per worker. We recommend this worker type for
#'     jobs whose workloads contain your most demanding transforms,
#'     aggregations, joins, and queries. This worker type is available only
#'     for Glue version 3.0 or later Spark ETL jobs in the following Amazon
#'     Web Services Regions: US East (Ohio), US East (N. Virginia), US West
#'     (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia
#'     Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe
#'     (Ireland), and Europe (Stockholm).
#' 
#' -   For the `G.8X` worker type, each worker maps to 8 DPU (32 vCPUs, 128
#'     GB of memory) with 512GB disk (approximately 487GB free), and
#'     provides 1 executor per worker. We recommend this worker type for
#'     jobs whose workloads contain your most demanding transforms,
#'     aggregations, joins, and queries. This worker type is available only
#'     for Glue version 3.0 or later Spark ETL jobs, in the same Amazon Web
#'     Services Regions as supported for the `G.4X` worker type.
#' 
#' -   For the `G.025X` worker type, each worker maps to 0.25 DPU (2 vCPUs,
#'     4 GB of memory) with 84GB disk (approximately 34GB free), and
#'     provides 1 executor per worker. We recommend this worker type for
#'     low volume streaming jobs. This worker type is only available for
#'     Glue version 3.0 streaming jobs.
#' 
#' -   For the `Z.2X` worker type, each worker maps to 2 M-DPU (8vCPUs, 64
#'     GB of memory) with 128 GB disk (approximately 120GB free), and
#'     provides up to 8 Ray workers based on the autoscaler.
#' @param CodeGenConfigurationNodes The representation of a directed acyclic graph on which both the Glue
#' Studio visual component and Glue Studio code generation is based.
#' @param ExecutionClass Indicates whether the job is run with a standard or flexible execution
#' class. The standard execution-class is ideal for time-sensitive
#' workloads that require fast job startup and dedicated resources.
#' 
#' The flexible execution class is appropriate for time-insensitive jobs
#' whose start and completion times may vary.
#' 
#' Only jobs with Glue version 3.0 and above and command type `glueetl`
#' will be allowed to set `ExecutionClass` to `FLEX`. The flexible
#' execution class is available for Spark jobs.
#' @param SourceControlDetails The details for a source control configuration for a job, allowing
#' synchronization of job artifacts to or from a remote repository.
#'
#' @keywords internal
#'
#' @rdname glue_create_job
glue_create_job <- function(Name, Description = NULL, LogUri = NULL, Role, ExecutionProperty = NULL, Command, DefaultArguments = NULL, NonOverridableArguments = NULL, Connections = NULL, MaxRetries = NULL, AllocatedCapacity = NULL, Timeout = NULL, MaxCapacity = NULL, SecurityConfiguration = NULL, Tags = NULL, NotificationProperty = NULL, GlueVersion = NULL, NumberOfWorkers = NULL, WorkerType = NULL, CodeGenConfigurationNodes = NULL, ExecutionClass = NULL, SourceControlDetails = NULL) {
  op <- new_operation(
    name = "CreateJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_job_input(Name = Name, Description = Description, LogUri = LogUri, Role = Role, ExecutionProperty = ExecutionProperty, Command = Command, DefaultArguments = DefaultArguments, NonOverridableArguments = NonOverridableArguments, Connections = Connections, MaxRetries = MaxRetries, AllocatedCapacity = AllocatedCapacity, Timeout = Timeout, MaxCapacity = MaxCapacity, SecurityConfiguration = SecurityConfiguration, Tags = Tags, NotificationProperty = NotificationProperty, GlueVersion = GlueVersion, NumberOfWorkers = NumberOfWorkers, WorkerType = WorkerType, CodeGenConfigurationNodes = CodeGenConfigurationNodes, ExecutionClass = ExecutionClass, SourceControlDetails = SourceControlDetails)
  output <- .glue$create_job_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_job <- glue_create_job

#' Creates an Glue machine learning transform
#'
#' @description
#' Creates an Glue machine learning transform. This operation creates the transform and all the necessary parameters to train it.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_ml_transform/](https://www.paws-r-sdk.com/docs/glue_create_ml_transform/) for full documentation.
#'
#' @param Name &#91;required&#93; The unique name that you give the transform when you create it.
#' @param Description A description of the machine learning transform that is being defined.
#' The default is an empty string.
#' @param InputRecordTables &#91;required&#93; A list of Glue table definitions used by the transform.
#' @param Parameters &#91;required&#93; The algorithmic parameters that are specific to the transform type used.
#' Conditionally dependent on the transform type.
#' @param Role &#91;required&#93; The name or Amazon Resource Name (ARN) of the IAM role with the required
#' permissions. The required permissions include both Glue service role
#' permissions to Glue resources, and Amazon S3 permissions required by the
#' transform.
#' 
#' -   This role needs Glue service role permissions to allow access to
#'     resources in Glue. See [Attach a Policy to IAM Users That Access
#'     Glue](https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html).
#' 
#' -   This role needs permission to your Amazon Simple Storage Service
#'     (Amazon S3) sources, targets, temporary directory, scripts, and any
#'     libraries used by the task run for this transform.
#' @param GlueVersion This value determines which version of Glue this machine learning
#' transform is compatible with. Glue 1.0 is recommended for most
#' customers. If the value is not set, the Glue compatibility defaults to
#' Glue 0.9. For more information, see [Glue
#' Versions](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions)
#' in the developer guide.
#' @param MaxCapacity The number of Glue data processing units (DPUs) that are allocated to
#' task runs for this transform. You can allocate from 2 to 100 DPUs; the
#' default is 10. A DPU is a relative measure of processing power that
#' consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
#' information, see the [Glue pricing
#' page](https://aws.amazon.com/glue/pricing/).
#' 
#' `MaxCapacity` is a mutually exclusive option with `NumberOfWorkers` and
#' `WorkerType`.
#' 
#' -   If either `NumberOfWorkers` or `WorkerType` is set, then
#'     `MaxCapacity` cannot be set.
#' 
#' -   If `MaxCapacity` is set then neither `NumberOfWorkers` or
#'     `WorkerType` can be set.
#' 
#' -   If `WorkerType` is set, then `NumberOfWorkers` is required (and vice
#'     versa).
#' 
#' -   `MaxCapacity` and `NumberOfWorkers` must both be at least 1.
#' 
#' When the `WorkerType` field is set to a value other than `Standard`, the
#' `MaxCapacity` field is set automatically and becomes read-only.
#' 
#' When the `WorkerType` field is set to a value other than `Standard`, the
#' `MaxCapacity` field is set automatically and becomes read-only.
#' @param WorkerType The type of predefined worker that is allocated when this task runs.
#' Accepts a value of Standard, G.1X, or G.2X.
#' 
#' -   For the `Standard` worker type, each worker provides 4 vCPU, 16 GB
#'     of memory and a 50GB disk, and 2 executors per worker.
#' 
#' -   For the `G.1X` worker type, each worker provides 4 vCPU, 16 GB of
#'     memory and a 64GB disk, and 1 executor per worker.
#' 
#' -   For the `G.2X` worker type, each worker provides 8 vCPU, 32 GB of
#'     memory and a 128GB disk, and 1 executor per worker.
#' 
#' `MaxCapacity` is a mutually exclusive option with `NumberOfWorkers` and
#' `WorkerType`.
#' 
#' -   If either `NumberOfWorkers` or `WorkerType` is set, then
#'     `MaxCapacity` cannot be set.
#' 
#' -   If `MaxCapacity` is set then neither `NumberOfWorkers` or
#'     `WorkerType` can be set.
#' 
#' -   If `WorkerType` is set, then `NumberOfWorkers` is required (and vice
#'     versa).
#' 
#' -   `MaxCapacity` and `NumberOfWorkers` must both be at least 1.
#' @param NumberOfWorkers The number of workers of a defined `workerType` that are allocated when
#' this task runs.
#' 
#' If `WorkerType` is set, then `NumberOfWorkers` is required (and vice
#' versa).
#' @param Timeout The timeout of the task run for this transform in minutes. This is the
#' maximum time that a task run for this transform can consume resources
#' before it is terminated and enters `TIMEOUT` status. The default is
#' 2,880 minutes (48 hours).
#' @param MaxRetries The maximum number of times to retry a task for this transform after a
#' task run fails.
#' @param Tags The tags to use with this machine learning transform. You may use tags
#' to limit access to the machine learning transform. For more information
#' about tags in Glue, see [Amazon Web Services Tags in
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in
#' the developer guide.
#' @param TransformEncryption The encryption-at-rest settings of the transform that apply to accessing
#' user data. Machine learning transforms can access user data encrypted in
#' Amazon S3 using KMS.
#'
#' @keywords internal
#'
#' @rdname glue_create_ml_transform
glue_create_ml_transform <- function(Name, Description = NULL, InputRecordTables, Parameters, Role, GlueVersion = NULL, MaxCapacity = NULL, WorkerType = NULL, NumberOfWorkers = NULL, Timeout = NULL, MaxRetries = NULL, Tags = NULL, TransformEncryption = NULL) {
  op <- new_operation(
    name = "CreateMLTransform",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_ml_transform_input(Name = Name, Description = Description, InputRecordTables = InputRecordTables, Parameters = Parameters, Role = Role, GlueVersion = GlueVersion, MaxCapacity = MaxCapacity, WorkerType = WorkerType, NumberOfWorkers = NumberOfWorkers, Timeout = Timeout, MaxRetries = MaxRetries, Tags = Tags, TransformEncryption = TransformEncryption)
  output <- .glue$create_ml_transform_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_ml_transform <- glue_create_ml_transform

#' Creates a new partition
#'
#' @description
#' Creates a new partition.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_partition/](https://www.paws-r-sdk.com/docs/glue_create_partition/) for full documentation.
#'
#' @param CatalogId The Amazon Web Services account ID of the catalog in which the partition
#' is to be created.
#' @param DatabaseName &#91;required&#93; The name of the metadata database in which the partition is to be
#' created.
#' @param TableName &#91;required&#93; The name of the metadata table in which the partition is to be created.
#' @param PartitionInput &#91;required&#93; A `PartitionInput` structure defining the partition to be created.
#'
#' @keywords internal
#'
#' @rdname glue_create_partition
glue_create_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionInput) {
  op <- new_operation(
    name = "CreatePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionInput = PartitionInput)
  output <- .glue$create_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_partition <- glue_create_partition

#' Creates a specified partition index in an existing table
#'
#' @description
#' Creates a specified partition index in an existing table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_partition_index/](https://www.paws-r-sdk.com/docs/glue_create_partition_index/) for full documentation.
#'
#' @param CatalogId The catalog ID where the table resides.
#' @param DatabaseName &#91;required&#93; Specifies the name of a database in which you want to create a partition
#' index.
#' @param TableName &#91;required&#93; Specifies the name of a table in which you want to create a partition
#' index.
#' @param PartitionIndex &#91;required&#93; Specifies a `PartitionIndex` structure to create a partition index in an
#' existing table.
#'
#' @keywords internal
#'
#' @rdname glue_create_partition_index
glue_create_partition_index <- function(CatalogId = NULL, DatabaseName, TableName, PartitionIndex) {
  op <- new_operation(
    name = "CreatePartitionIndex",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_partition_index_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionIndex = PartitionIndex)
  output <- .glue$create_partition_index_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_partition_index <- glue_create_partition_index

#' Creates a new registry which may be used to hold a collection of schemas
#'
#' @description
#' Creates a new registry which may be used to hold a collection of schemas.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_registry/](https://www.paws-r-sdk.com/docs/glue_create_registry/) for full documentation.
#'
#' @param RegistryName &#91;required&#93; Name of the registry to be created of max length of 255, and may only
#' contain letters, numbers, hyphen, underscore, dollar sign, or hash mark.
#' No whitespace.
#' @param Description A description of the registry. If description is not provided, there
#' will not be any default value for this.
#' @param Tags Amazon Web Services tags that contain a key value pair and may be
#' searched by console, command line, or API.
#'
#' @keywords internal
#'
#' @rdname glue_create_registry
glue_create_registry <- function(RegistryName, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateRegistry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_registry_input(RegistryName = RegistryName, Description = Description, Tags = Tags)
  output <- .glue$create_registry_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_registry <- glue_create_registry

#' Creates a new schema set and registers the schema definition
#'
#' @description
#' Creates a new schema set and registers the schema definition. Returns an error if the schema set already exists without actually registering the version.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_schema/](https://www.paws-r-sdk.com/docs/glue_create_schema/) for full documentation.
#'
#' @param RegistryId This is a wrapper shape to contain the registry identity fields. If this
#' is not provided, the default registry will be used. The ARN format for
#' the same will be:
#' `arn:aws:glue:us-east-2:<customer id>:registry/default-registry:random-5-letter-id`.
#' @param SchemaName &#91;required&#93; Name of the schema to be created of max length of 255, and may only
#' contain letters, numbers, hyphen, underscore, dollar sign, or hash mark.
#' No whitespace.
#' @param DataFormat &#91;required&#93; The data format of the schema definition. Currently `AVRO`, `JSON` and
#' `PROTOBUF` are supported.
#' @param Compatibility The compatibility mode of the schema. The possible values are:
#' 
#' -   *NONE*: No compatibility mode applies. You can use this choice in
#'     development scenarios or if you do not know the compatibility mode
#'     that you want to apply to schemas. Any new version added will be
#'     accepted without undergoing a compatibility check.
#' 
#' -   *DISABLED*: This compatibility choice prevents versioning for a
#'     particular schema. You can use this choice to prevent future
#'     versioning of a schema.
#' 
#' -   *BACKWARD*: This compatibility choice is recommended as it allows
#'     data receivers to read both the current and one previous schema
#'     version. This means that for instance, a new schema version cannot
#'     drop data fields or change the type of these fields, so they can't
#'     be read by readers using the previous version.
#' 
#' -   *BACKWARD_ALL*: This compatibility choice allows data receivers to
#'     read both the current and all previous schema versions. You can use
#'     this choice when you need to delete fields or add optional fields,
#'     and check compatibility against all previous schema versions.
#' 
#' -   *FORWARD*: This compatibility choice allows data receivers to read
#'     both the current and one next schema version, but not necessarily
#'     later versions. You can use this choice when you need to add fields
#'     or delete optional fields, but only check compatibility against the
#'     last schema version.
#' 
#' -   *FORWARD_ALL*: This compatibility choice allows data receivers to
#'     read written by producers of any new registered schema. You can use
#'     this choice when you need to add fields or delete optional fields,
#'     and check compatibility against all previous schema versions.
#' 
#' -   *FULL*: This compatibility choice allows data receivers to read data
#'     written by producers using the previous or next version of the
#'     schema, but not necessarily earlier or later versions. You can use
#'     this choice when you need to add or remove optional fields, but only
#'     check compatibility against the last schema version.
#' 
#' -   *FULL_ALL*: This compatibility choice allows data receivers to read
#'     data written by producers using all previous schema versions. You
#'     can use this choice when you need to add or remove optional fields,
#'     and check compatibility against all previous schema versions.
#' @param Description An optional description of the schema. If description is not provided,
#' there will not be any automatic default value for this.
#' @param Tags Amazon Web Services tags that contain a key value pair and may be
#' searched by console, command line, or API. If specified, follows the
#' Amazon Web Services tags-on-create pattern.
#' @param SchemaDefinition The schema definition using the `DataFormat` setting for `SchemaName`.
#'
#' @keywords internal
#'
#' @rdname glue_create_schema
glue_create_schema <- function(RegistryId = NULL, SchemaName, DataFormat, Compatibility = NULL, Description = NULL, Tags = NULL, SchemaDefinition = NULL) {
  op <- new_operation(
    name = "CreateSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_schema_input(RegistryId = RegistryId, SchemaName = SchemaName, DataFormat = DataFormat, Compatibility = Compatibility, Description = Description, Tags = Tags, SchemaDefinition = SchemaDefinition)
  output <- .glue$create_schema_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_schema <- glue_create_schema

#' Transforms a directed acyclic graph (DAG) into code
#'
#' @description
#' Transforms a directed acyclic graph (DAG) into code.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_script/](https://www.paws-r-sdk.com/docs/glue_create_script/) for full documentation.
#'
#' @param DagNodes A list of the nodes in the DAG.
#' @param DagEdges A list of the edges in the DAG.
#' @param Language The programming language of the resulting code from the DAG.
#'
#' @keywords internal
#'
#' @rdname glue_create_script
glue_create_script <- function(DagNodes = NULL, DagEdges = NULL, Language = NULL) {
  op <- new_operation(
    name = "CreateScript",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_script_input(DagNodes = DagNodes, DagEdges = DagEdges, Language = Language)
  output <- .glue$create_script_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_script <- glue_create_script

#' Creates a new security configuration
#'
#' @description
#' Creates a new security configuration. A security configuration is a set of security properties that can be used by Glue. You can use a security configuration to encrypt data at rest. For information about using security configurations in Glue, see [Encrypting Data Written by Crawlers, Jobs, and Development Endpoints](https://docs.aws.amazon.com/glue/latest/dg/encryption-security-configuration.html).
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_security_configuration/](https://www.paws-r-sdk.com/docs/glue_create_security_configuration/) for full documentation.
#'
#' @param Name &#91;required&#93; The name for the new security configuration.
#' @param EncryptionConfiguration &#91;required&#93; The encryption configuration for the new security configuration.
#'
#' @keywords internal
#'
#' @rdname glue_create_security_configuration
glue_create_security_configuration <- function(Name, EncryptionConfiguration) {
  op <- new_operation(
    name = "CreateSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_security_configuration_input(Name = Name, EncryptionConfiguration = EncryptionConfiguration)
  output <- .glue$create_security_configuration_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_security_configuration <- glue_create_security_configuration

#' Creates a new session
#'
#' @description
#' Creates a new session.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_session/](https://www.paws-r-sdk.com/docs/glue_create_session/) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the session request.
#' @param Description The description of the session.
#' @param Role &#91;required&#93; The IAM Role ARN
#' @param Command &#91;required&#93; The `SessionCommand` that runs the job.
#' @param Timeout The number of minutes before session times out. Default for Spark ETL
#' jobs is 48 hours (2880 minutes), the maximum session lifetime for this
#' job type. Consult the documentation for other job types.
#' @param IdleTimeout The number of minutes when idle before session times out. Default for
#' Spark ETL jobs is value of Timeout. Consult the documentation for other
#' job types.
#' @param DefaultArguments A map array of key-value pairs. Max is 75 pairs.
#' @param Connections The number of connections to use for the session.
#' @param MaxCapacity The number of Glue data processing units (DPUs) that can be allocated
#' when the job runs. A DPU is a relative measure of processing power that
#' consists of 4 vCPUs of compute capacity and 16 GB memory.
#' @param NumberOfWorkers The number of workers of a defined `WorkerType` to use for the session.
#' @param WorkerType The type of predefined worker that is allocated when a job runs. Accepts
#' a value of G.1X, G.2X, G.4X, or G.8X for Spark jobs. Accepts the value
#' Z.2X for Ray notebooks.
#' 
#' -   For the `G.1X` worker type, each worker maps to 1 DPU (4 vCPUs, 16
#'     GB of memory) with 84GB disk (approximately 34GB free), and provides
#'     1 executor per worker. We recommend this worker type for workloads
#'     such as data transforms, joins, and queries, to offers a scalable
#'     and cost effective way to run most jobs.
#' 
#' -   For the `G.2X` worker type, each worker maps to 2 DPU (8 vCPUs, 32
#'     GB of memory) with 128GB disk (approximately 77GB free), and
#'     provides 1 executor per worker. We recommend this worker type for
#'     workloads such as data transforms, joins, and queries, to offers a
#'     scalable and cost effective way to run most jobs.
#' 
#' -   For the `G.4X` worker type, each worker maps to 4 DPU (16 vCPUs, 64
#'     GB of memory) with 256GB disk (approximately 235GB free), and
#'     provides 1 executor per worker. We recommend this worker type for
#'     jobs whose workloads contain your most demanding transforms,
#'     aggregations, joins, and queries. This worker type is available only
#'     for Glue version 3.0 or later Spark ETL jobs in the following Amazon
#'     Web Services Regions: US East (Ohio), US East (N. Virginia), US West
#'     (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia
#'     Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe
#'     (Ireland), and Europe (Stockholm).
#' 
#' -   For the `G.8X` worker type, each worker maps to 8 DPU (32 vCPUs, 128
#'     GB of memory) with 512GB disk (approximately 487GB free), and
#'     provides 1 executor per worker. We recommend this worker type for
#'     jobs whose workloads contain your most demanding transforms,
#'     aggregations, joins, and queries. This worker type is available only
#'     for Glue version 3.0 or later Spark ETL jobs, in the same Amazon Web
#'     Services Regions as supported for the `G.4X` worker type.
#' 
#' -   For the `Z.2X` worker type, each worker maps to 2 M-DPU (8vCPUs, 64
#'     GB of memory) with 128 GB disk (approximately 120GB free), and
#'     provides up to 8 Ray workers based on the autoscaler.
#' @param SecurityConfiguration The name of the SecurityConfiguration structure to be used with the
#' session
#' @param GlueVersion The Glue version determines the versions of Apache Spark and Python that
#' Glue supports. The GlueVersion must be greater than 2.0.
#' @param Tags The map of key value pairs (tags) belonging to the session.
#' @param RequestOrigin The origin of the request.
#'
#' @keywords internal
#'
#' @rdname glue_create_session
glue_create_session <- function(Id, Description = NULL, Role, Command, Timeout = NULL, IdleTimeout = NULL, DefaultArguments = NULL, Connections = NULL, MaxCapacity = NULL, NumberOfWorkers = NULL, WorkerType = NULL, SecurityConfiguration = NULL, GlueVersion = NULL, Tags = NULL, RequestOrigin = NULL) {
  op <- new_operation(
    name = "CreateSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_session_input(Id = Id, Description = Description, Role = Role, Command = Command, Timeout = Timeout, IdleTimeout = IdleTimeout, DefaultArguments = DefaultArguments, Connections = Connections, MaxCapacity = MaxCapacity, NumberOfWorkers = NumberOfWorkers, WorkerType = WorkerType, SecurityConfiguration = SecurityConfiguration, GlueVersion = GlueVersion, Tags = Tags, RequestOrigin = RequestOrigin)
  output <- .glue$create_session_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_session <- glue_create_session

#' Creates a new table definition in the Data Catalog
#'
#' @description
#' Creates a new table definition in the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_table/](https://www.paws-r-sdk.com/docs/glue_create_table/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog in which to create the `Table`. If none is
#' supplied, the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The catalog database in which to create the new table. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableInput &#91;required&#93; The `TableInput` object that defines the metadata table to create in the
#' catalog.
#' @param PartitionIndexes A list of partition indexes, `PartitionIndex` structures, to create in
#' the table.
#' @param TransactionId The ID of the transaction.
#' @param OpenTableFormatInput Specifies an `OpenTableFormatInput` structure when creating an open
#' format table.
#'
#' @keywords internal
#'
#' @rdname glue_create_table
glue_create_table <- function(CatalogId = NULL, DatabaseName, TableInput, PartitionIndexes = NULL, TransactionId = NULL, OpenTableFormatInput = NULL) {
  op <- new_operation(
    name = "CreateTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableInput = TableInput, PartitionIndexes = PartitionIndexes, TransactionId = TransactionId, OpenTableFormatInput = OpenTableFormatInput)
  output <- .glue$create_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_table <- glue_create_table

#' Creates a new table optimizer for a specific function
#'
#' @description
#' Creates a new table optimizer for a specific function. `compaction` is the only currently supported optimizer type.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_table_optimizer/](https://www.paws-r-sdk.com/docs/glue_create_table_optimizer/) for full documentation.
#'
#' @param CatalogId &#91;required&#93; The Catalog ID of the table.
#' @param DatabaseName &#91;required&#93; The name of the database in the catalog in which the table resides.
#' @param TableName &#91;required&#93; The name of the table.
#' @param Type &#91;required&#93; The type of table optimizer. Currently, the only valid value is
#' `compaction`.
#' @param TableOptimizerConfiguration &#91;required&#93; A `TableOptimizerConfiguration` object representing the configuration of
#' a table optimizer.
#'
#' @keywords internal
#'
#' @rdname glue_create_table_optimizer
glue_create_table_optimizer <- function(CatalogId, DatabaseName, TableName, Type, TableOptimizerConfiguration) {
  op <- new_operation(
    name = "CreateTableOptimizer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_table_optimizer_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, Type = Type, TableOptimizerConfiguration = TableOptimizerConfiguration)
  output <- .glue$create_table_optimizer_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_table_optimizer <- glue_create_table_optimizer

#' Creates a new trigger
#'
#' @description
#' Creates a new trigger.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_trigger/](https://www.paws-r-sdk.com/docs/glue_create_trigger/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the trigger.
#' @param WorkflowName The name of the workflow associated with the trigger.
#' @param Type &#91;required&#93; The type of the new trigger.
#' @param Schedule A `cron` expression used to specify the schedule (see [Time-Based
#' Schedules for Jobs and
#' Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
#' For example, to run something every day at 12:15 UTC, you would specify:
#' `cron(15 12 * * ? *)`.
#' 
#' This field is required when the trigger type is SCHEDULED.
#' @param Predicate A predicate to specify when the new trigger should fire.
#' 
#' This field is required when the trigger type is `CONDITIONAL`.
#' @param Actions &#91;required&#93; The actions initiated by this trigger when it fires.
#' @param Description A description of the new trigger.
#' @param StartOnCreation Set to `true` to start `SCHEDULED` and `CONDITIONAL` triggers when
#' created. True is not supported for `ON_DEMAND` triggers.
#' @param Tags The tags to use with this trigger. You may use tags to limit access to
#' the trigger. For more information about tags in Glue, see [Amazon Web
#' Services Tags in
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in
#' the developer guide.
#' @param EventBatchingCondition Batch condition that must be met (specified number of events received or
#' batch time window expired) before EventBridge event trigger fires.
#'
#' @keywords internal
#'
#' @rdname glue_create_trigger
glue_create_trigger <- function(Name, WorkflowName = NULL, Type, Schedule = NULL, Predicate = NULL, Actions, Description = NULL, StartOnCreation = NULL, Tags = NULL, EventBatchingCondition = NULL) {
  op <- new_operation(
    name = "CreateTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_trigger_input(Name = Name, WorkflowName = WorkflowName, Type = Type, Schedule = Schedule, Predicate = Predicate, Actions = Actions, Description = Description, StartOnCreation = StartOnCreation, Tags = Tags, EventBatchingCondition = EventBatchingCondition)
  output <- .glue$create_trigger_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_trigger <- glue_create_trigger

#' Creates a new function definition in the Data Catalog
#'
#' @description
#' Creates a new function definition in the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_user_defined_function/](https://www.paws-r-sdk.com/docs/glue_create_user_defined_function/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog in which to create the function. If none is
#' provided, the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which to create the function.
#' @param FunctionInput &#91;required&#93; A `FunctionInput` object that defines the function to create in the Data
#' Catalog.
#'
#' @keywords internal
#'
#' @rdname glue_create_user_defined_function
glue_create_user_defined_function <- function(CatalogId = NULL, DatabaseName, FunctionInput) {
  op <- new_operation(
    name = "CreateUserDefinedFunction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_user_defined_function_input(CatalogId = CatalogId, DatabaseName = DatabaseName, FunctionInput = FunctionInput)
  output <- .glue$create_user_defined_function_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_user_defined_function <- glue_create_user_defined_function

#' Creates a new workflow
#'
#' @description
#' Creates a new workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_create_workflow/](https://www.paws-r-sdk.com/docs/glue_create_workflow/) for full documentation.
#'
#' @param Name &#91;required&#93; The name to be assigned to the workflow. It should be unique within your
#' account.
#' @param Description A description of the workflow.
#' @param DefaultRunProperties A collection of properties to be used as part of each execution of the
#' workflow.
#' @param Tags The tags to be used with this workflow.
#' @param MaxConcurrentRuns You can use this parameter to prevent unwanted multiple updates to data,
#' to control costs, or in some cases, to prevent exceeding the maximum
#' number of concurrent runs of any of the component jobs. If you leave
#' this parameter blank, there is no limit to the number of concurrent
#' workflow runs.
#'
#' @keywords internal
#'
#' @rdname glue_create_workflow
glue_create_workflow <- function(Name, Description = NULL, DefaultRunProperties = NULL, Tags = NULL, MaxConcurrentRuns = NULL) {
  op <- new_operation(
    name = "CreateWorkflow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_workflow_input(Name = Name, Description = Description, DefaultRunProperties = DefaultRunProperties, Tags = Tags, MaxConcurrentRuns = MaxConcurrentRuns)
  output <- .glue$create_workflow_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_workflow <- glue_create_workflow

#' Deletes an existing blueprint
#'
#' @description
#' Deletes an existing blueprint.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_blueprint/](https://www.paws-r-sdk.com/docs/glue_delete_blueprint/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the blueprint to delete.
#'
#' @keywords internal
#'
#' @rdname glue_delete_blueprint
glue_delete_blueprint <- function(Name) {
  op <- new_operation(
    name = "DeleteBlueprint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_blueprint_input(Name = Name)
  output <- .glue$delete_blueprint_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_blueprint <- glue_delete_blueprint

#' Removes a classifier from the Data Catalog
#'
#' @description
#' Removes a classifier from the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_classifier/](https://www.paws-r-sdk.com/docs/glue_delete_classifier/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the classifier to remove.
#'
#' @keywords internal
#'
#' @rdname glue_delete_classifier
glue_delete_classifier <- function(Name) {
  op <- new_operation(
    name = "DeleteClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_classifier_input(Name = Name)
  output <- .glue$delete_classifier_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_classifier <- glue_delete_classifier

#' Delete the partition column statistics of a column
#'
#' @description
#' Delete the partition column statistics of a column.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_column_statistics_for_partition/](https://www.paws-r-sdk.com/docs/glue_delete_column_statistics_for_partition/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param PartitionValues &#91;required&#93; A list of partition values identifying the partition.
#' @param ColumnName &#91;required&#93; Name of the column.
#'
#' @keywords internal
#'
#' @rdname glue_delete_column_statistics_for_partition
glue_delete_column_statistics_for_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValues, ColumnName) {
  op <- new_operation(
    name = "DeleteColumnStatisticsForPartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_column_statistics_for_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValues = PartitionValues, ColumnName = ColumnName)
  output <- .glue$delete_column_statistics_for_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_column_statistics_for_partition <- glue_delete_column_statistics_for_partition

#' Retrieves table statistics of columns
#'
#' @description
#' Retrieves table statistics of columns.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_column_statistics_for_table/](https://www.paws-r-sdk.com/docs/glue_delete_column_statistics_for_table/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param ColumnName &#91;required&#93; The name of the column.
#'
#' @keywords internal
#'
#' @rdname glue_delete_column_statistics_for_table
glue_delete_column_statistics_for_table <- function(CatalogId = NULL, DatabaseName, TableName, ColumnName) {
  op <- new_operation(
    name = "DeleteColumnStatisticsForTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_column_statistics_for_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, ColumnName = ColumnName)
  output <- .glue$delete_column_statistics_for_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_column_statistics_for_table <- glue_delete_column_statistics_for_table

#' Deletes a connection from the Data Catalog
#'
#' @description
#' Deletes a connection from the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_connection/](https://www.paws-r-sdk.com/docs/glue_delete_connection/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog in which the connection resides. If none is
#' provided, the Amazon Web Services account ID is used by default.
#' @param ConnectionName &#91;required&#93; The name of the connection to delete.
#'
#' @keywords internal
#'
#' @rdname glue_delete_connection
glue_delete_connection <- function(CatalogId = NULL, ConnectionName) {
  op <- new_operation(
    name = "DeleteConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_connection_input(CatalogId = CatalogId, ConnectionName = ConnectionName)
  output <- .glue$delete_connection_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_connection <- glue_delete_connection

#' Removes a specified crawler from the Glue Data Catalog, unless the
#' crawler state is RUNNING
#'
#' @description
#' Removes a specified crawler from the Glue Data Catalog, unless the crawler state is `RUNNING`.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_crawler/](https://www.paws-r-sdk.com/docs/glue_delete_crawler/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the crawler to remove.
#'
#' @keywords internal
#'
#' @rdname glue_delete_crawler
glue_delete_crawler <- function(Name) {
  op <- new_operation(
    name = "DeleteCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_crawler_input(Name = Name)
  output <- .glue$delete_crawler_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_crawler <- glue_delete_crawler

#' Deletes a custom pattern by specifying its name
#'
#' @description
#' Deletes a custom pattern by specifying its name.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_custom_entity_type/](https://www.paws-r-sdk.com/docs/glue_delete_custom_entity_type/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the custom pattern that you want to delete.
#'
#' @keywords internal
#'
#' @rdname glue_delete_custom_entity_type
glue_delete_custom_entity_type <- function(Name) {
  op <- new_operation(
    name = "DeleteCustomEntityType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_custom_entity_type_input(Name = Name)
  output <- .glue$delete_custom_entity_type_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_custom_entity_type <- glue_delete_custom_entity_type

#' Deletes a data quality ruleset
#'
#' @description
#' Deletes a data quality ruleset.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_data_quality_ruleset/](https://www.paws-r-sdk.com/docs/glue_delete_data_quality_ruleset/) for full documentation.
#'
#' @param Name &#91;required&#93; A name for the data quality ruleset.
#'
#' @keywords internal
#'
#' @rdname glue_delete_data_quality_ruleset
glue_delete_data_quality_ruleset <- function(Name) {
  op <- new_operation(
    name = "DeleteDataQualityRuleset",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_data_quality_ruleset_input(Name = Name)
  output <- .glue$delete_data_quality_ruleset_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_data_quality_ruleset <- glue_delete_data_quality_ruleset

#' Removes a specified database from a Data Catalog
#'
#' @description
#' Removes a specified database from a Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_database/](https://www.paws-r-sdk.com/docs/glue_delete_database/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog in which the database resides. If none is
#' provided, the Amazon Web Services account ID is used by default.
#' @param Name &#91;required&#93; The name of the database to delete. For Hive compatibility, this must be
#' all lowercase.
#'
#' @keywords internal
#'
#' @rdname glue_delete_database
glue_delete_database <- function(CatalogId = NULL, Name) {
  op <- new_operation(
    name = "DeleteDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_database_input(CatalogId = CatalogId, Name = Name)
  output <- .glue$delete_database_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_database <- glue_delete_database

#' Deletes a specified development endpoint
#'
#' @description
#' Deletes a specified development endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_dev_endpoint/](https://www.paws-r-sdk.com/docs/glue_delete_dev_endpoint/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the `DevEndpoint`.
#'
#' @keywords internal
#'
#' @rdname glue_delete_dev_endpoint
glue_delete_dev_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "DeleteDevEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_dev_endpoint_input(EndpointName = EndpointName)
  output <- .glue$delete_dev_endpoint_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_dev_endpoint <- glue_delete_dev_endpoint

#' Deletes a specified job definition
#'
#' @description
#' Deletes a specified job definition. If the job definition is not found, no exception is thrown.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_job/](https://www.paws-r-sdk.com/docs/glue_delete_job/) for full documentation.
#'
#' @param JobName &#91;required&#93; The name of the job definition to delete.
#'
#' @keywords internal
#'
#' @rdname glue_delete_job
glue_delete_job <- function(JobName) {
  op <- new_operation(
    name = "DeleteJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_job_input(JobName = JobName)
  output <- .glue$delete_job_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_job <- glue_delete_job

#' Deletes an Glue machine learning transform
#'
#' @description
#' Deletes an Glue machine learning transform. Machine learning transforms are a special type of transform that use machine learning to learn the details of the transformation to be performed by learning from examples provided by humans. These transformations are then saved by Glue. If you no longer need a transform, you can delete it by calling `DeleteMLTransforms`. However, any Glue jobs that still reference the deleted transform will no longer succeed.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_ml_transform/](https://www.paws-r-sdk.com/docs/glue_delete_ml_transform/) for full documentation.
#'
#' @param TransformId &#91;required&#93; The unique identifier of the transform to delete.
#'
#' @keywords internal
#'
#' @rdname glue_delete_ml_transform
glue_delete_ml_transform <- function(TransformId) {
  op <- new_operation(
    name = "DeleteMLTransform",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_ml_transform_input(TransformId = TransformId)
  output <- .glue$delete_ml_transform_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_ml_transform <- glue_delete_ml_transform

#' Deletes a specified partition
#'
#' @description
#' Deletes a specified partition.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_partition/](https://www.paws-r-sdk.com/docs/glue_delete_partition/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the partition to be deleted resides. If
#' none is provided, the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table in question resides.
#' @param TableName &#91;required&#93; The name of the table that contains the partition to be deleted.
#' @param PartitionValues &#91;required&#93; The values that define the partition.
#'
#' @keywords internal
#'
#' @rdname glue_delete_partition
glue_delete_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValues) {
  op <- new_operation(
    name = "DeletePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValues = PartitionValues)
  output <- .glue$delete_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_partition <- glue_delete_partition

#' Deletes a specified partition index from an existing table
#'
#' @description
#' Deletes a specified partition index from an existing table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_partition_index/](https://www.paws-r-sdk.com/docs/glue_delete_partition_index/) for full documentation.
#'
#' @param CatalogId The catalog ID where the table resides.
#' @param DatabaseName &#91;required&#93; Specifies the name of a database from which you want to delete a
#' partition index.
#' @param TableName &#91;required&#93; Specifies the name of a table from which you want to delete a partition
#' index.
#' @param IndexName &#91;required&#93; The name of the partition index to be deleted.
#'
#' @keywords internal
#'
#' @rdname glue_delete_partition_index
glue_delete_partition_index <- function(CatalogId = NULL, DatabaseName, TableName, IndexName) {
  op <- new_operation(
    name = "DeletePartitionIndex",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_partition_index_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, IndexName = IndexName)
  output <- .glue$delete_partition_index_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_partition_index <- glue_delete_partition_index

#' Delete the entire registry including schema and all of its versions
#'
#' @description
#' Delete the entire registry including schema and all of its versions. To get the status of the delete operation, you can call the [`get_registry`][glue_get_registry] API after the asynchronous call. Deleting a registry will deactivate all online operations for the registry such as the [`update_registry`][glue_update_registry], [`create_schema`][glue_create_schema], [`update_schema`][glue_update_schema], and [`register_schema_version`][glue_register_schema_version] APIs.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_registry/](https://www.paws-r-sdk.com/docs/glue_delete_registry/) for full documentation.
#'
#' @param RegistryId &#91;required&#93; This is a wrapper structure that may contain the registry name and
#' Amazon Resource Name (ARN).
#'
#' @keywords internal
#'
#' @rdname glue_delete_registry
glue_delete_registry <- function(RegistryId) {
  op <- new_operation(
    name = "DeleteRegistry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_registry_input(RegistryId = RegistryId)
  output <- .glue$delete_registry_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_registry <- glue_delete_registry

#' Deletes a specified policy
#'
#' @description
#' Deletes a specified policy.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_resource_policy/](https://www.paws-r-sdk.com/docs/glue_delete_resource_policy/) for full documentation.
#'
#' @param PolicyHashCondition The hash value returned when this policy was set.
#' @param ResourceArn The ARN of the Glue resource for the resource policy to be deleted.
#'
#' @keywords internal
#'
#' @rdname glue_delete_resource_policy
glue_delete_resource_policy <- function(PolicyHashCondition = NULL, ResourceArn = NULL) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_resource_policy_input(PolicyHashCondition = PolicyHashCondition, ResourceArn = ResourceArn)
  output <- .glue$delete_resource_policy_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_resource_policy <- glue_delete_resource_policy

#' Deletes the entire schema set, including the schema set and all of its
#' versions
#'
#' @description
#' Deletes the entire schema set, including the schema set and all of its versions. To get the status of the delete operation, you can call [`get_schema`][glue_get_schema] API after the asynchronous call. Deleting a registry will deactivate all online operations for the schema, such as the [`get_schema_by_definition`][glue_get_schema_by_definition], and [`register_schema_version`][glue_register_schema_version] APIs.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_schema/](https://www.paws-r-sdk.com/docs/glue_delete_schema/) for full documentation.
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure that may contain the schema name and Amazon
#' Resource Name (ARN).
#'
#' @keywords internal
#'
#' @rdname glue_delete_schema
glue_delete_schema <- function(SchemaId) {
  op <- new_operation(
    name = "DeleteSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_schema_input(SchemaId = SchemaId)
  output <- .glue$delete_schema_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_schema <- glue_delete_schema

#' Remove versions from the specified schema
#'
#' @description
#' Remove versions from the specified schema. A version number or range may be supplied. If the compatibility mode forbids deleting of a version that is necessary, such as BACKWARDS_FULL, an error is returned. Calling the `GetSchemaVersions` API after this call will list the status of the deleted versions.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_schema_versions/](https://www.paws-r-sdk.com/docs/glue_delete_schema_versions/) for full documentation.
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure that may contain the schema name and Amazon
#' Resource Name (ARN).
#' @param Versions &#91;required&#93; A version range may be supplied which may be of the format:
#' 
#' -   a single version number, 5
#' 
#' -   a range, 5-8 : deletes versions 5, 6, 7, 8
#'
#' @keywords internal
#'
#' @rdname glue_delete_schema_versions
glue_delete_schema_versions <- function(SchemaId, Versions) {
  op <- new_operation(
    name = "DeleteSchemaVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_schema_versions_input(SchemaId = SchemaId, Versions = Versions)
  output <- .glue$delete_schema_versions_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_schema_versions <- glue_delete_schema_versions

#' Deletes a specified security configuration
#'
#' @description
#' Deletes a specified security configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_security_configuration/](https://www.paws-r-sdk.com/docs/glue_delete_security_configuration/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the security configuration to delete.
#'
#' @keywords internal
#'
#' @rdname glue_delete_security_configuration
glue_delete_security_configuration <- function(Name) {
  op <- new_operation(
    name = "DeleteSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_security_configuration_input(Name = Name)
  output <- .glue$delete_security_configuration_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_security_configuration <- glue_delete_security_configuration

#' Deletes the session
#'
#' @description
#' Deletes the session.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_session/](https://www.paws-r-sdk.com/docs/glue_delete_session/) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the session to be deleted.
#' @param RequestOrigin The name of the origin of the delete session request.
#'
#' @keywords internal
#'
#' @rdname glue_delete_session
glue_delete_session <- function(Id, RequestOrigin = NULL) {
  op <- new_operation(
    name = "DeleteSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_session_input(Id = Id, RequestOrigin = RequestOrigin)
  output <- .glue$delete_session_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_session <- glue_delete_session

#' Removes a table definition from the Data Catalog
#'
#' @description
#' Removes a table definition from the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_table/](https://www.paws-r-sdk.com/docs/glue_delete_table/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the table resides. If none is provided,
#' the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param Name &#91;required&#93; The name of the table to be deleted. For Hive compatibility, this name
#' is entirely lowercase.
#' @param TransactionId The transaction ID at which to delete the table contents.
#'
#' @keywords internal
#'
#' @rdname glue_delete_table
glue_delete_table <- function(CatalogId = NULL, DatabaseName, Name, TransactionId = NULL) {
  op <- new_operation(
    name = "DeleteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, Name = Name, TransactionId = TransactionId)
  output <- .glue$delete_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_table <- glue_delete_table

#' Deletes an optimizer and all associated metadata for a table
#'
#' @description
#' Deletes an optimizer and all associated metadata for a table. The optimization will no longer be performed on the table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_table_optimizer/](https://www.paws-r-sdk.com/docs/glue_delete_table_optimizer/) for full documentation.
#'
#' @param CatalogId &#91;required&#93; The Catalog ID of the table.
#' @param DatabaseName &#91;required&#93; The name of the database in the catalog in which the table resides.
#' @param TableName &#91;required&#93; The name of the table.
#' @param Type &#91;required&#93; The type of table optimizer.
#'
#' @keywords internal
#'
#' @rdname glue_delete_table_optimizer
glue_delete_table_optimizer <- function(CatalogId, DatabaseName, TableName, Type) {
  op <- new_operation(
    name = "DeleteTableOptimizer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_table_optimizer_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, Type = Type)
  output <- .glue$delete_table_optimizer_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_table_optimizer <- glue_delete_table_optimizer

#' Deletes a specified version of a table
#'
#' @description
#' Deletes a specified version of a table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_table_version/](https://www.paws-r-sdk.com/docs/glue_delete_table_version/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is provided,
#' the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableName &#91;required&#93; The name of the table. For Hive compatibility, this name is entirely
#' lowercase.
#' @param VersionId &#91;required&#93; The ID of the table version to be deleted. A `VersionID` is a string
#' representation of an integer. Each version is incremented by 1.
#'
#' @keywords internal
#'
#' @rdname glue_delete_table_version
glue_delete_table_version <- function(CatalogId = NULL, DatabaseName, TableName, VersionId) {
  op <- new_operation(
    name = "DeleteTableVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_table_version_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, VersionId = VersionId)
  output <- .glue$delete_table_version_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_table_version <- glue_delete_table_version

#' Deletes a specified trigger
#'
#' @description
#' Deletes a specified trigger. If the trigger is not found, no exception is thrown.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_trigger/](https://www.paws-r-sdk.com/docs/glue_delete_trigger/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the trigger to delete.
#'
#' @keywords internal
#'
#' @rdname glue_delete_trigger
glue_delete_trigger <- function(Name) {
  op <- new_operation(
    name = "DeleteTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_trigger_input(Name = Name)
  output <- .glue$delete_trigger_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_trigger <- glue_delete_trigger

#' Deletes an existing function definition from the Data Catalog
#'
#' @description
#' Deletes an existing function definition from the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_user_defined_function/](https://www.paws-r-sdk.com/docs/glue_delete_user_defined_function/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the function to be deleted is located.
#' If none is supplied, the Amazon Web Services account ID is used by
#' default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the function is located.
#' @param FunctionName &#91;required&#93; The name of the function definition to be deleted.
#'
#' @keywords internal
#'
#' @rdname glue_delete_user_defined_function
glue_delete_user_defined_function <- function(CatalogId = NULL, DatabaseName, FunctionName) {
  op <- new_operation(
    name = "DeleteUserDefinedFunction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_user_defined_function_input(CatalogId = CatalogId, DatabaseName = DatabaseName, FunctionName = FunctionName)
  output <- .glue$delete_user_defined_function_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_user_defined_function <- glue_delete_user_defined_function

#' Deletes a workflow
#'
#' @description
#' Deletes a workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_delete_workflow/](https://www.paws-r-sdk.com/docs/glue_delete_workflow/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the workflow to be deleted.
#'
#' @keywords internal
#'
#' @rdname glue_delete_workflow
glue_delete_workflow <- function(Name) {
  op <- new_operation(
    name = "DeleteWorkflow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_workflow_input(Name = Name)
  output <- .glue$delete_workflow_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_workflow <- glue_delete_workflow

#' Retrieves the details of a blueprint
#'
#' @description
#' Retrieves the details of a blueprint.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_blueprint/](https://www.paws-r-sdk.com/docs/glue_get_blueprint/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the blueprint.
#' @param IncludeBlueprint Specifies whether or not to include the blueprint in the response.
#' @param IncludeParameterSpec Specifies whether or not to include the parameter specification.
#'
#' @keywords internal
#'
#' @rdname glue_get_blueprint
glue_get_blueprint <- function(Name, IncludeBlueprint = NULL, IncludeParameterSpec = NULL) {
  op <- new_operation(
    name = "GetBlueprint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_blueprint_input(Name = Name, IncludeBlueprint = IncludeBlueprint, IncludeParameterSpec = IncludeParameterSpec)
  output <- .glue$get_blueprint_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_blueprint <- glue_get_blueprint

#' Retrieves the details of a blueprint run
#'
#' @description
#' Retrieves the details of a blueprint run.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_blueprint_run/](https://www.paws-r-sdk.com/docs/glue_get_blueprint_run/) for full documentation.
#'
#' @param BlueprintName &#91;required&#93; The name of the blueprint.
#' @param RunId &#91;required&#93; The run ID for the blueprint run you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname glue_get_blueprint_run
glue_get_blueprint_run <- function(BlueprintName, RunId) {
  op <- new_operation(
    name = "GetBlueprintRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_blueprint_run_input(BlueprintName = BlueprintName, RunId = RunId)
  output <- .glue$get_blueprint_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_blueprint_run <- glue_get_blueprint_run

#' Retrieves the details of blueprint runs for a specified blueprint
#'
#' @description
#' Retrieves the details of blueprint runs for a specified blueprint.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_blueprint_runs/](https://www.paws-r-sdk.com/docs/glue_get_blueprint_runs/) for full documentation.
#'
#' @param BlueprintName &#91;required&#93; The name of the blueprint.
#' @param NextToken A continuation token, if this is a continuation request.
#' @param MaxResults The maximum size of a list to return.
#'
#' @keywords internal
#'
#' @rdname glue_get_blueprint_runs
glue_get_blueprint_runs <- function(BlueprintName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetBlueprintRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_blueprint_runs_input(BlueprintName = BlueprintName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_blueprint_runs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_blueprint_runs <- glue_get_blueprint_runs

#' Retrieves the status of a migration operation
#'
#' @description
#' Retrieves the status of a migration operation.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_catalog_import_status/](https://www.paws-r-sdk.com/docs/glue_get_catalog_import_status/) for full documentation.
#'
#' @param CatalogId The ID of the catalog to migrate. Currently, this should be the Amazon
#' Web Services account ID.
#'
#' @keywords internal
#'
#' @rdname glue_get_catalog_import_status
glue_get_catalog_import_status <- function(CatalogId = NULL) {
  op <- new_operation(
    name = "GetCatalogImportStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_catalog_import_status_input(CatalogId = CatalogId)
  output <- .glue$get_catalog_import_status_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_catalog_import_status <- glue_get_catalog_import_status

#' Retrieve a classifier by name
#'
#' @description
#' Retrieve a classifier by name.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_classifier/](https://www.paws-r-sdk.com/docs/glue_get_classifier/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the classifier to retrieve.
#'
#' @keywords internal
#'
#' @rdname glue_get_classifier
glue_get_classifier <- function(Name) {
  op <- new_operation(
    name = "GetClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_classifier_input(Name = Name)
  output <- .glue$get_classifier_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_classifier <- glue_get_classifier

#' Lists all classifier objects in the Data Catalog
#'
#' @description
#' Lists all classifier objects in the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_classifiers/](https://www.paws-r-sdk.com/docs/glue_get_classifiers/) for full documentation.
#'
#' @param MaxResults The size of the list to return (optional).
#' @param NextToken An optional continuation token.
#'
#' @keywords internal
#'
#' @rdname glue_get_classifiers
glue_get_classifiers <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetClassifiers",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_classifiers_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_classifiers_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_classifiers <- glue_get_classifiers

#' Retrieves partition statistics of columns
#'
#' @description
#' Retrieves partition statistics of columns.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_column_statistics_for_partition/](https://www.paws-r-sdk.com/docs/glue_get_column_statistics_for_partition/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param PartitionValues &#91;required&#93; A list of partition values identifying the partition.
#' @param ColumnNames &#91;required&#93; A list of the column names.
#'
#' @keywords internal
#'
#' @rdname glue_get_column_statistics_for_partition
glue_get_column_statistics_for_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValues, ColumnNames) {
  op <- new_operation(
    name = "GetColumnStatisticsForPartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_column_statistics_for_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValues = PartitionValues, ColumnNames = ColumnNames)
  output <- .glue$get_column_statistics_for_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_column_statistics_for_partition <- glue_get_column_statistics_for_partition

#' Retrieves table statistics of columns
#'
#' @description
#' Retrieves table statistics of columns.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_column_statistics_for_table/](https://www.paws-r-sdk.com/docs/glue_get_column_statistics_for_table/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param ColumnNames &#91;required&#93; A list of the column names.
#'
#' @keywords internal
#'
#' @rdname glue_get_column_statistics_for_table
glue_get_column_statistics_for_table <- function(CatalogId = NULL, DatabaseName, TableName, ColumnNames) {
  op <- new_operation(
    name = "GetColumnStatisticsForTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_column_statistics_for_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, ColumnNames = ColumnNames)
  output <- .glue$get_column_statistics_for_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_column_statistics_for_table <- glue_get_column_statistics_for_table

#' Get the associated metadata/information for a task run, given a task run
#' ID
#'
#' @description
#' Get the associated metadata/information for a task run, given a task run ID.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_column_statistics_task_run/](https://www.paws-r-sdk.com/docs/glue_get_column_statistics_task_run/) for full documentation.
#'
#' @param ColumnStatisticsTaskRunId &#91;required&#93; The identifier for the particular column statistics task run.
#'
#' @keywords internal
#'
#' @rdname glue_get_column_statistics_task_run
glue_get_column_statistics_task_run <- function(ColumnStatisticsTaskRunId) {
  op <- new_operation(
    name = "GetColumnStatisticsTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_column_statistics_task_run_input(ColumnStatisticsTaskRunId = ColumnStatisticsTaskRunId)
  output <- .glue$get_column_statistics_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_column_statistics_task_run <- glue_get_column_statistics_task_run

#' Retrieves information about all runs associated with the specified table
#'
#' @description
#' Retrieves information about all runs associated with the specified table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_column_statistics_task_runs/](https://www.paws-r-sdk.com/docs/glue_get_column_statistics_task_runs/) for full documentation.
#'
#' @param DatabaseName &#91;required&#93; The name of the database where the table resides.
#' @param TableName &#91;required&#93; The name of the table.
#' @param MaxResults The maximum size of the response.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @keywords internal
#'
#' @rdname glue_get_column_statistics_task_runs
glue_get_column_statistics_task_runs <- function(DatabaseName, TableName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetColumnStatisticsTaskRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_column_statistics_task_runs_input(DatabaseName = DatabaseName, TableName = TableName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_column_statistics_task_runs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_column_statistics_task_runs <- glue_get_column_statistics_task_runs

#' Retrieves a connection definition from the Data Catalog
#'
#' @description
#' Retrieves a connection definition from the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_connection/](https://www.paws-r-sdk.com/docs/glue_get_connection/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog in which the connection resides. If none is
#' provided, the Amazon Web Services account ID is used by default.
#' @param Name &#91;required&#93; The name of the connection definition to retrieve.
#' @param HidePassword Allows you to retrieve the connection metadata without returning the
#' password. For instance, the Glue console uses this flag to retrieve the
#' connection, and does not display the password. Set this parameter when
#' the caller might not have permission to use the KMS key to decrypt the
#' password, but it does have permission to access the rest of the
#' connection properties.
#'
#' @keywords internal
#'
#' @rdname glue_get_connection
glue_get_connection <- function(CatalogId = NULL, Name, HidePassword = NULL) {
  op <- new_operation(
    name = "GetConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_connection_input(CatalogId = CatalogId, Name = Name, HidePassword = HidePassword)
  output <- .glue$get_connection_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_connection <- glue_get_connection

#' Retrieves a list of connection definitions from the Data Catalog
#'
#' @description
#' Retrieves a list of connection definitions from the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_connections/](https://www.paws-r-sdk.com/docs/glue_get_connections/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog in which the connections reside. If none is
#' provided, the Amazon Web Services account ID is used by default.
#' @param Filter A filter that controls which connections are returned.
#' @param HidePassword Allows you to retrieve the connection metadata without returning the
#' password. For instance, the Glue console uses this flag to retrieve the
#' connection, and does not display the password. Set this parameter when
#' the caller might not have permission to use the KMS key to decrypt the
#' password, but it does have permission to access the rest of the
#' connection properties.
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum number of connections to return in one response.
#'
#' @keywords internal
#'
#' @rdname glue_get_connections
glue_get_connections <- function(CatalogId = NULL, Filter = NULL, HidePassword = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_connections_input(CatalogId = CatalogId, Filter = Filter, HidePassword = HidePassword, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_connections_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_connections <- glue_get_connections

#' Retrieves metadata for a specified crawler
#'
#' @description
#' Retrieves metadata for a specified crawler.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_crawler/](https://www.paws-r-sdk.com/docs/glue_get_crawler/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the crawler to retrieve metadata for.
#'
#' @keywords internal
#'
#' @rdname glue_get_crawler
glue_get_crawler <- function(Name) {
  op <- new_operation(
    name = "GetCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_crawler_input(Name = Name)
  output <- .glue$get_crawler_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_crawler <- glue_get_crawler

#' Retrieves metrics about specified crawlers
#'
#' @description
#' Retrieves metrics about specified crawlers.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_crawler_metrics/](https://www.paws-r-sdk.com/docs/glue_get_crawler_metrics/) for full documentation.
#'
#' @param CrawlerNameList A list of the names of crawlers about which to retrieve metrics.
#' @param MaxResults The maximum size of a list to return.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @keywords internal
#'
#' @rdname glue_get_crawler_metrics
glue_get_crawler_metrics <- function(CrawlerNameList = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetCrawlerMetrics",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_crawler_metrics_input(CrawlerNameList = CrawlerNameList, MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_crawler_metrics_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_crawler_metrics <- glue_get_crawler_metrics

#' Retrieves metadata for all crawlers defined in the customer account
#'
#' @description
#' Retrieves metadata for all crawlers defined in the customer account.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_crawlers/](https://www.paws-r-sdk.com/docs/glue_get_crawlers/) for full documentation.
#'
#' @param MaxResults The number of crawlers to return on each call.
#' @param NextToken A continuation token, if this is a continuation request.
#'
#' @keywords internal
#'
#' @rdname glue_get_crawlers
glue_get_crawlers <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetCrawlers",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_crawlers_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_crawlers_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_crawlers <- glue_get_crawlers

#' Retrieves the details of a custom pattern by specifying its name
#'
#' @description
#' Retrieves the details of a custom pattern by specifying its name.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_custom_entity_type/](https://www.paws-r-sdk.com/docs/glue_get_custom_entity_type/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the custom pattern that you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname glue_get_custom_entity_type
glue_get_custom_entity_type <- function(Name) {
  op <- new_operation(
    name = "GetCustomEntityType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_custom_entity_type_input(Name = Name)
  output <- .glue$get_custom_entity_type_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_custom_entity_type <- glue_get_custom_entity_type

#' Retrieves the security configuration for a specified catalog
#'
#' @description
#' Retrieves the security configuration for a specified catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_data_catalog_encryption_settings/](https://www.paws-r-sdk.com/docs/glue_get_data_catalog_encryption_settings/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog to retrieve the security configuration for.
#' If none is provided, the Amazon Web Services account ID is used by
#' default.
#'
#' @keywords internal
#'
#' @rdname glue_get_data_catalog_encryption_settings
glue_get_data_catalog_encryption_settings <- function(CatalogId = NULL) {
  op <- new_operation(
    name = "GetDataCatalogEncryptionSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_data_catalog_encryption_settings_input(CatalogId = CatalogId)
  output <- .glue$get_data_catalog_encryption_settings_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_data_catalog_encryption_settings <- glue_get_data_catalog_encryption_settings

#' Retrieves the result of a data quality rule evaluation
#'
#' @description
#' Retrieves the result of a data quality rule evaluation.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_data_quality_result/](https://www.paws-r-sdk.com/docs/glue_get_data_quality_result/) for full documentation.
#'
#' @param ResultId &#91;required&#93; A unique result ID for the data quality result.
#'
#' @keywords internal
#'
#' @rdname glue_get_data_quality_result
glue_get_data_quality_result <- function(ResultId) {
  op <- new_operation(
    name = "GetDataQualityResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_data_quality_result_input(ResultId = ResultId)
  output <- .glue$get_data_quality_result_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_data_quality_result <- glue_get_data_quality_result

#' Gets the specified recommendation run that was used to generate rules
#'
#' @description
#' Gets the specified recommendation run that was used to generate rules.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_data_quality_rule_recommendation_run/](https://www.paws-r-sdk.com/docs/glue_get_data_quality_rule_recommendation_run/) for full documentation.
#'
#' @param RunId &#91;required&#93; The unique run identifier associated with this run.
#'
#' @keywords internal
#'
#' @rdname glue_get_data_quality_rule_recommendation_run
glue_get_data_quality_rule_recommendation_run <- function(RunId) {
  op <- new_operation(
    name = "GetDataQualityRuleRecommendationRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_data_quality_rule_recommendation_run_input(RunId = RunId)
  output <- .glue$get_data_quality_rule_recommendation_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_data_quality_rule_recommendation_run <- glue_get_data_quality_rule_recommendation_run

#' Returns an existing ruleset by identifier or name
#'
#' @description
#' Returns an existing ruleset by identifier or name.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_data_quality_ruleset/](https://www.paws-r-sdk.com/docs/glue_get_data_quality_ruleset/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ruleset.
#'
#' @keywords internal
#'
#' @rdname glue_get_data_quality_ruleset
glue_get_data_quality_ruleset <- function(Name) {
  op <- new_operation(
    name = "GetDataQualityRuleset",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_data_quality_ruleset_input(Name = Name)
  output <- .glue$get_data_quality_ruleset_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_data_quality_ruleset <- glue_get_data_quality_ruleset

#' Retrieves a specific run where a ruleset is evaluated against a data
#' source
#'
#' @description
#' Retrieves a specific run where a ruleset is evaluated against a data source.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_data_quality_ruleset_evaluation_run/](https://www.paws-r-sdk.com/docs/glue_get_data_quality_ruleset_evaluation_run/) for full documentation.
#'
#' @param RunId &#91;required&#93; The unique run identifier associated with this run.
#'
#' @keywords internal
#'
#' @rdname glue_get_data_quality_ruleset_evaluation_run
glue_get_data_quality_ruleset_evaluation_run <- function(RunId) {
  op <- new_operation(
    name = "GetDataQualityRulesetEvaluationRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_data_quality_ruleset_evaluation_run_input(RunId = RunId)
  output <- .glue$get_data_quality_ruleset_evaluation_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_data_quality_ruleset_evaluation_run <- glue_get_data_quality_ruleset_evaluation_run

#' Retrieves the definition of a specified database
#'
#' @description
#' Retrieves the definition of a specified database.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_database/](https://www.paws-r-sdk.com/docs/glue_get_database/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog in which the database resides. If none is
#' provided, the Amazon Web Services account ID is used by default.
#' @param Name &#91;required&#93; The name of the database to retrieve. For Hive compatibility, this
#' should be all lowercase.
#'
#' @keywords internal
#'
#' @rdname glue_get_database
glue_get_database <- function(CatalogId = NULL, Name) {
  op <- new_operation(
    name = "GetDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_database_input(CatalogId = CatalogId, Name = Name)
  output <- .glue$get_database_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_database <- glue_get_database

#' Retrieves all databases defined in a given Data Catalog
#'
#' @description
#' Retrieves all databases defined in a given Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_databases/](https://www.paws-r-sdk.com/docs/glue_get_databases/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog from which to retrieve `Databases`. If none
#' is provided, the Amazon Web Services account ID is used by default.
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum number of databases to return in one response.
#' @param ResourceShareType Allows you to specify that you want to list the databases shared with
#' your account. The allowable values are `FEDERATED`, `FOREIGN` or `ALL`.
#' 
#' -   If set to `FEDERATED`, will list the federated databases
#'     (referencing an external entity) shared with your account.
#' 
#' -   If set to `FOREIGN`, will list the databases shared with your
#'     account.
#' 
#' -   If set to `ALL`, will list the databases shared with your account,
#'     as well as the databases in yor local account.
#'
#' @keywords internal
#'
#' @rdname glue_get_databases
glue_get_databases <- function(CatalogId = NULL, NextToken = NULL, MaxResults = NULL, ResourceShareType = NULL) {
  op <- new_operation(
    name = "GetDatabases",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_databases_input(CatalogId = CatalogId, NextToken = NextToken, MaxResults = MaxResults, ResourceShareType = ResourceShareType)
  output <- .glue$get_databases_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_databases <- glue_get_databases

#' Transforms a Python script into a directed acyclic graph (DAG)
#'
#' @description
#' Transforms a Python script into a directed acyclic graph (DAG).
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_dataflow_graph/](https://www.paws-r-sdk.com/docs/glue_get_dataflow_graph/) for full documentation.
#'
#' @param PythonScript The Python script to transform.
#'
#' @keywords internal
#'
#' @rdname glue_get_dataflow_graph
glue_get_dataflow_graph <- function(PythonScript = NULL) {
  op <- new_operation(
    name = "GetDataflowGraph",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_dataflow_graph_input(PythonScript = PythonScript)
  output <- .glue$get_dataflow_graph_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_dataflow_graph <- glue_get_dataflow_graph

#' Retrieves information about a specified development endpoint
#'
#' @description
#' Retrieves information about a specified development endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_dev_endpoint/](https://www.paws-r-sdk.com/docs/glue_get_dev_endpoint/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; Name of the `DevEndpoint` to retrieve information for.
#'
#' @keywords internal
#'
#' @rdname glue_get_dev_endpoint
glue_get_dev_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "GetDevEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_dev_endpoint_input(EndpointName = EndpointName)
  output <- .glue$get_dev_endpoint_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_dev_endpoint <- glue_get_dev_endpoint

#' Retrieves all the development endpoints in this Amazon Web Services
#' account
#'
#' @description
#' Retrieves all the development endpoints in this Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_dev_endpoints/](https://www.paws-r-sdk.com/docs/glue_get_dev_endpoints/) for full documentation.
#'
#' @param MaxResults The maximum size of information to return.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @keywords internal
#'
#' @rdname glue_get_dev_endpoints
glue_get_dev_endpoints <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDevEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_dev_endpoints_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_dev_endpoints_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_dev_endpoints <- glue_get_dev_endpoints

#' Retrieves an existing job definition
#'
#' @description
#' Retrieves an existing job definition.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_job/](https://www.paws-r-sdk.com/docs/glue_get_job/) for full documentation.
#'
#' @param JobName &#91;required&#93; The name of the job definition to retrieve.
#'
#' @keywords internal
#'
#' @rdname glue_get_job
glue_get_job <- function(JobName) {
  op <- new_operation(
    name = "GetJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_job_input(JobName = JobName)
  output <- .glue$get_job_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_job <- glue_get_job

#' Returns information on a job bookmark entry
#'
#' @description
#' Returns information on a job bookmark entry.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_job_bookmark/](https://www.paws-r-sdk.com/docs/glue_get_job_bookmark/) for full documentation.
#'
#' @param JobName &#91;required&#93; The name of the job in question.
#' @param RunId The unique run identifier associated with this job run.
#'
#' @keywords internal
#'
#' @rdname glue_get_job_bookmark
glue_get_job_bookmark <- function(JobName, RunId = NULL) {
  op <- new_operation(
    name = "GetJobBookmark",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_job_bookmark_input(JobName = JobName, RunId = RunId)
  output <- .glue$get_job_bookmark_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_job_bookmark <- glue_get_job_bookmark

#' Retrieves the metadata for a given job run
#'
#' @description
#' Retrieves the metadata for a given job run.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_job_run/](https://www.paws-r-sdk.com/docs/glue_get_job_run/) for full documentation.
#'
#' @param JobName &#91;required&#93; Name of the job definition being run.
#' @param RunId &#91;required&#93; The ID of the job run.
#' @param PredecessorsIncluded True if a list of predecessor runs should be returned.
#'
#' @keywords internal
#'
#' @rdname glue_get_job_run
glue_get_job_run <- function(JobName, RunId, PredecessorsIncluded = NULL) {
  op <- new_operation(
    name = "GetJobRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_job_run_input(JobName = JobName, RunId = RunId, PredecessorsIncluded = PredecessorsIncluded)
  output <- .glue$get_job_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_job_run <- glue_get_job_run

#' Retrieves metadata for all runs of a given job definition
#'
#' @description
#' Retrieves metadata for all runs of a given job definition.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_job_runs/](https://www.paws-r-sdk.com/docs/glue_get_job_runs/) for full documentation.
#'
#' @param JobName &#91;required&#93; The name of the job definition for which to retrieve all job runs.
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum size of the response.
#'
#' @keywords internal
#'
#' @rdname glue_get_job_runs
glue_get_job_runs <- function(JobName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetJobRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_job_runs_input(JobName = JobName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_job_runs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_job_runs <- glue_get_job_runs

#' Retrieves all current job definitions
#'
#' @description
#' Retrieves all current job definitions.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_jobs/](https://www.paws-r-sdk.com/docs/glue_get_jobs/) for full documentation.
#'
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum size of the response.
#'
#' @keywords internal
#'
#' @rdname glue_get_jobs
glue_get_jobs <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_jobs_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_jobs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_jobs <- glue_get_jobs

#' Gets details for a specific task run on a machine learning transform
#'
#' @description
#' Gets details for a specific task run on a machine learning transform. Machine learning task runs are asynchronous tasks that Glue runs on your behalf as part of various machine learning workflows. You can check the stats of any task run by calling [`get_ml_task_run`][glue_get_ml_task_run] with the `TaskRunID` and its parent transform's `TransformID`.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_ml_task_run/](https://www.paws-r-sdk.com/docs/glue_get_ml_task_run/) for full documentation.
#'
#' @param TransformId &#91;required&#93; The unique identifier of the machine learning transform.
#' @param TaskRunId &#91;required&#93; The unique identifier of the task run.
#'
#' @keywords internal
#'
#' @rdname glue_get_ml_task_run
glue_get_ml_task_run <- function(TransformId, TaskRunId) {
  op <- new_operation(
    name = "GetMLTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_ml_task_run_input(TransformId = TransformId, TaskRunId = TaskRunId)
  output <- .glue$get_ml_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_ml_task_run <- glue_get_ml_task_run

#' Gets a list of runs for a machine learning transform
#'
#' @description
#' Gets a list of runs for a machine learning transform. Machine learning task runs are asynchronous tasks that Glue runs on your behalf as part of various machine learning workflows. You can get a sortable, filterable list of machine learning task runs by calling [`get_ml_task_runs`][glue_get_ml_task_runs] with their parent transform's `TransformID` and other optional parameters as documented in this section.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_ml_task_runs/](https://www.paws-r-sdk.com/docs/glue_get_ml_task_runs/) for full documentation.
#'
#' @param TransformId &#91;required&#93; The unique identifier of the machine learning transform.
#' @param NextToken A token for pagination of the results. The default is empty.
#' @param MaxResults The maximum number of results to return.
#' @param Filter The filter criteria, in the `TaskRunFilterCriteria` structure, for the
#' task run.
#' @param Sort The sorting criteria, in the `TaskRunSortCriteria` structure, for the
#' task run.
#'
#' @keywords internal
#'
#' @rdname glue_get_ml_task_runs
glue_get_ml_task_runs <- function(TransformId, NextToken = NULL, MaxResults = NULL, Filter = NULL, Sort = NULL) {
  op <- new_operation(
    name = "GetMLTaskRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_ml_task_runs_input(TransformId = TransformId, NextToken = NextToken, MaxResults = MaxResults, Filter = Filter, Sort = Sort)
  output <- .glue$get_ml_task_runs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_ml_task_runs <- glue_get_ml_task_runs

#' Gets an Glue machine learning transform artifact and all its
#' corresponding metadata
#'
#' @description
#' Gets an Glue machine learning transform artifact and all its corresponding metadata. Machine learning transforms are a special type of transform that use machine learning to learn the details of the transformation to be performed by learning from examples provided by humans. These transformations are then saved by Glue. You can retrieve their metadata by calling [`get_ml_transform`][glue_get_ml_transform].
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_ml_transform/](https://www.paws-r-sdk.com/docs/glue_get_ml_transform/) for full documentation.
#'
#' @param TransformId &#91;required&#93; The unique identifier of the transform, generated at the time that the
#' transform was created.
#'
#' @keywords internal
#'
#' @rdname glue_get_ml_transform
glue_get_ml_transform <- function(TransformId) {
  op <- new_operation(
    name = "GetMLTransform",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_ml_transform_input(TransformId = TransformId)
  output <- .glue$get_ml_transform_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_ml_transform <- glue_get_ml_transform

#' Gets a sortable, filterable list of existing Glue machine learning
#' transforms
#'
#' @description
#' Gets a sortable, filterable list of existing Glue machine learning transforms. Machine learning transforms are a special type of transform that use machine learning to learn the details of the transformation to be performed by learning from examples provided by humans. These transformations are then saved by Glue, and you can retrieve their metadata by calling [`get_ml_transforms`][glue_get_ml_transforms].
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_ml_transforms/](https://www.paws-r-sdk.com/docs/glue_get_ml_transforms/) for full documentation.
#'
#' @param NextToken A paginated token to offset the results.
#' @param MaxResults The maximum number of results to return.
#' @param Filter The filter transformation criteria.
#' @param Sort The sorting criteria.
#'
#' @keywords internal
#'
#' @rdname glue_get_ml_transforms
glue_get_ml_transforms <- function(NextToken = NULL, MaxResults = NULL, Filter = NULL, Sort = NULL) {
  op <- new_operation(
    name = "GetMLTransforms",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_ml_transforms_input(NextToken = NextToken, MaxResults = MaxResults, Filter = Filter, Sort = Sort)
  output <- .glue$get_ml_transforms_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_ml_transforms <- glue_get_ml_transforms

#' Creates mappings
#'
#' @description
#' Creates mappings.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_mapping/](https://www.paws-r-sdk.com/docs/glue_get_mapping/) for full documentation.
#'
#' @param Source &#91;required&#93; Specifies the source table.
#' @param Sinks A list of target tables.
#' @param Location Parameters for the mapping.
#'
#' @keywords internal
#'
#' @rdname glue_get_mapping
glue_get_mapping <- function(Source, Sinks = NULL, Location = NULL) {
  op <- new_operation(
    name = "GetMapping",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_mapping_input(Source = Source, Sinks = Sinks, Location = Location)
  output <- .glue$get_mapping_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_mapping <- glue_get_mapping

#' Retrieves information about a specified partition
#'
#' @description
#' Retrieves information about a specified partition.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_partition/](https://www.paws-r-sdk.com/docs/glue_get_partition/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the partition in question resides. If
#' none is provided, the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partition resides.
#' @param TableName &#91;required&#93; The name of the partition's table.
#' @param PartitionValues &#91;required&#93; The values that define the partition.
#'
#' @keywords internal
#'
#' @rdname glue_get_partition
glue_get_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValues) {
  op <- new_operation(
    name = "GetPartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValues = PartitionValues)
  output <- .glue$get_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_partition <- glue_get_partition

#' Retrieves the partition indexes associated with a table
#'
#' @description
#' Retrieves the partition indexes associated with a table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_partition_indexes/](https://www.paws-r-sdk.com/docs/glue_get_partition_indexes/) for full documentation.
#'
#' @param CatalogId The catalog ID where the table resides.
#' @param DatabaseName &#91;required&#93; Specifies the name of a database from which you want to retrieve
#' partition indexes.
#' @param TableName &#91;required&#93; Specifies the name of a table for which you want to retrieve the
#' partition indexes.
#' @param NextToken A continuation token, included if this is a continuation call.
#'
#' @keywords internal
#'
#' @rdname glue_get_partition_indexes
glue_get_partition_indexes <- function(CatalogId = NULL, DatabaseName, TableName, NextToken = NULL) {
  op <- new_operation(
    name = "GetPartitionIndexes",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "PartitionIndexDescriptorList")
  )
  input <- .glue$get_partition_indexes_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, NextToken = NextToken)
  output <- .glue$get_partition_indexes_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_partition_indexes <- glue_get_partition_indexes

#' Retrieves information about the partitions in a table
#'
#' @description
#' Retrieves information about the partitions in a table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_partitions/](https://www.paws-r-sdk.com/docs/glue_get_partitions/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is provided, the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param Expression An expression that filters the partitions to be returned.
#' 
#' The expression uses SQL syntax similar to the SQL `WHERE` filter clause.
#' The SQL statement parser
#' [JSQLParser](https://jsqlparser.sourceforge.net/home.php) parses the
#' expression.
#' 
#' *Operators*: The following are the operators that you can use in the
#' `Expression` API call:
#' 
#' **=**
#' 
#' Checks whether the values of the two operands are equal; if yes, then
#' the condition becomes true.
#' 
#' Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
#' 
#' (a = b) is not true.
#' 
#' **\< \>**
#' 
#' Checks whether the values of two operands are equal; if the values are
#' not equal, then the condition becomes true.
#' 
#' Example: (a \< \> b) is true.
#' 
#' **\>**
#' 
#' Checks whether the value of the left operand is greater than the value
#' of the right operand; if yes, then the condition becomes true.
#' 
#' Example: (a \> b) is not true.
#' 
#' **\<**
#' 
#' Checks whether the value of the left operand is less than the value of
#' the right operand; if yes, then the condition becomes true.
#' 
#' Example: (a \< b) is true.
#' 
#' **\>=**
#' 
#' Checks whether the value of the left operand is greater than or equal to
#' the value of the right operand; if yes, then the condition becomes true.
#' 
#' Example: (a \>= b) is not true.
#' 
#' **\<=**
#' 
#' Checks whether the value of the left operand is less than or equal to
#' the value of the right operand; if yes, then the condition becomes true.
#' 
#' Example: (a \<= b) is true.
#' 
#' **AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL**
#' 
#' Logical operators.
#' 
#' *Supported Partition Key Types*: The following are the supported
#' partition keys.
#' 
#' -   `string`
#' 
#' -   `date`
#' 
#' -   `timestamp`
#' 
#' -   `int`
#' 
#' -   `bigint`
#' 
#' -   `long`
#' 
#' -   `tinyint`
#' 
#' -   `smallint`
#' 
#' -   `decimal`
#' 
#' If an type is encountered that is not valid, an exception is thrown.
#' 
#' The following list shows the valid operators on each type. When you
#' define a crawler, the `partitionKey` type is created as a `STRING`, to
#' be compatible with the catalog partitions.
#' 
#' *Sample API Call*:
#' @param NextToken A continuation token, if this is not the first call to retrieve these
#' partitions.
#' @param Segment The segment of the table's partitions to scan in this request.
#' @param MaxResults The maximum number of partitions to return in a single response.
#' @param ExcludeColumnSchema When true, specifies not returning the partition column schema. Useful
#' when you are interested only in other partition attributes such as
#' partition values or location. This approach avoids the problem of a
#' large response by not returning duplicate data.
#' @param TransactionId The transaction ID at which to read the partition contents.
#' @param QueryAsOfTime The time as of when to read the partition contents. If not set, the most
#' recent transaction commit time will be used. Cannot be specified along
#' with `TransactionId`.
#'
#' @keywords internal
#'
#' @rdname glue_get_partitions
glue_get_partitions <- function(CatalogId = NULL, DatabaseName, TableName, Expression = NULL, NextToken = NULL, Segment = NULL, MaxResults = NULL, ExcludeColumnSchema = NULL, TransactionId = NULL, QueryAsOfTime = NULL) {
  op <- new_operation(
    name = "GetPartitions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_partitions_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, Expression = Expression, NextToken = NextToken, Segment = Segment, MaxResults = MaxResults, ExcludeColumnSchema = ExcludeColumnSchema, TransactionId = TransactionId, QueryAsOfTime = QueryAsOfTime)
  output <- .glue$get_partitions_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_partitions <- glue_get_partitions

#' Gets code to perform a specified mapping
#'
#' @description
#' Gets code to perform a specified mapping.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_plan/](https://www.paws-r-sdk.com/docs/glue_get_plan/) for full documentation.
#'
#' @param Mapping &#91;required&#93; The list of mappings from a source table to target tables.
#' @param Source &#91;required&#93; The source table.
#' @param Sinks The target tables.
#' @param Location The parameters for the mapping.
#' @param Language The programming language of the code to perform the mapping.
#' @param AdditionalPlanOptionsMap A map to hold additional optional key-value parameters.
#' 
#' Currently, these key-value pairs are supported:
#' 
#' -   `inferSchema`  —  Specifies whether to set `inferSchema` to true or
#'     false for the default script generated by an Glue job. For example,
#'     to set `inferSchema` to true, pass the following key value pair:
#' 
#'     `--additional-plan-options-map '{"inferSchema":"true"}'`
#'
#' @keywords internal
#'
#' @rdname glue_get_plan
glue_get_plan <- function(Mapping, Source, Sinks = NULL, Location = NULL, Language = NULL, AdditionalPlanOptionsMap = NULL) {
  op <- new_operation(
    name = "GetPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_plan_input(Mapping = Mapping, Source = Source, Sinks = Sinks, Location = Location, Language = Language, AdditionalPlanOptionsMap = AdditionalPlanOptionsMap)
  output <- .glue$get_plan_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_plan <- glue_get_plan

#' Describes the specified registry in detail
#'
#' @description
#' Describes the specified registry in detail.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_registry/](https://www.paws-r-sdk.com/docs/glue_get_registry/) for full documentation.
#'
#' @param RegistryId &#91;required&#93; This is a wrapper structure that may contain the registry name and
#' Amazon Resource Name (ARN).
#'
#' @keywords internal
#'
#' @rdname glue_get_registry
glue_get_registry <- function(RegistryId) {
  op <- new_operation(
    name = "GetRegistry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_registry_input(RegistryId = RegistryId)
  output <- .glue$get_registry_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_registry <- glue_get_registry

#' Retrieves the resource policies set on individual resources by Resource
#' Access Manager during cross-account permission grants
#'
#' @description
#' Retrieves the resource policies set on individual resources by Resource Access Manager during cross-account permission grants. Also retrieves the Data Catalog resource policy.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_resource_policies/](https://www.paws-r-sdk.com/docs/glue_get_resource_policies/) for full documentation.
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param MaxResults The maximum size of a list to return.
#'
#' @keywords internal
#'
#' @rdname glue_get_resource_policies
glue_get_resource_policies <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetResourcePolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "GetResourcePoliciesResponseList")
  )
  input <- .glue$get_resource_policies_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_resource_policies_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_resource_policies <- glue_get_resource_policies

#' Retrieves a specified resource policy
#'
#' @description
#' Retrieves a specified resource policy.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_resource_policy/](https://www.paws-r-sdk.com/docs/glue_get_resource_policy/) for full documentation.
#'
#' @param ResourceArn The ARN of the Glue resource for which to retrieve the resource policy.
#' If not supplied, the Data Catalog resource policy is returned. Use
#' [`get_resource_policies`][glue_get_resource_policies] to view all
#' existing resource policies. For more information see [Specifying Glue
#' Resource
#' ARNs](https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html).
#'
#' @keywords internal
#'
#' @rdname glue_get_resource_policy
glue_get_resource_policy <- function(ResourceArn = NULL) {
  op <- new_operation(
    name = "GetResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_resource_policy_input(ResourceArn = ResourceArn)
  output <- .glue$get_resource_policy_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_resource_policy <- glue_get_resource_policy

#' Describes the specified schema in detail
#'
#' @description
#' Describes the specified schema in detail.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_schema/](https://www.paws-r-sdk.com/docs/glue_get_schema/) for full documentation.
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure to contain schema identity fields. The
#' structure contains:
#' 
#' -   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
#'     Either `SchemaArn` or `SchemaName` and `RegistryName` has to be
#'     provided.
#' 
#' -   SchemaId$SchemaName: The name of the schema. Either `SchemaArn` or
#'     `SchemaName` and `RegistryName` has to be provided.
#'
#' @keywords internal
#'
#' @rdname glue_get_schema
glue_get_schema <- function(SchemaId) {
  op <- new_operation(
    name = "GetSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_schema_input(SchemaId = SchemaId)
  output <- .glue$get_schema_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_schema <- glue_get_schema

#' Retrieves a schema by the SchemaDefinition
#'
#' @description
#' Retrieves a schema by the `SchemaDefinition`. The schema definition is sent to the Schema Registry, canonicalized, and hashed. If the hash is matched within the scope of the `SchemaName` or ARN (or the default registry, if none is supplied), that schema’s metadata is returned. Otherwise, a 404 or NotFound error is returned. Schema versions in `Deleted` statuses will not be included in the results.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_schema_by_definition/](https://www.paws-r-sdk.com/docs/glue_get_schema_by_definition/) for full documentation.
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure to contain schema identity fields. The
#' structure contains:
#' 
#' -   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
#'     One of `SchemaArn` or `SchemaName` has to be provided.
#' 
#' -   SchemaId$SchemaName: The name of the schema. One of `SchemaArn` or
#'     `SchemaName` has to be provided.
#' @param SchemaDefinition &#91;required&#93; The definition of the schema for which schema details are required.
#'
#' @keywords internal
#'
#' @rdname glue_get_schema_by_definition
glue_get_schema_by_definition <- function(SchemaId, SchemaDefinition) {
  op <- new_operation(
    name = "GetSchemaByDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_schema_by_definition_input(SchemaId = SchemaId, SchemaDefinition = SchemaDefinition)
  output <- .glue$get_schema_by_definition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_schema_by_definition <- glue_get_schema_by_definition

#' Get the specified schema by its unique ID assigned when a version of the
#' schema is created or registered
#'
#' @description
#' Get the specified schema by its unique ID assigned when a version of the schema is created or registered. Schema versions in Deleted status will not be included in the results.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_schema_version/](https://www.paws-r-sdk.com/docs/glue_get_schema_version/) for full documentation.
#'
#' @param SchemaId This is a wrapper structure to contain schema identity fields. The
#' structure contains:
#' 
#' -   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
#'     Either `SchemaArn` or `SchemaName` and `RegistryName` has to be
#'     provided.
#' 
#' -   SchemaId$SchemaName: The name of the schema. Either `SchemaArn` or
#'     `SchemaName` and `RegistryName` has to be provided.
#' @param SchemaVersionId The `SchemaVersionId` of the schema version. This field is required for
#' fetching by schema ID. Either this or the `SchemaId` wrapper has to be
#' provided.
#' @param SchemaVersionNumber The version number of the schema.
#'
#' @keywords internal
#'
#' @rdname glue_get_schema_version
glue_get_schema_version <- function(SchemaId = NULL, SchemaVersionId = NULL, SchemaVersionNumber = NULL) {
  op <- new_operation(
    name = "GetSchemaVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_schema_version_input(SchemaId = SchemaId, SchemaVersionId = SchemaVersionId, SchemaVersionNumber = SchemaVersionNumber)
  output <- .glue$get_schema_version_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_schema_version <- glue_get_schema_version

#' Fetches the schema version difference in the specified difference type
#' between two stored schema versions in the Schema Registry
#'
#' @description
#' Fetches the schema version difference in the specified difference type between two stored schema versions in the Schema Registry.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_schema_versions_diff/](https://www.paws-r-sdk.com/docs/glue_get_schema_versions_diff/) for full documentation.
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure to contain schema identity fields. The
#' structure contains:
#' 
#' -   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
#'     One of `SchemaArn` or `SchemaName` has to be provided.
#' 
#' -   SchemaId$SchemaName: The name of the schema. One of `SchemaArn` or
#'     `SchemaName` has to be provided.
#' @param FirstSchemaVersionNumber &#91;required&#93; The first of the two schema versions to be compared.
#' @param SecondSchemaVersionNumber &#91;required&#93; The second of the two schema versions to be compared.
#' @param SchemaDiffType &#91;required&#93; Refers to `SYNTAX_DIFF`, which is the currently supported diff type.
#'
#' @keywords internal
#'
#' @rdname glue_get_schema_versions_diff
glue_get_schema_versions_diff <- function(SchemaId, FirstSchemaVersionNumber, SecondSchemaVersionNumber, SchemaDiffType) {
  op <- new_operation(
    name = "GetSchemaVersionsDiff",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_schema_versions_diff_input(SchemaId = SchemaId, FirstSchemaVersionNumber = FirstSchemaVersionNumber, SecondSchemaVersionNumber = SecondSchemaVersionNumber, SchemaDiffType = SchemaDiffType)
  output <- .glue$get_schema_versions_diff_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_schema_versions_diff <- glue_get_schema_versions_diff

#' Retrieves a specified security configuration
#'
#' @description
#' Retrieves a specified security configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_security_configuration/](https://www.paws-r-sdk.com/docs/glue_get_security_configuration/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the security configuration to retrieve.
#'
#' @keywords internal
#'
#' @rdname glue_get_security_configuration
glue_get_security_configuration <- function(Name) {
  op <- new_operation(
    name = "GetSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_security_configuration_input(Name = Name)
  output <- .glue$get_security_configuration_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_security_configuration <- glue_get_security_configuration

#' Retrieves a list of all security configurations
#'
#' @description
#' Retrieves a list of all security configurations.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_security_configurations/](https://www.paws-r-sdk.com/docs/glue_get_security_configurations/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @keywords internal
#'
#' @rdname glue_get_security_configurations
glue_get_security_configurations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetSecurityConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "SecurityConfigurations")
  )
  input <- .glue$get_security_configurations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_security_configurations_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_security_configurations <- glue_get_security_configurations

#' Retrieves the session
#'
#' @description
#' Retrieves the session.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_session/](https://www.paws-r-sdk.com/docs/glue_get_session/) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the session.
#' @param RequestOrigin The origin of the request.
#'
#' @keywords internal
#'
#' @rdname glue_get_session
glue_get_session <- function(Id, RequestOrigin = NULL) {
  op <- new_operation(
    name = "GetSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_session_input(Id = Id, RequestOrigin = RequestOrigin)
  output <- .glue$get_session_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_session <- glue_get_session

#' Retrieves the statement
#'
#' @description
#' Retrieves the statement.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_statement/](https://www.paws-r-sdk.com/docs/glue_get_statement/) for full documentation.
#'
#' @param SessionId &#91;required&#93; The Session ID of the statement.
#' @param Id &#91;required&#93; The Id of the statement.
#' @param RequestOrigin The origin of the request.
#'
#' @keywords internal
#'
#' @rdname glue_get_statement
glue_get_statement <- function(SessionId, Id, RequestOrigin = NULL) {
  op <- new_operation(
    name = "GetStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_statement_input(SessionId = SessionId, Id = Id, RequestOrigin = RequestOrigin)
  output <- .glue$get_statement_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_statement <- glue_get_statement

#' Retrieves the Table definition in a Data Catalog for a specified table
#'
#' @description
#' Retrieves the `Table` definition in a Data Catalog for a specified table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_table/](https://www.paws-r-sdk.com/docs/glue_get_table/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the table resides. If none is provided,
#' the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the database in the catalog in which the table resides. For
#' Hive compatibility, this name is entirely lowercase.
#' @param Name &#91;required&#93; The name of the table for which to retrieve the definition. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TransactionId The transaction ID at which to read the table contents.
#' @param QueryAsOfTime The time as of when to read the table contents. If not set, the most
#' recent transaction commit time will be used. Cannot be specified along
#' with `TransactionId`.
#'
#' @keywords internal
#'
#' @rdname glue_get_table
glue_get_table <- function(CatalogId = NULL, DatabaseName, Name, TransactionId = NULL, QueryAsOfTime = NULL) {
  op <- new_operation(
    name = "GetTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, Name = Name, TransactionId = TransactionId, QueryAsOfTime = QueryAsOfTime)
  output <- .glue$get_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_table <- glue_get_table

#' Returns the configuration of all optimizers associated with a specified
#' table
#'
#' @description
#' Returns the configuration of all optimizers associated with a specified table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_table_optimizer/](https://www.paws-r-sdk.com/docs/glue_get_table_optimizer/) for full documentation.
#'
#' @param CatalogId &#91;required&#93; The Catalog ID of the table.
#' @param DatabaseName &#91;required&#93; The name of the database in the catalog in which the table resides.
#' @param TableName &#91;required&#93; The name of the table.
#' @param Type &#91;required&#93; The type of table optimizer.
#'
#' @keywords internal
#'
#' @rdname glue_get_table_optimizer
glue_get_table_optimizer <- function(CatalogId, DatabaseName, TableName, Type) {
  op <- new_operation(
    name = "GetTableOptimizer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_table_optimizer_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, Type = Type)
  output <- .glue$get_table_optimizer_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_table_optimizer <- glue_get_table_optimizer

#' Retrieves a specified version of a table
#'
#' @description
#' Retrieves a specified version of a table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_table_version/](https://www.paws-r-sdk.com/docs/glue_get_table_version/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is provided,
#' the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableName &#91;required&#93; The name of the table. For Hive compatibility, this name is entirely
#' lowercase.
#' @param VersionId The ID value of the table version to be retrieved. A `VersionID` is a
#' string representation of an integer. Each version is incremented by 1.
#'
#' @keywords internal
#'
#' @rdname glue_get_table_version
glue_get_table_version <- function(CatalogId = NULL, DatabaseName, TableName, VersionId = NULL) {
  op <- new_operation(
    name = "GetTableVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_table_version_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, VersionId = VersionId)
  output <- .glue$get_table_version_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_table_version <- glue_get_table_version

#' Retrieves a list of strings that identify available versions of a
#' specified table
#'
#' @description
#' Retrieves a list of strings that identify available versions of a specified table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_table_versions/](https://www.paws-r-sdk.com/docs/glue_get_table_versions/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is provided,
#' the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableName &#91;required&#93; The name of the table. For Hive compatibility, this name is entirely
#' lowercase.
#' @param NextToken A continuation token, if this is not the first call.
#' @param MaxResults The maximum number of table versions to return in one response.
#'
#' @keywords internal
#'
#' @rdname glue_get_table_versions
glue_get_table_versions <- function(CatalogId = NULL, DatabaseName, TableName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetTableVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_table_versions_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_table_versions_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_table_versions <- glue_get_table_versions

#' Retrieves the definitions of some or all of the tables in a given
#' Database
#'
#' @description
#' Retrieves the definitions of some or all of the tables in a given `Database`.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_tables/](https://www.paws-r-sdk.com/docs/glue_get_tables/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is provided,
#' the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog whose tables to list. For Hive
#' compatibility, this name is entirely lowercase.
#' @param Expression A regular expression pattern. If present, only those tables whose names
#' match the pattern are returned.
#' @param NextToken A continuation token, included if this is a continuation call.
#' @param MaxResults The maximum number of tables to return in a single response.
#' @param TransactionId The transaction ID at which to read the table contents.
#' @param QueryAsOfTime The time as of when to read the table contents. If not set, the most
#' recent transaction commit time will be used. Cannot be specified along
#' with `TransactionId`.
#'
#' @keywords internal
#'
#' @rdname glue_get_tables
glue_get_tables <- function(CatalogId = NULL, DatabaseName, Expression = NULL, NextToken = NULL, MaxResults = NULL, TransactionId = NULL, QueryAsOfTime = NULL) {
  op <- new_operation(
    name = "GetTables",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_tables_input(CatalogId = CatalogId, DatabaseName = DatabaseName, Expression = Expression, NextToken = NextToken, MaxResults = MaxResults, TransactionId = TransactionId, QueryAsOfTime = QueryAsOfTime)
  output <- .glue$get_tables_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_tables <- glue_get_tables

#' Retrieves a list of tags associated with a resource
#'
#' @description
#' Retrieves a list of tags associated with a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_tags/](https://www.paws-r-sdk.com/docs/glue_get_tags/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which to retrieve
#' tags.
#'
#' @keywords internal
#'
#' @rdname glue_get_tags
glue_get_tags <- function(ResourceArn) {
  op <- new_operation(
    name = "GetTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_tags_input(ResourceArn = ResourceArn)
  output <- .glue$get_tags_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_tags <- glue_get_tags

#' Retrieves the definition of a trigger
#'
#' @description
#' Retrieves the definition of a trigger.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_trigger/](https://www.paws-r-sdk.com/docs/glue_get_trigger/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the trigger to retrieve.
#'
#' @keywords internal
#'
#' @rdname glue_get_trigger
glue_get_trigger <- function(Name) {
  op <- new_operation(
    name = "GetTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_trigger_input(Name = Name)
  output <- .glue$get_trigger_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_trigger <- glue_get_trigger

#' Gets all the triggers associated with a job
#'
#' @description
#' Gets all the triggers associated with a job.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_triggers/](https://www.paws-r-sdk.com/docs/glue_get_triggers/) for full documentation.
#'
#' @param NextToken A continuation token, if this is a continuation call.
#' @param DependentJobName The name of the job to retrieve triggers for. The trigger that can start
#' this job is returned, and if there is no such trigger, all triggers are
#' returned.
#' @param MaxResults The maximum size of the response.
#'
#' @keywords internal
#'
#' @rdname glue_get_triggers
glue_get_triggers <- function(NextToken = NULL, DependentJobName = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetTriggers",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_triggers_input(NextToken = NextToken, DependentJobName = DependentJobName, MaxResults = MaxResults)
  output <- .glue$get_triggers_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_triggers <- glue_get_triggers

#' Retrieves partition metadata from the Data Catalog that contains
#' unfiltered metadata
#'
#' @description
#' Retrieves partition metadata from the Data Catalog that contains unfiltered metadata.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_unfiltered_partition_metadata/](https://www.paws-r-sdk.com/docs/glue_get_unfiltered_partition_metadata/) for full documentation.
#'
#' @param Region Specified only if the base tables belong to a different Amazon Web
#' Services Region.
#' @param CatalogId &#91;required&#93; The catalog ID where the partition resides.
#' @param DatabaseName &#91;required&#93; (Required) Specifies the name of a database that contains the partition.
#' @param TableName &#91;required&#93; (Required) Specifies the name of a table that contains the partition.
#' @param PartitionValues &#91;required&#93; (Required) A list of partition key values.
#' @param AuditContext A structure containing Lake Formation audit context information.
#' @param SupportedPermissionTypes &#91;required&#93; (Required) A list of supported permission types.
#' @param QuerySessionContext A structure used as a protocol between query engines and Lake Formation
#' or Glue. Contains both a Lake Formation generated authorization
#' identifier and information from the request's authorization context.
#'
#' @keywords internal
#'
#' @rdname glue_get_unfiltered_partition_metadata
glue_get_unfiltered_partition_metadata <- function(Region = NULL, CatalogId, DatabaseName, TableName, PartitionValues, AuditContext = NULL, SupportedPermissionTypes, QuerySessionContext = NULL) {
  op <- new_operation(
    name = "GetUnfilteredPartitionMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_unfiltered_partition_metadata_input(Region = Region, CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValues = PartitionValues, AuditContext = AuditContext, SupportedPermissionTypes = SupportedPermissionTypes, QuerySessionContext = QuerySessionContext)
  output <- .glue$get_unfiltered_partition_metadata_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_unfiltered_partition_metadata <- glue_get_unfiltered_partition_metadata

#' Retrieves partition metadata from the Data Catalog that contains
#' unfiltered metadata
#'
#' @description
#' Retrieves partition metadata from the Data Catalog that contains unfiltered metadata.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_unfiltered_partitions_metadata/](https://www.paws-r-sdk.com/docs/glue_get_unfiltered_partitions_metadata/) for full documentation.
#'
#' @param Region Specified only if the base tables belong to a different Amazon Web
#' Services Region.
#' @param CatalogId &#91;required&#93; The ID of the Data Catalog where the partitions in question reside. If
#' none is provided, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the table that contains the partition.
#' @param Expression An expression that filters the partitions to be returned.
#' 
#' The expression uses SQL syntax similar to the SQL `WHERE` filter clause.
#' The SQL statement parser
#' [JSQLParser](https://jsqlparser.sourceforge.net/home.php) parses the
#' expression.
#' 
#' *Operators*: The following are the operators that you can use in the
#' `Expression` API call:
#' 
#' **=**
#' 
#' Checks whether the values of the two operands are equal; if yes, then
#' the condition becomes true.
#' 
#' Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
#' 
#' (a = b) is not true.
#' 
#' **\< \>**
#' 
#' Checks whether the values of two operands are equal; if the values are
#' not equal, then the condition becomes true.
#' 
#' Example: (a \< \> b) is true.
#' 
#' **\>**
#' 
#' Checks whether the value of the left operand is greater than the value
#' of the right operand; if yes, then the condition becomes true.
#' 
#' Example: (a \> b) is not true.
#' 
#' **\<**
#' 
#' Checks whether the value of the left operand is less than the value of
#' the right operand; if yes, then the condition becomes true.
#' 
#' Example: (a \< b) is true.
#' 
#' **\>=**
#' 
#' Checks whether the value of the left operand is greater than or equal to
#' the value of the right operand; if yes, then the condition becomes true.
#' 
#' Example: (a \>= b) is not true.
#' 
#' **\<=**
#' 
#' Checks whether the value of the left operand is less than or equal to
#' the value of the right operand; if yes, then the condition becomes true.
#' 
#' Example: (a \<= b) is true.
#' 
#' **AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL**
#' 
#' Logical operators.
#' 
#' *Supported Partition Key Types*: The following are the supported
#' partition keys.
#' 
#' -   `string`
#' 
#' -   `date`
#' 
#' -   `timestamp`
#' 
#' -   `int`
#' 
#' -   `bigint`
#' 
#' -   `long`
#' 
#' -   `tinyint`
#' 
#' -   `smallint`
#' 
#' -   `decimal`
#' 
#' If an type is encountered that is not valid, an exception is thrown.
#' @param AuditContext A structure containing Lake Formation audit context information.
#' @param SupportedPermissionTypes &#91;required&#93; A list of supported permission types.
#' @param NextToken A continuation token, if this is not the first call to retrieve these
#' partitions.
#' @param Segment The segment of the table's partitions to scan in this request.
#' @param MaxResults The maximum number of partitions to return in a single response.
#' @param QuerySessionContext A structure used as a protocol between query engines and Lake Formation
#' or Glue. Contains both a Lake Formation generated authorization
#' identifier and information from the request's authorization context.
#'
#' @keywords internal
#'
#' @rdname glue_get_unfiltered_partitions_metadata
glue_get_unfiltered_partitions_metadata <- function(Region = NULL, CatalogId, DatabaseName, TableName, Expression = NULL, AuditContext = NULL, SupportedPermissionTypes, NextToken = NULL, Segment = NULL, MaxResults = NULL, QuerySessionContext = NULL) {
  op <- new_operation(
    name = "GetUnfilteredPartitionsMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_unfiltered_partitions_metadata_input(Region = Region, CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, Expression = Expression, AuditContext = AuditContext, SupportedPermissionTypes = SupportedPermissionTypes, NextToken = NextToken, Segment = Segment, MaxResults = MaxResults, QuerySessionContext = QuerySessionContext)
  output <- .glue$get_unfiltered_partitions_metadata_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_unfiltered_partitions_metadata <- glue_get_unfiltered_partitions_metadata

#' Allows a third-party analytical engine to retrieve unfiltered table
#' metadata from the Data Catalog
#'
#' @description
#' Allows a third-party analytical engine to retrieve unfiltered table metadata from the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_unfiltered_table_metadata/](https://www.paws-r-sdk.com/docs/glue_get_unfiltered_table_metadata/) for full documentation.
#'
#' @param Region Specified only if the base tables belong to a different Amazon Web
#' Services Region.
#' @param CatalogId &#91;required&#93; The catalog ID where the table resides.
#' @param DatabaseName &#91;required&#93; (Required) Specifies the name of a database that contains the table.
#' @param Name &#91;required&#93; (Required) Specifies the name of a table for which you are requesting
#' metadata.
#' @param AuditContext A structure containing Lake Formation audit context information.
#' @param SupportedPermissionTypes &#91;required&#93; Indicates the level of filtering a third-party analytical engine is
#' capable of enforcing when calling the
#' [`get_unfiltered_table_metadata`][glue_get_unfiltered_table_metadata]
#' API operation. Accepted values are:
#' 
#' -   `COLUMN_PERMISSION` - Column permissions ensure that users can
#'     access only specific columns in the table. If there are particular
#'     columns contain sensitive data, data lake administrators can define
#'     column filters that exclude access to specific columns.
#' 
#' -   `CELL_FILTER_PERMISSION` - Cell-level filtering combines column
#'     filtering (include or exclude columns) and row filter expressions to
#'     restrict access to individual elements in the table.
#' 
#' -   `NESTED_PERMISSION` - Nested permissions combines cell-level
#'     filtering and nested column filtering to restrict access to columns
#'     and/or nested columns in specific rows based on row filter
#'     expressions.
#' 
#' -   `NESTED_CELL_PERMISSION` - Nested cell permissions combines nested
#'     permission with nested cell-level filtering. This allows different
#'     subsets of nested columns to be restricted based on an array of row
#'     filter expressions.
#' 
#' Note: Each of these permission types follows a hierarchical order where
#' each subsequent permission type includes all permission of the previous
#' type.
#' 
#' Important: If you provide a supported permission type that doesn't match
#' the user's level of permissions on the table, then Lake Formation raises
#' an exception. For example, if the third-party engine calling the
#' [`get_unfiltered_table_metadata`][glue_get_unfiltered_table_metadata]
#' operation can enforce only column-level filtering, and the user has
#' nested cell filtering applied on the table, Lake Formation throws an
#' exception, and will not return unfiltered table metadata and data access
#' credentials.
#' @param ParentResourceArn The resource ARN of the view.
#' @param RootResourceArn The resource ARN of the root view in a chain of nested views.
#' @param SupportedDialect A structure specifying the dialect and dialect version used by the query
#' engine.
#' @param Permissions The Lake Formation data permissions of the caller on the table. Used to
#' authorize the call when no view context is found.
#' @param QuerySessionContext A structure used as a protocol between query engines and Lake Formation
#' or Glue. Contains both a Lake Formation generated authorization
#' identifier and information from the request's authorization context.
#'
#' @keywords internal
#'
#' @rdname glue_get_unfiltered_table_metadata
glue_get_unfiltered_table_metadata <- function(Region = NULL, CatalogId, DatabaseName, Name, AuditContext = NULL, SupportedPermissionTypes, ParentResourceArn = NULL, RootResourceArn = NULL, SupportedDialect = NULL, Permissions = NULL, QuerySessionContext = NULL) {
  op <- new_operation(
    name = "GetUnfilteredTableMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_unfiltered_table_metadata_input(Region = Region, CatalogId = CatalogId, DatabaseName = DatabaseName, Name = Name, AuditContext = AuditContext, SupportedPermissionTypes = SupportedPermissionTypes, ParentResourceArn = ParentResourceArn, RootResourceArn = RootResourceArn, SupportedDialect = SupportedDialect, Permissions = Permissions, QuerySessionContext = QuerySessionContext)
  output <- .glue$get_unfiltered_table_metadata_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_unfiltered_table_metadata <- glue_get_unfiltered_table_metadata

#' Retrieves a specified function definition from the Data Catalog
#'
#' @description
#' Retrieves a specified function definition from the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_user_defined_function/](https://www.paws-r-sdk.com/docs/glue_get_user_defined_function/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the function to be retrieved is
#' located. If none is provided, the Amazon Web Services account ID is used
#' by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the function is located.
#' @param FunctionName &#91;required&#93; The name of the function.
#'
#' @keywords internal
#'
#' @rdname glue_get_user_defined_function
glue_get_user_defined_function <- function(CatalogId = NULL, DatabaseName, FunctionName) {
  op <- new_operation(
    name = "GetUserDefinedFunction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_user_defined_function_input(CatalogId = CatalogId, DatabaseName = DatabaseName, FunctionName = FunctionName)
  output <- .glue$get_user_defined_function_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_user_defined_function <- glue_get_user_defined_function

#' Retrieves multiple function definitions from the Data Catalog
#'
#' @description
#' Retrieves multiple function definitions from the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_user_defined_functions/](https://www.paws-r-sdk.com/docs/glue_get_user_defined_functions/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the functions to be retrieved are
#' located. If none is provided, the Amazon Web Services account ID is used
#' by default.
#' @param DatabaseName The name of the catalog database where the functions are located. If
#' none is provided, functions from all the databases across the catalog
#' will be returned.
#' @param Pattern &#91;required&#93; An optional function-name pattern string that filters the function
#' definitions returned.
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum number of functions to return in one response.
#'
#' @keywords internal
#'
#' @rdname glue_get_user_defined_functions
glue_get_user_defined_functions <- function(CatalogId = NULL, DatabaseName = NULL, Pattern, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetUserDefinedFunctions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_user_defined_functions_input(CatalogId = CatalogId, DatabaseName = DatabaseName, Pattern = Pattern, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_user_defined_functions_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_user_defined_functions <- glue_get_user_defined_functions

#' Retrieves resource metadata for a workflow
#'
#' @description
#' Retrieves resource metadata for a workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_workflow/](https://www.paws-r-sdk.com/docs/glue_get_workflow/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the workflow to retrieve.
#' @param IncludeGraph Specifies whether to include a graph when returning the workflow
#' resource metadata.
#'
#' @keywords internal
#'
#' @rdname glue_get_workflow
glue_get_workflow <- function(Name, IncludeGraph = NULL) {
  op <- new_operation(
    name = "GetWorkflow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_workflow_input(Name = Name, IncludeGraph = IncludeGraph)
  output <- .glue$get_workflow_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_workflow <- glue_get_workflow

#' Retrieves the metadata for a given workflow run
#'
#' @description
#' Retrieves the metadata for a given workflow run.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_workflow_run/](https://www.paws-r-sdk.com/docs/glue_get_workflow_run/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the workflow being run.
#' @param RunId &#91;required&#93; The ID of the workflow run.
#' @param IncludeGraph Specifies whether to include the workflow graph in response or not.
#'
#' @keywords internal
#'
#' @rdname glue_get_workflow_run
glue_get_workflow_run <- function(Name, RunId, IncludeGraph = NULL) {
  op <- new_operation(
    name = "GetWorkflowRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_workflow_run_input(Name = Name, RunId = RunId, IncludeGraph = IncludeGraph)
  output <- .glue$get_workflow_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_workflow_run <- glue_get_workflow_run

#' Retrieves the workflow run properties which were set during the run
#'
#' @description
#' Retrieves the workflow run properties which were set during the run.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_workflow_run_properties/](https://www.paws-r-sdk.com/docs/glue_get_workflow_run_properties/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the workflow which was run.
#' @param RunId &#91;required&#93; The ID of the workflow run whose run properties should be returned.
#'
#' @keywords internal
#'
#' @rdname glue_get_workflow_run_properties
glue_get_workflow_run_properties <- function(Name, RunId) {
  op <- new_operation(
    name = "GetWorkflowRunProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_workflow_run_properties_input(Name = Name, RunId = RunId)
  output <- .glue$get_workflow_run_properties_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_workflow_run_properties <- glue_get_workflow_run_properties

#' Retrieves metadata for all runs of a given workflow
#'
#' @description
#' Retrieves metadata for all runs of a given workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_get_workflow_runs/](https://www.paws-r-sdk.com/docs/glue_get_workflow_runs/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the workflow whose metadata of runs should be returned.
#' @param IncludeGraph Specifies whether to include the workflow graph in response or not.
#' @param NextToken The maximum size of the response.
#' @param MaxResults The maximum number of workflow runs to be included in the response.
#'
#' @keywords internal
#'
#' @rdname glue_get_workflow_runs
glue_get_workflow_runs <- function(Name, IncludeGraph = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetWorkflowRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$get_workflow_runs_input(Name = Name, IncludeGraph = IncludeGraph, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_workflow_runs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_workflow_runs <- glue_get_workflow_runs

#' Imports an existing Amazon Athena Data Catalog to Glue
#'
#' @description
#' Imports an existing Amazon Athena Data Catalog to Glue.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_import_catalog_to_glue/](https://www.paws-r-sdk.com/docs/glue_import_catalog_to_glue/) for full documentation.
#'
#' @param CatalogId The ID of the catalog to import. Currently, this should be the Amazon
#' Web Services account ID.
#'
#' @keywords internal
#'
#' @rdname glue_import_catalog_to_glue
glue_import_catalog_to_glue <- function(CatalogId = NULL) {
  op <- new_operation(
    name = "ImportCatalogToGlue",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$import_catalog_to_glue_input(CatalogId = CatalogId)
  output <- .glue$import_catalog_to_glue_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$import_catalog_to_glue <- glue_import_catalog_to_glue

#' Lists all the blueprint names in an account
#'
#' @description
#' Lists all the blueprint names in an account.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_blueprints/](https://www.paws-r-sdk.com/docs/glue_list_blueprints/) for full documentation.
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param MaxResults The maximum size of a list to return.
#' @param Tags Filters the list by an Amazon Web Services resource tag.
#'
#' @keywords internal
#'
#' @rdname glue_list_blueprints
glue_list_blueprints <- function(NextToken = NULL, MaxResults = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListBlueprints",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_blueprints_input(NextToken = NextToken, MaxResults = MaxResults, Tags = Tags)
  output <- .glue$list_blueprints_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_blueprints <- glue_list_blueprints

#' List all task runs for a particular account
#'
#' @description
#' List all task runs for a particular account.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_column_statistics_task_runs/](https://www.paws-r-sdk.com/docs/glue_list_column_statistics_task_runs/) for full documentation.
#'
#' @param MaxResults The maximum size of the response.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @keywords internal
#'
#' @rdname glue_list_column_statistics_task_runs
glue_list_column_statistics_task_runs <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListColumnStatisticsTaskRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_column_statistics_task_runs_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$list_column_statistics_task_runs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_column_statistics_task_runs <- glue_list_column_statistics_task_runs

#' Retrieves the names of all crawler resources in this Amazon Web Services
#' account, or the resources with the specified tag
#'
#' @description
#' Retrieves the names of all crawler resources in this Amazon Web Services account, or the resources with the specified tag. This operation allows you to see which resources are available in your account, and their names.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_crawlers/](https://www.paws-r-sdk.com/docs/glue_list_crawlers/) for full documentation.
#'
#' @param MaxResults The maximum size of a list to return.
#' @param NextToken A continuation token, if this is a continuation request.
#' @param Tags Specifies to return only these tagged resources.
#'
#' @keywords internal
#'
#' @rdname glue_list_crawlers
glue_list_crawlers <- function(MaxResults = NULL, NextToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListCrawlers",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_crawlers_input(MaxResults = MaxResults, NextToken = NextToken, Tags = Tags)
  output <- .glue$list_crawlers_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_crawlers <- glue_list_crawlers

#' Returns all the crawls of a specified crawler
#'
#' @description
#' Returns all the crawls of a specified crawler. Returns only the crawls that have occurred since the launch date of the crawler history feature, and only retains up to 12 months of crawls. Older crawls will not be returned.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_crawls/](https://www.paws-r-sdk.com/docs/glue_list_crawls/) for full documentation.
#'
#' @param CrawlerName &#91;required&#93; The name of the crawler whose runs you want to retrieve.
#' @param MaxResults The maximum number of results to return. The default is 20, and maximum
#' is 100.
#' @param Filters Filters the crawls by the criteria you specify in a list of
#' `CrawlsFilter` objects.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @keywords internal
#'
#' @rdname glue_list_crawls
glue_list_crawls <- function(CrawlerName, MaxResults = NULL, Filters = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCrawls",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_crawls_input(CrawlerName = CrawlerName, MaxResults = MaxResults, Filters = Filters, NextToken = NextToken)
  output <- .glue$list_crawls_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_crawls <- glue_list_crawls

#' Lists all the custom patterns that have been created
#'
#' @description
#' Lists all the custom patterns that have been created.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_custom_entity_types/](https://www.paws-r-sdk.com/docs/glue_list_custom_entity_types/) for full documentation.
#'
#' @param NextToken A paginated token to offset the results.
#' @param MaxResults The maximum number of results to return.
#' @param Tags A list of key-value pair tags.
#'
#' @keywords internal
#'
#' @rdname glue_list_custom_entity_types
glue_list_custom_entity_types <- function(NextToken = NULL, MaxResults = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListCustomEntityTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_custom_entity_types_input(NextToken = NextToken, MaxResults = MaxResults, Tags = Tags)
  output <- .glue$list_custom_entity_types_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_custom_entity_types <- glue_list_custom_entity_types

#' Returns all data quality execution results for your account
#'
#' @description
#' Returns all data quality execution results for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_data_quality_results/](https://www.paws-r-sdk.com/docs/glue_list_data_quality_results/) for full documentation.
#'
#' @param Filter The filter criteria.
#' @param NextToken A paginated token to offset the results.
#' @param MaxResults The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname glue_list_data_quality_results
glue_list_data_quality_results <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDataQualityResults",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_data_quality_results_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$list_data_quality_results_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_data_quality_results <- glue_list_data_quality_results

#' Lists the recommendation runs meeting the filter criteria
#'
#' @description
#' Lists the recommendation runs meeting the filter criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_data_quality_rule_recommendation_runs/](https://www.paws-r-sdk.com/docs/glue_list_data_quality_rule_recommendation_runs/) for full documentation.
#'
#' @param Filter The filter criteria.
#' @param NextToken A paginated token to offset the results.
#' @param MaxResults The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname glue_list_data_quality_rule_recommendation_runs
glue_list_data_quality_rule_recommendation_runs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDataQualityRuleRecommendationRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_data_quality_rule_recommendation_runs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$list_data_quality_rule_recommendation_runs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_data_quality_rule_recommendation_runs <- glue_list_data_quality_rule_recommendation_runs

#' Lists all the runs meeting the filter criteria, where a ruleset is
#' evaluated against a data source
#'
#' @description
#' Lists all the runs meeting the filter criteria, where a ruleset is evaluated against a data source.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_data_quality_ruleset_evaluation_runs/](https://www.paws-r-sdk.com/docs/glue_list_data_quality_ruleset_evaluation_runs/) for full documentation.
#'
#' @param Filter The filter criteria.
#' @param NextToken A paginated token to offset the results.
#' @param MaxResults The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname glue_list_data_quality_ruleset_evaluation_runs
glue_list_data_quality_ruleset_evaluation_runs <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDataQualityRulesetEvaluationRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_data_quality_ruleset_evaluation_runs_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$list_data_quality_ruleset_evaluation_runs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_data_quality_ruleset_evaluation_runs <- glue_list_data_quality_ruleset_evaluation_runs

#' Returns a paginated list of rulesets for the specified list of Glue
#' tables
#'
#' @description
#' Returns a paginated list of rulesets for the specified list of Glue tables.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_data_quality_rulesets/](https://www.paws-r-sdk.com/docs/glue_list_data_quality_rulesets/) for full documentation.
#'
#' @param NextToken A paginated token to offset the results.
#' @param MaxResults The maximum number of results to return.
#' @param Filter The filter criteria.
#' @param Tags A list of key-value pair tags.
#'
#' @keywords internal
#'
#' @rdname glue_list_data_quality_rulesets
glue_list_data_quality_rulesets <- function(NextToken = NULL, MaxResults = NULL, Filter = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListDataQualityRulesets",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_data_quality_rulesets_input(NextToken = NextToken, MaxResults = MaxResults, Filter = Filter, Tags = Tags)
  output <- .glue$list_data_quality_rulesets_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_data_quality_rulesets <- glue_list_data_quality_rulesets

#' Retrieves the names of all DevEndpoint resources in this Amazon Web
#' Services account, or the resources with the specified tag
#'
#' @description
#' Retrieves the names of all `DevEndpoint` resources in this Amazon Web Services account, or the resources with the specified tag. This operation allows you to see which resources are available in your account, and their names.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_dev_endpoints/](https://www.paws-r-sdk.com/docs/glue_list_dev_endpoints/) for full documentation.
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param MaxResults The maximum size of a list to return.
#' @param Tags Specifies to return only these tagged resources.
#'
#' @keywords internal
#'
#' @rdname glue_list_dev_endpoints
glue_list_dev_endpoints <- function(NextToken = NULL, MaxResults = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListDevEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_dev_endpoints_input(NextToken = NextToken, MaxResults = MaxResults, Tags = Tags)
  output <- .glue$list_dev_endpoints_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_dev_endpoints <- glue_list_dev_endpoints

#' Retrieves the names of all job resources in this Amazon Web Services
#' account, or the resources with the specified tag
#'
#' @description
#' Retrieves the names of all job resources in this Amazon Web Services account, or the resources with the specified tag. This operation allows you to see which resources are available in your account, and their names.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_jobs/](https://www.paws-r-sdk.com/docs/glue_list_jobs/) for full documentation.
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param MaxResults The maximum size of a list to return.
#' @param Tags Specifies to return only these tagged resources.
#'
#' @keywords internal
#'
#' @rdname glue_list_jobs
glue_list_jobs <- function(NextToken = NULL, MaxResults = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_jobs_input(NextToken = NextToken, MaxResults = MaxResults, Tags = Tags)
  output <- .glue$list_jobs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_jobs <- glue_list_jobs

#' Retrieves a sortable, filterable list of existing Glue machine learning
#' transforms in this Amazon Web Services account, or the resources with
#' the specified tag
#'
#' @description
#' Retrieves a sortable, filterable list of existing Glue machine learning transforms in this Amazon Web Services account, or the resources with the specified tag. This operation takes the optional `Tags` field, which you can use as a filter of the responses so that tagged resources can be retrieved as a group. If you choose to use tag filtering, only resources with the tags are retrieved.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_ml_transforms/](https://www.paws-r-sdk.com/docs/glue_list_ml_transforms/) for full documentation.
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param MaxResults The maximum size of a list to return.
#' @param Filter A `TransformFilterCriteria` used to filter the machine learning
#' transforms.
#' @param Sort A `TransformSortCriteria` used to sort the machine learning transforms.
#' @param Tags Specifies to return only these tagged resources.
#'
#' @keywords internal
#'
#' @rdname glue_list_ml_transforms
glue_list_ml_transforms <- function(NextToken = NULL, MaxResults = NULL, Filter = NULL, Sort = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListMLTransforms",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_ml_transforms_input(NextToken = NextToken, MaxResults = MaxResults, Filter = Filter, Sort = Sort, Tags = Tags)
  output <- .glue$list_ml_transforms_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_ml_transforms <- glue_list_ml_transforms

#' Returns a list of registries that you have created, with minimal
#' registry information
#'
#' @description
#' Returns a list of registries that you have created, with minimal registry information. Registries in the `Deleting` status will not be included in the results. Empty results will be returned if there are no registries available.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_registries/](https://www.paws-r-sdk.com/docs/glue_list_registries/) for full documentation.
#'
#' @param MaxResults Maximum number of results required per page. If the value is not
#' supplied, this will be defaulted to 25 per page.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @keywords internal
#'
#' @rdname glue_list_registries
glue_list_registries <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListRegistries",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Registries")
  )
  input <- .glue$list_registries_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$list_registries_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_registries <- glue_list_registries

#' Returns a list of schema versions that you have created, with minimal
#' information
#'
#' @description
#' Returns a list of schema versions that you have created, with minimal information. Schema versions in Deleted status will not be included in the results. Empty results will be returned if there are no schema versions available.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_schema_versions/](https://www.paws-r-sdk.com/docs/glue_list_schema_versions/) for full documentation.
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure to contain schema identity fields. The
#' structure contains:
#' 
#' -   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
#'     Either `SchemaArn` or `SchemaName` and `RegistryName` has to be
#'     provided.
#' 
#' -   SchemaId$SchemaName: The name of the schema. Either `SchemaArn` or
#'     `SchemaName` and `RegistryName` has to be provided.
#' @param MaxResults Maximum number of results required per page. If the value is not
#' supplied, this will be defaulted to 25 per page.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @keywords internal
#'
#' @rdname glue_list_schema_versions
glue_list_schema_versions <- function(SchemaId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSchemaVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Schemas")
  )
  input <- .glue$list_schema_versions_input(SchemaId = SchemaId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$list_schema_versions_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_schema_versions <- glue_list_schema_versions

#' Returns a list of schemas with minimal details
#'
#' @description
#' Returns a list of schemas with minimal details. Schemas in Deleting status will not be included in the results. Empty results will be returned if there are no schemas available.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_schemas/](https://www.paws-r-sdk.com/docs/glue_list_schemas/) for full documentation.
#'
#' @param RegistryId A wrapper structure that may contain the registry name and Amazon
#' Resource Name (ARN).
#' @param MaxResults Maximum number of results required per page. If the value is not
#' supplied, this will be defaulted to 25 per page.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @keywords internal
#'
#' @rdname glue_list_schemas
glue_list_schemas <- function(RegistryId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSchemas",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Schemas")
  )
  input <- .glue$list_schemas_input(RegistryId = RegistryId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$list_schemas_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_schemas <- glue_list_schemas

#' Retrieve a list of sessions
#'
#' @description
#' Retrieve a list of sessions.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_sessions/](https://www.paws-r-sdk.com/docs/glue_list_sessions/) for full documentation.
#'
#' @param NextToken The token for the next set of results, or null if there are no more
#' result.
#' @param MaxResults The maximum number of results.
#' @param Tags Tags belonging to the session.
#' @param RequestOrigin The origin of the request.
#'
#' @keywords internal
#'
#' @rdname glue_list_sessions
glue_list_sessions <- function(NextToken = NULL, MaxResults = NULL, Tags = NULL, RequestOrigin = NULL) {
  op <- new_operation(
    name = "ListSessions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_sessions_input(NextToken = NextToken, MaxResults = MaxResults, Tags = Tags, RequestOrigin = RequestOrigin)
  output <- .glue$list_sessions_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_sessions <- glue_list_sessions

#' Lists statements for the session
#'
#' @description
#' Lists statements for the session.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_statements/](https://www.paws-r-sdk.com/docs/glue_list_statements/) for full documentation.
#'
#' @param SessionId &#91;required&#93; The Session ID of the statements.
#' @param RequestOrigin The origin of the request to list statements.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @keywords internal
#'
#' @rdname glue_list_statements
glue_list_statements <- function(SessionId, RequestOrigin = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListStatements",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_statements_input(SessionId = SessionId, RequestOrigin = RequestOrigin, NextToken = NextToken)
  output <- .glue$list_statements_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_statements <- glue_list_statements

#' Lists the history of previous optimizer runs for a specific table
#'
#' @description
#' Lists the history of previous optimizer runs for a specific table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_table_optimizer_runs/](https://www.paws-r-sdk.com/docs/glue_list_table_optimizer_runs/) for full documentation.
#'
#' @param CatalogId &#91;required&#93; The Catalog ID of the table.
#' @param DatabaseName &#91;required&#93; The name of the database in the catalog in which the table resides.
#' @param TableName &#91;required&#93; The name of the table.
#' @param Type &#91;required&#93; The type of table optimizer. Currently, the only valid value is
#' `compaction`.
#' @param MaxResults The maximum number of optimizer runs to return on each call.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @keywords internal
#'
#' @rdname glue_list_table_optimizer_runs
glue_list_table_optimizer_runs <- function(CatalogId, DatabaseName, TableName, Type, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTableOptimizerRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_table_optimizer_runs_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, Type = Type, MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$list_table_optimizer_runs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_table_optimizer_runs <- glue_list_table_optimizer_runs

#' Retrieves the names of all trigger resources in this Amazon Web Services
#' account, or the resources with the specified tag
#'
#' @description
#' Retrieves the names of all trigger resources in this Amazon Web Services account, or the resources with the specified tag. This operation allows you to see which resources are available in your account, and their names.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_triggers/](https://www.paws-r-sdk.com/docs/glue_list_triggers/) for full documentation.
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param DependentJobName The name of the job for which to retrieve triggers. The trigger that can
#' start this job is returned. If there is no such trigger, all triggers
#' are returned.
#' @param MaxResults The maximum size of a list to return.
#' @param Tags Specifies to return only these tagged resources.
#'
#' @keywords internal
#'
#' @rdname glue_list_triggers
glue_list_triggers <- function(NextToken = NULL, DependentJobName = NULL, MaxResults = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListTriggers",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_triggers_input(NextToken = NextToken, DependentJobName = DependentJobName, MaxResults = MaxResults, Tags = Tags)
  output <- .glue$list_triggers_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_triggers <- glue_list_triggers

#' Lists names of workflows created in the account
#'
#' @description
#' Lists names of workflows created in the account.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_list_workflows/](https://www.paws-r-sdk.com/docs/glue_list_workflows/) for full documentation.
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param MaxResults The maximum size of a list to return.
#'
#' @keywords internal
#'
#' @rdname glue_list_workflows
glue_list_workflows <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkflows",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$list_workflows_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$list_workflows_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_workflows <- glue_list_workflows

#' Sets the security configuration for a specified catalog
#'
#' @description
#' Sets the security configuration for a specified catalog. After the configuration has been set, the specified encryption is applied to every catalog write thereafter.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_put_data_catalog_encryption_settings/](https://www.paws-r-sdk.com/docs/glue_put_data_catalog_encryption_settings/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog to set the security configuration for. If
#' none is provided, the Amazon Web Services account ID is used by default.
#' @param DataCatalogEncryptionSettings &#91;required&#93; The security configuration to set.
#'
#' @keywords internal
#'
#' @rdname glue_put_data_catalog_encryption_settings
glue_put_data_catalog_encryption_settings <- function(CatalogId = NULL, DataCatalogEncryptionSettings) {
  op <- new_operation(
    name = "PutDataCatalogEncryptionSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$put_data_catalog_encryption_settings_input(CatalogId = CatalogId, DataCatalogEncryptionSettings = DataCatalogEncryptionSettings)
  output <- .glue$put_data_catalog_encryption_settings_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$put_data_catalog_encryption_settings <- glue_put_data_catalog_encryption_settings

#' Sets the Data Catalog resource policy for access control
#'
#' @description
#' Sets the Data Catalog resource policy for access control.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_put_resource_policy/](https://www.paws-r-sdk.com/docs/glue_put_resource_policy/) for full documentation.
#'
#' @param PolicyInJson &#91;required&#93; Contains the policy document to set, in JSON format.
#' @param ResourceArn Do not use. For internal use only.
#' @param PolicyHashCondition The hash value returned when the previous policy was set using
#' [`put_resource_policy`][glue_put_resource_policy]. Its purpose is to
#' prevent concurrent modifications of a policy. Do not use this parameter
#' if no previous policy has been set.
#' @param PolicyExistsCondition A value of `MUST_EXIST` is used to update a policy. A value of
#' `NOT_EXIST` is used to create a new policy. If a value of `NONE` or a
#' null value is used, the call does not depend on the existence of a
#' policy.
#' @param EnableHybrid If `'TRUE'`, indicates that you are using both methods to grant
#' cross-account access to Data Catalog resources:
#' 
#' -   By directly updating the resource policy with `PutResourePolicy`
#' 
#' -   By using the **Grant permissions** command on the Amazon Web
#'     Services Management Console.
#' 
#' Must be set to `'TRUE'` if you have already used the Management Console
#' to grant cross-account access, otherwise the call fails. Default is
#' 'FALSE'.
#'
#' @keywords internal
#'
#' @rdname glue_put_resource_policy
glue_put_resource_policy <- function(PolicyInJson, ResourceArn = NULL, PolicyHashCondition = NULL, PolicyExistsCondition = NULL, EnableHybrid = NULL) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$put_resource_policy_input(PolicyInJson = PolicyInJson, ResourceArn = ResourceArn, PolicyHashCondition = PolicyHashCondition, PolicyExistsCondition = PolicyExistsCondition, EnableHybrid = EnableHybrid)
  output <- .glue$put_resource_policy_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$put_resource_policy <- glue_put_resource_policy

#' Puts the metadata key value pair for a specified schema version ID
#'
#' @description
#' Puts the metadata key value pair for a specified schema version ID. A maximum of 10 key value pairs will be allowed per schema version. They can be added over one or more calls.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_put_schema_version_metadata/](https://www.paws-r-sdk.com/docs/glue_put_schema_version_metadata/) for full documentation.
#'
#' @param SchemaId The unique ID for the schema.
#' @param SchemaVersionNumber The version number of the schema.
#' @param SchemaVersionId The unique version ID of the schema version.
#' @param MetadataKeyValue &#91;required&#93; The metadata key's corresponding value.
#'
#' @keywords internal
#'
#' @rdname glue_put_schema_version_metadata
glue_put_schema_version_metadata <- function(SchemaId = NULL, SchemaVersionNumber = NULL, SchemaVersionId = NULL, MetadataKeyValue) {
  op <- new_operation(
    name = "PutSchemaVersionMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$put_schema_version_metadata_input(SchemaId = SchemaId, SchemaVersionNumber = SchemaVersionNumber, SchemaVersionId = SchemaVersionId, MetadataKeyValue = MetadataKeyValue)
  output <- .glue$put_schema_version_metadata_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$put_schema_version_metadata <- glue_put_schema_version_metadata

#' Puts the specified workflow run properties for the given workflow run
#'
#' @description
#' Puts the specified workflow run properties for the given workflow run. If a property already exists for the specified run, then it overrides the value otherwise adds the property to existing properties.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_put_workflow_run_properties/](https://www.paws-r-sdk.com/docs/glue_put_workflow_run_properties/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the workflow which was run.
#' @param RunId &#91;required&#93; The ID of the workflow run for which the run properties should be
#' updated.
#' @param RunProperties &#91;required&#93; The properties to put for the specified run.
#'
#' @keywords internal
#'
#' @rdname glue_put_workflow_run_properties
glue_put_workflow_run_properties <- function(Name, RunId, RunProperties) {
  op <- new_operation(
    name = "PutWorkflowRunProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$put_workflow_run_properties_input(Name = Name, RunId = RunId, RunProperties = RunProperties)
  output <- .glue$put_workflow_run_properties_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$put_workflow_run_properties <- glue_put_workflow_run_properties

#' Queries for the schema version metadata information
#'
#' @description
#' Queries for the schema version metadata information.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_query_schema_version_metadata/](https://www.paws-r-sdk.com/docs/glue_query_schema_version_metadata/) for full documentation.
#'
#' @param SchemaId A wrapper structure that may contain the schema name and Amazon Resource
#' Name (ARN).
#' @param SchemaVersionNumber The version number of the schema.
#' @param SchemaVersionId The unique version ID of the schema version.
#' @param MetadataList Search key-value pairs for metadata, if they are not provided all the
#' metadata information will be fetched.
#' @param MaxResults Maximum number of results required per page. If the value is not
#' supplied, this will be defaulted to 25 per page.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @keywords internal
#'
#' @rdname glue_query_schema_version_metadata
glue_query_schema_version_metadata <- function(SchemaId = NULL, SchemaVersionNumber = NULL, SchemaVersionId = NULL, MetadataList = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "QuerySchemaVersionMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$query_schema_version_metadata_input(SchemaId = SchemaId, SchemaVersionNumber = SchemaVersionNumber, SchemaVersionId = SchemaVersionId, MetadataList = MetadataList, MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$query_schema_version_metadata_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$query_schema_version_metadata <- glue_query_schema_version_metadata

#' Adds a new version to the existing schema
#'
#' @description
#' Adds a new version to the existing schema. Returns an error if new version of schema does not meet the compatibility requirements of the schema set. This API will not create a new schema set and will return a 404 error if the schema set is not already present in the Schema Registry.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_register_schema_version/](https://www.paws-r-sdk.com/docs/glue_register_schema_version/) for full documentation.
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure to contain schema identity fields. The
#' structure contains:
#' 
#' -   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
#'     Either `SchemaArn` or `SchemaName` and `RegistryName` has to be
#'     provided.
#' 
#' -   SchemaId$SchemaName: The name of the schema. Either `SchemaArn` or
#'     `SchemaName` and `RegistryName` has to be provided.
#' @param SchemaDefinition &#91;required&#93; The schema definition using the `DataFormat` setting for the
#' `SchemaName`.
#'
#' @keywords internal
#'
#' @rdname glue_register_schema_version
glue_register_schema_version <- function(SchemaId, SchemaDefinition) {
  op <- new_operation(
    name = "RegisterSchemaVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$register_schema_version_input(SchemaId = SchemaId, SchemaDefinition = SchemaDefinition)
  output <- .glue$register_schema_version_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$register_schema_version <- glue_register_schema_version

#' Removes a key value pair from the schema version metadata for the
#' specified schema version ID
#'
#' @description
#' Removes a key value pair from the schema version metadata for the specified schema version ID.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_remove_schema_version_metadata/](https://www.paws-r-sdk.com/docs/glue_remove_schema_version_metadata/) for full documentation.
#'
#' @param SchemaId A wrapper structure that may contain the schema name and Amazon Resource
#' Name (ARN).
#' @param SchemaVersionNumber The version number of the schema.
#' @param SchemaVersionId The unique version ID of the schema version.
#' @param MetadataKeyValue &#91;required&#93; The value of the metadata key.
#'
#' @keywords internal
#'
#' @rdname glue_remove_schema_version_metadata
glue_remove_schema_version_metadata <- function(SchemaId = NULL, SchemaVersionNumber = NULL, SchemaVersionId = NULL, MetadataKeyValue) {
  op <- new_operation(
    name = "RemoveSchemaVersionMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$remove_schema_version_metadata_input(SchemaId = SchemaId, SchemaVersionNumber = SchemaVersionNumber, SchemaVersionId = SchemaVersionId, MetadataKeyValue = MetadataKeyValue)
  output <- .glue$remove_schema_version_metadata_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$remove_schema_version_metadata <- glue_remove_schema_version_metadata

#' Resets a bookmark entry
#'
#' @description
#' Resets a bookmark entry.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_reset_job_bookmark/](https://www.paws-r-sdk.com/docs/glue_reset_job_bookmark/) for full documentation.
#'
#' @param JobName &#91;required&#93; The name of the job in question.
#' @param RunId The unique run identifier associated with this job run.
#'
#' @keywords internal
#'
#' @rdname glue_reset_job_bookmark
glue_reset_job_bookmark <- function(JobName, RunId = NULL) {
  op <- new_operation(
    name = "ResetJobBookmark",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$reset_job_bookmark_input(JobName = JobName, RunId = RunId)
  output <- .glue$reset_job_bookmark_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$reset_job_bookmark <- glue_reset_job_bookmark

#' Restarts selected nodes of a previous partially completed workflow run
#' and resumes the workflow run
#'
#' @description
#' Restarts selected nodes of a previous partially completed workflow run and resumes the workflow run. The selected nodes and all nodes that are downstream from the selected nodes are run.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_resume_workflow_run/](https://www.paws-r-sdk.com/docs/glue_resume_workflow_run/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the workflow to resume.
#' @param RunId &#91;required&#93; The ID of the workflow run to resume.
#' @param NodeIds &#91;required&#93; A list of the node IDs for the nodes you want to restart. The nodes that
#' are to be restarted must have a run attempt in the original run.
#'
#' @keywords internal
#'
#' @rdname glue_resume_workflow_run
glue_resume_workflow_run <- function(Name, RunId, NodeIds) {
  op <- new_operation(
    name = "ResumeWorkflowRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$resume_workflow_run_input(Name = Name, RunId = RunId, NodeIds = NodeIds)
  output <- .glue$resume_workflow_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$resume_workflow_run <- glue_resume_workflow_run

#' Executes the statement
#'
#' @description
#' Executes the statement.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_run_statement/](https://www.paws-r-sdk.com/docs/glue_run_statement/) for full documentation.
#'
#' @param SessionId &#91;required&#93; The Session Id of the statement to be run.
#' @param Code &#91;required&#93; The statement code to be run.
#' @param RequestOrigin The origin of the request.
#'
#' @keywords internal
#'
#' @rdname glue_run_statement
glue_run_statement <- function(SessionId, Code, RequestOrigin = NULL) {
  op <- new_operation(
    name = "RunStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$run_statement_input(SessionId = SessionId, Code = Code, RequestOrigin = RequestOrigin)
  output <- .glue$run_statement_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$run_statement <- glue_run_statement

#' Searches a set of tables based on properties in the table metadata as
#' well as on the parent database
#'
#' @description
#' Searches a set of tables based on properties in the table metadata as well as on the parent database. You can search against text or filter conditions.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_search_tables/](https://www.paws-r-sdk.com/docs/glue_search_tables/) for full documentation.
#'
#' @param CatalogId A unique identifier, consisting of ` account_id `.
#' @param NextToken A continuation token, included if this is a continuation call.
#' @param Filters A list of key-value pairs, and a comparator used to filter the search
#' results. Returns all entities matching the predicate.
#' 
#' The `Comparator` member of the `PropertyPredicate` struct is used only
#' for time fields, and can be omitted for other field types. Also, when
#' comparing string values, such as when `Key=Name`, a fuzzy match
#' algorithm is used. The `Key` field (for example, the value of the `Name`
#' field) is split on certain punctuation characters, for example, -, :,
#' #, etc. into tokens. Then each token is exact-match compared with the
#' `Value` member of `PropertyPredicate`. For example, if `Key=Name` and
#' `Value=link`, tables named `customer-link` and `xx-link-yy` are
#' returned, but `xxlinkyy` is not returned.
#' @param SearchText A string used for a text search.
#' 
#' Specifying a value in quotes filters based on an exact match to the
#' value.
#' @param SortCriteria A list of criteria for sorting the results by a field name, in an
#' ascending or descending order.
#' @param MaxResults The maximum number of tables to return in a single response.
#' @param ResourceShareType Allows you to specify that you want to search the tables shared with
#' your account. The allowable values are `FOREIGN` or `ALL`.
#' 
#' -   If set to `FOREIGN`, will search the tables shared with your
#'     account.
#' 
#' -   If set to `ALL`, will search the tables shared with your account, as
#'     well as the tables in yor local account.
#'
#' @keywords internal
#'
#' @rdname glue_search_tables
glue_search_tables <- function(CatalogId = NULL, NextToken = NULL, Filters = NULL, SearchText = NULL, SortCriteria = NULL, MaxResults = NULL, ResourceShareType = NULL) {
  op <- new_operation(
    name = "SearchTables",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .glue$search_tables_input(CatalogId = CatalogId, NextToken = NextToken, Filters = Filters, SearchText = SearchText, SortCriteria = SortCriteria, MaxResults = MaxResults, ResourceShareType = ResourceShareType)
  output <- .glue$search_tables_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$search_tables <- glue_search_tables

#' Starts a new run of the specified blueprint
#'
#' @description
#' Starts a new run of the specified blueprint.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_start_blueprint_run/](https://www.paws-r-sdk.com/docs/glue_start_blueprint_run/) for full documentation.
#'
#' @param BlueprintName &#91;required&#93; The name of the blueprint.
#' @param Parameters Specifies the parameters as a `BlueprintParameters` object.
#' @param RoleArn &#91;required&#93; Specifies the IAM role used to create the workflow.
#'
#' @keywords internal
#'
#' @rdname glue_start_blueprint_run
glue_start_blueprint_run <- function(BlueprintName, Parameters = NULL, RoleArn) {
  op <- new_operation(
    name = "StartBlueprintRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_blueprint_run_input(BlueprintName = BlueprintName, Parameters = Parameters, RoleArn = RoleArn)
  output <- .glue$start_blueprint_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_blueprint_run <- glue_start_blueprint_run

#' Starts a column statistics task run, for a specified table and columns
#'
#' @description
#' Starts a column statistics task run, for a specified table and columns.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_start_column_statistics_task_run/](https://www.paws-r-sdk.com/docs/glue_start_column_statistics_task_run/) for full documentation.
#'
#' @param DatabaseName &#91;required&#93; The name of the database where the table resides.
#' @param TableName &#91;required&#93; The name of the table to generate statistics.
#' @param ColumnNameList A list of the column names to generate statistics. If none is supplied,
#' all column names for the table will be used by default.
#' @param Role &#91;required&#93; The IAM role that the service assumes to generate statistics.
#' @param SampleSize The percentage of rows used to generate statistics. If none is supplied,
#' the entire table will be used to generate stats.
#' @param CatalogID The ID of the Data Catalog where the table reside. If none is supplied,
#' the Amazon Web Services account ID is used by default.
#' @param SecurityConfiguration Name of the security configuration that is used to encrypt CloudWatch
#' logs for the column stats task run.
#'
#' @keywords internal
#'
#' @rdname glue_start_column_statistics_task_run
glue_start_column_statistics_task_run <- function(DatabaseName, TableName, ColumnNameList = NULL, Role, SampleSize = NULL, CatalogID = NULL, SecurityConfiguration = NULL) {
  op <- new_operation(
    name = "StartColumnStatisticsTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_column_statistics_task_run_input(DatabaseName = DatabaseName, TableName = TableName, ColumnNameList = ColumnNameList, Role = Role, SampleSize = SampleSize, CatalogID = CatalogID, SecurityConfiguration = SecurityConfiguration)
  output <- .glue$start_column_statistics_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_column_statistics_task_run <- glue_start_column_statistics_task_run

#' Starts a crawl using the specified crawler, regardless of what is
#' scheduled
#'
#' @description
#' Starts a crawl using the specified crawler, regardless of what is scheduled. If the crawler is already running, returns a [CrawlerRunningException](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-exceptions.html#aws-glue-api-exceptions-CrawlerRunningException).
#'
#' See [https://www.paws-r-sdk.com/docs/glue_start_crawler/](https://www.paws-r-sdk.com/docs/glue_start_crawler/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the crawler to start.
#'
#' @keywords internal
#'
#' @rdname glue_start_crawler
glue_start_crawler <- function(Name) {
  op <- new_operation(
    name = "StartCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_crawler_input(Name = Name)
  output <- .glue$start_crawler_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_crawler <- glue_start_crawler

#' Changes the schedule state of the specified crawler to SCHEDULED, unless
#' the crawler is already running or the schedule state is already
#' SCHEDULED
#'
#' @description
#' Changes the schedule state of the specified crawler to `SCHEDULED`, unless the crawler is already running or the schedule state is already `SCHEDULED`.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_start_crawler_schedule/](https://www.paws-r-sdk.com/docs/glue_start_crawler_schedule/) for full documentation.
#'
#' @param CrawlerName &#91;required&#93; Name of the crawler to schedule.
#'
#' @keywords internal
#'
#' @rdname glue_start_crawler_schedule
glue_start_crawler_schedule <- function(CrawlerName) {
  op <- new_operation(
    name = "StartCrawlerSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_crawler_schedule_input(CrawlerName = CrawlerName)
  output <- .glue$start_crawler_schedule_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_crawler_schedule <- glue_start_crawler_schedule

#' Starts a recommendation run that is used to generate rules when you
#' don't know what rules to write
#'
#' @description
#' Starts a recommendation run that is used to generate rules when you don't know what rules to write. Glue Data Quality analyzes the data and comes up with recommendations for a potential ruleset. You can then triage the ruleset and modify the generated ruleset to your liking.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_start_data_quality_rule_recommendation_run/](https://www.paws-r-sdk.com/docs/glue_start_data_quality_rule_recommendation_run/) for full documentation.
#'
#' @param DataSource &#91;required&#93; The data source (Glue table) associated with this run.
#' @param Role &#91;required&#93; An IAM role supplied to encrypt the results of the run.
#' @param NumberOfWorkers The number of `G.1X` workers to be used in the run. The default is 5.
#' @param Timeout The timeout for a run in minutes. This is the maximum time that a run
#' can consume resources before it is terminated and enters `TIMEOUT`
#' status. The default is 2,880 minutes (48 hours).
#' @param CreatedRulesetName A name for the ruleset.
#' @param ClientToken Used for idempotency and is recommended to be set to a random ID (such
#' as a UUID) to avoid creating or starting multiple instances of the same
#' resource.
#'
#' @keywords internal
#'
#' @rdname glue_start_data_quality_rule_recommendation_run
glue_start_data_quality_rule_recommendation_run <- function(DataSource, Role, NumberOfWorkers = NULL, Timeout = NULL, CreatedRulesetName = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "StartDataQualityRuleRecommendationRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_data_quality_rule_recommendation_run_input(DataSource = DataSource, Role = Role, NumberOfWorkers = NumberOfWorkers, Timeout = Timeout, CreatedRulesetName = CreatedRulesetName, ClientToken = ClientToken)
  output <- .glue$start_data_quality_rule_recommendation_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_data_quality_rule_recommendation_run <- glue_start_data_quality_rule_recommendation_run

#' Once you have a ruleset definition (either recommended or your own), you
#' call this operation to evaluate the ruleset against a data source (Glue
#' table)
#'
#' @description
#' Once you have a ruleset definition (either recommended or your own), you call this operation to evaluate the ruleset against a data source (Glue table). The evaluation computes results which you can retrieve with the [`get_data_quality_result`][glue_get_data_quality_result] API.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_start_data_quality_ruleset_evaluation_run/](https://www.paws-r-sdk.com/docs/glue_start_data_quality_ruleset_evaluation_run/) for full documentation.
#'
#' @param DataSource &#91;required&#93; The data source (Glue table) associated with this run.
#' @param Role &#91;required&#93; An IAM role supplied to encrypt the results of the run.
#' @param NumberOfWorkers The number of `G.1X` workers to be used in the run. The default is 5.
#' @param Timeout The timeout for a run in minutes. This is the maximum time that a run
#' can consume resources before it is terminated and enters `TIMEOUT`
#' status. The default is 2,880 minutes (48 hours).
#' @param ClientToken Used for idempotency and is recommended to be set to a random ID (such
#' as a UUID) to avoid creating or starting multiple instances of the same
#' resource.
#' @param AdditionalRunOptions Additional run options you can specify for an evaluation run.
#' @param RulesetNames &#91;required&#93; A list of ruleset names.
#' @param AdditionalDataSources A map of reference strings to additional data sources you can specify
#' for an evaluation run.
#'
#' @keywords internal
#'
#' @rdname glue_start_data_quality_ruleset_evaluation_run
glue_start_data_quality_ruleset_evaluation_run <- function(DataSource, Role, NumberOfWorkers = NULL, Timeout = NULL, ClientToken = NULL, AdditionalRunOptions = NULL, RulesetNames, AdditionalDataSources = NULL) {
  op <- new_operation(
    name = "StartDataQualityRulesetEvaluationRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_data_quality_ruleset_evaluation_run_input(DataSource = DataSource, Role = Role, NumberOfWorkers = NumberOfWorkers, Timeout = Timeout, ClientToken = ClientToken, AdditionalRunOptions = AdditionalRunOptions, RulesetNames = RulesetNames, AdditionalDataSources = AdditionalDataSources)
  output <- .glue$start_data_quality_ruleset_evaluation_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_data_quality_ruleset_evaluation_run <- glue_start_data_quality_ruleset_evaluation_run

#' Begins an asynchronous task to export all labeled data for a particular
#' transform
#'
#' @description
#' Begins an asynchronous task to export all labeled data for a particular transform. This task is the only label-related API call that is not part of the typical active learning workflow. You typically use [`start_export_labels_task_run`][glue_start_export_labels_task_run] when you want to work with all of your existing labels at the same time, such as when you want to remove or change labels that were previously submitted as truth. This API operation accepts the `TransformId` whose labels you want to export and an Amazon Simple Storage Service (Amazon S3) path to export the labels to. The operation returns a `TaskRunId`. You can check on the status of your task run by calling the [`get_ml_task_run`][glue_get_ml_task_run] API.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_start_export_labels_task_run/](https://www.paws-r-sdk.com/docs/glue_start_export_labels_task_run/) for full documentation.
#'
#' @param TransformId &#91;required&#93; The unique identifier of the machine learning transform.
#' @param OutputS3Path &#91;required&#93; The Amazon S3 path where you export the labels.
#'
#' @keywords internal
#'
#' @rdname glue_start_export_labels_task_run
glue_start_export_labels_task_run <- function(TransformId, OutputS3Path) {
  op <- new_operation(
    name = "StartExportLabelsTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_export_labels_task_run_input(TransformId = TransformId, OutputS3Path = OutputS3Path)
  output <- .glue$start_export_labels_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_export_labels_task_run <- glue_start_export_labels_task_run

#' Enables you to provide additional labels (examples of truth) to be used
#' to teach the machine learning transform and improve its quality
#'
#' @description
#' Enables you to provide additional labels (examples of truth) to be used to teach the machine learning transform and improve its quality. This API operation is generally used as part of the active learning workflow that starts with the [`start_ml_labeling_set_generation_task_run`][glue_start_ml_labeling_set_generation_task_run] call and that ultimately results in improving the quality of your machine learning transform.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_start_import_labels_task_run/](https://www.paws-r-sdk.com/docs/glue_start_import_labels_task_run/) for full documentation.
#'
#' @param TransformId &#91;required&#93; The unique identifier of the machine learning transform.
#' @param InputS3Path &#91;required&#93; The Amazon Simple Storage Service (Amazon S3) path from where you import
#' the labels.
#' @param ReplaceAllLabels Indicates whether to overwrite your existing labels.
#'
#' @keywords internal
#'
#' @rdname glue_start_import_labels_task_run
glue_start_import_labels_task_run <- function(TransformId, InputS3Path, ReplaceAllLabels = NULL) {
  op <- new_operation(
    name = "StartImportLabelsTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_import_labels_task_run_input(TransformId = TransformId, InputS3Path = InputS3Path, ReplaceAllLabels = ReplaceAllLabels)
  output <- .glue$start_import_labels_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_import_labels_task_run <- glue_start_import_labels_task_run

#' Starts a job run using a job definition
#'
#' @description
#' Starts a job run using a job definition.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_start_job_run/](https://www.paws-r-sdk.com/docs/glue_start_job_run/) for full documentation.
#'
#' @param JobName &#91;required&#93; The name of the job definition to use.
#' @param JobRunId The ID of a previous `JobRun` to retry.
#' @param Arguments The job arguments associated with this run. For this job run, they
#' replace the default arguments set in the job definition itself.
#' 
#' You can specify arguments here that your own job-execution script
#' consumes, as well as arguments that Glue itself consumes.
#' 
#' Job arguments may be logged. Do not pass plaintext secrets as arguments.
#' Retrieve secrets from a Glue Connection, Secrets Manager or other secret
#' management mechanism if you intend to keep them within the Job.
#' 
#' For information about how to specify and consume your own Job arguments,
#' see the [Calling Glue APIs in
#' Python](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
#' topic in the developer guide.
#' 
#' For information about the arguments you can provide to this field when
#' configuring Spark jobs, see the [Special Parameters Used by
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
#' topic in the developer guide.
#' 
#' For information about the arguments you can provide to this field when
#' configuring Ray jobs, see [Using job parameters in Ray
#' jobs](https://docs.aws.amazon.com/glue/latest/dg/author-job-ray-job-parameters.html)
#' in the developer guide.
#' @param AllocatedCapacity This field is deprecated. Use `MaxCapacity` instead.
#' 
#' The number of Glue data processing units (DPUs) to allocate to this
#' JobRun. You can allocate a minimum of 2 DPUs; the default is 10. A DPU
#' is a relative measure of processing power that consists of 4 vCPUs of
#' compute capacity and 16 GB of memory. For more information, see the
#' [Glue pricing page](https://aws.amazon.com/glue/pricing/).
#' @param Timeout The `JobRun` timeout in minutes. This is the maximum time that a job run
#' can consume resources before it is terminated and enters `TIMEOUT`
#' status. This value overrides the timeout value set in the parent job.
#' 
#' Streaming jobs do not have a timeout. The default for non-streaming jobs
#' is 2,880 minutes (48 hours).
#' @param MaxCapacity For Glue version 1.0 or earlier jobs, using the standard worker type,
#' the number of Glue data processing units (DPUs) that can be allocated
#' when this job runs. A DPU is a relative measure of processing power that
#' consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
#' information, see the [Glue pricing
#' page](https://aws.amazon.com/glue/pricing/).
#' 
#' For Glue version 2.0+ jobs, you cannot specify a `Maximum capacity`.
#' Instead, you should specify a `Worker type` and the `Number of workers`.
#' 
#' Do not set `MaxCapacity` if using `WorkerType` and `NumberOfWorkers`.
#' 
#' The value that can be allocated for `MaxCapacity` depends on whether you
#' are running a Python shell job, an Apache Spark ETL job, or an Apache
#' Spark streaming ETL job:
#' 
#' -   When you specify a Python shell job
#'     (`JobCommand.Name`="pythonshell"), you can allocate either 0.0625 or
#'     1 DPU. The default is 0.0625 DPU.
#' 
#' -   When you specify an Apache Spark ETL job
#'     (`JobCommand.Name`="glueetl") or Apache Spark streaming ETL job
#'     (`JobCommand.Name`="gluestreaming"), you can allocate from 2 to 100
#'     DPUs. The default is 10 DPUs. This job type cannot have a fractional
#'     DPU allocation.
#' @param SecurityConfiguration The name of the `SecurityConfiguration` structure to be used with this
#' job run.
#' @param NotificationProperty Specifies configuration properties of a job run notification.
#' @param WorkerType The type of predefined worker that is allocated when a job runs. Accepts
#' a value of G.1X, G.2X, G.4X, G.8X or G.025X for Spark jobs. Accepts the
#' value Z.2X for Ray jobs.
#' 
#' -   For the `G.1X` worker type, each worker maps to 1 DPU (4 vCPUs, 16
#'     GB of memory) with 84GB disk (approximately 34GB free), and provides
#'     1 executor per worker. We recommend this worker type for workloads
#'     such as data transforms, joins, and queries, to offers a scalable
#'     and cost effective way to run most jobs.
#' 
#' -   For the `G.2X` worker type, each worker maps to 2 DPU (8 vCPUs, 32
#'     GB of memory) with 128GB disk (approximately 77GB free), and
#'     provides 1 executor per worker. We recommend this worker type for
#'     workloads such as data transforms, joins, and queries, to offers a
#'     scalable and cost effective way to run most jobs.
#' 
#' -   For the `G.4X` worker type, each worker maps to 4 DPU (16 vCPUs, 64
#'     GB of memory) with 256GB disk (approximately 235GB free), and
#'     provides 1 executor per worker. We recommend this worker type for
#'     jobs whose workloads contain your most demanding transforms,
#'     aggregations, joins, and queries. This worker type is available only
#'     for Glue version 3.0 or later Spark ETL jobs in the following Amazon
#'     Web Services Regions: US East (Ohio), US East (N. Virginia), US West
#'     (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia
#'     Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe
#'     (Ireland), and Europe (Stockholm).
#' 
#' -   For the `G.8X` worker type, each worker maps to 8 DPU (32 vCPUs, 128
#'     GB of memory) with 512GB disk (approximately 487GB free), and
#'     provides 1 executor per worker. We recommend this worker type for
#'     jobs whose workloads contain your most demanding transforms,
#'     aggregations, joins, and queries. This worker type is available only
#'     for Glue version 3.0 or later Spark ETL jobs, in the same Amazon Web
#'     Services Regions as supported for the `G.4X` worker type.
#' 
#' -   For the `G.025X` worker type, each worker maps to 0.25 DPU (2 vCPUs,
#'     4 GB of memory) with 84GB disk (approximately 34GB free), and
#'     provides 1 executor per worker. We recommend this worker type for
#'     low volume streaming jobs. This worker type is only available for
#'     Glue version 3.0 streaming jobs.
#' 
#' -   For the `Z.2X` worker type, each worker maps to 2 M-DPU (8vCPUs, 64
#'     GB of memory) with 128 GB disk (approximately 120GB free), and
#'     provides up to 8 Ray workers based on the autoscaler.
#' @param NumberOfWorkers The number of workers of a defined `workerType` that are allocated when
#' a job runs.
#' @param ExecutionClass Indicates whether the job is run with a standard or flexible execution
#' class. The standard execution-class is ideal for time-sensitive
#' workloads that require fast job startup and dedicated resources.
#' 
#' The flexible execution class is appropriate for time-insensitive jobs
#' whose start and completion times may vary.
#' 
#' Only jobs with Glue version 3.0 and above and command type `glueetl`
#' will be allowed to set `ExecutionClass` to `FLEX`. The flexible
#' execution class is available for Spark jobs.
#'
#' @keywords internal
#'
#' @rdname glue_start_job_run
glue_start_job_run <- function(JobName, JobRunId = NULL, Arguments = NULL, AllocatedCapacity = NULL, Timeout = NULL, MaxCapacity = NULL, SecurityConfiguration = NULL, NotificationProperty = NULL, WorkerType = NULL, NumberOfWorkers = NULL, ExecutionClass = NULL) {
  op <- new_operation(
    name = "StartJobRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_job_run_input(JobName = JobName, JobRunId = JobRunId, Arguments = Arguments, AllocatedCapacity = AllocatedCapacity, Timeout = Timeout, MaxCapacity = MaxCapacity, SecurityConfiguration = SecurityConfiguration, NotificationProperty = NotificationProperty, WorkerType = WorkerType, NumberOfWorkers = NumberOfWorkers, ExecutionClass = ExecutionClass)
  output <- .glue$start_job_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_job_run <- glue_start_job_run

#' Starts a task to estimate the quality of the transform
#'
#' @description
#' Starts a task to estimate the quality of the transform.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_start_ml_evaluation_task_run/](https://www.paws-r-sdk.com/docs/glue_start_ml_evaluation_task_run/) for full documentation.
#'
#' @param TransformId &#91;required&#93; The unique identifier of the machine learning transform.
#'
#' @keywords internal
#'
#' @rdname glue_start_ml_evaluation_task_run
glue_start_ml_evaluation_task_run <- function(TransformId) {
  op <- new_operation(
    name = "StartMLEvaluationTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_ml_evaluation_task_run_input(TransformId = TransformId)
  output <- .glue$start_ml_evaluation_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_ml_evaluation_task_run <- glue_start_ml_evaluation_task_run

#' Starts the active learning workflow for your machine learning transform
#' to improve the transform's quality by generating label sets and adding
#' labels
#'
#' @description
#' Starts the active learning workflow for your machine learning transform to improve the transform's quality by generating label sets and adding labels.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_start_ml_labeling_set_generation_task_run/](https://www.paws-r-sdk.com/docs/glue_start_ml_labeling_set_generation_task_run/) for full documentation.
#'
#' @param TransformId &#91;required&#93; The unique identifier of the machine learning transform.
#' @param OutputS3Path &#91;required&#93; The Amazon Simple Storage Service (Amazon S3) path where you generate
#' the labeling set.
#'
#' @keywords internal
#'
#' @rdname glue_start_ml_labeling_set_generation_task_run
glue_start_ml_labeling_set_generation_task_run <- function(TransformId, OutputS3Path) {
  op <- new_operation(
    name = "StartMLLabelingSetGenerationTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_ml_labeling_set_generation_task_run_input(TransformId = TransformId, OutputS3Path = OutputS3Path)
  output <- .glue$start_ml_labeling_set_generation_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_ml_labeling_set_generation_task_run <- glue_start_ml_labeling_set_generation_task_run

#' Starts an existing trigger
#'
#' @description
#' Starts an existing trigger. See [Triggering Jobs](https://docs.aws.amazon.com/glue/latest/dg/trigger-job.html) for information about how different types of trigger are started.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_start_trigger/](https://www.paws-r-sdk.com/docs/glue_start_trigger/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the trigger to start.
#'
#' @keywords internal
#'
#' @rdname glue_start_trigger
glue_start_trigger <- function(Name) {
  op <- new_operation(
    name = "StartTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_trigger_input(Name = Name)
  output <- .glue$start_trigger_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_trigger <- glue_start_trigger

#' Starts a new run of the specified workflow
#'
#' @description
#' Starts a new run of the specified workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_start_workflow_run/](https://www.paws-r-sdk.com/docs/glue_start_workflow_run/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the workflow to start.
#' @param RunProperties The workflow run properties for the new workflow run.
#'
#' @keywords internal
#'
#' @rdname glue_start_workflow_run
glue_start_workflow_run <- function(Name, RunProperties = NULL) {
  op <- new_operation(
    name = "StartWorkflowRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_workflow_run_input(Name = Name, RunProperties = RunProperties)
  output <- .glue$start_workflow_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_workflow_run <- glue_start_workflow_run

#' Stops a task run for the specified table
#'
#' @description
#' Stops a task run for the specified table.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_stop_column_statistics_task_run/](https://www.paws-r-sdk.com/docs/glue_stop_column_statistics_task_run/) for full documentation.
#'
#' @param DatabaseName &#91;required&#93; The name of the database where the table resides.
#' @param TableName &#91;required&#93; The name of the table.
#'
#' @keywords internal
#'
#' @rdname glue_stop_column_statistics_task_run
glue_stop_column_statistics_task_run <- function(DatabaseName, TableName) {
  op <- new_operation(
    name = "StopColumnStatisticsTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$stop_column_statistics_task_run_input(DatabaseName = DatabaseName, TableName = TableName)
  output <- .glue$stop_column_statistics_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$stop_column_statistics_task_run <- glue_stop_column_statistics_task_run

#' If the specified crawler is running, stops the crawl
#'
#' @description
#' If the specified crawler is running, stops the crawl.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_stop_crawler/](https://www.paws-r-sdk.com/docs/glue_stop_crawler/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the crawler to stop.
#'
#' @keywords internal
#'
#' @rdname glue_stop_crawler
glue_stop_crawler <- function(Name) {
  op <- new_operation(
    name = "StopCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$stop_crawler_input(Name = Name)
  output <- .glue$stop_crawler_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$stop_crawler <- glue_stop_crawler

#' Sets the schedule state of the specified crawler to NOT_SCHEDULED, but
#' does not stop the crawler if it is already running
#'
#' @description
#' Sets the schedule state of the specified crawler to `NOT_SCHEDULED`, but does not stop the crawler if it is already running.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_stop_crawler_schedule/](https://www.paws-r-sdk.com/docs/glue_stop_crawler_schedule/) for full documentation.
#'
#' @param CrawlerName &#91;required&#93; Name of the crawler whose schedule state to set.
#'
#' @keywords internal
#'
#' @rdname glue_stop_crawler_schedule
glue_stop_crawler_schedule <- function(CrawlerName) {
  op <- new_operation(
    name = "StopCrawlerSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$stop_crawler_schedule_input(CrawlerName = CrawlerName)
  output <- .glue$stop_crawler_schedule_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$stop_crawler_schedule <- glue_stop_crawler_schedule

#' Stops the session
#'
#' @description
#' Stops the session.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_stop_session/](https://www.paws-r-sdk.com/docs/glue_stop_session/) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the session to be stopped.
#' @param RequestOrigin The origin of the request.
#'
#' @keywords internal
#'
#' @rdname glue_stop_session
glue_stop_session <- function(Id, RequestOrigin = NULL) {
  op <- new_operation(
    name = "StopSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$stop_session_input(Id = Id, RequestOrigin = RequestOrigin)
  output <- .glue$stop_session_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$stop_session <- glue_stop_session

#' Stops a specified trigger
#'
#' @description
#' Stops a specified trigger.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_stop_trigger/](https://www.paws-r-sdk.com/docs/glue_stop_trigger/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the trigger to stop.
#'
#' @keywords internal
#'
#' @rdname glue_stop_trigger
glue_stop_trigger <- function(Name) {
  op <- new_operation(
    name = "StopTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$stop_trigger_input(Name = Name)
  output <- .glue$stop_trigger_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$stop_trigger <- glue_stop_trigger

#' Stops the execution of the specified workflow run
#'
#' @description
#' Stops the execution of the specified workflow run.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_stop_workflow_run/](https://www.paws-r-sdk.com/docs/glue_stop_workflow_run/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the workflow to stop.
#' @param RunId &#91;required&#93; The ID of the workflow run to stop.
#'
#' @keywords internal
#'
#' @rdname glue_stop_workflow_run
glue_stop_workflow_run <- function(Name, RunId) {
  op <- new_operation(
    name = "StopWorkflowRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$stop_workflow_run_input(Name = Name, RunId = RunId)
  output <- .glue$stop_workflow_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$stop_workflow_run <- glue_stop_workflow_run

#' Adds tags to a resource
#'
#' @description
#' Adds tags to a resource. A tag is a label you can assign to an Amazon Web Services resource. In Glue, you can tag only certain resources. For information about what resources you can tag, see [Amazon Web Services Tags in Glue](https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html).
#'
#' See [https://www.paws-r-sdk.com/docs/glue_tag_resource/](https://www.paws-r-sdk.com/docs/glue_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the Glue resource to which to add the tags. For more
#' information about Glue resource ARNs, see the [Glue ARN string
#' pattern](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id).
#' @param TagsToAdd &#91;required&#93; Tags to add to this resource.
#'
#' @keywords internal
#'
#' @rdname glue_tag_resource
glue_tag_resource <- function(ResourceArn, TagsToAdd) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$tag_resource_input(ResourceArn = ResourceArn, TagsToAdd = TagsToAdd)
  output <- .glue$tag_resource_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$tag_resource <- glue_tag_resource

#' Removes tags from a resource
#'
#' @description
#' Removes tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_untag_resource/](https://www.paws-r-sdk.com/docs/glue_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource from which to remove the
#' tags.
#' @param TagsToRemove &#91;required&#93; Tags to remove from this resource.
#'
#' @keywords internal
#'
#' @rdname glue_untag_resource
glue_untag_resource <- function(ResourceArn, TagsToRemove) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$untag_resource_input(ResourceArn = ResourceArn, TagsToRemove = TagsToRemove)
  output <- .glue$untag_resource_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$untag_resource <- glue_untag_resource

#' Updates a registered blueprint
#'
#' @description
#' Updates a registered blueprint.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_blueprint/](https://www.paws-r-sdk.com/docs/glue_update_blueprint/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the blueprint.
#' @param Description A description of the blueprint.
#' @param BlueprintLocation &#91;required&#93; Specifies a path in Amazon S3 where the blueprint is published.
#'
#' @keywords internal
#'
#' @rdname glue_update_blueprint
glue_update_blueprint <- function(Name, Description = NULL, BlueprintLocation) {
  op <- new_operation(
    name = "UpdateBlueprint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_blueprint_input(Name = Name, Description = Description, BlueprintLocation = BlueprintLocation)
  output <- .glue$update_blueprint_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_blueprint <- glue_update_blueprint

#' Modifies an existing classifier (a GrokClassifier, an XMLClassifier, a
#' JsonClassifier, or a CsvClassifier, depending on which field is present)
#'
#' @description
#' Modifies an existing classifier (a `GrokClassifier`, an `XMLClassifier`, a `JsonClassifier`, or a `CsvClassifier`, depending on which field is present).
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_classifier/](https://www.paws-r-sdk.com/docs/glue_update_classifier/) for full documentation.
#'
#' @param GrokClassifier A `GrokClassifier` object with updated fields.
#' @param XMLClassifier An `XMLClassifier` object with updated fields.
#' @param JsonClassifier A `JsonClassifier` object with updated fields.
#' @param CsvClassifier A `CsvClassifier` object with updated fields.
#'
#' @keywords internal
#'
#' @rdname glue_update_classifier
glue_update_classifier <- function(GrokClassifier = NULL, XMLClassifier = NULL, JsonClassifier = NULL, CsvClassifier = NULL) {
  op <- new_operation(
    name = "UpdateClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_classifier_input(GrokClassifier = GrokClassifier, XMLClassifier = XMLClassifier, JsonClassifier = JsonClassifier, CsvClassifier = CsvClassifier)
  output <- .glue$update_classifier_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_classifier <- glue_update_classifier

#' Creates or updates partition statistics of columns
#'
#' @description
#' Creates or updates partition statistics of columns.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_column_statistics_for_partition/](https://www.paws-r-sdk.com/docs/glue_update_column_statistics_for_partition/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param PartitionValues &#91;required&#93; A list of partition values identifying the partition.
#' @param ColumnStatisticsList &#91;required&#93; A list of the column statistics.
#'
#' @keywords internal
#'
#' @rdname glue_update_column_statistics_for_partition
glue_update_column_statistics_for_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValues, ColumnStatisticsList) {
  op <- new_operation(
    name = "UpdateColumnStatisticsForPartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_column_statistics_for_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValues = PartitionValues, ColumnStatisticsList = ColumnStatisticsList)
  output <- .glue$update_column_statistics_for_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_column_statistics_for_partition <- glue_update_column_statistics_for_partition

#' Creates or updates table statistics of columns
#'
#' @description
#' Creates or updates table statistics of columns.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_column_statistics_for_table/](https://www.paws-r-sdk.com/docs/glue_update_column_statistics_for_table/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param ColumnStatisticsList &#91;required&#93; A list of the column statistics.
#'
#' @keywords internal
#'
#' @rdname glue_update_column_statistics_for_table
glue_update_column_statistics_for_table <- function(CatalogId = NULL, DatabaseName, TableName, ColumnStatisticsList) {
  op <- new_operation(
    name = "UpdateColumnStatisticsForTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_column_statistics_for_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, ColumnStatisticsList = ColumnStatisticsList)
  output <- .glue$update_column_statistics_for_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_column_statistics_for_table <- glue_update_column_statistics_for_table

#' Updates a connection definition in the Data Catalog
#'
#' @description
#' Updates a connection definition in the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_connection/](https://www.paws-r-sdk.com/docs/glue_update_connection/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog in which the connection resides. If none is
#' provided, the Amazon Web Services account ID is used by default.
#' @param Name &#91;required&#93; The name of the connection definition to update.
#' @param ConnectionInput &#91;required&#93; A `ConnectionInput` object that redefines the connection in question.
#'
#' @keywords internal
#'
#' @rdname glue_update_connection
glue_update_connection <- function(CatalogId = NULL, Name, ConnectionInput) {
  op <- new_operation(
    name = "UpdateConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_connection_input(CatalogId = CatalogId, Name = Name, ConnectionInput = ConnectionInput)
  output <- .glue$update_connection_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_connection <- glue_update_connection

#' Updates a crawler
#'
#' @description
#' Updates a crawler. If a crawler is running, you must stop it using [`stop_crawler`][glue_stop_crawler] before updating it.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_crawler/](https://www.paws-r-sdk.com/docs/glue_update_crawler/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the new crawler.
#' @param Role The IAM role or Amazon Resource Name (ARN) of an IAM role that is used
#' by the new crawler to access customer resources.
#' @param DatabaseName The Glue database where results are stored, such as:
#' `arn:aws:daylight:us-east-1::database/sometable/*`.
#' @param Description A description of the new crawler.
#' @param Targets A list of targets to crawl.
#' @param Schedule A `cron` expression used to specify the schedule (see [Time-Based
#' Schedules for Jobs and
#' Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
#' For example, to run something every day at 12:15 UTC, you would specify:
#' `cron(15 12 * * ? *)`.
#' @param Classifiers A list of custom classifiers that the user has registered. By default,
#' all built-in classifiers are included in a crawl, but these custom
#' classifiers always override the default classifiers for a given
#' classification.
#' @param TablePrefix The table prefix used for catalog tables that are created.
#' @param SchemaChangePolicy The policy for the crawler's update and deletion behavior.
#' @param RecrawlPolicy A policy that specifies whether to crawl the entire dataset again, or to
#' crawl only folders that were added since the last crawler run.
#' @param LineageConfiguration Specifies data lineage configuration settings for the crawler.
#' @param LakeFormationConfiguration Specifies Lake Formation configuration settings for the crawler.
#' @param Configuration Crawler configuration information. This versioned JSON string allows
#' users to specify aspects of a crawler's behavior. For more information,
#' see [Setting crawler configuration
#' options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
#' @param CrawlerSecurityConfiguration The name of the `SecurityConfiguration` structure to be used by this
#' crawler.
#'
#' @keywords internal
#'
#' @rdname glue_update_crawler
glue_update_crawler <- function(Name, Role = NULL, DatabaseName = NULL, Description = NULL, Targets = NULL, Schedule = NULL, Classifiers = NULL, TablePrefix = NULL, SchemaChangePolicy = NULL, RecrawlPolicy = NULL, LineageConfiguration = NULL, LakeFormationConfiguration = NULL, Configuration = NULL, CrawlerSecurityConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_crawler_input(Name = Name, Role = Role, DatabaseName = DatabaseName, Description = Description, Targets = Targets, Schedule = Schedule, Classifiers = Classifiers, TablePrefix = TablePrefix, SchemaChangePolicy = SchemaChangePolicy, RecrawlPolicy = RecrawlPolicy, LineageConfiguration = LineageConfiguration, LakeFormationConfiguration = LakeFormationConfiguration, Configuration = Configuration, CrawlerSecurityConfiguration = CrawlerSecurityConfiguration)
  output <- .glue$update_crawler_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_crawler <- glue_update_crawler

#' Updates the schedule of a crawler using a cron expression
#'
#' @description
#' Updates the schedule of a crawler using a `cron` expression.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_crawler_schedule/](https://www.paws-r-sdk.com/docs/glue_update_crawler_schedule/) for full documentation.
#'
#' @param CrawlerName &#91;required&#93; The name of the crawler whose schedule to update.
#' @param Schedule The updated `cron` expression used to specify the schedule (see
#' [Time-Based Schedules for Jobs and
#' Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
#' For example, to run something every day at 12:15 UTC, you would specify:
#' `cron(15 12 * * ? *)`.
#'
#' @keywords internal
#'
#' @rdname glue_update_crawler_schedule
glue_update_crawler_schedule <- function(CrawlerName, Schedule = NULL) {
  op <- new_operation(
    name = "UpdateCrawlerSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_crawler_schedule_input(CrawlerName = CrawlerName, Schedule = Schedule)
  output <- .glue$update_crawler_schedule_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_crawler_schedule <- glue_update_crawler_schedule

#' Updates the specified data quality ruleset
#'
#' @description
#' Updates the specified data quality ruleset.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_data_quality_ruleset/](https://www.paws-r-sdk.com/docs/glue_update_data_quality_ruleset/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the data quality ruleset.
#' @param Description A description of the ruleset.
#' @param Ruleset A Data Quality Definition Language (DQDL) ruleset. For more information,
#' see the Glue developer guide.
#'
#' @keywords internal
#'
#' @rdname glue_update_data_quality_ruleset
glue_update_data_quality_ruleset <- function(Name, Description = NULL, Ruleset = NULL) {
  op <- new_operation(
    name = "UpdateDataQualityRuleset",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_data_quality_ruleset_input(Name = Name, Description = Description, Ruleset = Ruleset)
  output <- .glue$update_data_quality_ruleset_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_data_quality_ruleset <- glue_update_data_quality_ruleset

#' Updates an existing database definition in a Data Catalog
#'
#' @description
#' Updates an existing database definition in a Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_database/](https://www.paws-r-sdk.com/docs/glue_update_database/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog in which the metadata database resides. If
#' none is provided, the Amazon Web Services account ID is used by default.
#' @param Name &#91;required&#93; The name of the database to update in the catalog. For Hive
#' compatibility, this is folded to lowercase.
#' @param DatabaseInput &#91;required&#93; A `DatabaseInput` object specifying the new definition of the metadata
#' database in the catalog.
#'
#' @keywords internal
#'
#' @rdname glue_update_database
glue_update_database <- function(CatalogId = NULL, Name, DatabaseInput) {
  op <- new_operation(
    name = "UpdateDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_database_input(CatalogId = CatalogId, Name = Name, DatabaseInput = DatabaseInput)
  output <- .glue$update_database_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_database <- glue_update_database

#' Updates a specified development endpoint
#'
#' @description
#' Updates a specified development endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_dev_endpoint/](https://www.paws-r-sdk.com/docs/glue_update_dev_endpoint/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the `DevEndpoint` to be updated.
#' @param PublicKey The public key for the `DevEndpoint` to use.
#' @param AddPublicKeys The list of public keys for the `DevEndpoint` to use.
#' @param DeletePublicKeys The list of public keys to be deleted from the `DevEndpoint`.
#' @param CustomLibraries Custom Python or Java libraries to be loaded in the `DevEndpoint`.
#' @param UpdateEtlLibraries `True` if the list of custom libraries to be loaded in the development
#' endpoint needs to be updated, or `False` if otherwise.
#' @param DeleteArguments The list of argument keys to be deleted from the map of arguments used
#' to configure the `DevEndpoint`.
#' @param AddArguments The map of arguments to add the map of arguments used to configure the
#' `DevEndpoint`.
#' 
#' Valid arguments are:
#' 
#' -   `"--enable-glue-datacatalog": ""`
#' 
#' You can specify a version of Python support for development endpoints by
#' using the `Arguments` parameter in the
#' [`create_dev_endpoint`][glue_create_dev_endpoint] or
#' [`update_dev_endpoint`][glue_update_dev_endpoint] APIs. If no arguments
#' are provided, the version defaults to Python 2.
#'
#' @keywords internal
#'
#' @rdname glue_update_dev_endpoint
glue_update_dev_endpoint <- function(EndpointName, PublicKey = NULL, AddPublicKeys = NULL, DeletePublicKeys = NULL, CustomLibraries = NULL, UpdateEtlLibraries = NULL, DeleteArguments = NULL, AddArguments = NULL) {
  op <- new_operation(
    name = "UpdateDevEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_dev_endpoint_input(EndpointName = EndpointName, PublicKey = PublicKey, AddPublicKeys = AddPublicKeys, DeletePublicKeys = DeletePublicKeys, CustomLibraries = CustomLibraries, UpdateEtlLibraries = UpdateEtlLibraries, DeleteArguments = DeleteArguments, AddArguments = AddArguments)
  output <- .glue$update_dev_endpoint_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_dev_endpoint <- glue_update_dev_endpoint

#' Updates an existing job definition
#'
#' @description
#' Updates an existing job definition. The previous job definition is completely overwritten by this information.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_job/](https://www.paws-r-sdk.com/docs/glue_update_job/) for full documentation.
#'
#' @param JobName &#91;required&#93; The name of the job definition to update.
#' @param JobUpdate &#91;required&#93; Specifies the values with which to update the job definition.
#' Unspecified configuration is removed or reset to default values.
#'
#' @keywords internal
#'
#' @rdname glue_update_job
glue_update_job <- function(JobName, JobUpdate) {
  op <- new_operation(
    name = "UpdateJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_job_input(JobName = JobName, JobUpdate = JobUpdate)
  output <- .glue$update_job_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_job <- glue_update_job

#' Synchronizes a job from the source control repository
#'
#' @description
#' Synchronizes a job from the source control repository. This operation takes the job artifacts that are located in the remote repository and updates the Glue internal stores with these artifacts.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_job_from_source_control/](https://www.paws-r-sdk.com/docs/glue_update_job_from_source_control/) for full documentation.
#'
#' @param JobName The name of the Glue job to be synchronized to or from the remote
#' repository.
#' @param Provider The provider for the remote repository. Possible values: GITHUB,
#' AWS_CODE_COMMIT, GITLAB, BITBUCKET.
#' @param RepositoryName The name of the remote repository that contains the job artifacts. For
#' BitBucket providers, `RepositoryName` should include `WorkspaceName`.
#' Use the format `<WorkspaceName>/<RepositoryName>`.
#' @param RepositoryOwner The owner of the remote repository that contains the job artifacts.
#' @param BranchName An optional branch in the remote repository.
#' @param Folder An optional folder in the remote repository.
#' @param CommitId A commit ID for a commit in the remote repository.
#' @param AuthStrategy The type of authentication, which can be an authentication token stored
#' in Amazon Web Services Secrets Manager, or a personal access token.
#' @param AuthToken The value of the authorization token.
#'
#' @keywords internal
#'
#' @rdname glue_update_job_from_source_control
glue_update_job_from_source_control <- function(JobName = NULL, Provider = NULL, RepositoryName = NULL, RepositoryOwner = NULL, BranchName = NULL, Folder = NULL, CommitId = NULL, AuthStrategy = NULL, AuthToken = NULL) {
  op <- new_operation(
    name = "UpdateJobFromSourceControl",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_job_from_source_control_input(JobName = JobName, Provider = Provider, RepositoryName = RepositoryName, RepositoryOwner = RepositoryOwner, BranchName = BranchName, Folder = Folder, CommitId = CommitId, AuthStrategy = AuthStrategy, AuthToken = AuthToken)
  output <- .glue$update_job_from_source_control_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_job_from_source_control <- glue_update_job_from_source_control

#' Updates an existing machine learning transform
#'
#' @description
#' Updates an existing machine learning transform. Call this operation to tune the algorithm parameters to achieve better results.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_ml_transform/](https://www.paws-r-sdk.com/docs/glue_update_ml_transform/) for full documentation.
#'
#' @param TransformId &#91;required&#93; A unique identifier that was generated when the transform was created.
#' @param Name The unique name that you gave the transform when you created it.
#' @param Description A description of the transform. The default is an empty string.
#' @param Parameters The configuration parameters that are specific to the transform type
#' (algorithm) used. Conditionally dependent on the transform type.
#' @param Role The name or Amazon Resource Name (ARN) of the IAM role with the required
#' permissions.
#' @param GlueVersion This value determines which version of Glue this machine learning
#' transform is compatible with. Glue 1.0 is recommended for most
#' customers. If the value is not set, the Glue compatibility defaults to
#' Glue 0.9. For more information, see [Glue
#' Versions](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions)
#' in the developer guide.
#' @param MaxCapacity The number of Glue data processing units (DPUs) that are allocated to
#' task runs for this transform. You can allocate from 2 to 100 DPUs; the
#' default is 10. A DPU is a relative measure of processing power that
#' consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
#' information, see the [Glue pricing
#' page](https://aws.amazon.com/glue/pricing/).
#' 
#' When the `WorkerType` field is set to a value other than `Standard`, the
#' `MaxCapacity` field is set automatically and becomes read-only.
#' @param WorkerType The type of predefined worker that is allocated when this task runs.
#' Accepts a value of Standard, G.1X, or G.2X.
#' 
#' -   For the `Standard` worker type, each worker provides 4 vCPU, 16 GB
#'     of memory and a 50GB disk, and 2 executors per worker.
#' 
#' -   For the `G.1X` worker type, each worker provides 4 vCPU, 16 GB of
#'     memory and a 64GB disk, and 1 executor per worker.
#' 
#' -   For the `G.2X` worker type, each worker provides 8 vCPU, 32 GB of
#'     memory and a 128GB disk, and 1 executor per worker.
#' @param NumberOfWorkers The number of workers of a defined `workerType` that are allocated when
#' this task runs.
#' @param Timeout The timeout for a task run for this transform in minutes. This is the
#' maximum time that a task run for this transform can consume resources
#' before it is terminated and enters `TIMEOUT` status. The default is
#' 2,880 minutes (48 hours).
#' @param MaxRetries The maximum number of times to retry a task for this transform after a
#' task run fails.
#'
#' @keywords internal
#'
#' @rdname glue_update_ml_transform
glue_update_ml_transform <- function(TransformId, Name = NULL, Description = NULL, Parameters = NULL, Role = NULL, GlueVersion = NULL, MaxCapacity = NULL, WorkerType = NULL, NumberOfWorkers = NULL, Timeout = NULL, MaxRetries = NULL) {
  op <- new_operation(
    name = "UpdateMLTransform",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_ml_transform_input(TransformId = TransformId, Name = Name, Description = Description, Parameters = Parameters, Role = Role, GlueVersion = GlueVersion, MaxCapacity = MaxCapacity, WorkerType = WorkerType, NumberOfWorkers = NumberOfWorkers, Timeout = Timeout, MaxRetries = MaxRetries)
  output <- .glue$update_ml_transform_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_ml_transform <- glue_update_ml_transform

#' Updates a partition
#'
#' @description
#' Updates a partition.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_partition/](https://www.paws-r-sdk.com/docs/glue_update_partition/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the partition to be updated resides. If
#' none is provided, the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table in question resides.
#' @param TableName &#91;required&#93; The name of the table in which the partition to be updated is located.
#' @param PartitionValueList &#91;required&#93; List of partition key values that define the partition to update.
#' @param PartitionInput &#91;required&#93; The new partition object to update the partition to.
#' 
#' The `Values` property can't be changed. If you want to change the
#' partition key values for a partition, delete and recreate the partition.
#'
#' @keywords internal
#'
#' @rdname glue_update_partition
glue_update_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValueList, PartitionInput) {
  op <- new_operation(
    name = "UpdatePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValueList = PartitionValueList, PartitionInput = PartitionInput)
  output <- .glue$update_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_partition <- glue_update_partition

#' Updates an existing registry which is used to hold a collection of
#' schemas
#'
#' @description
#' Updates an existing registry which is used to hold a collection of schemas. The updated properties relate to the registry, and do not modify any of the schemas within the registry.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_registry/](https://www.paws-r-sdk.com/docs/glue_update_registry/) for full documentation.
#'
#' @param RegistryId &#91;required&#93; This is a wrapper structure that may contain the registry name and
#' Amazon Resource Name (ARN).
#' @param Description &#91;required&#93; A description of the registry. If description is not provided, this
#' field will not be updated.
#'
#' @keywords internal
#'
#' @rdname glue_update_registry
glue_update_registry <- function(RegistryId, Description) {
  op <- new_operation(
    name = "UpdateRegistry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_registry_input(RegistryId = RegistryId, Description = Description)
  output <- .glue$update_registry_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_registry <- glue_update_registry

#' Updates the description, compatibility setting, or version checkpoint
#' for a schema set
#'
#' @description
#' Updates the description, compatibility setting, or version checkpoint for a schema set.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_schema/](https://www.paws-r-sdk.com/docs/glue_update_schema/) for full documentation.
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure to contain schema identity fields. The
#' structure contains:
#' 
#' -   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
#'     One of `SchemaArn` or `SchemaName` has to be provided.
#' 
#' -   SchemaId$SchemaName: The name of the schema. One of `SchemaArn` or
#'     `SchemaName` has to be provided.
#' @param SchemaVersionNumber Version number required for check pointing. One of `VersionNumber` or
#' `Compatibility` has to be provided.
#' @param Compatibility The new compatibility setting for the schema.
#' @param Description The new description for the schema.
#'
#' @keywords internal
#'
#' @rdname glue_update_schema
glue_update_schema <- function(SchemaId, SchemaVersionNumber = NULL, Compatibility = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_schema_input(SchemaId = SchemaId, SchemaVersionNumber = SchemaVersionNumber, Compatibility = Compatibility, Description = Description)
  output <- .glue$update_schema_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_schema <- glue_update_schema

#' Synchronizes a job to the source control repository
#'
#' @description
#' Synchronizes a job to the source control repository. This operation takes the job artifacts from the Glue internal stores and makes a commit to the remote repository that is configured on the job.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_source_control_from_job/](https://www.paws-r-sdk.com/docs/glue_update_source_control_from_job/) for full documentation.
#'
#' @param JobName The name of the Glue job to be synchronized to or from the remote
#' repository.
#' @param Provider The provider for the remote repository. Possible values: GITHUB,
#' AWS_CODE_COMMIT, GITLAB, BITBUCKET.
#' @param RepositoryName The name of the remote repository that contains the job artifacts. For
#' BitBucket providers, `RepositoryName` should include `WorkspaceName`.
#' Use the format `<WorkspaceName>/<RepositoryName>`.
#' @param RepositoryOwner The owner of the remote repository that contains the job artifacts.
#' @param BranchName An optional branch in the remote repository.
#' @param Folder An optional folder in the remote repository.
#' @param CommitId A commit ID for a commit in the remote repository.
#' @param AuthStrategy The type of authentication, which can be an authentication token stored
#' in Amazon Web Services Secrets Manager, or a personal access token.
#' @param AuthToken The value of the authorization token.
#'
#' @keywords internal
#'
#' @rdname glue_update_source_control_from_job
glue_update_source_control_from_job <- function(JobName = NULL, Provider = NULL, RepositoryName = NULL, RepositoryOwner = NULL, BranchName = NULL, Folder = NULL, CommitId = NULL, AuthStrategy = NULL, AuthToken = NULL) {
  op <- new_operation(
    name = "UpdateSourceControlFromJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_source_control_from_job_input(JobName = JobName, Provider = Provider, RepositoryName = RepositoryName, RepositoryOwner = RepositoryOwner, BranchName = BranchName, Folder = Folder, CommitId = CommitId, AuthStrategy = AuthStrategy, AuthToken = AuthToken)
  output <- .glue$update_source_control_from_job_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_source_control_from_job <- glue_update_source_control_from_job

#' Updates a metadata table in the Data Catalog
#'
#' @description
#' Updates a metadata table in the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_table/](https://www.paws-r-sdk.com/docs/glue_update_table/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the table resides. If none is provided,
#' the Amazon Web Services account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableInput &#91;required&#93; An updated `TableInput` object to define the metadata table in the
#' catalog.
#' @param SkipArchive By default, [`update_table`][glue_update_table] always creates an
#' archived version of the table before updating it. However, if
#' `skipArchive` is set to true, [`update_table`][glue_update_table] does
#' not create the archived version.
#' @param TransactionId The transaction ID at which to update the table contents.
#' @param VersionId The version ID at which to update the table contents.
#'
#' @keywords internal
#'
#' @rdname glue_update_table
glue_update_table <- function(CatalogId = NULL, DatabaseName, TableInput, SkipArchive = NULL, TransactionId = NULL, VersionId = NULL) {
  op <- new_operation(
    name = "UpdateTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableInput = TableInput, SkipArchive = SkipArchive, TransactionId = TransactionId, VersionId = VersionId)
  output <- .glue$update_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_table <- glue_update_table

#' Updates the configuration for an existing table optimizer
#'
#' @description
#' Updates the configuration for an existing table optimizer.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_table_optimizer/](https://www.paws-r-sdk.com/docs/glue_update_table_optimizer/) for full documentation.
#'
#' @param CatalogId &#91;required&#93; The Catalog ID of the table.
#' @param DatabaseName &#91;required&#93; The name of the database in the catalog in which the table resides.
#' @param TableName &#91;required&#93; The name of the table.
#' @param Type &#91;required&#93; The type of table optimizer. Currently, the only valid value is
#' `compaction`.
#' @param TableOptimizerConfiguration &#91;required&#93; A `TableOptimizerConfiguration` object representing the configuration of
#' a table optimizer.
#'
#' @keywords internal
#'
#' @rdname glue_update_table_optimizer
glue_update_table_optimizer <- function(CatalogId, DatabaseName, TableName, Type, TableOptimizerConfiguration) {
  op <- new_operation(
    name = "UpdateTableOptimizer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_table_optimizer_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, Type = Type, TableOptimizerConfiguration = TableOptimizerConfiguration)
  output <- .glue$update_table_optimizer_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_table_optimizer <- glue_update_table_optimizer

#' Updates a trigger definition
#'
#' @description
#' Updates a trigger definition.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_trigger/](https://www.paws-r-sdk.com/docs/glue_update_trigger/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the trigger to update.
#' @param TriggerUpdate &#91;required&#93; The new values with which to update the trigger.
#'
#' @keywords internal
#'
#' @rdname glue_update_trigger
glue_update_trigger <- function(Name, TriggerUpdate) {
  op <- new_operation(
    name = "UpdateTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_trigger_input(Name = Name, TriggerUpdate = TriggerUpdate)
  output <- .glue$update_trigger_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_trigger <- glue_update_trigger

#' Updates an existing function definition in the Data Catalog
#'
#' @description
#' Updates an existing function definition in the Data Catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_user_defined_function/](https://www.paws-r-sdk.com/docs/glue_update_user_defined_function/) for full documentation.
#'
#' @param CatalogId The ID of the Data Catalog where the function to be updated is located.
#' If none is provided, the Amazon Web Services account ID is used by
#' default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the function to be updated is
#' located.
#' @param FunctionName &#91;required&#93; The name of the function.
#' @param FunctionInput &#91;required&#93; A `FunctionInput` object that redefines the function in the Data
#' Catalog.
#'
#' @keywords internal
#'
#' @rdname glue_update_user_defined_function
glue_update_user_defined_function <- function(CatalogId = NULL, DatabaseName, FunctionName, FunctionInput) {
  op <- new_operation(
    name = "UpdateUserDefinedFunction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_user_defined_function_input(CatalogId = CatalogId, DatabaseName = DatabaseName, FunctionName = FunctionName, FunctionInput = FunctionInput)
  output <- .glue$update_user_defined_function_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_user_defined_function <- glue_update_user_defined_function

#' Updates an existing workflow
#'
#' @description
#' Updates an existing workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/glue_update_workflow/](https://www.paws-r-sdk.com/docs/glue_update_workflow/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the workflow to be updated.
#' @param Description The description of the workflow.
#' @param DefaultRunProperties A collection of properties to be used as part of each execution of the
#' workflow.
#' @param MaxConcurrentRuns You can use this parameter to prevent unwanted multiple updates to data,
#' to control costs, or in some cases, to prevent exceeding the maximum
#' number of concurrent runs of any of the component jobs. If you leave
#' this parameter blank, there is no limit to the number of concurrent
#' workflow runs.
#'
#' @keywords internal
#'
#' @rdname glue_update_workflow
glue_update_workflow <- function(Name, Description = NULL, DefaultRunProperties = NULL, MaxConcurrentRuns = NULL) {
  op <- new_operation(
    name = "UpdateWorkflow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_workflow_input(Name = Name, Description = Description, DefaultRunProperties = DefaultRunProperties, MaxConcurrentRuns = MaxConcurrentRuns)
  output <- .glue$update_workflow_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_workflow <- glue_update_workflow
