% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_start_data_quality_rule_recommendation_run}
\alias{glue_start_data_quality_rule_recommendation_run}
\title{Starts a recommendation run that is used to generate rules when you
don't know what rules to write}
\usage{
glue_start_data_quality_rule_recommendation_run(
  DataSource,
  Role,
  NumberOfWorkers = NULL,
  Timeout = NULL,
  CreatedRulesetName = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{DataSource}{[required] The data source (Glue table) associated with this run.}

\item{Role}{[required] An IAM role supplied to encrypt the results of the run.}

\item{NumberOfWorkers}{The number of \code{G.1X} workers to be used in the run. The default is 5.}

\item{Timeout}{The timeout for a run in minutes. This is the maximum time that a run
can consume resources before it is terminated and enters \code{TIMEOUT}
status. The default is 2,880 minutes (48 hours).}

\item{CreatedRulesetName}{A name for the ruleset.}

\item{ClientToken}{Used for idempotency and is recommended to be set to a random ID (such
as a UUID) to avoid creating or starting multiple instances of the same
resource.}
}
\description{
Starts a recommendation run that is used to generate rules when you don't know what rules to write. Glue Data Quality analyzes the data and comes up with recommendations for a potential ruleset. You can then triage the ruleset and modify the generated ruleset to your liking.

See \url{https://www.paws-r-sdk.com/docs/glue_start_data_quality_rule_recommendation_run/} for full documentation.
}
\keyword{internal}
