# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Interactive Video Service
#'
#' @description
#' **Introduction**
#' 
#' The Amazon Interactive Video Service (IVS) API is REST compatible, using
#' a standard HTTP API and an Amazon Web Services EventBridge event stream
#' for responses. JSON is used for both requests and responses, including
#' errors.
#' 
#' The API is an Amazon Web Services regional service. For a list of
#' supported regions and Amazon IVS HTTPS service endpoints, see the
#' [Amazon IVS
#' page](https://docs.aws.amazon.com/general/latest/gr/ivs.html) in the
#' *Amazon Web Services General Reference*.
#' 
#' *All API request parameters and URLs are case sensitive. *
#' 
#' For a summary of notable documentation changes in each release, see
#' [Document
#' History](https://docs.aws.amazon.com/ivs/latest/LowLatencyUserGuide/doc-history.html).
#' 
#' **Allowed Header Values**
#' 
#' -   ` Accept: ` application/json
#' 
#' -   ` Accept-Encoding: ` gzip, deflate
#' 
#' -   ` Content-Type: `application/json
#' 
#' **Key Concepts**
#' 
#' -   **Channel** — Stores configuration data related to your live stream.
#'     You first create a channel and then use the channel’s stream key to
#'     start your live stream.
#' 
#' -   **Stream key** — An identifier assigned by Amazon IVS when you
#'     create a channel, which is then used to authorize streaming. *Treat
#'     the stream key like a secret, since it allows anyone to stream to
#'     the channel.*
#' 
#' -   **Playback key pair** — Video playback may be restricted using
#'     playback-authorization tokens, which use public-key encryption. A
#'     playback key pair is the public-private pair of keys used to sign
#'     and validate the playback-authorization token.
#' 
#' -   **Recording configuration** — Stores configuration related to
#'     recording a live stream and where to store the recorded content.
#'     Multiple channels can reference the same recording configuration.
#' 
#' -   **Playback restriction policy** — Restricts playback by countries
#'     and/or origin sites.
#' 
#' For more information about your IVS live stream, also see [Getting
#' Started with IVS Low-Latency
#' Streaming](https://docs.aws.amazon.com/ivs/latest/LowLatencyUserGuide/getting-started.html).
#' 
#' **Tagging**
#' 
#' A *tag* is a metadata label that you assign to an Amazon Web Services
#' resource. A tag comprises a *key* and a *value*, both set by you. For
#' example, you might set a tag as `topic:nature` to label a particular
#' video category. See [Tagging Amazon Web Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#' for more information, including restrictions that apply to tags and "Tag
#' naming limits and requirements"; Amazon IVS has no service-specific
#' constraints beyond what is documented there.
#' 
#' Tags can help you identify and organize your Amazon Web Services
#' resources. For example, you can use the same tag for different resources
#' to indicate that they are related. You can also use tags to manage
#' access (see [Access
#' Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html)).
#' 
#' The Amazon IVS API has these tag-related endpoints:
#' [`tag_resource`][ivs_tag_resource],
#' [`untag_resource`][ivs_untag_resource], and
#' [`list_tags_for_resource`][ivs_list_tags_for_resource]. The following
#' resources support tagging: Channels, Stream Keys, Playback Key Pairs,
#' and Recording Configurations.
#' 
#' At most 50 tags can be applied to a resource.
#' 
#' **Authentication versus Authorization**
#' 
#' Note the differences between these concepts:
#' 
#' -   *Authentication* is about verifying identity. You need to be
#'     authenticated to sign Amazon IVS API requests.
#' 
#' -   *Authorization* is about granting permissions. Your IAM roles need
#'     to have permissions for Amazon IVS API requests. In addition,
#'     authorization is needed to view [Amazon IVS private
#'     channels](https://docs.aws.amazon.com/ivs/latest/LowLatencyUserGuide/private-channels.html).
#'     (Private channels are channels that are enabled for "playback
#'     authorization.")
#' 
#' **Authentication**
#' 
#' All Amazon IVS API requests must be authenticated with a signature. The
#' Amazon Web Services Command-Line Interface (CLI) and Amazon IVS Player
#' SDKs take care of signing the underlying API calls for you. However, if
#' your application calls the Amazon IVS API directly, it’s your
#' responsibility to sign the requests.
#' 
#' You generate a signature using valid Amazon Web Services credentials
#' that have permission to perform the requested action. For example, you
#' must sign PutMetadata requests with a signature generated from a user
#' account that has the `ivs:PutMetadata` permission.
#' 
#' For more information:
#' 
#' -   Authentication and generating signatures — See [Authenticating
#'     Requests (Amazon Web Services Signature Version
#'     4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html)
#'     in the *Amazon Web Services General Reference*.
#' 
#' -   Managing Amazon IVS permissions — See [Identity and Access
#'     Management](https://docs.aws.amazon.com/ivs/latest/LowLatencyUserGuide/security-iam.html)
#'     on the Security page of the *Amazon IVS User Guide*.
#' 
#' **Amazon Resource Names (ARNs)**
#' 
#' ARNs uniquely identify AWS resources. An ARN is required when you need
#' to specify a resource unambiguously across all of AWS, such as in IAM
#' policies and API calls. For more information, see [Amazon Resource
#' Names](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *AWS General Reference*.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- ivs(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- ivs()
#' svc$batch_get_channel(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=ivs_batch_get_channel]{batch_get_channel} \tab Performs GetChannel on multiple ARNs simultaneously\cr
#'  \link[=ivs_batch_get_stream_key]{batch_get_stream_key} \tab Performs GetStreamKey on multiple ARNs simultaneously\cr
#'  \link[=ivs_batch_start_viewer_session_revocation]{batch_start_viewer_session_revocation} \tab Performs StartViewerSessionRevocation on multiple channel ARN and viewer ID pairs simultaneously\cr
#'  \link[=ivs_create_channel]{create_channel} \tab Creates a new channel and an associated stream key to start streaming\cr
#'  \link[=ivs_create_playback_restriction_policy]{create_playback_restriction_policy} \tab Creates a new playback restriction policy, for constraining playback by countries and/or origins\cr
#'  \link[=ivs_create_recording_configuration]{create_recording_configuration} \tab Creates a new recording configuration, used to enable recording to Amazon S3\cr
#'  \link[=ivs_create_stream_key]{create_stream_key} \tab Creates a stream key, used to initiate a stream, for the specified channel ARN\cr
#'  \link[=ivs_delete_channel]{delete_channel} \tab Deletes the specified channel and its associated stream keys\cr
#'  \link[=ivs_delete_playback_key_pair]{delete_playback_key_pair} \tab Deletes a specified authorization key pair\cr
#'  \link[=ivs_delete_playback_restriction_policy]{delete_playback_restriction_policy} \tab Deletes the specified playback restriction policy\cr
#'  \link[=ivs_delete_recording_configuration]{delete_recording_configuration} \tab Deletes the recording configuration for the specified ARN\cr
#'  \link[=ivs_delete_stream_key]{delete_stream_key} \tab Deletes the stream key for the specified ARN, so it can no longer be used to stream\cr
#'  \link[=ivs_get_channel]{get_channel} \tab Gets the channel configuration for the specified channel ARN\cr
#'  \link[=ivs_get_playback_key_pair]{get_playback_key_pair} \tab Gets a specified playback authorization key pair and returns the arn and fingerprint\cr
#'  \link[=ivs_get_playback_restriction_policy]{get_playback_restriction_policy} \tab Gets the specified playback restriction policy\cr
#'  \link[=ivs_get_recording_configuration]{get_recording_configuration} \tab Gets the recording configuration for the specified ARN\cr
#'  \link[=ivs_get_stream]{get_stream} \tab Gets information about the active (live) stream on a specified channel\cr
#'  \link[=ivs_get_stream_key]{get_stream_key} \tab Gets stream-key information for a specified ARN\cr
#'  \link[=ivs_get_stream_session]{get_stream_session} \tab Gets metadata on a specified stream\cr
#'  \link[=ivs_import_playback_key_pair]{import_playback_key_pair} \tab Imports the public portion of a new key pair and returns its arn and fingerprint\cr
#'  \link[=ivs_list_channels]{list_channels} \tab Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed\cr
#'  \link[=ivs_list_playback_key_pairs]{list_playback_key_pairs} \tab Gets summary information about playback key pairs\cr
#'  \link[=ivs_list_playback_restriction_policies]{list_playback_restriction_policies} \tab Gets summary information about playback restriction policies\cr
#'  \link[=ivs_list_recording_configurations]{list_recording_configurations} \tab Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed\cr
#'  \link[=ivs_list_stream_keys]{list_stream_keys} \tab Gets summary information about stream keys for the specified channel\cr
#'  \link[=ivs_list_streams]{list_streams} \tab Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed\cr
#'  \link[=ivs_list_stream_sessions]{list_stream_sessions} \tab Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed\cr
#'  \link[=ivs_list_tags_for_resource]{list_tags_for_resource} \tab Gets information about Amazon Web Services tags for the specified ARN\cr
#'  \link[=ivs_put_metadata]{put_metadata} \tab Inserts metadata into the active stream of the specified channel\cr
#'  \link[=ivs_start_viewer_session_revocation]{start_viewer_session_revocation} \tab Starts the process of revoking the viewer session associated with a specified channel ARN and viewer ID\cr
#'  \link[=ivs_stop_stream]{stop_stream} \tab Disconnects the incoming RTMPS stream for the specified channel\cr
#'  \link[=ivs_tag_resource]{tag_resource} \tab Adds or updates tags for the Amazon Web Services resource with the specified ARN\cr
#'  \link[=ivs_untag_resource]{untag_resource} \tab Removes tags from the resource with the specified ARN\cr
#'  \link[=ivs_update_channel]{update_channel} \tab Updates a channel's configuration\cr
#'  \link[=ivs_update_playback_restriction_policy]{update_playback_restriction_policy} \tab Updates a specified playback restriction policy
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname ivs
#' @export
ivs <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .ivs$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.ivs <- list()

.ivs$operations <- list()

.ivs$metadata <- list(
  service_name = "ivs",
  endpoints = list("*" = list(endpoint = "ivs.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "ivs.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "ivs.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "ivs.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "ivs.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "ivs.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "ivs",
  api_version = "2020-07-14",
  signing_name = "ivs",
  json_version = "",
  target_prefix = ""
)

.ivs$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.ivs$metadata, handlers, config, op)
}
