# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include opensearchservice_service.R
NULL

#' Allows the destination Amazon OpenSearch Service domain owner to accept
#' an inbound cross-cluster search connection request
#'
#' @description
#' Allows the destination Amazon OpenSearch Service domain owner to accept an inbound cross-cluster search connection request. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_accept_inbound_connection/](https://www.paws-r-sdk.com/docs/opensearchservice_accept_inbound_connection/) for full documentation.
#'
#' @param ConnectionId &#91;required&#93; The ID of the inbound connection to accept.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_accept_inbound_connection
opensearchservice_accept_inbound_connection <- function(ConnectionId) {
  op <- new_operation(
    name = "AcceptInboundConnection",
    http_method = "PUT",
    http_path = "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}/accept",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$accept_inbound_connection_input(ConnectionId = ConnectionId)
  output <- .opensearchservice$accept_inbound_connection_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$accept_inbound_connection <- opensearchservice_accept_inbound_connection

#' Creates a new direct-query data source to the specified domain
#'
#' @description
#' Creates a new direct-query data source to the specified domain. For more information, see [Creating Amazon OpenSearch Service data source integrations with Amazon S3](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_add_data_source/](https://www.paws-r-sdk.com/docs/opensearchservice_add_data_source/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain to add the data source to.
#' @param Name &#91;required&#93; A name for the data source.
#' @param DataSourceType &#91;required&#93; The type of data source.
#' @param Description A description of the data source.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_add_data_source
opensearchservice_add_data_source <- function(DomainName, Name, DataSourceType, Description = NULL) {
  op <- new_operation(
    name = "AddDataSource",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/dataSource",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$add_data_source_input(DomainName = DomainName, Name = Name, DataSourceType = DataSourceType, Description = Description)
  output <- .opensearchservice$add_data_source_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$add_data_source <- opensearchservice_add_data_source

#' Attaches tags to an existing Amazon OpenSearch Service domain
#'
#' @description
#' Attaches tags to an existing Amazon OpenSearch Service domain. Tags are a set of case-sensitive key-value pairs. A domain can have up to 10 tags. For more information, see [Tagging Amazon OpenSearch Service domains](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_add_tags/](https://www.paws-r-sdk.com/docs/opensearchservice_add_tags/) for full documentation.
#'
#' @param ARN &#91;required&#93; Amazon Resource Name (ARN) for the OpenSearch Service domain to which
#' you want to attach resource tags.
#' @param TagList &#91;required&#93; List of resource tags.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_add_tags
opensearchservice_add_tags <- function(ARN, TagList) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/2021-01-01/tags",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$add_tags_input(ARN = ARN, TagList = TagList)
  output <- .opensearchservice$add_tags_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$add_tags <- opensearchservice_add_tags

#' Associates a package with an Amazon OpenSearch Service domain
#'
#' @description
#' Associates a package with an Amazon OpenSearch Service domain. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_associate_package/](https://www.paws-r-sdk.com/docs/opensearchservice_associate_package/) for full documentation.
#'
#' @param PackageID &#91;required&#93; Internal ID of the package to associate with a domain. Use
#' [`describe_packages`][opensearchservice_describe_packages] to find this
#' value.
#' @param DomainName &#91;required&#93; Name of the domain to associate the package with.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_associate_package
opensearchservice_associate_package <- function(PackageID, DomainName) {
  op <- new_operation(
    name = "AssociatePackage",
    http_method = "POST",
    http_path = "/2021-01-01/packages/associate/{PackageID}/{DomainName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$associate_package_input(PackageID = PackageID, DomainName = DomainName)
  output <- .opensearchservice$associate_package_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$associate_package <- opensearchservice_associate_package

#' Provides access to an Amazon OpenSearch Service domain through the use
#' of an interface VPC endpoint
#'
#' @description
#' Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_authorize_vpc_endpoint_access/](https://www.paws-r-sdk.com/docs/opensearchservice_authorize_vpc_endpoint_access/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the OpenSearch Service domain to provide access to.
#' @param Account &#91;required&#93; The Amazon Web Services account ID to grant access to.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_authorize_vpc_endpoint_access
opensearchservice_authorize_vpc_endpoint_access <- function(DomainName, Account) {
  op <- new_operation(
    name = "AuthorizeVpcEndpointAccess",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/authorizeVpcEndpointAccess",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$authorize_vpc_endpoint_access_input(DomainName = DomainName, Account = Account)
  output <- .opensearchservice$authorize_vpc_endpoint_access_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$authorize_vpc_endpoint_access <- opensearchservice_authorize_vpc_endpoint_access

#' Cancels a pending configuration change on an Amazon OpenSearch Service
#' domain
#'
#' @description
#' Cancels a pending configuration change on an Amazon OpenSearch Service domain.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_cancel_domain_config_change/](https://www.paws-r-sdk.com/docs/opensearchservice_cancel_domain_config_change/) for full documentation.
#'
#' @param DomainName &#91;required&#93; 
#' @param DryRun When set to `True`, returns the list of change IDs and properties that
#' will be cancelled without actually cancelling the change.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_cancel_domain_config_change
opensearchservice_cancel_domain_config_change <- function(DomainName, DryRun = NULL) {
  op <- new_operation(
    name = "CancelDomainConfigChange",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/config/cancel",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$cancel_domain_config_change_input(DomainName = DomainName, DryRun = DryRun)
  output <- .opensearchservice$cancel_domain_config_change_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$cancel_domain_config_change <- opensearchservice_cancel_domain_config_change

#' Cancels a scheduled service software update for an Amazon OpenSearch
#' Service domain
#'
#' @description
#' Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this operation before the `AutomatedUpdateDate` and when the domain's `UpdateStatus` is `PENDING_UPDATE`. For more information, see [Service software updates in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_cancel_service_software_update/](https://www.paws-r-sdk.com/docs/opensearchservice_cancel_service_software_update/) for full documentation.
#'
#' @param DomainName &#91;required&#93; Name of the OpenSearch Service domain that you want to cancel the
#' service software update on.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_cancel_service_software_update
opensearchservice_cancel_service_software_update <- function(DomainName) {
  op <- new_operation(
    name = "CancelServiceSoftwareUpdate",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/serviceSoftwareUpdate/cancel",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$cancel_service_software_update_input(DomainName = DomainName)
  output <- .opensearchservice$cancel_service_software_update_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$cancel_service_software_update <- opensearchservice_cancel_service_software_update

#' Creates an Amazon OpenSearch Service domain
#'
#' @description
#' Creates an Amazon OpenSearch Service domain. For more information, see [Creating and managing Amazon OpenSearch Service domains](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_create_domain/](https://www.paws-r-sdk.com/docs/opensearchservice_create_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; Name of the OpenSearch Service domain to create. Domain names are unique
#' across the domains owned by an account within an Amazon Web Services
#' Region.
#' @param EngineVersion String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the
#' engine version for the OpenSearch Service domain. For example,
#' `OpenSearch_1.0` or `Elasticsearch_7.9`. For more information, see
#' [Creating and managing Amazon OpenSearch Service
#' domains](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains).
#' @param ClusterConfig Container for the cluster configuration of a domain.
#' @param EBSOptions Container for the parameters required to enable EBS-based storage for an
#' OpenSearch Service domain.
#' @param AccessPolicies Identity and Access Management (IAM) policy document specifying the
#' access policies for the new domain.
#' @param IPAddressType Specify either dual stack or IPv4 as your IP address type. Dual stack
#' allows you to share domain resources across IPv4 and IPv6 address types,
#' and is the recommended option. If you set your IP address type to dual
#' stack, you can't change your address type later.
#' @param SnapshotOptions DEPRECATED. Container for the parameters required to configure automated
#' snapshots of domain indexes.
#' @param VPCOptions Container for the values required to configure VPC access domains. If
#' you don't specify these values, OpenSearch Service creates the domain
#' with a public endpoint. For more information, see [Launching your Amazon
#' OpenSearch Service domains using a
#' VPC](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
#' @param CognitoOptions Key-value pairs to configure Amazon Cognito authentication. For more
#' information, see [Configuring Amazon Cognito authentication for
#' OpenSearch
#' Dashboards](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
#' @param EncryptionAtRestOptions Key-value pairs to enable encryption at rest.
#' @param NodeToNodeEncryptionOptions Enables node-to-node encryption.
#' @param AdvancedOptions Key-value pairs to specify advanced configuration options. The following
#' key-value pairs are supported:
#' 
#' -   `"rest.action.multi.allow_explicit_index": "true" | "false"` - Note
#'     the use of a string rather than a boolean. Specifies whether
#'     explicit references to indexes are allowed inside the body of HTTP
#'     requests. If you want to configure access policies for domain
#'     sub-resources, such as specific indexes and domain APIs, you must
#'     disable this property. Default is true.
#' 
#' -   `"indices.fielddata.cache.size": "80" ` - Note the use of a string
#'     rather than a boolean. Specifies the percentage of heap space
#'     allocated to field data. Default is unbounded.
#' 
#' -   `"indices.query.bool.max_clause_count": "1024"` - Note the use of a
#'     string rather than a boolean. Specifies the maximum number of
#'     clauses allowed in a Lucene boolean query. Default is 1,024. Queries
#'     with more than the permitted number of clauses result in a
#'     `TooManyClauses` error.
#' 
#' -   `"override_main_response_version": "true" | "false"` - Note the use
#'     of a string rather than a boolean. Specifies whether the domain
#'     reports its version as 7.10 to allow Elasticsearch OSS clients and
#'     plugins to continue working with it. Default is false when creating
#'     a domain and true when upgrading a domain.
#' 
#' For more information, see [Advanced cluster
#' parameters](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
#' @param LogPublishingOptions Key-value pairs to configure log publishing.
#' @param DomainEndpointOptions Additional options for the domain endpoint, such as whether to require
#' HTTPS for all traffic.
#' @param AdvancedSecurityOptions Options for fine-grained access control.
#' @param TagList List of tags to add to the domain upon creation.
#' @param AutoTuneOptions Options for Auto-Tune.
#' @param OffPeakWindowOptions Specifies a daily 10-hour time block during which OpenSearch Service can
#' perform configuration changes on the domain, including service software
#' updates and Auto-Tune enhancements that require a blue/green deployment.
#' If no options are specified, the default start time of 10:00 P.M. local
#' time (for the Region that the domain is created in) is used.
#' @param SoftwareUpdateOptions Software update options for the domain.
#' @param AIMLOptions Options for all machine learning features for the specified domain.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_create_domain
opensearchservice_create_domain <- function(DomainName, EngineVersion = NULL, ClusterConfig = NULL, EBSOptions = NULL, AccessPolicies = NULL, IPAddressType = NULL, SnapshotOptions = NULL, VPCOptions = NULL, CognitoOptions = NULL, EncryptionAtRestOptions = NULL, NodeToNodeEncryptionOptions = NULL, AdvancedOptions = NULL, LogPublishingOptions = NULL, DomainEndpointOptions = NULL, AdvancedSecurityOptions = NULL, TagList = NULL, AutoTuneOptions = NULL, OffPeakWindowOptions = NULL, SoftwareUpdateOptions = NULL, AIMLOptions = NULL) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/domain",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$create_domain_input(DomainName = DomainName, EngineVersion = EngineVersion, ClusterConfig = ClusterConfig, EBSOptions = EBSOptions, AccessPolicies = AccessPolicies, IPAddressType = IPAddressType, SnapshotOptions = SnapshotOptions, VPCOptions = VPCOptions, CognitoOptions = CognitoOptions, EncryptionAtRestOptions = EncryptionAtRestOptions, NodeToNodeEncryptionOptions = NodeToNodeEncryptionOptions, AdvancedOptions = AdvancedOptions, LogPublishingOptions = LogPublishingOptions, DomainEndpointOptions = DomainEndpointOptions, AdvancedSecurityOptions = AdvancedSecurityOptions, TagList = TagList, AutoTuneOptions = AutoTuneOptions, OffPeakWindowOptions = OffPeakWindowOptions, SoftwareUpdateOptions = SoftwareUpdateOptions, AIMLOptions = AIMLOptions)
  output <- .opensearchservice$create_domain_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$create_domain <- opensearchservice_create_domain

#' Creates a new cross-cluster search connection from a source Amazon
#' OpenSearch Service domain to a destination domain
#'
#' @description
#' Creates a new cross-cluster search connection from a source Amazon OpenSearch Service domain to a destination domain. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_create_outbound_connection/](https://www.paws-r-sdk.com/docs/opensearchservice_create_outbound_connection/) for full documentation.
#'
#' @param LocalDomainInfo &#91;required&#93; Name and Region of the source (local) domain.
#' @param RemoteDomainInfo &#91;required&#93; Name and Region of the destination (remote) domain.
#' @param ConnectionAlias &#91;required&#93; Name of the connection.
#' @param ConnectionMode The connection mode.
#' @param ConnectionProperties The `ConnectionProperties` for the outbound connection.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_create_outbound_connection
opensearchservice_create_outbound_connection <- function(LocalDomainInfo, RemoteDomainInfo, ConnectionAlias, ConnectionMode = NULL, ConnectionProperties = NULL) {
  op <- new_operation(
    name = "CreateOutboundConnection",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/cc/outboundConnection",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$create_outbound_connection_input(LocalDomainInfo = LocalDomainInfo, RemoteDomainInfo = RemoteDomainInfo, ConnectionAlias = ConnectionAlias, ConnectionMode = ConnectionMode, ConnectionProperties = ConnectionProperties)
  output <- .opensearchservice$create_outbound_connection_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$create_outbound_connection <- opensearchservice_create_outbound_connection

#' Creates a package for use with Amazon OpenSearch Service domains
#'
#' @description
#' Creates a package for use with Amazon OpenSearch Service domains. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_create_package/](https://www.paws-r-sdk.com/docs/opensearchservice_create_package/) for full documentation.
#'
#' @param PackageName &#91;required&#93; Unique name for the package.
#' @param PackageType &#91;required&#93; The type of package.
#' @param PackageDescription Description of the package.
#' @param PackageSource &#91;required&#93; The Amazon S3 location from which to import the package.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_create_package
opensearchservice_create_package <- function(PackageName, PackageType, PackageDescription = NULL, PackageSource) {
  op <- new_operation(
    name = "CreatePackage",
    http_method = "POST",
    http_path = "/2021-01-01/packages",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$create_package_input(PackageName = PackageName, PackageType = PackageType, PackageDescription = PackageDescription, PackageSource = PackageSource)
  output <- .opensearchservice$create_package_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$create_package <- opensearchservice_create_package

#' Creates an Amazon OpenSearch Service-managed VPC endpoint
#'
#' @description
#' Creates an Amazon OpenSearch Service-managed VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_create_vpc_endpoint/](https://www.paws-r-sdk.com/docs/opensearchservice_create_vpc_endpoint/) for full documentation.
#'
#' @param DomainArn &#91;required&#93; The Amazon Resource Name (ARN) of the domain to create the endpoint for.
#' @param VpcOptions &#91;required&#93; Options to specify the subnets and security groups for the endpoint.
#' @param ClientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_create_vpc_endpoint
opensearchservice_create_vpc_endpoint <- function(DomainArn, VpcOptions, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateVpcEndpoint",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/vpcEndpoints",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$create_vpc_endpoint_input(DomainArn = DomainArn, VpcOptions = VpcOptions, ClientToken = ClientToken)
  output <- .opensearchservice$create_vpc_endpoint_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$create_vpc_endpoint <- opensearchservice_create_vpc_endpoint

#' Deletes a direct-query data source
#'
#' @description
#' Deletes a direct-query data source. For more information, see [Deleting an Amazon OpenSearch Service data source with Amazon S3](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_delete_data_source/](https://www.paws-r-sdk.com/docs/opensearchservice_delete_data_source/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain.
#' @param Name &#91;required&#93; The name of the data source to delete.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_delete_data_source
opensearchservice_delete_data_source <- function(DomainName, Name) {
  op <- new_operation(
    name = "DeleteDataSource",
    http_method = "DELETE",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/dataSource/{DataSourceName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$delete_data_source_input(DomainName = DomainName, Name = Name)
  output <- .opensearchservice$delete_data_source_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$delete_data_source <- opensearchservice_delete_data_source

#' Deletes an Amazon OpenSearch Service domain and all of its data
#'
#' @description
#' Deletes an Amazon OpenSearch Service domain and all of its data. You can't recover a domain after you delete it.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_delete_domain/](https://www.paws-r-sdk.com/docs/opensearchservice_delete_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain you want to permanently delete.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_delete_domain
opensearchservice_delete_domain <- function(DomainName) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "DELETE",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$delete_domain_input(DomainName = DomainName)
  output <- .opensearchservice$delete_domain_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$delete_domain <- opensearchservice_delete_domain

#' Allows the destination Amazon OpenSearch Service domain owner to delete
#' an existing inbound cross-cluster search connection
#'
#' @description
#' Allows the destination Amazon OpenSearch Service domain owner to delete an existing inbound cross-cluster search connection. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_delete_inbound_connection/](https://www.paws-r-sdk.com/docs/opensearchservice_delete_inbound_connection/) for full documentation.
#'
#' @param ConnectionId &#91;required&#93; The ID of the inbound connection to permanently delete.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_delete_inbound_connection
opensearchservice_delete_inbound_connection <- function(ConnectionId) {
  op <- new_operation(
    name = "DeleteInboundConnection",
    http_method = "DELETE",
    http_path = "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$delete_inbound_connection_input(ConnectionId = ConnectionId)
  output <- .opensearchservice$delete_inbound_connection_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$delete_inbound_connection <- opensearchservice_delete_inbound_connection

#' Allows the source Amazon OpenSearch Service domain owner to delete an
#' existing outbound cross-cluster search connection
#'
#' @description
#' Allows the source Amazon OpenSearch Service domain owner to delete an existing outbound cross-cluster search connection. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_delete_outbound_connection/](https://www.paws-r-sdk.com/docs/opensearchservice_delete_outbound_connection/) for full documentation.
#'
#' @param ConnectionId &#91;required&#93; The ID of the outbound connection you want to permanently delete.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_delete_outbound_connection
opensearchservice_delete_outbound_connection <- function(ConnectionId) {
  op <- new_operation(
    name = "DeleteOutboundConnection",
    http_method = "DELETE",
    http_path = "/2021-01-01/opensearch/cc/outboundConnection/{ConnectionId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$delete_outbound_connection_input(ConnectionId = ConnectionId)
  output <- .opensearchservice$delete_outbound_connection_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$delete_outbound_connection <- opensearchservice_delete_outbound_connection

#' Deletes an Amazon OpenSearch Service package
#'
#' @description
#' Deletes an Amazon OpenSearch Service package. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_delete_package/](https://www.paws-r-sdk.com/docs/opensearchservice_delete_package/) for full documentation.
#'
#' @param PackageID &#91;required&#93; The internal ID of the package you want to delete. Use
#' [`describe_packages`][opensearchservice_describe_packages] to find this
#' value.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_delete_package
opensearchservice_delete_package <- function(PackageID) {
  op <- new_operation(
    name = "DeletePackage",
    http_method = "DELETE",
    http_path = "/2021-01-01/packages/{PackageID}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$delete_package_input(PackageID = PackageID)
  output <- .opensearchservice$delete_package_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$delete_package <- opensearchservice_delete_package

#' Deletes an Amazon OpenSearch Service-managed interface VPC endpoint
#'
#' @description
#' Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_delete_vpc_endpoint/](https://www.paws-r-sdk.com/docs/opensearchservice_delete_vpc_endpoint/) for full documentation.
#'
#' @param VpcEndpointId &#91;required&#93; The unique identifier of the endpoint.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_delete_vpc_endpoint
opensearchservice_delete_vpc_endpoint <- function(VpcEndpointId) {
  op <- new_operation(
    name = "DeleteVpcEndpoint",
    http_method = "DELETE",
    http_path = "/2021-01-01/opensearch/vpcEndpoints/{VpcEndpointId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$delete_vpc_endpoint_input(VpcEndpointId = VpcEndpointId)
  output <- .opensearchservice$delete_vpc_endpoint_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$delete_vpc_endpoint <- opensearchservice_delete_vpc_endpoint

#' Describes the domain configuration for the specified Amazon OpenSearch
#' Service domain, including the domain ID, domain service endpoint, and
#' domain ARN
#'
#' @description
#' Describes the domain configuration for the specified Amazon OpenSearch Service domain, including the domain ID, domain service endpoint, and domain ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_domain/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want information about.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_domain
opensearchservice_describe_domain <- function(DomainName) {
  op <- new_operation(
    name = "DescribeDomain",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$describe_domain_input(DomainName = DomainName)
  output <- .opensearchservice$describe_domain_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_domain <- opensearchservice_describe_domain

#' Returns the list of optimizations that Auto-Tune has made to an Amazon
#' OpenSearch Service domain
#'
#' @description
#' Returns the list of optimizations that Auto-Tune has made to an Amazon OpenSearch Service domain. For more information, see [Auto-Tune for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_domain_auto_tunes/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_domain_auto_tunes/) for full documentation.
#'
#' @param DomainName &#91;required&#93; Name of the domain that you want Auto-Tune details about.
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial
#' [`describe_domain_auto_tunes`][opensearchservice_describe_domain_auto_tunes]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`describe_domain_auto_tunes`][opensearchservice_describe_domain_auto_tunes]
#' operations, which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_domain_auto_tunes
opensearchservice_describe_domain_auto_tunes <- function(DomainName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeDomainAutoTunes",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/autoTunes",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchservice$describe_domain_auto_tunes_input(DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$describe_domain_auto_tunes_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_domain_auto_tunes <- opensearchservice_describe_domain_auto_tunes

#' Returns information about the current blue/green deployment happening on
#' an Amazon OpenSearch Service domain
#'
#' @description
#' Returns information about the current blue/green deployment happening on an Amazon OpenSearch Service domain. For more information, see [Making configuration changes in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_domain_change_progress/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_domain_change_progress/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain to get progress information for.
#' @param ChangeId The specific change ID for which you want to get progress information.
#' If omitted, the request returns information about the most recent
#' configuration change.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_domain_change_progress
opensearchservice_describe_domain_change_progress <- function(DomainName, ChangeId = NULL) {
  op <- new_operation(
    name = "DescribeDomainChangeProgress",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/progress",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$describe_domain_change_progress_input(DomainName = DomainName, ChangeId = ChangeId)
  output <- .opensearchservice$describe_domain_change_progress_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_domain_change_progress <- opensearchservice_describe_domain_change_progress

#' Returns the configuration of an Amazon OpenSearch Service domain
#'
#' @description
#' Returns the configuration of an Amazon OpenSearch Service domain.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_domain_config/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_domain_config/) for full documentation.
#'
#' @param DomainName &#91;required&#93; Name of the OpenSearch Service domain configuration that you want to
#' describe.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_domain_config
opensearchservice_describe_domain_config <- function(DomainName) {
  op <- new_operation(
    name = "DescribeDomainConfig",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/config",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$describe_domain_config_input(DomainName = DomainName)
  output <- .opensearchservice$describe_domain_config_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_domain_config <- opensearchservice_describe_domain_config

#' Returns information about domain and node health, the standby
#' Availability Zone, number of nodes per Availability Zone, and shard
#' count per node
#'
#' @description
#' Returns information about domain and node health, the standby Availability Zone, number of nodes per Availability Zone, and shard count per node.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_domain_health/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_domain_health/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_domain_health
opensearchservice_describe_domain_health <- function(DomainName) {
  op <- new_operation(
    name = "DescribeDomainHealth",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/health",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$describe_domain_health_input(DomainName = DomainName)
  output <- .opensearchservice$describe_domain_health_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_domain_health <- opensearchservice_describe_domain_health

#' Returns information about domain and nodes, including data nodes, master
#' nodes, ultrawarm nodes, Availability Zone(s), standby nodes, node
#' configurations, and node states
#'
#' @description
#' Returns information about domain and nodes, including data nodes, master nodes, ultrawarm nodes, Availability Zone(s), standby nodes, node configurations, and node states.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_domain_nodes/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_domain_nodes/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_domain_nodes
opensearchservice_describe_domain_nodes <- function(DomainName) {
  op <- new_operation(
    name = "DescribeDomainNodes",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/nodes",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$describe_domain_nodes_input(DomainName = DomainName)
  output <- .opensearchservice$describe_domain_nodes_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_domain_nodes <- opensearchservice_describe_domain_nodes

#' Returns domain configuration information about the specified Amazon
#' OpenSearch Service domains
#'
#' @description
#' Returns domain configuration information about the specified Amazon OpenSearch Service domains.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_domains/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_domains/) for full documentation.
#'
#' @param DomainNames &#91;required&#93; Array of OpenSearch Service domain names that you want information
#' about. You must specify at least one domain name.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_domains
opensearchservice_describe_domains <- function(DomainNames) {
  op <- new_operation(
    name = "DescribeDomains",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/domain-info",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$describe_domains_input(DomainNames = DomainNames)
  output <- .opensearchservice$describe_domains_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_domains <- opensearchservice_describe_domains

#' Describes the progress of a pre-update dry run analysis on an Amazon
#' OpenSearch Service domain
#'
#' @description
#' Describes the progress of a pre-update dry run analysis on an Amazon OpenSearch Service domain. For more information, see [Determining whether a change will cause a blue/green deployment](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes.html#dryrun).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_dry_run_progress/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_dry_run_progress/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain.
#' @param DryRunId The unique identifier of the dry run.
#' @param LoadDryRunConfig Whether to include the configuration of the dry run in the response. The
#' configuration specifies the updates that you're planning to make on the
#' domain.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_dry_run_progress
opensearchservice_describe_dry_run_progress <- function(DomainName, DryRunId = NULL, LoadDryRunConfig = NULL) {
  op <- new_operation(
    name = "DescribeDryRunProgress",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/dryRun",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$describe_dry_run_progress_input(DomainName = DomainName, DryRunId = DryRunId, LoadDryRunConfig = LoadDryRunConfig)
  output <- .opensearchservice$describe_dry_run_progress_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_dry_run_progress <- opensearchservice_describe_dry_run_progress

#' Lists all the inbound cross-cluster search connections for a destination
#' (remote) Amazon OpenSearch Service domain
#'
#' @description
#' Lists all the inbound cross-cluster search connections for a destination (remote) Amazon OpenSearch Service domain. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_inbound_connections/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_inbound_connections/) for full documentation.
#'
#' @param Filters A list of filters used to match properties for inbound cross-cluster
#' connections.
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial
#' [`describe_inbound_connections`][opensearchservice_describe_inbound_connections]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`describe_inbound_connections`][opensearchservice_describe_inbound_connections]
#' operations, which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_inbound_connections
opensearchservice_describe_inbound_connections <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInboundConnections",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/cc/inboundConnection/search",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchservice$describe_inbound_connections_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$describe_inbound_connections_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_inbound_connections <- opensearchservice_describe_inbound_connections

#' Describes the instance count, storage, and master node limits for a
#' given OpenSearch or Elasticsearch version and instance type
#'
#' @description
#' Describes the instance count, storage, and master node limits for a given OpenSearch or Elasticsearch version and instance type.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_instance_type_limits/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_instance_type_limits/) for full documentation.
#'
#' @param DomainName The name of the domain. Only specify if you need the limits for an
#' existing domain.
#' @param InstanceType &#91;required&#93; The OpenSearch Service instance type for which you need limit
#' information.
#' @param EngineVersion &#91;required&#93; Version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y
#' or OpenSearch_X.Y. Defaults to the latest version of OpenSearch.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_instance_type_limits
opensearchservice_describe_instance_type_limits <- function(DomainName = NULL, InstanceType, EngineVersion) {
  op <- new_operation(
    name = "DescribeInstanceTypeLimits",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/instanceTypeLimits/{EngineVersion}/{InstanceType}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$describe_instance_type_limits_input(DomainName = DomainName, InstanceType = InstanceType, EngineVersion = EngineVersion)
  output <- .opensearchservice$describe_instance_type_limits_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_instance_type_limits <- opensearchservice_describe_instance_type_limits

#' Lists all the outbound cross-cluster connections for a local (source)
#' Amazon OpenSearch Service domain
#'
#' @description
#' Lists all the outbound cross-cluster connections for a local (source) Amazon OpenSearch Service domain. For more information, see [Cross-cluster search for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_outbound_connections/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_outbound_connections/) for full documentation.
#'
#' @param Filters List of filter names and values that you can use for requests.
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial
#' [`describe_outbound_connections`][opensearchservice_describe_outbound_connections]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`describe_outbound_connections`][opensearchservice_describe_outbound_connections]
#' operations, which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_outbound_connections
opensearchservice_describe_outbound_connections <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOutboundConnections",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/cc/outboundConnection/search",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchservice$describe_outbound_connections_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$describe_outbound_connections_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_outbound_connections <- opensearchservice_describe_outbound_connections

#' Describes all packages available to OpenSearch Service
#'
#' @description
#' Describes all packages available to OpenSearch Service. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_packages/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_packages/) for full documentation.
#'
#' @param Filters Only returns packages that match the `DescribePackagesFilterList`
#' values.
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial `DescribePackageFilters` operation returns a
#' `nextToken`, you can include the returned `nextToken` in subsequent
#' `DescribePackageFilters` operations, which returns results in the next
#' page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_packages
opensearchservice_describe_packages <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePackages",
    http_method = "POST",
    http_path = "/2021-01-01/packages/describe",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchservice$describe_packages_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$describe_packages_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_packages <- opensearchservice_describe_packages

#' Describes the available Amazon OpenSearch Service Reserved Instance
#' offerings for a given Region
#'
#' @description
#' Describes the available Amazon OpenSearch Service Reserved Instance offerings for a given Region. For more information, see [Reserved Instances in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_reserved_instance_offerings/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_reserved_instance_offerings/) for full documentation.
#'
#' @param ReservedInstanceOfferingId The Reserved Instance identifier filter value. Use this parameter to
#' show only the available instance types that match the specified
#' reservation identifier.
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial
#' [`describe_reserved_instance_offerings`][opensearchservice_describe_reserved_instance_offerings]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`describe_reserved_instance_offerings`][opensearchservice_describe_reserved_instance_offerings]
#' operations, which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_reserved_instance_offerings
opensearchservice_describe_reserved_instance_offerings <- function(ReservedInstanceOfferingId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstanceOfferings",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/reservedInstanceOfferings",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchservice$describe_reserved_instance_offerings_input(ReservedInstanceOfferingId = ReservedInstanceOfferingId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$describe_reserved_instance_offerings_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_reserved_instance_offerings <- opensearchservice_describe_reserved_instance_offerings

#' Describes the Amazon OpenSearch Service instances that you have reserved
#' in a given Region
#'
#' @description
#' Describes the Amazon OpenSearch Service instances that you have reserved in a given Region. For more information, see [Reserved Instances in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_reserved_instances/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_reserved_instances/) for full documentation.
#'
#' @param ReservedInstanceId The reserved instance identifier filter value. Use this parameter to
#' show only the reservation that matches the specified reserved OpenSearch
#' instance ID.
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial
#' [`describe_reserved_instances`][opensearchservice_describe_reserved_instances]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`describe_reserved_instances`][opensearchservice_describe_reserved_instances]
#' operations, which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_reserved_instances
opensearchservice_describe_reserved_instances <- function(ReservedInstanceId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstances",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/reservedInstances",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchservice$describe_reserved_instances_input(ReservedInstanceId = ReservedInstanceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$describe_reserved_instances_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_reserved_instances <- opensearchservice_describe_reserved_instances

#' Describes one or more Amazon OpenSearch Service-managed VPC endpoints
#'
#' @description
#' Describes one or more Amazon OpenSearch Service-managed VPC endpoints.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_describe_vpc_endpoints/](https://www.paws-r-sdk.com/docs/opensearchservice_describe_vpc_endpoints/) for full documentation.
#'
#' @param VpcEndpointIds &#91;required&#93; The unique identifiers of the endpoints to get information about.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_vpc_endpoints
opensearchservice_describe_vpc_endpoints <- function(VpcEndpointIds) {
  op <- new_operation(
    name = "DescribeVpcEndpoints",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/vpcEndpoints/describe",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$describe_vpc_endpoints_input(VpcEndpointIds = VpcEndpointIds)
  output <- .opensearchservice$describe_vpc_endpoints_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_vpc_endpoints <- opensearchservice_describe_vpc_endpoints

#' Removes a package from the specified Amazon OpenSearch Service domain
#'
#' @description
#' Removes a package from the specified Amazon OpenSearch Service domain. The package can't be in use with any OpenSearch index for the dissociation to succeed. The package is still available in OpenSearch Service for association later. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_dissociate_package/](https://www.paws-r-sdk.com/docs/opensearchservice_dissociate_package/) for full documentation.
#'
#' @param PackageID &#91;required&#93; Internal ID of the package to dissociate from the domain. Use
#' [`list_packages_for_domain`][opensearchservice_list_packages_for_domain]
#' to find this value.
#' @param DomainName &#91;required&#93; Name of the domain to dissociate the package from.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_dissociate_package
opensearchservice_dissociate_package <- function(PackageID, DomainName) {
  op <- new_operation(
    name = "DissociatePackage",
    http_method = "POST",
    http_path = "/2021-01-01/packages/dissociate/{PackageID}/{DomainName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$dissociate_package_input(PackageID = PackageID, DomainName = DomainName)
  output <- .opensearchservice$dissociate_package_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$dissociate_package <- opensearchservice_dissociate_package

#' Returns a map of OpenSearch or Elasticsearch versions and the versions
#' you can upgrade them to
#'
#' @description
#' Returns a map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_get_compatible_versions/](https://www.paws-r-sdk.com/docs/opensearchservice_get_compatible_versions/) for full documentation.
#'
#' @param DomainName The name of an existing domain. Provide this parameter to limit the
#' results to a single domain.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_get_compatible_versions
opensearchservice_get_compatible_versions <- function(DomainName = NULL) {
  op <- new_operation(
    name = "GetCompatibleVersions",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/compatibleVersions",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$get_compatible_versions_input(DomainName = DomainName)
  output <- .opensearchservice$get_compatible_versions_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$get_compatible_versions <- opensearchservice_get_compatible_versions

#' Retrieves information about a direct query data source
#'
#' @description
#' Retrieves information about a direct query data source.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_get_data_source/](https://www.paws-r-sdk.com/docs/opensearchservice_get_data_source/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain.
#' @param Name &#91;required&#93; The name of the data source to get information about.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_get_data_source
opensearchservice_get_data_source <- function(DomainName, Name) {
  op <- new_operation(
    name = "GetDataSource",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/dataSource/{DataSourceName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$get_data_source_input(DomainName = DomainName, Name = Name)
  output <- .opensearchservice$get_data_source_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$get_data_source <- opensearchservice_get_data_source

#' The status of the maintenance action
#'
#' @description
#' The status of the maintenance action.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_get_domain_maintenance_status/](https://www.paws-r-sdk.com/docs/opensearchservice_get_domain_maintenance_status/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain.
#' @param MaintenanceId &#91;required&#93; The request ID of the maintenance action.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_get_domain_maintenance_status
opensearchservice_get_domain_maintenance_status <- function(DomainName, MaintenanceId) {
  op <- new_operation(
    name = "GetDomainMaintenanceStatus",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/domainMaintenance",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$get_domain_maintenance_status_input(DomainName = DomainName, MaintenanceId = MaintenanceId)
  output <- .opensearchservice$get_domain_maintenance_status_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$get_domain_maintenance_status <- opensearchservice_get_domain_maintenance_status

#' Returns a list of Amazon OpenSearch Service package versions, along with
#' their creation time, commit message, and plugin properties (if the
#' package is a zip plugin package)
#'
#' @description
#' Returns a list of Amazon OpenSearch Service package versions, along with their creation time, commit message, and plugin properties (if the package is a zip plugin package). For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_get_package_version_history/](https://www.paws-r-sdk.com/docs/opensearchservice_get_package_version_history/) for full documentation.
#'
#' @param PackageID &#91;required&#93; The unique identifier of the package.
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial
#' [`get_package_version_history`][opensearchservice_get_package_version_history]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`get_package_version_history`][opensearchservice_get_package_version_history]
#' operations, which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_get_package_version_history
opensearchservice_get_package_version_history <- function(PackageID, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetPackageVersionHistory",
    http_method = "GET",
    http_path = "/2021-01-01/packages/{PackageID}/history",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchservice$get_package_version_history_input(PackageID = PackageID, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$get_package_version_history_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$get_package_version_history <- opensearchservice_get_package_version_history

#' Retrieves the complete history of the last 10 upgrades performed on an
#' Amazon OpenSearch Service domain
#'
#' @description
#' Retrieves the complete history of the last 10 upgrades performed on an Amazon OpenSearch Service domain.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_get_upgrade_history/](https://www.paws-r-sdk.com/docs/opensearchservice_get_upgrade_history/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of an existing domain.
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial
#' [`get_upgrade_history`][opensearchservice_get_upgrade_history] operation
#' returns a `nextToken`, you can include the returned `nextToken` in
#' subsequent
#' [`get_upgrade_history`][opensearchservice_get_upgrade_history]
#' operations, which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_get_upgrade_history
opensearchservice_get_upgrade_history <- function(DomainName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetUpgradeHistory",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/upgradeDomain/{DomainName}/history",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchservice$get_upgrade_history_input(DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$get_upgrade_history_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$get_upgrade_history <- opensearchservice_get_upgrade_history

#' Returns the most recent status of the last upgrade or upgrade
#' eligibility check performed on an Amazon OpenSearch Service domain
#'
#' @description
#' Returns the most recent status of the last upgrade or upgrade eligibility check performed on an Amazon OpenSearch Service domain.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_get_upgrade_status/](https://www.paws-r-sdk.com/docs/opensearchservice_get_upgrade_status/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The domain of the domain to get upgrade status information for.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_get_upgrade_status
opensearchservice_get_upgrade_status <- function(DomainName) {
  op <- new_operation(
    name = "GetUpgradeStatus",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/upgradeDomain/{DomainName}/status",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$get_upgrade_status_input(DomainName = DomainName)
  output <- .opensearchservice$get_upgrade_status_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$get_upgrade_status <- opensearchservice_get_upgrade_status

#' Lists direct-query data sources for a specific domain
#'
#' @description
#' Lists direct-query data sources for a specific domain. For more information, see For more information, see [Working with Amazon OpenSearch Service direct queries with Amazon S3](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_list_data_sources/](https://www.paws-r-sdk.com/docs/opensearchservice_list_data_sources/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_data_sources
opensearchservice_list_data_sources <- function(DomainName) {
  op <- new_operation(
    name = "ListDataSources",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/dataSource",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$list_data_sources_input(DomainName = DomainName)
  output <- .opensearchservice$list_data_sources_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_data_sources <- opensearchservice_list_data_sources

#' A list of maintenance actions for the domain
#'
#' @description
#' A list of maintenance actions for the domain.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_list_domain_maintenances/](https://www.paws-r-sdk.com/docs/opensearchservice_list_domain_maintenances/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain.
#' @param Action The name of the action.
#' @param Status The status of the action.
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial
#' [`list_domain_maintenances`][opensearchservice_list_domain_maintenances]
#' operation returns a `nextToken`, include the returned `nextToken` in
#' subsequent
#' [`list_domain_maintenances`][opensearchservice_list_domain_maintenances]
#' operations, which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_domain_maintenances
opensearchservice_list_domain_maintenances <- function(DomainName, Action = NULL, Status = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDomainMaintenances",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/domainMaintenances",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchservice$list_domain_maintenances_input(DomainName = DomainName, Action = Action, Status = Status, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$list_domain_maintenances_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_domain_maintenances <- opensearchservice_list_domain_maintenances

#' Returns the names of all Amazon OpenSearch Service domains owned by the
#' current user in the active Region
#'
#' @description
#' Returns the names of all Amazon OpenSearch Service domains owned by the current user in the active Region.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_list_domain_names/](https://www.paws-r-sdk.com/docs/opensearchservice_list_domain_names/) for full documentation.
#'
#' @param EngineType Filters the output by domain engine type.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_domain_names
opensearchservice_list_domain_names <- function(EngineType = NULL) {
  op <- new_operation(
    name = "ListDomainNames",
    http_method = "GET",
    http_path = "/2021-01-01/domain",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$list_domain_names_input(EngineType = EngineType)
  output <- .opensearchservice$list_domain_names_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_domain_names <- opensearchservice_list_domain_names

#' Lists all Amazon OpenSearch Service domains associated with a given
#' package
#'
#' @description
#' Lists all Amazon OpenSearch Service domains associated with a given package. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_list_domains_for_package/](https://www.paws-r-sdk.com/docs/opensearchservice_list_domains_for_package/) for full documentation.
#'
#' @param PackageID &#91;required&#93; The unique identifier of the package for which to list associated
#' domains.
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial
#' [`list_domains_for_package`][opensearchservice_list_domains_for_package]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`list_domains_for_package`][opensearchservice_list_domains_for_package]
#' operations, which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_domains_for_package
opensearchservice_list_domains_for_package <- function(PackageID, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDomainsForPackage",
    http_method = "GET",
    http_path = "/2021-01-01/packages/{PackageID}/domains",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchservice$list_domains_for_package_input(PackageID = PackageID, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$list_domains_for_package_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_domains_for_package <- opensearchservice_list_domains_for_package

#' Lists all instance types and available features for a given OpenSearch
#' or Elasticsearch version
#'
#' @description
#' Lists all instance types and available features for a given OpenSearch or Elasticsearch version.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_list_instance_type_details/](https://www.paws-r-sdk.com/docs/opensearchservice_list_instance_type_details/) for full documentation.
#'
#' @param EngineVersion &#91;required&#93; The version of OpenSearch or Elasticsearch, in the format
#' Elasticsearch_X.Y or OpenSearch_X.Y. Defaults to the latest version of
#' OpenSearch.
#' @param DomainName The name of the domain.
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial
#' [`list_instance_type_details`][opensearchservice_list_instance_type_details]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`list_instance_type_details`][opensearchservice_list_instance_type_details]
#' operations, which returns results in the next page.
#' @param RetrieveAZs An optional parameter that specifies the Availability Zones for the
#' domain.
#' @param InstanceType An optional parameter that lists information for a given instance type.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_instance_type_details
opensearchservice_list_instance_type_details <- function(EngineVersion, DomainName = NULL, MaxResults = NULL, NextToken = NULL, RetrieveAZs = NULL, InstanceType = NULL) {
  op <- new_operation(
    name = "ListInstanceTypeDetails",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/instanceTypeDetails/{EngineVersion}",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchservice$list_instance_type_details_input(EngineVersion = EngineVersion, DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken, RetrieveAZs = RetrieveAZs, InstanceType = InstanceType)
  output <- .opensearchservice$list_instance_type_details_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_instance_type_details <- opensearchservice_list_instance_type_details

#' Lists all packages associated with an Amazon OpenSearch Service domain
#'
#' @description
#' Lists all packages associated with an Amazon OpenSearch Service domain. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_list_packages_for_domain/](https://www.paws-r-sdk.com/docs/opensearchservice_list_packages_for_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain for which you want to list associated packages.
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial
#' [`list_packages_for_domain`][opensearchservice_list_packages_for_domain]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`list_packages_for_domain`][opensearchservice_list_packages_for_domain]
#' operations, which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_packages_for_domain
opensearchservice_list_packages_for_domain <- function(DomainName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPackagesForDomain",
    http_method = "GET",
    http_path = "/2021-01-01/domain/{DomainName}/packages",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchservice$list_packages_for_domain_input(DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$list_packages_for_domain_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_packages_for_domain <- opensearchservice_list_packages_for_domain

#' Retrieves a list of configuration changes that are scheduled for a
#' domain
#'
#' @description
#' Retrieves a list of configuration changes that are scheduled for a domain. These changes can be [service software updates](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html) or [blue/green Auto-Tune enhancements](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_list_scheduled_actions/](https://www.paws-r-sdk.com/docs/opensearchservice_list_scheduled_actions/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain.
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial
#' [`list_scheduled_actions`][opensearchservice_list_scheduled_actions]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`list_scheduled_actions`][opensearchservice_list_scheduled_actions]
#' operations, which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_scheduled_actions
opensearchservice_list_scheduled_actions <- function(DomainName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListScheduledActions",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/scheduledActions",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchservice$list_scheduled_actions_input(DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$list_scheduled_actions_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_scheduled_actions <- opensearchservice_list_scheduled_actions

#' Returns all resource tags for an Amazon OpenSearch Service domain
#'
#' @description
#' Returns all resource tags for an Amazon OpenSearch Service domain. For more information, see [Tagging Amazon OpenSearch Service domains](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_list_tags/](https://www.paws-r-sdk.com/docs/opensearchservice_list_tags/) for full documentation.
#'
#' @param ARN &#91;required&#93; Amazon Resource Name (ARN) for the domain to view tags for.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_tags
opensearchservice_list_tags <- function(ARN) {
  op <- new_operation(
    name = "ListTags",
    http_method = "GET",
    http_path = "/2021-01-01/tags/",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$list_tags_input(ARN = ARN)
  output <- .opensearchservice$list_tags_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_tags <- opensearchservice_list_tags

#' Lists all versions of OpenSearch and Elasticsearch that Amazon
#' OpenSearch Service supports
#'
#' @description
#' Lists all versions of OpenSearch and Elasticsearch that Amazon OpenSearch Service supports.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_list_versions/](https://www.paws-r-sdk.com/docs/opensearchservice_list_versions/) for full documentation.
#'
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial [`list_versions`][opensearchservice_list_versions]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`list_versions`][opensearchservice_list_versions] operations, which
#' returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_versions
opensearchservice_list_versions <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListVersions",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/versions",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchservice$list_versions_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$list_versions_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_versions <- opensearchservice_list_versions

#' Retrieves information about each Amazon Web Services principal that is
#' allowed to access a given Amazon OpenSearch Service domain through the
#' use of an interface VPC endpoint
#'
#' @description
#' Retrieves information about each Amazon Web Services principal that is allowed to access a given Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_list_vpc_endpoint_access/](https://www.paws-r-sdk.com/docs/opensearchservice_list_vpc_endpoint_access/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the OpenSearch Service domain to retrieve access information
#' for.
#' @param NextToken If your initial
#' [`list_vpc_endpoint_access`][opensearchservice_list_vpc_endpoint_access]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`list_vpc_endpoint_access`][opensearchservice_list_vpc_endpoint_access]
#' operations, which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_vpc_endpoint_access
opensearchservice_list_vpc_endpoint_access <- function(DomainName, NextToken = NULL) {
  op <- new_operation(
    name = "ListVpcEndpointAccess",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/listVpcEndpointAccess",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$list_vpc_endpoint_access_input(DomainName = DomainName, NextToken = NextToken)
  output <- .opensearchservice$list_vpc_endpoint_access_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_vpc_endpoint_access <- opensearchservice_list_vpc_endpoint_access

#' Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the
#' current Amazon Web Services account and Region
#'
#' @description
#' Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current Amazon Web Services account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_list_vpc_endpoints/](https://www.paws-r-sdk.com/docs/opensearchservice_list_vpc_endpoints/) for full documentation.
#'
#' @param NextToken If your initial
#' [`list_vpc_endpoints`][opensearchservice_list_vpc_endpoints] operation
#' returns a `nextToken`, you can include the returned `nextToken` in
#' subsequent [`list_vpc_endpoints`][opensearchservice_list_vpc_endpoints]
#' operations, which returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_vpc_endpoints
opensearchservice_list_vpc_endpoints <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListVpcEndpoints",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/vpcEndpoints",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$list_vpc_endpoints_input(NextToken = NextToken)
  output <- .opensearchservice$list_vpc_endpoints_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_vpc_endpoints <- opensearchservice_list_vpc_endpoints

#' Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated
#' with a particular domain
#'
#' @description
#' Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_list_vpc_endpoints_for_domain/](https://www.paws-r-sdk.com/docs/opensearchservice_list_vpc_endpoints_for_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain to list associated VPC endpoints for.
#' @param NextToken If your initial `ListEndpointsForDomain` operation returns a
#' `nextToken`, you can include the returned `nextToken` in subsequent
#' `ListEndpointsForDomain` operations, which returns results in the next
#' page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_vpc_endpoints_for_domain
opensearchservice_list_vpc_endpoints_for_domain <- function(DomainName, NextToken = NULL) {
  op <- new_operation(
    name = "ListVpcEndpointsForDomain",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/vpcEndpoints",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$list_vpc_endpoints_for_domain_input(DomainName = DomainName, NextToken = NextToken)
  output <- .opensearchservice$list_vpc_endpoints_for_domain_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_vpc_endpoints_for_domain <- opensearchservice_list_vpc_endpoints_for_domain

#' Allows you to purchase Amazon OpenSearch Service Reserved Instances
#'
#' @description
#' Allows you to purchase Amazon OpenSearch Service Reserved Instances.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_purchase_reserved_instance_offering/](https://www.paws-r-sdk.com/docs/opensearchservice_purchase_reserved_instance_offering/) for full documentation.
#'
#' @param ReservedInstanceOfferingId &#91;required&#93; The ID of the Reserved Instance offering to purchase.
#' @param ReservationName &#91;required&#93; A customer-specified identifier to track this reservation.
#' @param InstanceCount The number of OpenSearch instances to reserve.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_purchase_reserved_instance_offering
opensearchservice_purchase_reserved_instance_offering <- function(ReservedInstanceOfferingId, ReservationName, InstanceCount = NULL) {
  op <- new_operation(
    name = "PurchaseReservedInstanceOffering",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/purchaseReservedInstanceOffering",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$purchase_reserved_instance_offering_input(ReservedInstanceOfferingId = ReservedInstanceOfferingId, ReservationName = ReservationName, InstanceCount = InstanceCount)
  output <- .opensearchservice$purchase_reserved_instance_offering_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$purchase_reserved_instance_offering <- opensearchservice_purchase_reserved_instance_offering

#' Allows the remote Amazon OpenSearch Service domain owner to reject an
#' inbound cross-cluster connection request
#'
#' @description
#' Allows the remote Amazon OpenSearch Service domain owner to reject an inbound cross-cluster connection request.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_reject_inbound_connection/](https://www.paws-r-sdk.com/docs/opensearchservice_reject_inbound_connection/) for full documentation.
#'
#' @param ConnectionId &#91;required&#93; The unique identifier of the inbound connection to reject.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_reject_inbound_connection
opensearchservice_reject_inbound_connection <- function(ConnectionId) {
  op <- new_operation(
    name = "RejectInboundConnection",
    http_method = "PUT",
    http_path = "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}/reject",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$reject_inbound_connection_input(ConnectionId = ConnectionId)
  output <- .opensearchservice$reject_inbound_connection_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$reject_inbound_connection <- opensearchservice_reject_inbound_connection

#' Removes the specified set of tags from an Amazon OpenSearch Service
#' domain
#'
#' @description
#' Removes the specified set of tags from an Amazon OpenSearch Service domain. For more information, see [Tagging Amazon OpenSearch Service domains](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/#managedomains-awsresorcetagging).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_remove_tags/](https://www.paws-r-sdk.com/docs/opensearchservice_remove_tags/) for full documentation.
#'
#' @param ARN &#91;required&#93; The Amazon Resource Name (ARN) of the domain from which you want to
#' delete the specified tags.
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the domain.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_remove_tags
opensearchservice_remove_tags <- function(ARN, TagKeys) {
  op <- new_operation(
    name = "RemoveTags",
    http_method = "POST",
    http_path = "/2021-01-01/tags-removal",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$remove_tags_input(ARN = ARN, TagKeys = TagKeys)
  output <- .opensearchservice$remove_tags_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$remove_tags <- opensearchservice_remove_tags

#' Revokes access to an Amazon OpenSearch Service domain that was provided
#' through an interface VPC endpoint
#'
#' @description
#' Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_revoke_vpc_endpoint_access/](https://www.paws-r-sdk.com/docs/opensearchservice_revoke_vpc_endpoint_access/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the OpenSearch Service domain.
#' @param Account &#91;required&#93; The account ID to revoke access from.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_revoke_vpc_endpoint_access
opensearchservice_revoke_vpc_endpoint_access <- function(DomainName, Account) {
  op <- new_operation(
    name = "RevokeVpcEndpointAccess",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/revokeVpcEndpointAccess",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$revoke_vpc_endpoint_access_input(DomainName = DomainName, Account = Account)
  output <- .opensearchservice$revoke_vpc_endpoint_access_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$revoke_vpc_endpoint_access <- opensearchservice_revoke_vpc_endpoint_access

#' Starts the node maintenance process on the data node
#'
#' @description
#' Starts the node maintenance process on the data node. These processes can include a node reboot, an Opensearch or Elasticsearch process restart, or a Dashboard or Kibana restart.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_start_domain_maintenance/](https://www.paws-r-sdk.com/docs/opensearchservice_start_domain_maintenance/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain.
#' @param Action &#91;required&#93; The name of the action.
#' @param NodeId The ID of the data node.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_start_domain_maintenance
opensearchservice_start_domain_maintenance <- function(DomainName, Action, NodeId = NULL) {
  op <- new_operation(
    name = "StartDomainMaintenance",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/domainMaintenance",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$start_domain_maintenance_input(DomainName = DomainName, Action = Action, NodeId = NodeId)
  output <- .opensearchservice$start_domain_maintenance_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$start_domain_maintenance <- opensearchservice_start_domain_maintenance

#' Schedules a service software update for an Amazon OpenSearch Service
#' domain
#'
#' @description
#' Schedules a service software update for an Amazon OpenSearch Service domain. For more information, see [Service software updates in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_start_service_software_update/](https://www.paws-r-sdk.com/docs/opensearchservice_start_service_software_update/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to update to the latest service
#' software.
#' @param ScheduleAt When to start the service software update.
#' 
#' -   `NOW` - Immediately schedules the update to happen in the current
#'     hour if there's capacity available.
#' 
#' -   `TIMESTAMP` - Lets you specify a custom date and time to apply the
#'     update. If you specify this value, you must also provide a value for
#'     `DesiredStartTime`.
#' 
#' -   `OFF_PEAK_WINDOW` - Marks the update to be picked up during an
#'     upcoming off-peak window. There's no guarantee that the update will
#'     happen during the next immediate window. Depending on capacity, it
#'     might happen in subsequent days.
#' 
#' Default: `NOW` if you don't specify a value for `DesiredStartTime`, and
#' `TIMESTAMP` if you do.
#' @param DesiredStartTime The Epoch timestamp when you want the service software update to start.
#' You only need to specify this parameter if you set `ScheduleAt` to
#' `TIMESTAMP`.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_start_service_software_update
opensearchservice_start_service_software_update <- function(DomainName, ScheduleAt = NULL, DesiredStartTime = NULL) {
  op <- new_operation(
    name = "StartServiceSoftwareUpdate",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/serviceSoftwareUpdate/start",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$start_service_software_update_input(DomainName = DomainName, ScheduleAt = ScheduleAt, DesiredStartTime = DesiredStartTime)
  output <- .opensearchservice$start_service_software_update_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$start_service_software_update <- opensearchservice_start_service_software_update

#' Updates a direct-query data source
#'
#' @description
#' Updates a direct-query data source. For more information, see [Working with Amazon OpenSearch Service data source integrations with Amazon S3](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_update_data_source/](https://www.paws-r-sdk.com/docs/opensearchservice_update_data_source/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain.
#' @param Name &#91;required&#93; The name of the data source to modify.
#' @param DataSourceType &#91;required&#93; The type of data source.
#' @param Description A new description of the data source.
#' @param Status The status of the data source update.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_update_data_source
opensearchservice_update_data_source <- function(DomainName, Name, DataSourceType, Description = NULL, Status = NULL) {
  op <- new_operation(
    name = "UpdateDataSource",
    http_method = "PUT",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/dataSource/{DataSourceName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$update_data_source_input(DomainName = DomainName, Name = Name, DataSourceType = DataSourceType, Description = Description, Status = Status)
  output <- .opensearchservice$update_data_source_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$update_data_source <- opensearchservice_update_data_source

#' Modifies the cluster configuration of the specified Amazon OpenSearch
#' Service domain
#'
#' @description
#' Modifies the cluster configuration of the specified Amazon OpenSearch Service domain.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_update_domain_config/](https://www.paws-r-sdk.com/docs/opensearchservice_update_domain_config/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you're updating.
#' @param ClusterConfig Changes that you want to make to the cluster configuration, such as the
#' instance type and number of EC2 instances.
#' @param EBSOptions The type and size of the EBS volume to attach to instances in the
#' domain.
#' @param SnapshotOptions Option to set the time, in UTC format, for the daily automated snapshot.
#' Default value is `0` hours.
#' @param VPCOptions Options to specify the subnets and security groups for a VPC endpoint.
#' For more information, see [Launching your Amazon OpenSearch Service
#' domains using a
#' VPC](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
#' @param CognitoOptions Key-value pairs to configure Amazon Cognito authentication for
#' OpenSearch Dashboards.
#' @param AdvancedOptions Key-value pairs to specify advanced configuration options. The following
#' key-value pairs are supported:
#' 
#' -   `"rest.action.multi.allow_explicit_index": "true" | "false"` - Note
#'     the use of a string rather than a boolean. Specifies whether
#'     explicit references to indexes are allowed inside the body of HTTP
#'     requests. If you want to configure access policies for domain
#'     sub-resources, such as specific indexes and domain APIs, you must
#'     disable this property. Default is true.
#' 
#' -   `"indices.fielddata.cache.size": "80" ` - Note the use of a string
#'     rather than a boolean. Specifies the percentage of heap space
#'     allocated to field data. Default is unbounded.
#' 
#' -   `"indices.query.bool.max_clause_count": "1024"` - Note the use of a
#'     string rather than a boolean. Specifies the maximum number of
#'     clauses allowed in a Lucene boolean query. Default is 1,024. Queries
#'     with more than the permitted number of clauses result in a
#'     `TooManyClauses` error.
#' 
#' For more information, see [Advanced cluster
#' parameters](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
#' @param AccessPolicies Identity and Access Management (IAM) access policy as a JSON-formatted
#' string.
#' @param IPAddressType Specify either dual stack or IPv4 as your IP address type. Dual stack
#' allows you to share domain resources across IPv4 and IPv6 address types,
#' and is the recommended option. If your IP address type is currently set
#' to dual stack, you can't change it.
#' @param LogPublishingOptions Options to publish OpenSearch logs to Amazon CloudWatch Logs.
#' @param EncryptionAtRestOptions Encryption at rest options for the domain.
#' @param DomainEndpointOptions Additional options for the domain endpoint, such as whether to require
#' HTTPS for all traffic.
#' @param NodeToNodeEncryptionOptions Node-to-node encryption options for the domain.
#' @param AdvancedSecurityOptions Options for fine-grained access control.
#' @param AutoTuneOptions Options for Auto-Tune.
#' @param DryRun This flag, when set to True, specifies whether the `UpdateDomain`
#' request should return the results of a dry run analysis without actually
#' applying the change. A dry run determines what type of deployment the
#' update will cause.
#' @param DryRunMode The type of dry run to perform.
#' 
#' -   `Basic` only returns the type of deployment (blue/green or dynamic)
#'     that the update will cause.
#' 
#' -   `Verbose` runs an additional check to validate the changes you're
#'     making. For more information, see [Validating a domain
#'     update](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes.html#validation-check).
#' @param OffPeakWindowOptions Off-peak window options for the domain.
#' @param SoftwareUpdateOptions Service software update options for the domain.
#' @param AIMLOptions Options for all machine learning features for the specified domain.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_update_domain_config
opensearchservice_update_domain_config <- function(DomainName, ClusterConfig = NULL, EBSOptions = NULL, SnapshotOptions = NULL, VPCOptions = NULL, CognitoOptions = NULL, AdvancedOptions = NULL, AccessPolicies = NULL, IPAddressType = NULL, LogPublishingOptions = NULL, EncryptionAtRestOptions = NULL, DomainEndpointOptions = NULL, NodeToNodeEncryptionOptions = NULL, AdvancedSecurityOptions = NULL, AutoTuneOptions = NULL, DryRun = NULL, DryRunMode = NULL, OffPeakWindowOptions = NULL, SoftwareUpdateOptions = NULL, AIMLOptions = NULL) {
  op <- new_operation(
    name = "UpdateDomainConfig",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/config",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$update_domain_config_input(DomainName = DomainName, ClusterConfig = ClusterConfig, EBSOptions = EBSOptions, SnapshotOptions = SnapshotOptions, VPCOptions = VPCOptions, CognitoOptions = CognitoOptions, AdvancedOptions = AdvancedOptions, AccessPolicies = AccessPolicies, IPAddressType = IPAddressType, LogPublishingOptions = LogPublishingOptions, EncryptionAtRestOptions = EncryptionAtRestOptions, DomainEndpointOptions = DomainEndpointOptions, NodeToNodeEncryptionOptions = NodeToNodeEncryptionOptions, AdvancedSecurityOptions = AdvancedSecurityOptions, AutoTuneOptions = AutoTuneOptions, DryRun = DryRun, DryRunMode = DryRunMode, OffPeakWindowOptions = OffPeakWindowOptions, SoftwareUpdateOptions = SoftwareUpdateOptions, AIMLOptions = AIMLOptions)
  output <- .opensearchservice$update_domain_config_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$update_domain_config <- opensearchservice_update_domain_config

#' Updates a package for use with Amazon OpenSearch Service domains
#'
#' @description
#' Updates a package for use with Amazon OpenSearch Service domains. For more information, see [Custom packages for Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_update_package/](https://www.paws-r-sdk.com/docs/opensearchservice_update_package/) for full documentation.
#'
#' @param PackageID &#91;required&#93; The unique identifier for the package.
#' @param PackageSource &#91;required&#93; Amazon S3 bucket and key for the package.
#' @param PackageDescription A new description of the package.
#' @param CommitMessage Commit message for the updated file, which is shown as part of
#' `GetPackageVersionHistoryResponse`.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_update_package
opensearchservice_update_package <- function(PackageID, PackageSource, PackageDescription = NULL, CommitMessage = NULL) {
  op <- new_operation(
    name = "UpdatePackage",
    http_method = "POST",
    http_path = "/2021-01-01/packages/update",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$update_package_input(PackageID = PackageID, PackageSource = PackageSource, PackageDescription = PackageDescription, CommitMessage = CommitMessage)
  output <- .opensearchservice$update_package_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$update_package <- opensearchservice_update_package

#' Reschedules a planned domain configuration change for a later time
#'
#' @description
#' Reschedules a planned domain configuration change for a later time. This change can be a scheduled [service software update](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html) or a [blue/green Auto-Tune enhancement](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_update_scheduled_action/](https://www.paws-r-sdk.com/docs/opensearchservice_update_scheduled_action/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain to reschedule an action for.
#' @param ActionID &#91;required&#93; The unique identifier of the action to reschedule. To retrieve this ID,
#' send a
#' [`list_scheduled_actions`][opensearchservice_list_scheduled_actions]
#' request.
#' @param ActionType &#91;required&#93; The type of action to reschedule. Can be one of
#' `SERVICE_SOFTWARE_UPDATE`, `JVM_HEAP_SIZE_TUNING`, or
#' `JVM_YOUNG_GEN_TUNING`. To retrieve this value, send a
#' [`list_scheduled_actions`][opensearchservice_list_scheduled_actions]
#' request.
#' @param ScheduleAt &#91;required&#93; When to schedule the action.
#' 
#' -   `NOW` - Immediately schedules the update to happen in the current
#'     hour if there's capacity available.
#' 
#' -   `TIMESTAMP` - Lets you specify a custom date and time to apply the
#'     update. If you specify this value, you must also provide a value for
#'     `DesiredStartTime`.
#' 
#' -   `OFF_PEAK_WINDOW` - Marks the action to be picked up during an
#'     upcoming off-peak window. There's no guarantee that the change will
#'     be implemented during the next immediate window. Depending on
#'     capacity, it might happen in subsequent days.
#' @param DesiredStartTime The time to implement the change, in Coordinated Universal Time (UTC).
#' Only specify this parameter if you set `ScheduleAt` to `TIMESTAMP`.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_update_scheduled_action
opensearchservice_update_scheduled_action <- function(DomainName, ActionID, ActionType, ScheduleAt, DesiredStartTime = NULL) {
  op <- new_operation(
    name = "UpdateScheduledAction",
    http_method = "PUT",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/scheduledAction/update",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$update_scheduled_action_input(DomainName = DomainName, ActionID = ActionID, ActionType = ActionType, ScheduleAt = ScheduleAt, DesiredStartTime = DesiredStartTime)
  output <- .opensearchservice$update_scheduled_action_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$update_scheduled_action <- opensearchservice_update_scheduled_action

#' Modifies an Amazon OpenSearch Service-managed interface VPC endpoint
#'
#' @description
#' Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_update_vpc_endpoint/](https://www.paws-r-sdk.com/docs/opensearchservice_update_vpc_endpoint/) for full documentation.
#'
#' @param VpcEndpointId &#91;required&#93; The unique identifier of the endpoint.
#' @param VpcOptions &#91;required&#93; The security groups and/or subnets to add, remove, or modify.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_update_vpc_endpoint
opensearchservice_update_vpc_endpoint <- function(VpcEndpointId, VpcOptions) {
  op <- new_operation(
    name = "UpdateVpcEndpoint",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/vpcEndpoints/update",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$update_vpc_endpoint_input(VpcEndpointId = VpcEndpointId, VpcOptions = VpcOptions)
  output <- .opensearchservice$update_vpc_endpoint_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$update_vpc_endpoint <- opensearchservice_update_vpc_endpoint

#' Allows you to either upgrade your Amazon OpenSearch Service domain or
#' perform an upgrade eligibility check to a compatible version of
#' OpenSearch or Elasticsearch
#'
#' @description
#' Allows you to either upgrade your Amazon OpenSearch Service domain or perform an upgrade eligibility check to a compatible version of OpenSearch or Elasticsearch.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchservice_upgrade_domain/](https://www.paws-r-sdk.com/docs/opensearchservice_upgrade_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; Name of the OpenSearch Service domain that you want to upgrade.
#' @param TargetVersion &#91;required&#93; OpenSearch or Elasticsearch version to which you want to upgrade, in the
#' format Opensearch_X.Y or Elasticsearch_X.Y.
#' @param PerformCheckOnly When true, indicates that an upgrade eligibility check needs to be
#' performed. Does not actually perform the upgrade.
#' @param AdvancedOptions Only supports the `override_main_response_version` parameter and not
#' other advanced options. You can only include this option when upgrading
#' to an OpenSearch version. Specifies whether the domain reports its
#' version as 7.10 so that it continues to work with Elasticsearch OSS
#' clients and plugins.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_upgrade_domain
opensearchservice_upgrade_domain <- function(DomainName, TargetVersion, PerformCheckOnly = NULL, AdvancedOptions = NULL) {
  op <- new_operation(
    name = "UpgradeDomain",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/upgradeDomain",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchservice$upgrade_domain_input(DomainName = DomainName, TargetVersion = TargetVersion, PerformCheckOnly = PerformCheckOnly, AdvancedOptions = AdvancedOptions)
  output <- .opensearchservice$upgrade_domain_output()
  config <- get_config()
  svc <- .opensearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$upgrade_domain <- opensearchservice_upgrade_domain
