% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_list_stream_consumers}
\alias{kinesis_list_stream_consumers}
\title{Lists the consumers registered to receive data from a stream using
enhanced fan-out, and provides information about each consumer}
\usage{
kinesis_list_stream_consumers(
  StreamARN,
  NextToken = NULL,
  MaxResults = NULL,
  StreamCreationTimestamp = NULL
)
}
\arguments{
\item{StreamARN}{[required] The ARN of the Kinesis data stream for which you want to list the
registered consumers. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#arn-syntax-kinesis-streams}{Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces}.}

\item{NextToken}{When the number of consumers that are registered with the data stream is
greater than the default value for the \code{MaxResults} parameter, or if you
explicitly specify a value for \code{MaxResults} that is less than the number
of consumers that are registered with the data stream, the response
includes a pagination token named \code{NextToken}. You can specify this
\code{NextToken} value in a subsequent call to
\code{\link[=kinesis_list_stream_consumers]{list_stream_consumers}} to list the
next set of registered consumers.

Don't specify \code{StreamName} or \code{StreamCreationTimestamp} if you specify
\code{NextToken} because the latter unambiguously identifies the stream.

You can optionally specify a value for the \code{MaxResults} parameter when
you specify \code{NextToken}. If you specify a \code{MaxResults} value that is
less than the number of consumers that the operation returns if you
don't specify \code{MaxResults}, the response will contain a new \code{NextToken}
value. You can use the new \code{NextToken} value in a subsequent call to the
\code{\link[=kinesis_list_stream_consumers]{list_stream_consumers}} operation to
list the next set of consumers.

Tokens expire after 300 seconds. When you obtain a value for \code{NextToken}
in the response to a call to
\code{\link[=kinesis_list_stream_consumers]{list_stream_consumers}}, you have 300
seconds to use that value. If you specify an expired token in a call to
\code{\link[=kinesis_list_stream_consumers]{list_stream_consumers}}, you get
\code{ExpiredNextTokenException}.}

\item{MaxResults}{The maximum number of consumers that you want a single call of
\code{\link[=kinesis_list_stream_consumers]{list_stream_consumers}} to return. The
default value is 100. If you specify a value greater than 100, at most
100 results are returned.}

\item{StreamCreationTimestamp}{Specify this input parameter to distinguish data streams that have the
same name. For example, if you create a data stream and then delete it,
and you later create another data stream with the same name, you can use
this input parameter to specify which of the two streams you want to
list the consumers for.

You can't specify this parameter if you specify the NextToken parameter.}
}
\description{
Lists the consumers registered to receive data from a stream using enhanced fan-out, and provides information about each consumer.

See \url{https://www.paws-r-sdk.com/docs/kinesis_list_stream_consumers/} for full documentation.
}
\keyword{internal}
