# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include sns_service.R
NULL

#' Adds a statement to a topic's access control policy, granting access for
#' the specified AWS accounts to the specified actions
#'
#' Adds a statement to a topic\'s access control policy, granting access
#' for the specified AWS accounts to the specified actions.
#'
#' @usage
#' sns_add_permission(TopicArn, Label, AWSAccountId, ActionName)
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic whose access control policy you wish to modify.
#' @param Label &#91;required&#93; A unique identifier for the new policy statement.
#' @param AWSAccountId &#91;required&#93; The AWS account IDs of the users (principals) who will be given access
#' to the specified actions. The users must have AWS accounts, but do not
#' need to be signed up for this service.
#' @param ActionName &#91;required&#93; The action you want to allow for the specified principal(s).
#' 
#' Valid values: any Amazon SNS action name.
#'
#' @section Request syntax:
#' ```
#' svc$add_permission(
#'   TopicArn = "string",
#'   Label = "string",
#'   AWSAccountId = list(
#'     "string"
#'   ),
#'   ActionName = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_add_permission
sns_add_permission <- function(TopicArn, Label, AWSAccountId, ActionName) {
  op <- new_operation(
    name = "AddPermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$add_permission_input(TopicArn = TopicArn, Label = Label, AWSAccountId = AWSAccountId, ActionName = ActionName)
  output <- .sns$add_permission_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$add_permission <- sns_add_permission

#' Accepts a phone number and indicates whether the phone holder has opted
#' out of receiving SMS messages from your account
#'
#' Accepts a phone number and indicates whether the phone holder has opted
#' out of receiving SMS messages from your account. You cannot send SMS
#' messages to a number that is opted out.
#' 
#' To resume sending messages, you can opt in the number by using the
#' `OptInPhoneNumber` action.
#'
#' @usage
#' sns_check_if_phone_number_is_opted_out(phoneNumber)
#'
#' @param phoneNumber &#91;required&#93; The phone number for which you want to check the opt out status.
#'
#' @section Request syntax:
#' ```
#' svc$check_if_phone_number_is_opted_out(
#'   phoneNumber = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_check_if_phone_number_is_opted_out
sns_check_if_phone_number_is_opted_out <- function(phoneNumber) {
  op <- new_operation(
    name = "CheckIfPhoneNumberIsOptedOut",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$check_if_phone_number_is_opted_out_input(phoneNumber = phoneNumber)
  output <- .sns$check_if_phone_number_is_opted_out_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$check_if_phone_number_is_opted_out <- sns_check_if_phone_number_is_opted_out

#' Verifies an endpoint owner's intent to receive messages by validating
#' the token sent to the endpoint by an earlier Subscribe action
#'
#' Verifies an endpoint owner\'s intent to receive messages by validating
#' the token sent to the endpoint by an earlier `Subscribe` action. If the
#' token is valid, the action creates a new subscription and returns its
#' Amazon Resource Name (ARN). This call requires an AWS signature only
#' when the `AuthenticateOnUnsubscribe` flag is set to \"true\".
#'
#' @usage
#' sns_confirm_subscription(TopicArn, Token, AuthenticateOnUnsubscribe)
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic for which you wish to confirm a subscription.
#' @param Token &#91;required&#93; Short-lived token sent to an endpoint during the `Subscribe` action.
#' @param AuthenticateOnUnsubscribe Disallows unauthenticated unsubscribes of the subscription. If the value
#' of this parameter is `true` and the request has an AWS signature, then
#' only the topic owner and the subscription owner can unsubscribe the
#' endpoint. The unsubscribe action requires AWS authentication.
#'
#' @section Request syntax:
#' ```
#' svc$confirm_subscription(
#'   TopicArn = "string",
#'   Token = "string",
#'   AuthenticateOnUnsubscribe = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_confirm_subscription
sns_confirm_subscription <- function(TopicArn, Token, AuthenticateOnUnsubscribe = NULL) {
  op <- new_operation(
    name = "ConfirmSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$confirm_subscription_input(TopicArn = TopicArn, Token = Token, AuthenticateOnUnsubscribe = AuthenticateOnUnsubscribe)
  output <- .sns$confirm_subscription_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$confirm_subscription <- sns_confirm_subscription

#' Creates a platform application object for one of the supported push
#' notification services, such as APNS and GCM, to which devices and mobile
#' apps may register
#'
#' Creates a platform application object for one of the supported push
#' notification services, such as APNS and GCM, to which devices and mobile
#' apps may register. You must specify PlatformPrincipal and
#' PlatformCredential attributes when using the `CreatePlatformApplication`
#' action. The PlatformPrincipal is received from the notification service.
#' For APNS/APNS\\_SANDBOX, PlatformPrincipal is \"SSL certificate\". For
#' GCM, PlatformPrincipal is not applicable. For ADM, PlatformPrincipal is
#' \"client id\". The PlatformCredential is also received from the
#' notification service. For WNS, PlatformPrincipal is \"Package Security
#' Identifier\". For MPNS, PlatformPrincipal is \"TLS certificate\". For
#' Baidu, PlatformPrincipal is \"API key\".
#' 
#' For APNS/APNS\\_SANDBOX, PlatformCredential is \"private key\". For GCM,
#' PlatformCredential is \"API key\". For ADM, PlatformCredential is
#' \"client secret\". For WNS, PlatformCredential is \"secret key\". For
#' MPNS, PlatformCredential is \"private key\". For Baidu,
#' PlatformCredential is \"secret key\". The PlatformApplicationArn that is
#' returned when using `CreatePlatformApplication` is then used as an
#' attribute for the `CreatePlatformEndpoint` action. For more information,
#' see [Using Amazon SNS Mobile Push
#' Notifications](http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
#' For more information about obtaining the PlatformPrincipal and
#' PlatformCredential for each of the supported push notification services,
#' see [Getting Started with Apple Push Notification
#' Service](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-apns.html),
#' [Getting Started with Amazon Device
#' Messaging](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-adm.html),
#' [Getting Started with Baidu Cloud
#' Push](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-baidu.html),
#' [Getting Started with Google Cloud Messaging for
#' Android](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-gcm.html),
#' [Getting Started with
#' MPNS](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-mpns.html),
#' or [Getting Started with
#' WNS](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-wns.html).
#'
#' @usage
#' sns_create_platform_application(Name, Platform, Attributes)
#'
#' @param Name &#91;required&#93; Application names must be made up of only uppercase and lowercase ASCII
#' letters, numbers, underscores, hyphens, and periods, and must be between
#' 1 and 256 characters long.
#' @param Platform &#91;required&#93; The following platforms are supported: ADM (Amazon Device Messaging),
#' APNS (Apple Push Notification Service), APNS\\_SANDBOX, and GCM (Google
#' Cloud Messaging).
#' @param Attributes &#91;required&#93; For a list of attributes, see
#' [SetPlatformApplicationAttributes](http://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html)
#'
#' @section Request syntax:
#' ```
#' svc$create_platform_application(
#'   Name = "string",
#'   Platform = "string",
#'   Attributes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_create_platform_application
sns_create_platform_application <- function(Name, Platform, Attributes) {
  op <- new_operation(
    name = "CreatePlatformApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$create_platform_application_input(Name = Name, Platform = Platform, Attributes = Attributes)
  output <- .sns$create_platform_application_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$create_platform_application <- sns_create_platform_application

#' Creates an endpoint for a device and mobile app on one of the supported
#' push notification services, such as GCM and APNS
#'
#' Creates an endpoint for a device and mobile app on one of the supported
#' push notification services, such as GCM and APNS.
#' `CreatePlatformEndpoint` requires the PlatformApplicationArn that is
#' returned from `CreatePlatformApplication`. The EndpointArn that is
#' returned when using `CreatePlatformEndpoint` can then be used by the
#' `Publish` action to send a message to a mobile app or by the `Subscribe`
#' action for subscription to a topic. The `CreatePlatformEndpoint` action
#' is idempotent, so if the requester already owns an endpoint with the
#' same device token and attributes, that endpoint\'s ARN is returned
#' without creating a new endpoint. For more information, see [Using Amazon
#' SNS Mobile Push
#' Notifications](http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
#' 
#' When using `CreatePlatformEndpoint` with Baidu, two attributes must be
#' provided: ChannelId and UserId. The token field must also contain the
#' ChannelId. For more information, see [Creating an Amazon SNS Endpoint
#' for
#' Baidu](http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePushBaiduEndpoint.html).
#'
#' @usage
#' sns_create_platform_endpoint(PlatformApplicationArn, Token,
#'   CustomUserData, Attributes)
#'
#' @param PlatformApplicationArn &#91;required&#93; PlatformApplicationArn returned from CreatePlatformApplication is used
#' to create a an endpoint.
#' @param Token &#91;required&#93; Unique identifier created by the notification service for an app on a
#' device. The specific name for Token will vary, depending on which
#' notification service is being used. For example, when using APNS as the
#' notification service, you need the device token. Alternatively, when
#' using GCM or ADM, the device token equivalent is called the registration
#' ID.
#' @param CustomUserData Arbitrary user data to associate with the endpoint. Amazon SNS does not
#' use this data. The data must be in UTF-8 format and less than 2KB.
#' @param Attributes For a list of attributes, see
#' [SetEndpointAttributes](http://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_platform_endpoint(
#'   PlatformApplicationArn = "string",
#'   Token = "string",
#'   CustomUserData = "string",
#'   Attributes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_create_platform_endpoint
sns_create_platform_endpoint <- function(PlatformApplicationArn, Token, CustomUserData = NULL, Attributes = NULL) {
  op <- new_operation(
    name = "CreatePlatformEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$create_platform_endpoint_input(PlatformApplicationArn = PlatformApplicationArn, Token = Token, CustomUserData = CustomUserData, Attributes = Attributes)
  output <- .sns$create_platform_endpoint_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$create_platform_endpoint <- sns_create_platform_endpoint

#' Creates a topic to which notifications can be published
#'
#' Creates a topic to which notifications can be published. Users can
#' create at most 100,000 topics. For more information, see
#' [http://aws.amazon.com/sns](http://aws.amazon.com/sns/). This action is
#' idempotent, so if the requester already owns a topic with the specified
#' name, that topic\'s ARN is returned without creating a new topic.
#'
#' @usage
#' sns_create_topic(Name, Attributes)
#'
#' @param Name &#91;required&#93; The name of the topic you want to create.
#' 
#' Constraints: Topic names must be made up of only uppercase and lowercase
#' ASCII letters, numbers, underscores, and hyphens, and must be between 1
#' and 256 characters long.
#' @param Attributes A map of attributes with their corresponding values.
#' 
#' The following lists the names, descriptions, and values of the special
#' request parameters that the `CreateTopic` action uses:
#' 
#' -   `DeliveryPolicy` -- The policy that defines how Amazon SNS retries
#'     failed deliveries to HTTP/S endpoints.
#' 
#' -   `DisplayName` -- The display name to use for a topic with SMS
#'     subscriptions.
#' 
#' -   `Policy` -- The policy that defines who can access your topic. By
#'     default, only the topic owner can publish or subscribe to the topic.
#'
#' @section Request syntax:
#' ```
#' svc$create_topic(
#'   Name = "string",
#'   Attributes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_create_topic
sns_create_topic <- function(Name, Attributes = NULL) {
  op <- new_operation(
    name = "CreateTopic",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$create_topic_input(Name = Name, Attributes = Attributes)
  output <- .sns$create_topic_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$create_topic <- sns_create_topic

#' Deletes the endpoint for a device and mobile app from Amazon SNS
#'
#' Deletes the endpoint for a device and mobile app from Amazon SNS. This
#' action is idempotent. For more information, see [Using Amazon SNS Mobile
#' Push
#' Notifications](http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
#' 
#' When you delete an endpoint that is also subscribed to a topic, then you
#' must also unsubscribe the endpoint from the topic.
#'
#' @usage
#' sns_delete_endpoint(EndpointArn)
#'
#' @param EndpointArn &#91;required&#93; EndpointArn of endpoint to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_endpoint(
#'   EndpointArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_delete_endpoint
sns_delete_endpoint <- function(EndpointArn) {
  op <- new_operation(
    name = "DeleteEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$delete_endpoint_input(EndpointArn = EndpointArn)
  output <- .sns$delete_endpoint_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$delete_endpoint <- sns_delete_endpoint

#' Deletes a platform application object for one of the supported push
#' notification services, such as APNS and GCM
#'
#' Deletes a platform application object for one of the supported push
#' notification services, such as APNS and GCM. For more information, see
#' [Using Amazon SNS Mobile Push
#' Notifications](http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
#'
#' @usage
#' sns_delete_platform_application(PlatformApplicationArn)
#'
#' @param PlatformApplicationArn &#91;required&#93; PlatformApplicationArn of platform application object to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_platform_application(
#'   PlatformApplicationArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_delete_platform_application
sns_delete_platform_application <- function(PlatformApplicationArn) {
  op <- new_operation(
    name = "DeletePlatformApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$delete_platform_application_input(PlatformApplicationArn = PlatformApplicationArn)
  output <- .sns$delete_platform_application_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$delete_platform_application <- sns_delete_platform_application

#' Deletes a topic and all its subscriptions
#'
#' Deletes a topic and all its subscriptions. Deleting a topic might
#' prevent some messages previously sent to the topic from being delivered
#' to subscribers. This action is idempotent, so deleting a topic that does
#' not exist does not result in an error.
#'
#' @usage
#' sns_delete_topic(TopicArn)
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_topic(
#'   TopicArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_delete_topic
sns_delete_topic <- function(TopicArn) {
  op <- new_operation(
    name = "DeleteTopic",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$delete_topic_input(TopicArn = TopicArn)
  output <- .sns$delete_topic_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$delete_topic <- sns_delete_topic

#' Retrieves the endpoint attributes for a device on one of the supported
#' push notification services, such as GCM and APNS
#'
#' Retrieves the endpoint attributes for a device on one of the supported
#' push notification services, such as GCM and APNS. For more information,
#' see [Using Amazon SNS Mobile Push
#' Notifications](http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
#'
#' @usage
#' sns_get_endpoint_attributes(EndpointArn)
#'
#' @param EndpointArn &#91;required&#93; EndpointArn for GetEndpointAttributes input.
#'
#' @section Request syntax:
#' ```
#' svc$get_endpoint_attributes(
#'   EndpointArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_get_endpoint_attributes
sns_get_endpoint_attributes <- function(EndpointArn) {
  op <- new_operation(
    name = "GetEndpointAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$get_endpoint_attributes_input(EndpointArn = EndpointArn)
  output <- .sns$get_endpoint_attributes_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$get_endpoint_attributes <- sns_get_endpoint_attributes

#' Retrieves the attributes of the platform application object for the
#' supported push notification services, such as APNS and GCM
#'
#' Retrieves the attributes of the platform application object for the
#' supported push notification services, such as APNS and GCM. For more
#' information, see [Using Amazon SNS Mobile Push
#' Notifications](http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
#'
#' @usage
#' sns_get_platform_application_attributes(PlatformApplicationArn)
#'
#' @param PlatformApplicationArn &#91;required&#93; PlatformApplicationArn for GetPlatformApplicationAttributesInput.
#'
#' @section Request syntax:
#' ```
#' svc$get_platform_application_attributes(
#'   PlatformApplicationArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_get_platform_application_attributes
sns_get_platform_application_attributes <- function(PlatformApplicationArn) {
  op <- new_operation(
    name = "GetPlatformApplicationAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$get_platform_application_attributes_input(PlatformApplicationArn = PlatformApplicationArn)
  output <- .sns$get_platform_application_attributes_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$get_platform_application_attributes <- sns_get_platform_application_attributes

#' Returns the settings for sending SMS messages from your account
#'
#' Returns the settings for sending SMS messages from your account.
#' 
#' These settings are set with the `SetSMSAttributes` action.
#'
#' @usage
#' sns_get_sms_attributes(attributes)
#'
#' @param attributes A list of the individual attribute names, such as `MonthlySpendLimit`,
#' for which you want values.
#' 
#' For all attribute names, see
#' [SetSMSAttributes](http://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html).
#' 
#' If you don\'t use this parameter, Amazon SNS returns all SMS attributes.
#'
#' @section Request syntax:
#' ```
#' svc$get_sms_attributes(
#'   attributes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_get_sms_attributes
sns_get_sms_attributes <- function(attributes = NULL) {
  op <- new_operation(
    name = "GetSMSAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$get_sms_attributes_input(attributes = attributes)
  output <- .sns$get_sms_attributes_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$get_sms_attributes <- sns_get_sms_attributes

#' Returns all of the properties of a subscription
#'
#' Returns all of the properties of a subscription.
#'
#' @usage
#' sns_get_subscription_attributes(SubscriptionArn)
#'
#' @param SubscriptionArn &#91;required&#93; The ARN of the subscription whose properties you want to get.
#'
#' @section Request syntax:
#' ```
#' svc$get_subscription_attributes(
#'   SubscriptionArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_get_subscription_attributes
sns_get_subscription_attributes <- function(SubscriptionArn) {
  op <- new_operation(
    name = "GetSubscriptionAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$get_subscription_attributes_input(SubscriptionArn = SubscriptionArn)
  output <- .sns$get_subscription_attributes_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$get_subscription_attributes <- sns_get_subscription_attributes

#' Returns all of the properties of a topic
#'
#' Returns all of the properties of a topic. Topic properties returned
#' might differ based on the authorization of the user.
#'
#' @usage
#' sns_get_topic_attributes(TopicArn)
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic whose properties you want to get.
#'
#' @section Request syntax:
#' ```
#' svc$get_topic_attributes(
#'   TopicArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_get_topic_attributes
sns_get_topic_attributes <- function(TopicArn) {
  op <- new_operation(
    name = "GetTopicAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$get_topic_attributes_input(TopicArn = TopicArn)
  output <- .sns$get_topic_attributes_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$get_topic_attributes <- sns_get_topic_attributes

#' Lists the endpoints and endpoint attributes for devices in a supported
#' push notification service, such as GCM and APNS
#'
#' Lists the endpoints and endpoint attributes for devices in a supported
#' push notification service, such as GCM and APNS. The results for
#' `ListEndpointsByPlatformApplication` are paginated and return a limited
#' list of endpoints, up to 100. If additional records are available after
#' the first page results, then a NextToken string will be returned. To
#' receive the next page, you call `ListEndpointsByPlatformApplication`
#' again using the NextToken string received from the previous call. When
#' there are no more records to return, NextToken will be null. For more
#' information, see [Using Amazon SNS Mobile Push
#' Notifications](http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
#' 
#' This action is throttled at 30 transactions per second (TPS).
#'
#' @usage
#' sns_list_endpoints_by_platform_application(PlatformApplicationArn,
#'   NextToken)
#'
#' @param PlatformApplicationArn &#91;required&#93; PlatformApplicationArn for ListEndpointsByPlatformApplicationInput
#' action.
#' @param NextToken NextToken string is used when calling ListEndpointsByPlatformApplication
#' action to retrieve additional records that are available after the first
#' page results.
#'
#' @section Request syntax:
#' ```
#' svc$list_endpoints_by_platform_application(
#'   PlatformApplicationArn = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_list_endpoints_by_platform_application
sns_list_endpoints_by_platform_application <- function(PlatformApplicationArn, NextToken = NULL) {
  op <- new_operation(
    name = "ListEndpointsByPlatformApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$list_endpoints_by_platform_application_input(PlatformApplicationArn = PlatformApplicationArn, NextToken = NextToken)
  output <- .sns$list_endpoints_by_platform_application_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_endpoints_by_platform_application <- sns_list_endpoints_by_platform_application

#' Returns a list of phone numbers that are opted out, meaning you cannot
#' send SMS messages to them
#'
#' Returns a list of phone numbers that are opted out, meaning you cannot
#' send SMS messages to them.
#' 
#' The results for `ListPhoneNumbersOptedOut` are paginated, and each page
#' returns up to 100 phone numbers. If additional phone numbers are
#' available after the first page of results, then a `NextToken` string
#' will be returned. To receive the next page, you call
#' `ListPhoneNumbersOptedOut` again using the `NextToken` string received
#' from the previous call. When there are no more records to return,
#' `NextToken` will be null.
#'
#' @usage
#' sns_list_phone_numbers_opted_out(nextToken)
#'
#' @param nextToken A `NextToken` string is used when you call the
#' `ListPhoneNumbersOptedOut` action to retrieve additional records that
#' are available after the first page of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_phone_numbers_opted_out(
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_list_phone_numbers_opted_out
sns_list_phone_numbers_opted_out <- function(nextToken = NULL) {
  op <- new_operation(
    name = "ListPhoneNumbersOptedOut",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$list_phone_numbers_opted_out_input(nextToken = nextToken)
  output <- .sns$list_phone_numbers_opted_out_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_phone_numbers_opted_out <- sns_list_phone_numbers_opted_out

#' Lists the platform application objects for the supported push
#' notification services, such as APNS and GCM
#'
#' Lists the platform application objects for the supported push
#' notification services, such as APNS and GCM. The results for
#' `ListPlatformApplications` are paginated and return a limited list of
#' applications, up to 100. If additional records are available after the
#' first page results, then a NextToken string will be returned. To receive
#' the next page, you call `ListPlatformApplications` using the NextToken
#' string received from the previous call. When there are no more records
#' to return, NextToken will be null. For more information, see [Using
#' Amazon SNS Mobile Push
#' Notifications](http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
#' 
#' This action is throttled at 15 transactions per second (TPS).
#'
#' @usage
#' sns_list_platform_applications(NextToken)
#'
#' @param NextToken NextToken string is used when calling ListPlatformApplications action to
#' retrieve additional records that are available after the first page
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_platform_applications(
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_list_platform_applications
sns_list_platform_applications <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListPlatformApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$list_platform_applications_input(NextToken = NextToken)
  output <- .sns$list_platform_applications_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_platform_applications <- sns_list_platform_applications

#' Returns a list of the requester's subscriptions
#'
#' Returns a list of the requester\'s subscriptions. Each call returns a
#' limited list of subscriptions, up to 100. If there are more
#' subscriptions, a `NextToken` is also returned. Use the `NextToken`
#' parameter in a new `ListSubscriptions` call to get further results.
#' 
#' This action is throttled at 30 transactions per second (TPS).
#'
#' @usage
#' sns_list_subscriptions(NextToken)
#'
#' @param NextToken Token returned by the previous `ListSubscriptions` request.
#'
#' @section Request syntax:
#' ```
#' svc$list_subscriptions(
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_list_subscriptions
sns_list_subscriptions <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListSubscriptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$list_subscriptions_input(NextToken = NextToken)
  output <- .sns$list_subscriptions_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_subscriptions <- sns_list_subscriptions

#' Returns a list of the subscriptions to a specific topic
#'
#' Returns a list of the subscriptions to a specific topic. Each call
#' returns a limited list of subscriptions, up to 100. If there are more
#' subscriptions, a `NextToken` is also returned. Use the `NextToken`
#' parameter in a new `ListSubscriptionsByTopic` call to get further
#' results.
#' 
#' This action is throttled at 30 transactions per second (TPS).
#'
#' @usage
#' sns_list_subscriptions_by_topic(TopicArn, NextToken)
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic for which you wish to find subscriptions.
#' @param NextToken Token returned by the previous `ListSubscriptionsByTopic` request.
#'
#' @section Request syntax:
#' ```
#' svc$list_subscriptions_by_topic(
#'   TopicArn = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_list_subscriptions_by_topic
sns_list_subscriptions_by_topic <- function(TopicArn, NextToken = NULL) {
  op <- new_operation(
    name = "ListSubscriptionsByTopic",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$list_subscriptions_by_topic_input(TopicArn = TopicArn, NextToken = NextToken)
  output <- .sns$list_subscriptions_by_topic_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_subscriptions_by_topic <- sns_list_subscriptions_by_topic

#' Returns a list of the requester's topics
#'
#' Returns a list of the requester\'s topics. Each call returns a limited
#' list of topics, up to 100. If there are more topics, a `NextToken` is
#' also returned. Use the `NextToken` parameter in a new `ListTopics` call
#' to get further results.
#' 
#' This action is throttled at 30 transactions per second (TPS).
#'
#' @usage
#' sns_list_topics(NextToken)
#'
#' @param NextToken Token returned by the previous `ListTopics` request.
#'
#' @section Request syntax:
#' ```
#' svc$list_topics(
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_list_topics
sns_list_topics <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListTopics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$list_topics_input(NextToken = NextToken)
  output <- .sns$list_topics_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_topics <- sns_list_topics

#' Use this request to opt in a phone number that is opted out, which
#' enables you to resume sending SMS messages to the number
#'
#' Use this request to opt in a phone number that is opted out, which
#' enables you to resume sending SMS messages to the number.
#' 
#' You can opt in a phone number only once every 30 days.
#'
#' @usage
#' sns_opt_in_phone_number(phoneNumber)
#'
#' @param phoneNumber &#91;required&#93; The phone number to opt in.
#'
#' @section Request syntax:
#' ```
#' svc$opt_in_phone_number(
#'   phoneNumber = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_opt_in_phone_number
sns_opt_in_phone_number <- function(phoneNumber) {
  op <- new_operation(
    name = "OptInPhoneNumber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$opt_in_phone_number_input(phoneNumber = phoneNumber)
  output <- .sns$opt_in_phone_number_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$opt_in_phone_number <- sns_opt_in_phone_number

#' Sends a message to an Amazon SNS topic or sends a text message (SMS
#' message) directly to a phone number
#'
#' Sends a message to an Amazon SNS topic or sends a text message (SMS
#' message) directly to a phone number.
#' 
#' If you send a message to a topic, Amazon SNS delivers the message to
#' each endpoint that is subscribed to the topic. The format of the message
#' depends on the notification protocol for each subscribed endpoint.
#' 
#' When a `messageId` is returned, the message has been saved and Amazon
#' SNS will attempt to deliver it shortly.
#' 
#' To use the `Publish` action for sending a message to a mobile endpoint,
#' such as an app on a Kindle device or mobile phone, you must specify the
#' EndpointArn for the TargetArn parameter. The EndpointArn is returned
#' when making a call with the `CreatePlatformEndpoint` action.
#' 
#' For more information about formatting messages, see [Send Custom
#' Platform-Specific Payloads in Messages to Mobile
#' Devices](http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-custommessage.html).
#'
#' @usage
#' sns_publish(TopicArn, TargetArn, PhoneNumber, Message, Subject,
#'   MessageStructure, MessageAttributes)
#'
#' @param TopicArn The topic you want to publish to.
#' 
#' If you don\'t specify a value for the `TopicArn` parameter, you must
#' specify a value for the `PhoneNumber` or `TargetArn` parameters.
#' @param TargetArn Either TopicArn or EndpointArn, but not both.
#' 
#' If you don\'t specify a value for the `TargetArn` parameter, you must
#' specify a value for the `PhoneNumber` or `TopicArn` parameters.
#' @param PhoneNumber The phone number to which you want to deliver an SMS message. Use E.164
#' format.
#' 
#' If you don\'t specify a value for the `PhoneNumber` parameter, you must
#' specify a value for the `TargetArn` or `TopicArn` parameters.
#' @param Message &#91;required&#93; The message you want to send.
#' 
#' The `Message` parameter is always a string. If you set
#' `MessageStructure` to `json`, you must string-encode the `Message`
#' parameter.
#' 
#' If you are publishing to a topic and you want to send the same message
#' to all transport protocols, include the text of the message as a String
#' value. If you want to send different messages for each transport
#' protocol, set the value of the `MessageStructure` parameter to `json`
#' and use a JSON object for the `Message` parameter.
#' 
#' Constraints:
#' 
#' -   With the exception of SMS, messages must be UTF-8 encoded strings
#'     and at most 256 KB in size (262,144 bytes, not 262,144 characters).
#' 
#' -   For SMS, each message can contain up to 140 characters. This
#'     character limit depends on the encoding schema. For example, an SMS
#'     message can contain 160 GSM characters, 140 ASCII characters, or 70
#'     UCS-2 characters.
#' 
#'     If you publish a message that exceeds this size limit, Amazon SNS
#'     sends the message as multiple messages, each fitting within the size
#'     limit. Messages aren\'t truncated mid-word but are cut off at
#'     whole-word boundaries.
#' 
#'     The total size limit for a single SMS `Publish` action is 1,600
#'     characters.
#' 
#' JSON-specific constraints:
#' 
#' -   Keys in the JSON object that correspond to supported transport
#'     protocols must have simple JSON string values.
#' 
#' -   The values will be parsed (unescaped) before they are used in
#'     outgoing messages.
#' 
#' -   Outbound notifications are JSON encoded (meaning that the characters
#'     will be reescaped for sending).
#' 
#' -   Values have a minimum length of 0 (the empty string, \"\", is
#'     allowed).
#' 
#' -   Values have a maximum length bounded by the overall message size
#'     (so, including multiple protocols may limit message sizes).
#' 
#' -   Non-string values will cause the key to be ignored.
#' 
#' -   Keys that do not correspond to supported transport protocols are
#'     ignored.
#' 
#' -   Duplicate keys are not allowed.
#' 
#' -   Failure to parse or validate any key or value in the message will
#'     cause the `Publish` call to return an error (no partial delivery).
#' @param Subject Optional parameter to be used as the \"Subject\" line when the message
#' is delivered to email endpoints. This field will also be included, if
#' present, in the standard JSON messages delivered to other endpoints.
#' 
#' Constraints: Subjects must be ASCII text that begins with a letter,
#' number, or punctuation mark; must not include line breaks or control
#' characters; and must be less than 100 characters long.
#' @param MessageStructure Set `MessageStructure` to `json` if you want to send a different message
#' for each protocol. For example, using one publish action, you can send a
#' short message to your SMS subscribers and a longer message to your email
#' subscribers. If you set `MessageStructure` to `json`, the value of the
#' `Message` parameter must:
#' 
#' -   be a syntactically valid JSON object; and
#' 
#' -   contain at least a top-level JSON key of \"default\" with a value
#'     that is a string.
#' 
#' You can define other top-level keys that define the message you want to
#' send to a specific transport protocol (e.g., \"http\").
#' 
#' For information about sending different messages for each protocol using
#' the AWS Management Console, go to [Create Different Messages for Each
#' Protocol](http://docs.aws.amazon.com/sns/latest/gsg/Publish.html#sns-message-formatting-by-protocol)
#' in the *Amazon Simple Notification Service Getting Started Guide*.
#' 
#' Valid value: `json`
#' @param MessageAttributes Message attributes for Publish action.
#'
#' @section Request syntax:
#' ```
#' svc$publish(
#'   TopicArn = "string",
#'   TargetArn = "string",
#'   PhoneNumber = "string",
#'   Message = "string",
#'   Subject = "string",
#'   MessageStructure = "string",
#'   MessageAttributes = list(
#'     list(
#'       DataType = "string",
#'       StringValue = "string",
#'       BinaryValue = raw
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_publish
sns_publish <- function(TopicArn = NULL, TargetArn = NULL, PhoneNumber = NULL, Message, Subject = NULL, MessageStructure = NULL, MessageAttributes = NULL) {
  op <- new_operation(
    name = "Publish",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$publish_input(TopicArn = TopicArn, TargetArn = TargetArn, PhoneNumber = PhoneNumber, Message = Message, Subject = Subject, MessageStructure = MessageStructure, MessageAttributes = MessageAttributes)
  output <- .sns$publish_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$publish <- sns_publish

#' Removes a statement from a topic's access control policy
#'
#' Removes a statement from a topic\'s access control policy.
#'
#' @usage
#' sns_remove_permission(TopicArn, Label)
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic whose access control policy you wish to modify.
#' @param Label &#91;required&#93; The unique label of the statement you want to remove.
#'
#' @section Request syntax:
#' ```
#' svc$remove_permission(
#'   TopicArn = "string",
#'   Label = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_remove_permission
sns_remove_permission <- function(TopicArn, Label) {
  op <- new_operation(
    name = "RemovePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$remove_permission_input(TopicArn = TopicArn, Label = Label)
  output <- .sns$remove_permission_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$remove_permission <- sns_remove_permission

#' Sets the attributes for an endpoint for a device on one of the supported
#' push notification services, such as GCM and APNS
#'
#' Sets the attributes for an endpoint for a device on one of the supported
#' push notification services, such as GCM and APNS. For more information,
#' see [Using Amazon SNS Mobile Push
#' Notifications](http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
#'
#' @usage
#' sns_set_endpoint_attributes(EndpointArn, Attributes)
#'
#' @param EndpointArn &#91;required&#93; EndpointArn used for SetEndpointAttributes action.
#' @param Attributes &#91;required&#93; A map of the endpoint attributes. Attributes in this map include the
#' following:
#' 
#' -   `CustomUserData` -- arbitrary user data to associate with the
#'     endpoint. Amazon SNS does not use this data. The data must be in
#'     UTF-8 format and less than 2KB.
#' 
#' -   `Enabled` -- flag that enables/disables delivery to the endpoint.
#'     Amazon SNS will set this to false when a notification service
#'     indicates to Amazon SNS that the endpoint is invalid. Users can set
#'     it back to true, typically after updating Token.
#' 
#' -   `Token` -- device token, also referred to as a registration id, for
#'     an app and mobile device. This is returned from the notification
#'     service when an app and mobile device are registered with the
#'     notification service.
#'
#' @section Request syntax:
#' ```
#' svc$set_endpoint_attributes(
#'   EndpointArn = "string",
#'   Attributes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_set_endpoint_attributes
sns_set_endpoint_attributes <- function(EndpointArn, Attributes) {
  op <- new_operation(
    name = "SetEndpointAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$set_endpoint_attributes_input(EndpointArn = EndpointArn, Attributes = Attributes)
  output <- .sns$set_endpoint_attributes_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$set_endpoint_attributes <- sns_set_endpoint_attributes

#' Sets the attributes of the platform application object for the supported
#' push notification services, such as APNS and GCM
#'
#' Sets the attributes of the platform application object for the supported
#' push notification services, such as APNS and GCM. For more information,
#' see [Using Amazon SNS Mobile Push
#' Notifications](http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
#' For information on configuring attributes for message delivery status,
#' see [Using Amazon SNS Application Attributes for Message Delivery
#' Status](http://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html).
#'
#' @usage
#' sns_set_platform_application_attributes(PlatformApplicationArn,
#'   Attributes)
#'
#' @param PlatformApplicationArn &#91;required&#93; PlatformApplicationArn for SetPlatformApplicationAttributes action.
#' @param Attributes &#91;required&#93; A map of the platform application attributes. Attributes in this map
#' include the following:
#' 
#' -   `PlatformCredential` -- The credential received from the
#'     notification service. For APNS/APNS\\_SANDBOX, PlatformCredential is
#'     private key. For GCM, PlatformCredential is \"API key\". For ADM,
#'     PlatformCredential is \"client secret\".
#' 
#' -   `PlatformPrincipal` -- The principal received from the notification
#'     service. For APNS/APNS\\_SANDBOX, PlatformPrincipal is SSL
#'     certificate. For GCM, PlatformPrincipal is not applicable. For ADM,
#'     PlatformPrincipal is \"client id\".
#' 
#' -   `EventEndpointCreated` -- Topic ARN to which EndpointCreated event
#'     notifications should be sent.
#' 
#' -   `EventEndpointDeleted` -- Topic ARN to which EndpointDeleted event
#'     notifications should be sent.
#' 
#' -   `EventEndpointUpdated` -- Topic ARN to which EndpointUpdate event
#'     notifications should be sent.
#' 
#' -   `EventDeliveryFailure` -- Topic ARN to which DeliveryFailure event
#'     notifications should be sent upon Direct Publish delivery failure
#'     (permanent) to one of the application\'s endpoints.
#' 
#' -   `SuccessFeedbackRoleArn` -- IAM role ARN used to give Amazon SNS
#'     write access to use CloudWatch Logs on your behalf.
#' 
#' -   `FailureFeedbackRoleArn` -- IAM role ARN used to give Amazon SNS
#'     write access to use CloudWatch Logs on your behalf.
#' 
#' -   `SuccessFeedbackSampleRate` -- Sample rate percentage (0-100) of
#'     successfully delivered messages.
#'
#' @section Request syntax:
#' ```
#' svc$set_platform_application_attributes(
#'   PlatformApplicationArn = "string",
#'   Attributes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_set_platform_application_attributes
sns_set_platform_application_attributes <- function(PlatformApplicationArn, Attributes) {
  op <- new_operation(
    name = "SetPlatformApplicationAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$set_platform_application_attributes_input(PlatformApplicationArn = PlatformApplicationArn, Attributes = Attributes)
  output <- .sns$set_platform_application_attributes_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$set_platform_application_attributes <- sns_set_platform_application_attributes

#' Use this request to set the default settings for sending SMS messages
#' and receiving daily SMS usage reports
#'
#' Use this request to set the default settings for sending SMS messages
#' and receiving daily SMS usage reports.
#' 
#' You can override some of these settings for a single message when you
#' use the `Publish` action with the `MessageAttributes.entry.N` parameter.
#' For more information, see [Sending an SMS
#' Message](http://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html)
#' in the *Amazon SNS Developer Guide*.
#'
#' @usage
#' sns_set_sms_attributes(attributes)
#'
#' @param attributes &#91;required&#93; The default settings for sending SMS messages from your account. You can
#' set values for the following attribute names:
#' 
#' `MonthlySpendLimit` -- The maximum amount in USD that you are willing to
#' spend each month to send SMS messages. When Amazon SNS determines that
#' sending an SMS message would incur a cost that exceeds this limit, it
#' stops sending SMS messages within minutes.
#' 
#' Amazon SNS stops sending SMS messages within minutes of the limit being
#' crossed. During that interval, if you continue to send SMS messages, you
#' will incur costs that exceed your limit.
#' 
#' By default, the spend limit is set to the maximum allowed by Amazon SNS.
#' If you want to raise the limit, submit an [SNS Limit Increase
#' case](https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&limitType=service-code-sns).
#' For **New limit value**, enter your desired monthly spend limit. In the
#' **Use Case Description** field, explain that you are requesting an SMS
#' monthly spend limit increase.
#' 
#' `DeliveryStatusIAMRole` -- The ARN of the IAM role that allows Amazon
#' SNS to write logs about SMS deliveries in CloudWatch Logs. For each SMS
#' message that you send, Amazon SNS writes a log that includes the message
#' price, the success or failure status, the reason for failure (if the
#' message failed), the message dwell time, and other information.
#' 
#' `DeliveryStatusSuccessSamplingRate` -- The percentage of successful SMS
#' deliveries for which Amazon SNS will write logs in CloudWatch Logs. The
#' value can be an integer from 0 - 100. For example, to write logs only
#' for failed deliveries, set this value to `0`. To write logs for 10\% of
#' your successful deliveries, set it to `10`.
#' 
#' `DefaultSenderID` -- A string, such as your business brand, that is
#' displayed as the sender on the receiving device. Support for sender IDs
#' varies by country. The sender ID can be 1 - 11 alphanumeric characters,
#' and it must contain at least one letter.
#' 
#' `DefaultSMSType` -- The type of SMS message that you will send by
#' default. You can assign the following values:
#' 
#' -   `Promotional` -- (Default) Noncritical messages, such as marketing
#'     messages. Amazon SNS optimizes the message delivery to incur the
#'     lowest cost.
#' 
#' -   `Transactional` -- Critical messages that support customer
#'     transactions, such as one-time passcodes for multi-factor
#'     authentication. Amazon SNS optimizes the message delivery to achieve
#'     the highest reliability.
#' 
#' `UsageReportS3Bucket` -- The name of the Amazon S3 bucket to receive
#' daily SMS usage reports from Amazon SNS. Each day, Amazon SNS will
#' deliver a usage report as a CSV file to the bucket. The report includes
#' the following information for each SMS message that was successfully
#' delivered by your account:
#' 
#' -   Time that the message was published (in UTC)
#' 
#' -   Message ID
#' 
#' -   Destination phone number
#' 
#' -   Message type
#' 
#' -   Delivery status
#' 
#' -   Message price (in USD)
#' 
#' -   Part number (a message is split into multiple parts if it is too
#'     long for a single message)
#' 
#' -   Total number of parts
#' 
#' To receive the report, the bucket must have a policy that allows the
#' Amazon SNS service principle to perform the `s3:PutObject` and
#' `s3:GetBucketLocation` actions.
#' 
#' For an example bucket policy and usage report, see [Monitoring SMS
#' Activity](http://docs.aws.amazon.com/sns/latest/dg/sms_stats.html) in
#' the *Amazon SNS Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$set_sms_attributes(
#'   attributes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_set_sms_attributes
sns_set_sms_attributes <- function(attributes) {
  op <- new_operation(
    name = "SetSMSAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$set_sms_attributes_input(attributes = attributes)
  output <- .sns$set_sms_attributes_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$set_sms_attributes <- sns_set_sms_attributes

#' Allows a subscription owner to set an attribute of the subscription to a
#' new value
#'
#' Allows a subscription owner to set an attribute of the subscription to a
#' new value.
#'
#' @usage
#' sns_set_subscription_attributes(SubscriptionArn, AttributeName,
#'   AttributeValue)
#'
#' @param SubscriptionArn &#91;required&#93; The ARN of the subscription to modify.
#' @param AttributeName &#91;required&#93; A map of attributes with their corresponding values.
#' 
#' The following lists the names, descriptions, and values of the special
#' request parameters that the `SetTopicAttributes` action uses:
#' 
#' -   `DeliveryPolicy` -- The policy that defines how Amazon SNS retries
#'     failed deliveries to HTTP/S endpoints.
#' 
#' -   `FilterPolicy` -- The simple JSON object that lets your subscriber
#'     receive only a subset of messages, rather than receiving every
#'     message published to the topic.
#' 
#' -   `RawMessageDelivery` -- When set to `true`, enables raw message
#'     delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need
#'     for the endpoints to process JSON formatting, which is otherwise
#'     created for Amazon SNS metadata.
#' @param AttributeValue The new value for the attribute in JSON format.
#'
#' @section Request syntax:
#' ```
#' svc$set_subscription_attributes(
#'   SubscriptionArn = "string",
#'   AttributeName = "string",
#'   AttributeValue = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_set_subscription_attributes
sns_set_subscription_attributes <- function(SubscriptionArn, AttributeName, AttributeValue = NULL) {
  op <- new_operation(
    name = "SetSubscriptionAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$set_subscription_attributes_input(SubscriptionArn = SubscriptionArn, AttributeName = AttributeName, AttributeValue = AttributeValue)
  output <- .sns$set_subscription_attributes_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$set_subscription_attributes <- sns_set_subscription_attributes

#' Allows a topic owner to set an attribute of the topic to a new value
#'
#' Allows a topic owner to set an attribute of the topic to a new value.
#'
#' @usage
#' sns_set_topic_attributes(TopicArn, AttributeName, AttributeValue)
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic to modify.
#' @param AttributeName &#91;required&#93; A map of attributes with their corresponding values.
#' 
#' The following lists the names, descriptions, and values of the special
#' request parameters that the `SetTopicAttributes` action uses:
#' 
#' -   `DeliveryPolicy` -- The policy that defines how Amazon SNS retries
#'     failed deliveries to HTTP/S endpoints.
#' 
#' -   `DisplayName` -- The display name to use for a topic with SMS
#'     subscriptions.
#' 
#' -   `Policy` -- The policy that defines who can access your topic. By
#'     default, only the topic owner can publish or subscribe to the topic.
#' @param AttributeValue The new value for the attribute.
#'
#' @section Request syntax:
#' ```
#' svc$set_topic_attributes(
#'   TopicArn = "string",
#'   AttributeName = "string",
#'   AttributeValue = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_set_topic_attributes
sns_set_topic_attributes <- function(TopicArn, AttributeName, AttributeValue = NULL) {
  op <- new_operation(
    name = "SetTopicAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$set_topic_attributes_input(TopicArn = TopicArn, AttributeName = AttributeName, AttributeValue = AttributeValue)
  output <- .sns$set_topic_attributes_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$set_topic_attributes <- sns_set_topic_attributes

#' Prepares to subscribe an endpoint by sending the endpoint a confirmation
#' message
#'
#' Prepares to subscribe an endpoint by sending the endpoint a confirmation
#' message. To actually create a subscription, the endpoint owner must call
#' the `ConfirmSubscription` action with the token from the confirmation
#' message. Confirmation tokens are valid for three days.
#' 
#' This action is throttled at 100 transactions per second (TPS).
#'
#' @usage
#' sns_subscribe(TopicArn, Protocol, Endpoint, Attributes,
#'   ReturnSubscriptionArn)
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic you want to subscribe to.
#' @param Protocol &#91;required&#93; The protocol you want to use. Supported protocols include:
#' 
#' -   `http` -- delivery of JSON-encoded message via HTTP POST
#' 
#' -   `https` -- delivery of JSON-encoded message via HTTPS POST
#' 
#' -   `email` -- delivery of message via SMTP
#' 
#' -   `email-json` -- delivery of JSON-encoded message via SMTP
#' 
#' -   `sms` -- delivery of message via SMS
#' 
#' -   `sqs` -- delivery of JSON-encoded message to an Amazon SQS queue
#' 
#' -   `application` -- delivery of JSON-encoded message to an EndpointArn
#'     for a mobile app and device.
#' 
#' -   `lambda` -- delivery of JSON-encoded message to an AWS Lambda
#'     function.
#' @param Endpoint The endpoint that you want to receive notifications. Endpoints vary by
#' protocol:
#' 
#' -   For the `http` protocol, the endpoint is an URL beginning with
#'     \"http://\"
#' 
#' -   For the `https` protocol, the endpoint is a URL beginning with
#'     \"https://\"
#' 
#' -   For the `email` protocol, the endpoint is an email address
#' 
#' -   For the `email-json` protocol, the endpoint is an email address
#' 
#' -   For the `sms` protocol, the endpoint is a phone number of an
#'     SMS-enabled device
#' 
#' -   For the `sqs` protocol, the endpoint is the ARN of an Amazon SQS
#'     queue
#' 
#' -   For the `application` protocol, the endpoint is the EndpointArn of a
#'     mobile app and device.
#' 
#' -   For the `lambda` protocol, the endpoint is the ARN of an AWS Lambda
#'     function.
#' @param Attributes A map of attributes with their corresponding values.
#' 
#' The following lists the names, descriptions, and values of the special
#' request parameters that the `SetTopicAttributes` action uses:
#' 
#' -   `DeliveryPolicy` -- The policy that defines how Amazon SNS retries
#'     failed deliveries to HTTP/S endpoints.
#' 
#' -   `FilterPolicy` -- The simple JSON object that lets your subscriber
#'     receive only a subset of messages, rather than receiving every
#'     message published to the topic.
#' 
#' -   `RawMessageDelivery` -- When set to `true`, enables raw message
#'     delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need
#'     for the endpoints to process JSON formatting, which is otherwise
#'     created for Amazon SNS metadata.
#' @param ReturnSubscriptionArn Sets whether the response from the `Subscribe` request includes the
#' subscription ARN, even if the subscription is not yet confirmed.
#' 
#' If you set this parameter to `false`, the response includes the ARN for
#' confirmed subscriptions, but it includes an ARN value of \"pending
#' subscription\" for subscriptions that are not yet confirmed. A
#' subscription becomes confirmed when the subscriber calls the
#' `ConfirmSubscription` action with a confirmation token.
#' 
#' If you set this parameter to `true`, the response includes the ARN in
#' all cases, even if the subscription is not yet confirmed.
#' 
#' The default value is `false`.
#'
#' @section Request syntax:
#' ```
#' svc$subscribe(
#'   TopicArn = "string",
#'   Protocol = "string",
#'   Endpoint = "string",
#'   Attributes = list(
#'     "string"
#'   ),
#'   ReturnSubscriptionArn = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_subscribe
sns_subscribe <- function(TopicArn, Protocol, Endpoint = NULL, Attributes = NULL, ReturnSubscriptionArn = NULL) {
  op <- new_operation(
    name = "Subscribe",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$subscribe_input(TopicArn = TopicArn, Protocol = Protocol, Endpoint = Endpoint, Attributes = Attributes, ReturnSubscriptionArn = ReturnSubscriptionArn)
  output <- .sns$subscribe_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$subscribe <- sns_subscribe

#' Deletes a subscription
#'
#' Deletes a subscription. If the subscription requires authentication for
#' deletion, only the owner of the subscription or the topic\'s owner can
#' unsubscribe, and an AWS signature is required. If the `Unsubscribe` call
#' does not require authentication and the requester is not the
#' subscription owner, a final cancellation message is delivered to the
#' endpoint, so that the endpoint owner can easily resubscribe to the topic
#' if the `Unsubscribe` request was unintended.
#' 
#' This action is throttled at 100 transactions per second (TPS).
#'
#' @usage
#' sns_unsubscribe(SubscriptionArn)
#'
#' @param SubscriptionArn &#91;required&#93; The ARN of the subscription to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$unsubscribe(
#'   SubscriptionArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sns_unsubscribe
sns_unsubscribe <- function(SubscriptionArn) {
  op <- new_operation(
    name = "Unsubscribe",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$unsubscribe_input(SubscriptionArn = SubscriptionArn)
  output <- .sns$unsubscribe_output()
  svc <- .sns$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$unsubscribe <- sns_unsubscribe
