% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_list_queue_tags}
\alias{sqs_list_queue_tags}
\title{List all cost allocation tags added to the specified Amazon SQS queue}
\usage{
sqs_list_queue_tags(QueueUrl)
}
\arguments{
\item{QueueUrl}{[required] The URL of the queue.}
}
\value{
A list with the following syntax:\preformatted{list(
  Tags = list(
    "string"
  )
)
}
}
\description{
List all cost allocation tags added to the specified Amazon SQS queue.
For an overview, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html}{Tagging Your Amazon SQS Queues}
in the \emph{Amazon Simple Queue Service Developer Guide}.

Cross-account permissions don't apply to this action. For more
information, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-basic-examples-of-sqs-policies.html#grant-cross-account-permissions-to-role-and-user-name}{Grant cross-account permissions to a role and a user name}
in the \emph{Amazon Simple Queue Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_queue_tags(
  QueueUrl = "string"
)
}
}

\keyword{internal}
