# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sns_service.R
NULL

#' Adds a statement to a topic's access control policy, granting access for
#' the specified Amazon Web Services accounts to the specified actions
#'
#' @description
#' Adds a statement to a topic's access control policy, granting access for the specified Amazon Web Services accounts to the specified actions.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_add_permission/](https://www.paws-r-sdk.com/docs/sns_add_permission/) for full documentation.
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic whose access control policy you wish to modify.
#' @param Label &#91;required&#93; A unique identifier for the new policy statement.
#' @param AWSAccountId &#91;required&#93; The Amazon Web Services account IDs of the users (principals) who will
#' be given access to the specified actions. The users must have Amazon Web
#' Services account, but do not need to be signed up for this service.
#' @param ActionName &#91;required&#93; The action you want to allow for the specified principal(s).
#' 
#' Valid values: Any Amazon SNS action name, for example
#' [`publish`][sns_publish].
#'
#' @keywords internal
#'
#' @rdname sns_add_permission
sns_add_permission <- function(TopicArn, Label, AWSAccountId, ActionName) {
  op <- new_operation(
    name = "AddPermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$add_permission_input(TopicArn = TopicArn, Label = Label, AWSAccountId = AWSAccountId, ActionName = ActionName)
  output <- .sns$add_permission_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$add_permission <- sns_add_permission

#' Accepts a phone number and indicates whether the phone holder has opted
#' out of receiving SMS messages from your Amazon Web Services account
#'
#' @description
#' Accepts a phone number and indicates whether the phone holder has opted out of receiving SMS messages from your Amazon Web Services account. You cannot send SMS messages to a number that is opted out.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_check_if_phone_number_is_opted_out/](https://www.paws-r-sdk.com/docs/sns_check_if_phone_number_is_opted_out/) for full documentation.
#'
#' @param phoneNumber &#91;required&#93; The phone number for which you want to check the opt out status.
#'
#' @keywords internal
#'
#' @rdname sns_check_if_phone_number_is_opted_out
sns_check_if_phone_number_is_opted_out <- function(phoneNumber) {
  op <- new_operation(
    name = "CheckIfPhoneNumberIsOptedOut",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$check_if_phone_number_is_opted_out_input(phoneNumber = phoneNumber)
  output <- .sns$check_if_phone_number_is_opted_out_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$check_if_phone_number_is_opted_out <- sns_check_if_phone_number_is_opted_out

#' Verifies an endpoint owner's intent to receive messages by validating
#' the token sent to the endpoint by an earlier Subscribe action
#'
#' @description
#' Verifies an endpoint owner's intent to receive messages by validating the token sent to the endpoint by an earlier [`subscribe`][sns_subscribe] action. If the token is valid, the action creates a new subscription and returns its Amazon Resource Name (ARN). This call requires an AWS signature only when the `AuthenticateOnUnsubscribe` flag is set to "true".
#'
#' See [https://www.paws-r-sdk.com/docs/sns_confirm_subscription/](https://www.paws-r-sdk.com/docs/sns_confirm_subscription/) for full documentation.
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic for which you wish to confirm a subscription.
#' @param Token &#91;required&#93; Short-lived token sent to an endpoint during the
#' [`subscribe`][sns_subscribe] action.
#' @param AuthenticateOnUnsubscribe Disallows unauthenticated unsubscribes of the subscription. If the value
#' of this parameter is `true` and the request has an Amazon Web Services
#' signature, then only the topic owner and the subscription owner can
#' unsubscribe the endpoint. The unsubscribe action requires Amazon Web
#' Services authentication.
#'
#' @keywords internal
#'
#' @rdname sns_confirm_subscription
sns_confirm_subscription <- function(TopicArn, Token, AuthenticateOnUnsubscribe = NULL) {
  op <- new_operation(
    name = "ConfirmSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$confirm_subscription_input(TopicArn = TopicArn, Token = Token, AuthenticateOnUnsubscribe = AuthenticateOnUnsubscribe)
  output <- .sns$confirm_subscription_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$confirm_subscription <- sns_confirm_subscription

#' Creates a platform application object for one of the supported push
#' notification services, such as APNS and GCM (Firebase Cloud Messaging),
#' to which devices and mobile apps may register
#'
#' @description
#' Creates a platform application object for one of the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging), to which devices and mobile apps may register. You must specify `PlatformPrincipal` and `PlatformCredential` attributes when using the [`create_platform_application`][sns_create_platform_application] action.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_create_platform_application/](https://www.paws-r-sdk.com/docs/sns_create_platform_application/) for full documentation.
#'
#' @param Name &#91;required&#93; Application names must be made up of only uppercase and lowercase ASCII
#' letters, numbers, underscores, hyphens, and periods, and must be between
#' 1 and 256 characters long.
#' @param Platform &#91;required&#93; The following platforms are supported: ADM (Amazon Device Messaging),
#' APNS (Apple Push Notification Service), APNS_SANDBOX, and GCM (Firebase
#' Cloud Messaging).
#' @param Attributes &#91;required&#93; For a list of attributes, see
#' [`set_platform_application_attributes`](https://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html)
#' .
#'
#' @keywords internal
#'
#' @rdname sns_create_platform_application
sns_create_platform_application <- function(Name, Platform, Attributes) {
  op <- new_operation(
    name = "CreatePlatformApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$create_platform_application_input(Name = Name, Platform = Platform, Attributes = Attributes)
  output <- .sns$create_platform_application_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$create_platform_application <- sns_create_platform_application

#' Creates an endpoint for a device and mobile app on one of the supported
#' push notification services, such as GCM (Firebase Cloud Messaging) and
#' APNS
#'
#' @description
#' Creates an endpoint for a device and mobile app on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. [`create_platform_endpoint`][sns_create_platform_endpoint] requires the `PlatformApplicationArn` that is returned from [`create_platform_application`][sns_create_platform_application]. You can use the returned `EndpointArn` to send a message to a mobile app or by the [`subscribe`][sns_subscribe] action for subscription to a topic. The [`create_platform_endpoint`][sns_create_platform_endpoint] action is idempotent, so if the requester already owns an endpoint with the same device token and attributes, that endpoint's ARN is returned without creating a new endpoint. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/sns-mobile-application-as-subscriber.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sns_create_platform_endpoint/](https://www.paws-r-sdk.com/docs/sns_create_platform_endpoint/) for full documentation.
#'
#' @param PlatformApplicationArn &#91;required&#93; `PlatformApplicationArn` returned from CreatePlatformApplication is used
#' to create a an endpoint.
#' @param Token &#91;required&#93; Unique identifier created by the notification service for an app on a
#' device. The specific name for Token will vary, depending on which
#' notification service is being used. For example, when using APNS as the
#' notification service, you need the device token. Alternatively, when
#' using GCM (Firebase Cloud Messaging) or ADM, the device token equivalent
#' is called the registration ID.
#' @param CustomUserData Arbitrary user data to associate with the endpoint. Amazon SNS does not
#' use this data. The data must be in UTF-8 format and less than 2KB.
#' @param Attributes For a list of attributes, see
#' [`set_endpoint_attributes`](https://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html)
#' .
#'
#' @keywords internal
#'
#' @rdname sns_create_platform_endpoint
sns_create_platform_endpoint <- function(PlatformApplicationArn, Token, CustomUserData = NULL, Attributes = NULL) {
  op <- new_operation(
    name = "CreatePlatformEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$create_platform_endpoint_input(PlatformApplicationArn = PlatformApplicationArn, Token = Token, CustomUserData = CustomUserData, Attributes = Attributes)
  output <- .sns$create_platform_endpoint_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$create_platform_endpoint <- sns_create_platform_endpoint

#' Adds a destination phone number to an Amazon Web Services account in the
#' SMS sandbox and sends a one-time password (OTP) to that phone number
#'
#' @description
#' Adds a destination phone number to an Amazon Web Services account in the SMS sandbox and sends a one-time password (OTP) to that phone number.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_create_sms_sandbox_phone_number/](https://www.paws-r-sdk.com/docs/sns_create_sms_sandbox_phone_number/) for full documentation.
#'
#' @param PhoneNumber &#91;required&#93; The destination phone number to verify. On verification, Amazon SNS adds
#' this phone number to the list of verified phone numbers that you can
#' send SMS messages to.
#' @param LanguageCode The language to use for sending the OTP. The default value is `en-US`.
#'
#' @keywords internal
#'
#' @rdname sns_create_sms_sandbox_phone_number
sns_create_sms_sandbox_phone_number <- function(PhoneNumber, LanguageCode = NULL) {
  op <- new_operation(
    name = "CreateSMSSandboxPhoneNumber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$create_sms_sandbox_phone_number_input(PhoneNumber = PhoneNumber, LanguageCode = LanguageCode)
  output <- .sns$create_sms_sandbox_phone_number_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$create_sms_sandbox_phone_number <- sns_create_sms_sandbox_phone_number

#' Creates a topic to which notifications can be published
#'
#' @description
#' Creates a topic to which notifications can be published. Users can create at most 100,000 standard topics (at most 1,000 FIFO topics). For more information, see [Creating an Amazon SNS topic](https://docs.aws.amazon.com/sns/latest/dg/sns-create-topic.html) in the *Amazon SNS Developer Guide*. This action is idempotent, so if the requester already owns a topic with the specified name, that topic's ARN is returned without creating a new topic.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_create_topic/](https://www.paws-r-sdk.com/docs/sns_create_topic/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the topic you want to create.
#' 
#' Constraints: Topic names must be made up of only uppercase and lowercase
#' ASCII letters, numbers, underscores, and hyphens, and must be between 1
#' and 256 characters long.
#' 
#' For a FIFO (first-in-first-out) topic, the name must end with the
#' `.fifo` suffix.
#' @param Attributes A map of attributes with their corresponding values.
#' 
#' The following lists the names, descriptions, and values of the special
#' request parameters that the [`create_topic`][sns_create_topic] action
#' uses:
#' 
#' -   `DeliveryPolicy` – The policy that defines how Amazon SNS retries
#'     failed deliveries to HTTP/S endpoints.
#' 
#' -   `DisplayName` – The display name to use for a topic with SMS
#'     subscriptions.
#' 
#' -   `FifoTopic` – Set to true to create a FIFO topic.
#' 
#' -   `Policy` – The policy that defines who can access your topic. By
#'     default, only the topic owner can publish or subscribe to the topic.
#' 
#' -   `SignatureVersion` – The signature version corresponds to the
#'     hashing algorithm used while creating the signature of the
#'     notifications, subscription confirmations, or unsubscribe
#'     confirmation messages sent by Amazon SNS. By default,
#'     `SignatureVersion` is set to `1`.
#' 
#' -   `TracingConfig` – Tracing mode of an Amazon SNS topic. By default
#'     `TracingConfig` is set to `PassThrough`, and the topic passes
#'     through the tracing header it receives from an Amazon SNS publisher
#'     to its subscriptions. If set to `Active`, Amazon SNS will vend X-Ray
#'     segment data to topic owner account if the sampled flag in the
#'     tracing header is true. This is only supported on standard topics.
#' 
#' The following attribute applies only to [server-side
#' encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html):
#' 
#' -   `KmsMasterKeyId` – The ID of an Amazon Web Services managed customer
#'     master key (CMK) for Amazon SNS or a custom CMK. For more
#'     information, see [Key
#'     Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms).
#'     For more examples, see
#'     [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters)
#'     in the *Key Management Service API Reference*.
#' 
#' The following attributes apply only to [FIFO
#' topics](https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html):
#' 
#' -   `ArchivePolicy` – Adds or updates an inline policy document to
#'     archive messages stored in the specified Amazon SNS topic.
#' 
#' -   `BeginningArchiveTime` – The earliest starting point at which a
#'     message in the topic’s archive can be replayed from. This point in
#'     time is based on the configured message retention period set by the
#'     topic’s message archiving policy.
#' 
#' -   `ContentBasedDeduplication` – Enables content-based deduplication
#'     for FIFO topics.
#' 
#'     -   By default, `ContentBasedDeduplication` is set to `false`. If
#'         you create a FIFO topic and this attribute is `false`, you must
#'         specify a value for the `MessageDeduplicationId` parameter for
#'         the [`publish`][sns_publish] action.
#' 
#'     -   When you set `ContentBasedDeduplication` to `true`, Amazon SNS
#'         uses a SHA-256 hash to generate the `MessageDeduplicationId`
#'         using the body of the message (but not the attributes of the
#'         message).
#' 
#'         (Optional) To override the generated value, you can specify a
#'         value for the `MessageDeduplicationId` parameter for the
#'         [`publish`][sns_publish] action.
#' @param Tags The list of tags to add to a new topic.
#' 
#' To be able to tag a topic on creation, you must have the
#' `sns:CreateTopic` and `sns:TagResource` permissions.
#' @param DataProtectionPolicy The body of the policy document you want to use for this topic.
#' 
#' You can only add one policy per topic.
#' 
#' The policy must be in JSON string format.
#' 
#' Length Constraints: Maximum length of 30,720.
#'
#' @keywords internal
#'
#' @rdname sns_create_topic
sns_create_topic <- function(Name, Attributes = NULL, Tags = NULL, DataProtectionPolicy = NULL) {
  op <- new_operation(
    name = "CreateTopic",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$create_topic_input(Name = Name, Attributes = Attributes, Tags = Tags, DataProtectionPolicy = DataProtectionPolicy)
  output <- .sns$create_topic_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$create_topic <- sns_create_topic

#' Deletes the endpoint for a device and mobile app from Amazon SNS
#'
#' @description
#' Deletes the endpoint for a device and mobile app from Amazon SNS. This action is idempotent. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/sns-mobile-application-as-subscriber.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sns_delete_endpoint/](https://www.paws-r-sdk.com/docs/sns_delete_endpoint/) for full documentation.
#'
#' @param EndpointArn &#91;required&#93; `EndpointArn` of endpoint to delete.
#'
#' @keywords internal
#'
#' @rdname sns_delete_endpoint
sns_delete_endpoint <- function(EndpointArn) {
  op <- new_operation(
    name = "DeleteEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$delete_endpoint_input(EndpointArn = EndpointArn)
  output <- .sns$delete_endpoint_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$delete_endpoint <- sns_delete_endpoint

#' Deletes a platform application object for one of the supported push
#' notification services, such as APNS and GCM (Firebase Cloud Messaging)
#'
#' @description
#' Deletes a platform application object for one of the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/sns-mobile-application-as-subscriber.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sns_delete_platform_application/](https://www.paws-r-sdk.com/docs/sns_delete_platform_application/) for full documentation.
#'
#' @param PlatformApplicationArn &#91;required&#93; `PlatformApplicationArn` of platform application object to delete.
#'
#' @keywords internal
#'
#' @rdname sns_delete_platform_application
sns_delete_platform_application <- function(PlatformApplicationArn) {
  op <- new_operation(
    name = "DeletePlatformApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$delete_platform_application_input(PlatformApplicationArn = PlatformApplicationArn)
  output <- .sns$delete_platform_application_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$delete_platform_application <- sns_delete_platform_application

#' Deletes an Amazon Web Services account's verified or pending phone
#' number from the SMS sandbox
#'
#' @description
#' Deletes an Amazon Web Services account's verified or pending phone number from the SMS sandbox.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_delete_sms_sandbox_phone_number/](https://www.paws-r-sdk.com/docs/sns_delete_sms_sandbox_phone_number/) for full documentation.
#'
#' @param PhoneNumber &#91;required&#93; The destination phone number to delete.
#'
#' @keywords internal
#'
#' @rdname sns_delete_sms_sandbox_phone_number
sns_delete_sms_sandbox_phone_number <- function(PhoneNumber) {
  op <- new_operation(
    name = "DeleteSMSSandboxPhoneNumber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$delete_sms_sandbox_phone_number_input(PhoneNumber = PhoneNumber)
  output <- .sns$delete_sms_sandbox_phone_number_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$delete_sms_sandbox_phone_number <- sns_delete_sms_sandbox_phone_number

#' Deletes a topic and all its subscriptions
#'
#' @description
#' Deletes a topic and all its subscriptions. Deleting a topic might prevent some messages previously sent to the topic from being delivered to subscribers. This action is idempotent, so deleting a topic that does not exist does not result in an error.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_delete_topic/](https://www.paws-r-sdk.com/docs/sns_delete_topic/) for full documentation.
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic you want to delete.
#'
#' @keywords internal
#'
#' @rdname sns_delete_topic
sns_delete_topic <- function(TopicArn) {
  op <- new_operation(
    name = "DeleteTopic",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$delete_topic_input(TopicArn = TopicArn)
  output <- .sns$delete_topic_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$delete_topic <- sns_delete_topic

#' Retrieves the specified inline DataProtectionPolicy document that is
#' stored in the specified Amazon SNS topic
#'
#' @description
#' Retrieves the specified inline `DataProtectionPolicy` document that is stored in the specified Amazon SNS topic.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_get_data_protection_policy/](https://www.paws-r-sdk.com/docs/sns_get_data_protection_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the topic whose `DataProtectionPolicy` you want to get.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the Amazon Web Services General Reference.
#'
#' @keywords internal
#'
#' @rdname sns_get_data_protection_policy
sns_get_data_protection_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "GetDataProtectionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$get_data_protection_policy_input(ResourceArn = ResourceArn)
  output <- .sns$get_data_protection_policy_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$get_data_protection_policy <- sns_get_data_protection_policy

#' Retrieves the endpoint attributes for a device on one of the supported
#' push notification services, such as GCM (Firebase Cloud Messaging) and
#' APNS
#'
#' @description
#' Retrieves the endpoint attributes for a device on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/sns-mobile-application-as-subscriber.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sns_get_endpoint_attributes/](https://www.paws-r-sdk.com/docs/sns_get_endpoint_attributes/) for full documentation.
#'
#' @param EndpointArn &#91;required&#93; `EndpointArn` for
#' [`get_endpoint_attributes`][sns_get_endpoint_attributes] input.
#'
#' @keywords internal
#'
#' @rdname sns_get_endpoint_attributes
sns_get_endpoint_attributes <- function(EndpointArn) {
  op <- new_operation(
    name = "GetEndpointAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$get_endpoint_attributes_input(EndpointArn = EndpointArn)
  output <- .sns$get_endpoint_attributes_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$get_endpoint_attributes <- sns_get_endpoint_attributes

#' Retrieves the attributes of the platform application object for the
#' supported push notification services, such as APNS and GCM (Firebase
#' Cloud Messaging)
#'
#' @description
#' Retrieves the attributes of the platform application object for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/sns-mobile-application-as-subscriber.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sns_get_platform_application_attributes/](https://www.paws-r-sdk.com/docs/sns_get_platform_application_attributes/) for full documentation.
#'
#' @param PlatformApplicationArn &#91;required&#93; `PlatformApplicationArn` for GetPlatformApplicationAttributesInput.
#'
#' @keywords internal
#'
#' @rdname sns_get_platform_application_attributes
sns_get_platform_application_attributes <- function(PlatformApplicationArn) {
  op <- new_operation(
    name = "GetPlatformApplicationAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$get_platform_application_attributes_input(PlatformApplicationArn = PlatformApplicationArn)
  output <- .sns$get_platform_application_attributes_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$get_platform_application_attributes <- sns_get_platform_application_attributes

#' Returns the settings for sending SMS messages from your Amazon Web
#' Services account
#'
#' @description
#' Returns the settings for sending SMS messages from your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_get_sms_attributes/](https://www.paws-r-sdk.com/docs/sns_get_sms_attributes/) for full documentation.
#'
#' @param attributes A list of the individual attribute names, such as `MonthlySpendLimit`,
#' for which you want values.
#' 
#' For all attribute names, see
#' [`set_sms_attributes`][sns_set_sms_attributes].
#' 
#' If you don't use this parameter, Amazon SNS returns all SMS attributes.
#'
#' @keywords internal
#'
#' @rdname sns_get_sms_attributes
sns_get_sms_attributes <- function(attributes = NULL) {
  op <- new_operation(
    name = "GetSMSAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$get_sms_attributes_input(attributes = attributes)
  output <- .sns$get_sms_attributes_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$get_sms_attributes <- sns_get_sms_attributes

#' Retrieves the SMS sandbox status for the calling Amazon Web Services
#' account in the target Amazon Web Services Region
#'
#' @description
#' Retrieves the SMS sandbox status for the calling Amazon Web Services account in the target Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_get_sms_sandbox_account_status/](https://www.paws-r-sdk.com/docs/sns_get_sms_sandbox_account_status/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname sns_get_sms_sandbox_account_status
sns_get_sms_sandbox_account_status <- function() {
  op <- new_operation(
    name = "GetSMSSandboxAccountStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$get_sms_sandbox_account_status_input()
  output <- .sns$get_sms_sandbox_account_status_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$get_sms_sandbox_account_status <- sns_get_sms_sandbox_account_status

#' Returns all of the properties of a subscription
#'
#' @description
#' Returns all of the properties of a subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_get_subscription_attributes/](https://www.paws-r-sdk.com/docs/sns_get_subscription_attributes/) for full documentation.
#'
#' @param SubscriptionArn &#91;required&#93; The ARN of the subscription whose properties you want to get.
#'
#' @keywords internal
#'
#' @rdname sns_get_subscription_attributes
sns_get_subscription_attributes <- function(SubscriptionArn) {
  op <- new_operation(
    name = "GetSubscriptionAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$get_subscription_attributes_input(SubscriptionArn = SubscriptionArn)
  output <- .sns$get_subscription_attributes_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$get_subscription_attributes <- sns_get_subscription_attributes

#' Returns all of the properties of a topic
#'
#' @description
#' Returns all of the properties of a topic. Topic properties returned might differ based on the authorization of the user.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_get_topic_attributes/](https://www.paws-r-sdk.com/docs/sns_get_topic_attributes/) for full documentation.
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic whose properties you want to get.
#'
#' @keywords internal
#'
#' @rdname sns_get_topic_attributes
sns_get_topic_attributes <- function(TopicArn) {
  op <- new_operation(
    name = "GetTopicAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$get_topic_attributes_input(TopicArn = TopicArn)
  output <- .sns$get_topic_attributes_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$get_topic_attributes <- sns_get_topic_attributes

#' Lists the endpoints and endpoint attributes for devices in a supported
#' push notification service, such as GCM (Firebase Cloud Messaging) and
#' APNS
#'
#' @description
#' Lists the endpoints and endpoint attributes for devices in a supported push notification service, such as GCM (Firebase Cloud Messaging) and APNS. The results for [`list_endpoints_by_platform_application`][sns_list_endpoints_by_platform_application] are paginated and return a limited list of endpoints, up to 100. If additional records are available after the first page results, then a NextToken string will be returned. To receive the next page, you call [`list_endpoints_by_platform_application`][sns_list_endpoints_by_platform_application] again using the NextToken string received from the previous call. When there are no more records to return, NextToken will be null. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/sns-mobile-application-as-subscriber.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sns_list_endpoints_by_platform_application/](https://www.paws-r-sdk.com/docs/sns_list_endpoints_by_platform_application/) for full documentation.
#'
#' @param PlatformApplicationArn &#91;required&#93; `PlatformApplicationArn` for `ListEndpointsByPlatformApplicationInput`
#' action.
#' @param NextToken `NextToken` string is used when calling
#' [`list_endpoints_by_platform_application`][sns_list_endpoints_by_platform_application]
#' action to retrieve additional records that are available after the first
#' page results.
#'
#' @keywords internal
#'
#' @rdname sns_list_endpoints_by_platform_application
sns_list_endpoints_by_platform_application <- function(PlatformApplicationArn, NextToken = NULL) {
  op <- new_operation(
    name = "ListEndpointsByPlatformApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Endpoints")
  )
  input <- .sns$list_endpoints_by_platform_application_input(PlatformApplicationArn = PlatformApplicationArn, NextToken = NextToken)
  output <- .sns$list_endpoints_by_platform_application_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_endpoints_by_platform_application <- sns_list_endpoints_by_platform_application

#' Lists the calling Amazon Web Services account's dedicated origination
#' numbers and their metadata
#'
#' @description
#' Lists the calling Amazon Web Services account's dedicated origination numbers and their metadata. For more information about origination numbers, see [Origination numbers](https://docs.aws.amazon.com/sns/latest/dg/channels-sms-originating-identities-origination-numbers.html) in the *Amazon SNS Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_list_origination_numbers/](https://www.paws-r-sdk.com/docs/sns_list_origination_numbers/) for full documentation.
#'
#' @param NextToken Token that the previous
#' [`list_origination_numbers`][sns_list_origination_numbers] request
#' returns.
#' @param MaxResults The maximum number of origination numbers to return.
#'
#' @keywords internal
#'
#' @rdname sns_list_origination_numbers
sns_list_origination_numbers <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListOriginationNumbers",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "PhoneNumbers")
  )
  input <- .sns$list_origination_numbers_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .sns$list_origination_numbers_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_origination_numbers <- sns_list_origination_numbers

#' Returns a list of phone numbers that are opted out, meaning you cannot
#' send SMS messages to them
#'
#' @description
#' Returns a list of phone numbers that are opted out, meaning you cannot send SMS messages to them.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_list_phone_numbers_opted_out/](https://www.paws-r-sdk.com/docs/sns_list_phone_numbers_opted_out/) for full documentation.
#'
#' @param nextToken A `NextToken` string is used when you call the
#' [`list_phone_numbers_opted_out`][sns_list_phone_numbers_opted_out]
#' action to retrieve additional records that are available after the first
#' page of results.
#'
#' @keywords internal
#'
#' @rdname sns_list_phone_numbers_opted_out
sns_list_phone_numbers_opted_out <- function(nextToken = NULL) {
  op <- new_operation(
    name = "ListPhoneNumbersOptedOut",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "phoneNumbers")
  )
  input <- .sns$list_phone_numbers_opted_out_input(nextToken = nextToken)
  output <- .sns$list_phone_numbers_opted_out_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_phone_numbers_opted_out <- sns_list_phone_numbers_opted_out

#' Lists the platform application objects for the supported push
#' notification services, such as APNS and GCM (Firebase Cloud Messaging)
#'
#' @description
#' Lists the platform application objects for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). The results for [`list_platform_applications`][sns_list_platform_applications] are paginated and return a limited list of applications, up to 100. If additional records are available after the first page results, then a NextToken string will be returned. To receive the next page, you call [`list_platform_applications`][sns_list_platform_applications] using the NextToken string received from the previous call. When there are no more records to return, `NextToken` will be null. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/sns-mobile-application-as-subscriber.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sns_list_platform_applications/](https://www.paws-r-sdk.com/docs/sns_list_platform_applications/) for full documentation.
#'
#' @param NextToken `NextToken` string is used when calling
#' [`list_platform_applications`][sns_list_platform_applications] action to
#' retrieve additional records that are available after the first page
#' results.
#'
#' @keywords internal
#'
#' @rdname sns_list_platform_applications
sns_list_platform_applications <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListPlatformApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "PlatformApplications")
  )
  input <- .sns$list_platform_applications_input(NextToken = NextToken)
  output <- .sns$list_platform_applications_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_platform_applications <- sns_list_platform_applications

#' Lists the calling Amazon Web Services account's current verified and
#' pending destination phone numbers in the SMS sandbox
#'
#' @description
#' Lists the calling Amazon Web Services account's current verified and pending destination phone numbers in the SMS sandbox.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_list_sms_sandbox_phone_numbers/](https://www.paws-r-sdk.com/docs/sns_list_sms_sandbox_phone_numbers/) for full documentation.
#'
#' @param NextToken Token that the previous `ListSMSSandboxPhoneNumbersInput` request
#' returns.
#' @param MaxResults The maximum number of phone numbers to return.
#'
#' @keywords internal
#'
#' @rdname sns_list_sms_sandbox_phone_numbers
sns_list_sms_sandbox_phone_numbers <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListSMSSandboxPhoneNumbers",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "PhoneNumbers")
  )
  input <- .sns$list_sms_sandbox_phone_numbers_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .sns$list_sms_sandbox_phone_numbers_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_sms_sandbox_phone_numbers <- sns_list_sms_sandbox_phone_numbers

#' Returns a list of the requester's subscriptions
#'
#' @description
#' Returns a list of the requester's subscriptions. Each call returns a limited list of subscriptions, up to 100. If there are more subscriptions, a `NextToken` is also returned. Use the `NextToken` parameter in a new [`list_subscriptions`][sns_list_subscriptions] call to get further results.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_list_subscriptions/](https://www.paws-r-sdk.com/docs/sns_list_subscriptions/) for full documentation.
#'
#' @param NextToken Token returned by the previous
#' [`list_subscriptions`][sns_list_subscriptions] request.
#'
#' @keywords internal
#'
#' @rdname sns_list_subscriptions
sns_list_subscriptions <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListSubscriptions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Subscriptions")
  )
  input <- .sns$list_subscriptions_input(NextToken = NextToken)
  output <- .sns$list_subscriptions_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_subscriptions <- sns_list_subscriptions

#' Returns a list of the subscriptions to a specific topic
#'
#' @description
#' Returns a list of the subscriptions to a specific topic. Each call returns a limited list of subscriptions, up to 100. If there are more subscriptions, a `NextToken` is also returned. Use the `NextToken` parameter in a new [`list_subscriptions_by_topic`][sns_list_subscriptions_by_topic] call to get further results.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_list_subscriptions_by_topic/](https://www.paws-r-sdk.com/docs/sns_list_subscriptions_by_topic/) for full documentation.
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic for which you wish to find subscriptions.
#' @param NextToken Token returned by the previous
#' [`list_subscriptions_by_topic`][sns_list_subscriptions_by_topic]
#' request.
#'
#' @keywords internal
#'
#' @rdname sns_list_subscriptions_by_topic
sns_list_subscriptions_by_topic <- function(TopicArn, NextToken = NULL) {
  op <- new_operation(
    name = "ListSubscriptionsByTopic",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Subscriptions")
  )
  input <- .sns$list_subscriptions_by_topic_input(TopicArn = TopicArn, NextToken = NextToken)
  output <- .sns$list_subscriptions_by_topic_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_subscriptions_by_topic <- sns_list_subscriptions_by_topic

#' List all tags added to the specified Amazon SNS topic
#'
#' @description
#' List all tags added to the specified Amazon SNS topic. For an overview, see [Amazon SNS Tags](https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html) in the *Amazon Simple Notification Service Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/sns_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the topic for which to list tags.
#'
#' @keywords internal
#'
#' @rdname sns_list_tags_for_resource
sns_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .sns$list_tags_for_resource_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_tags_for_resource <- sns_list_tags_for_resource

#' Returns a list of the requester's topics
#'
#' @description
#' Returns a list of the requester's topics. Each call returns a limited list of topics, up to 100. If there are more topics, a `NextToken` is also returned. Use the `NextToken` parameter in a new [`list_topics`][sns_list_topics] call to get further results.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_list_topics/](https://www.paws-r-sdk.com/docs/sns_list_topics/) for full documentation.
#'
#' @param NextToken Token returned by the previous [`list_topics`][sns_list_topics] request.
#'
#' @keywords internal
#'
#' @rdname sns_list_topics
sns_list_topics <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListTopics",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Topics")
  )
  input <- .sns$list_topics_input(NextToken = NextToken)
  output <- .sns$list_topics_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$list_topics <- sns_list_topics

#' Use this request to opt in a phone number that is opted out, which
#' enables you to resume sending SMS messages to the number
#'
#' @description
#' Use this request to opt in a phone number that is opted out, which enables you to resume sending SMS messages to the number.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_opt_in_phone_number/](https://www.paws-r-sdk.com/docs/sns_opt_in_phone_number/) for full documentation.
#'
#' @param phoneNumber &#91;required&#93; The phone number to opt in. Use E.164 format.
#'
#' @keywords internal
#'
#' @rdname sns_opt_in_phone_number
sns_opt_in_phone_number <- function(phoneNumber) {
  op <- new_operation(
    name = "OptInPhoneNumber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$opt_in_phone_number_input(phoneNumber = phoneNumber)
  output <- .sns$opt_in_phone_number_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$opt_in_phone_number <- sns_opt_in_phone_number

#' Sends a message to an Amazon SNS topic, a text message (SMS message)
#' directly to a phone number, or a message to a mobile platform endpoint
#' (when you specify the TargetArn)
#'
#' @description
#' Sends a message to an Amazon SNS topic, a text message (SMS message) directly to a phone number, or a message to a mobile platform endpoint (when you specify the `TargetArn`).
#'
#' See [https://www.paws-r-sdk.com/docs/sns_publish/](https://www.paws-r-sdk.com/docs/sns_publish/) for full documentation.
#'
#' @param TopicArn The topic you want to publish to.
#' 
#' If you don't specify a value for the `TopicArn` parameter, you must
#' specify a value for the `PhoneNumber` or `TargetArn` parameters.
#' @param TargetArn If you don't specify a value for the `TargetArn` parameter, you must
#' specify a value for the `PhoneNumber` or `TopicArn` parameters.
#' @param PhoneNumber The phone number to which you want to deliver an SMS message. Use E.164
#' format.
#' 
#' If you don't specify a value for the `PhoneNumber` parameter, you must
#' specify a value for the `TargetArn` or `TopicArn` parameters.
#' @param Message &#91;required&#93; The message you want to send.
#' 
#' If you are publishing to a topic and you want to send the same message
#' to all transport protocols, include the text of the message as a String
#' value. If you want to send different messages for each transport
#' protocol, set the value of the `MessageStructure` parameter to `json`
#' and use a JSON object for the `Message` parameter.
#' 
#' Constraints:
#' 
#' -   With the exception of SMS, messages must be UTF-8 encoded strings
#'     and at most 256 KB in size (262,144 bytes, not 262,144 characters).
#' 
#' -   For SMS, each message can contain up to 140 characters. This
#'     character limit depends on the encoding schema. For example, an SMS
#'     message can contain 160 GSM characters, 140 ASCII characters, or 70
#'     UCS-2 characters.
#' 
#'     If you publish a message that exceeds this size limit, Amazon SNS
#'     sends the message as multiple messages, each fitting within the size
#'     limit. Messages aren't truncated mid-word but are cut off at
#'     whole-word boundaries.
#' 
#'     The total size limit for a single SMS [`publish`][sns_publish]
#'     action is 1,600 characters.
#' 
#' JSON-specific constraints:
#' 
#' -   Keys in the JSON object that correspond to supported transport
#'     protocols must have simple JSON string values.
#' 
#' -   The values will be parsed (unescaped) before they are used in
#'     outgoing messages.
#' 
#' -   Outbound notifications are JSON encoded (meaning that the characters
#'     will be reescaped for sending).
#' 
#' -   Values have a minimum length of 0 (the empty string, "", is
#'     allowed).
#' 
#' -   Values have a maximum length bounded by the overall message size
#'     (so, including multiple protocols may limit message sizes).
#' 
#' -   Non-string values will cause the key to be ignored.
#' 
#' -   Keys that do not correspond to supported transport protocols are
#'     ignored.
#' 
#' -   Duplicate keys are not allowed.
#' 
#' -   Failure to parse or validate any key or value in the message will
#'     cause the [`publish`][sns_publish] call to return an error (no
#'     partial delivery).
#' @param Subject Optional parameter to be used as the "Subject" line when the message is
#' delivered to email endpoints. This field will also be included, if
#' present, in the standard JSON messages delivered to other endpoints.
#' 
#' Constraints: Subjects must be ASCII text that begins with a letter,
#' number, or punctuation mark; must not include line breaks or control
#' characters; and must be less than 100 characters long.
#' @param MessageStructure Set `MessageStructure` to `json` if you want to send a different message
#' for each protocol. For example, using one publish action, you can send a
#' short message to your SMS subscribers and a longer message to your email
#' subscribers. If you set `MessageStructure` to `json`, the value of the
#' `Message` parameter must:
#' 
#' -   be a syntactically valid JSON object; and
#' 
#' -   contain at least a top-level JSON key of "default" with a value that
#'     is a string.
#' 
#' You can define other top-level keys that define the message you want to
#' send to a specific transport protocol (e.g., "http").
#' 
#' Valid value: `json`
#' @param MessageAttributes Message attributes for Publish action.
#' @param MessageDeduplicationId This parameter applies only to FIFO (first-in-first-out) topics. The
#' `MessageDeduplicationId` can contain up to 128 alphanumeric characters
#' `(a-z, A-Z, 0-9)` and punctuation
#' `` (!\"#$%&\'()*+,-./:;<=>?@@[\]^_\`{|}~) ``.
#' 
#' Every message must have a unique `MessageDeduplicationId`, which is a
#' token used for deduplication of sent messages. If a message with a
#' particular `MessageDeduplicationId` is sent successfully, any message
#' sent with the same `MessageDeduplicationId` during the 5-minute
#' deduplication interval is treated as a duplicate.
#' 
#' If the topic has `ContentBasedDeduplication` set, the system generates a
#' `MessageDeduplicationId` based on the contents of the message. Your
#' `MessageDeduplicationId` overrides the generated one.
#' @param MessageGroupId This parameter applies only to FIFO (first-in-first-out) topics. The
#' `MessageGroupId` can contain up to 128 alphanumeric characters
#' `(a-z, A-Z, 0-9)` and punctuation
#' `` (!\"#$%&\'()*+,-./:;<=>?@@[\]^_\`{|}~) ``.
#' 
#' The `MessageGroupId` is a tag that specifies that a message belongs to a
#' specific message group. Messages that belong to the same message group
#' are processed in a FIFO manner (however, messages in different message
#' groups might be processed out of order). Every message must include a
#' `MessageGroupId`.
#'
#' @keywords internal
#'
#' @rdname sns_publish
sns_publish <- function(TopicArn = NULL, TargetArn = NULL, PhoneNumber = NULL, Message, Subject = NULL, MessageStructure = NULL, MessageAttributes = NULL, MessageDeduplicationId = NULL, MessageGroupId = NULL) {
  op <- new_operation(
    name = "Publish",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$publish_input(TopicArn = TopicArn, TargetArn = TargetArn, PhoneNumber = PhoneNumber, Message = Message, Subject = Subject, MessageStructure = MessageStructure, MessageAttributes = MessageAttributes, MessageDeduplicationId = MessageDeduplicationId, MessageGroupId = MessageGroupId)
  output <- .sns$publish_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$publish <- sns_publish

#' Publishes up to ten messages to the specified topic
#'
#' @description
#' Publishes up to ten messages to the specified topic. This is a batch version of [`publish`][sns_publish]. For FIFO topics, multiple messages within a single batch are published in the order they are sent, and messages are deduplicated within the batch and across batches for 5 minutes.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_publish_batch/](https://www.paws-r-sdk.com/docs/sns_publish_batch/) for full documentation.
#'
#' @param TopicArn &#91;required&#93; The Amazon resource name (ARN) of the topic you want to batch publish
#' to.
#' @param PublishBatchRequestEntries &#91;required&#93; A list of [`publish_batch`][sns_publish_batch] request entries to be
#' sent to the SNS topic.
#'
#' @keywords internal
#'
#' @rdname sns_publish_batch
sns_publish_batch <- function(TopicArn, PublishBatchRequestEntries) {
  op <- new_operation(
    name = "PublishBatch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$publish_batch_input(TopicArn = TopicArn, PublishBatchRequestEntries = PublishBatchRequestEntries)
  output <- .sns$publish_batch_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$publish_batch <- sns_publish_batch

#' Adds or updates an inline policy document that is stored in the
#' specified Amazon SNS topic
#'
#' @description
#' Adds or updates an inline policy document that is stored in the specified Amazon SNS topic.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_put_data_protection_policy/](https://www.paws-r-sdk.com/docs/sns_put_data_protection_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the topic whose `DataProtectionPolicy` you want to add or
#' update.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the Amazon Web Services General Reference.
#' @param DataProtectionPolicy &#91;required&#93; The JSON serialization of the topic's `DataProtectionPolicy`.
#' 
#' The `DataProtectionPolicy` must be in JSON string format.
#' 
#' Length Constraints: Maximum length of 30,720.
#'
#' @keywords internal
#'
#' @rdname sns_put_data_protection_policy
sns_put_data_protection_policy <- function(ResourceArn, DataProtectionPolicy) {
  op <- new_operation(
    name = "PutDataProtectionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$put_data_protection_policy_input(ResourceArn = ResourceArn, DataProtectionPolicy = DataProtectionPolicy)
  output <- .sns$put_data_protection_policy_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$put_data_protection_policy <- sns_put_data_protection_policy

#' Removes a statement from a topic's access control policy
#'
#' @description
#' Removes a statement from a topic's access control policy.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_remove_permission/](https://www.paws-r-sdk.com/docs/sns_remove_permission/) for full documentation.
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic whose access control policy you wish to modify.
#' @param Label &#91;required&#93; The unique label of the statement you want to remove.
#'
#' @keywords internal
#'
#' @rdname sns_remove_permission
sns_remove_permission <- function(TopicArn, Label) {
  op <- new_operation(
    name = "RemovePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$remove_permission_input(TopicArn = TopicArn, Label = Label)
  output <- .sns$remove_permission_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$remove_permission <- sns_remove_permission

#' Sets the attributes for an endpoint for a device on one of the supported
#' push notification services, such as GCM (Firebase Cloud Messaging) and
#' APNS
#'
#' @description
#' Sets the attributes for an endpoint for a device on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/sns-mobile-application-as-subscriber.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sns_set_endpoint_attributes/](https://www.paws-r-sdk.com/docs/sns_set_endpoint_attributes/) for full documentation.
#'
#' @param EndpointArn &#91;required&#93; EndpointArn used for
#' [`set_endpoint_attributes`][sns_set_endpoint_attributes] action.
#' @param Attributes &#91;required&#93; A map of the endpoint attributes. Attributes in this map include the
#' following:
#' 
#' -   `CustomUserData` – arbitrary user data to associate with the
#'     endpoint. Amazon SNS does not use this data. The data must be in
#'     UTF-8 format and less than 2KB.
#' 
#' -   `Enabled` – flag that enables/disables delivery to the endpoint.
#'     Amazon SNS will set this to false when a notification service
#'     indicates to Amazon SNS that the endpoint is invalid. Users can set
#'     it back to true, typically after updating Token.
#' 
#' -   `Token` – device token, also referred to as a registration id, for
#'     an app and mobile device. This is returned from the notification
#'     service when an app and mobile device are registered with the
#'     notification service.
#'
#' @keywords internal
#'
#' @rdname sns_set_endpoint_attributes
sns_set_endpoint_attributes <- function(EndpointArn, Attributes) {
  op <- new_operation(
    name = "SetEndpointAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$set_endpoint_attributes_input(EndpointArn = EndpointArn, Attributes = Attributes)
  output <- .sns$set_endpoint_attributes_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$set_endpoint_attributes <- sns_set_endpoint_attributes

#' Sets the attributes of the platform application object for the supported
#' push notification services, such as APNS and GCM (Firebase Cloud
#' Messaging)
#'
#' @description
#' Sets the attributes of the platform application object for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/sns-mobile-application-as-subscriber.html). For information on configuring attributes for message delivery status, see [Using Amazon SNS Application Attributes for Message Delivery Status](https://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sns_set_platform_application_attributes/](https://www.paws-r-sdk.com/docs/sns_set_platform_application_attributes/) for full documentation.
#'
#' @param PlatformApplicationArn &#91;required&#93; `PlatformApplicationArn` for
#' [`set_platform_application_attributes`][sns_set_platform_application_attributes]
#' action.
#' @param Attributes &#91;required&#93; A map of the platform application attributes. Attributes in this map
#' include the following:
#' 
#' -   `PlatformCredential` – The credential received from the notification
#'     service.
#' 
#'     -   For ADM, `PlatformCredential`is client secret.
#' 
#'     -   For Apple Services using certificate credentials,
#'         `PlatformCredential` is private key.
#' 
#'     -   For Apple Services using token credentials, `PlatformCredential`
#'         is signing key.
#' 
#'     -   For GCM (Firebase Cloud Messaging) using key credentials, there
#'         is no `PlatformPrincipal`. The `PlatformCredential` is
#'         `API key`.
#' 
#'     -   For GCM (Firebase Cloud Messaging) using token credentials,
#'         there is no `PlatformPrincipal`. The `PlatformCredential` is a
#'         JSON formatted private key file. When using the Amazon Web
#'         Services CLI, the file must be in string format and special
#'         characters must be ignored. To format the file correctly, Amazon
#'         SNS recommends using the following command:
#'         `` SERVICE_JSON=`jq @@json <<< cat service.json` ``.
#' 
#' 
#' -   `PlatformPrincipal` – The principal received from the notification
#'     service.
#' 
#'     -   For ADM, `PlatformPrincipal`is client id.
#' 
#'     -   For Apple Services using certificate credentials,
#'         `PlatformPrincipal` is SSL certificate.
#' 
#'     -   For Apple Services using token credentials, `PlatformPrincipal`
#'         is signing key ID.
#' 
#'     -   For GCM (Firebase Cloud Messaging), there is no
#'         `PlatformPrincipal`.
#' 
#' 
#' -   `EventEndpointCreated` – Topic ARN to which `EndpointCreated` event
#'     notifications are sent.
#' 
#' -   `EventEndpointDeleted` – Topic ARN to which `EndpointDeleted` event
#'     notifications are sent.
#' 
#' -   `EventEndpointUpdated` – Topic ARN to which `EndpointUpdate` event
#'     notifications are sent.
#' 
#' -   `EventDeliveryFailure` – Topic ARN to which `DeliveryFailure` event
#'     notifications are sent upon Direct Publish delivery failure
#'     (permanent) to one of the application's endpoints.
#' 
#' -   `SuccessFeedbackRoleArn` – IAM role ARN used to give Amazon SNS
#'     write access to use CloudWatch Logs on your behalf.
#' 
#' -   `FailureFeedbackRoleArn` – IAM role ARN used to give Amazon SNS
#'     write access to use CloudWatch Logs on your behalf.
#' 
#' -   `SuccessFeedbackSampleRate` – Sample rate percentage (0-100) of
#'     successfully delivered messages.
#' 
#' The following attributes only apply to `APNs` token-based
#' authentication:
#' 
#' -   `ApplePlatformTeamID` – The identifier that's assigned to your Apple
#'     developer account team.
#' 
#' -   `ApplePlatformBundleID` – The bundle identifier that's assigned to
#'     your iOS app.
#'
#' @keywords internal
#'
#' @rdname sns_set_platform_application_attributes
sns_set_platform_application_attributes <- function(PlatformApplicationArn, Attributes) {
  op <- new_operation(
    name = "SetPlatformApplicationAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$set_platform_application_attributes_input(PlatformApplicationArn = PlatformApplicationArn, Attributes = Attributes)
  output <- .sns$set_platform_application_attributes_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$set_platform_application_attributes <- sns_set_platform_application_attributes

#' Use this request to set the default settings for sending SMS messages
#' and receiving daily SMS usage reports
#'
#' @description
#' Use this request to set the default settings for sending SMS messages and receiving daily SMS usage reports.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_set_sms_attributes/](https://www.paws-r-sdk.com/docs/sns_set_sms_attributes/) for full documentation.
#'
#' @param attributes &#91;required&#93; The default settings for sending SMS messages from your Amazon Web
#' Services account. You can set values for the following attribute names:
#' 
#' `MonthlySpendLimit` – The maximum amount in USD that you are willing to
#' spend each month to send SMS messages. When Amazon SNS determines that
#' sending an SMS message would incur a cost that exceeds this limit, it
#' stops sending SMS messages within minutes.
#' 
#' Amazon SNS stops sending SMS messages within minutes of the limit being
#' crossed. During that interval, if you continue to send SMS messages, you
#' will incur costs that exceed your limit.
#' 
#' By default, the spend limit is set to the maximum allowed by Amazon SNS.
#' If you want to raise the limit, submit an SNS Limit Increase case. For
#' **New limit value**, enter your desired monthly spend limit. In the
#' **Use Case Description** field, explain that you are requesting an SMS
#' monthly spend limit increase.
#' 
#' `DeliveryStatusIAMRole` – The ARN of the IAM role that allows Amazon SNS
#' to write logs about SMS deliveries in CloudWatch Logs. For each SMS
#' message that you send, Amazon SNS writes a log that includes the message
#' price, the success or failure status, the reason for failure (if the
#' message failed), the message dwell time, and other information.
#' 
#' `DeliveryStatusSuccessSamplingRate` – The percentage of successful SMS
#' deliveries for which Amazon SNS will write logs in CloudWatch Logs. The
#' value can be an integer from 0 - 100. For example, to write logs only
#' for failed deliveries, set this value to `0`. To write logs for 10% of
#' your successful deliveries, set it to `10`.
#' 
#' `DefaultSenderID` – A string, such as your business brand, that is
#' displayed as the sender on the receiving device. Support for sender IDs
#' varies by country. The sender ID can be 1 - 11 alphanumeric characters,
#' and it must contain at least one letter.
#' 
#' `DefaultSMSType` – The type of SMS message that you will send by
#' default. You can assign the following values:
#' 
#' -   `Promotional` – (Default) Noncritical messages, such as marketing
#'     messages. Amazon SNS optimizes the message delivery to incur the
#'     lowest cost.
#' 
#' -   `Transactional` – Critical messages that support customer
#'     transactions, such as one-time passcodes for multi-factor
#'     authentication. Amazon SNS optimizes the message delivery to achieve
#'     the highest reliability.
#' 
#' `UsageReportS3Bucket` – The name of the Amazon S3 bucket to receive
#' daily SMS usage reports from Amazon SNS. Each day, Amazon SNS will
#' deliver a usage report as a CSV file to the bucket. The report includes
#' the following information for each SMS message that was successfully
#' delivered by your Amazon Web Services account:
#' 
#' -   Time that the message was published (in UTC)
#' 
#' -   Message ID
#' 
#' -   Destination phone number
#' 
#' -   Message type
#' 
#' -   Delivery status
#' 
#' -   Message price (in USD)
#' 
#' -   Part number (a message is split into multiple parts if it is too
#'     long for a single message)
#' 
#' -   Total number of parts
#' 
#' To receive the report, the bucket must have a policy that allows the
#' Amazon SNS service principal to perform the `s3:PutObject` and
#' `s3:GetBucketLocation` actions.
#' 
#' For an example bucket policy and usage report, see [Monitoring SMS
#' Activity](https://docs.aws.amazon.com/sns/latest/dg/sms_stats.html) in
#' the *Amazon SNS Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname sns_set_sms_attributes
sns_set_sms_attributes <- function(attributes) {
  op <- new_operation(
    name = "SetSMSAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$set_sms_attributes_input(attributes = attributes)
  output <- .sns$set_sms_attributes_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$set_sms_attributes <- sns_set_sms_attributes

#' Allows a subscription owner to set an attribute of the subscription to a
#' new value
#'
#' @description
#' Allows a subscription owner to set an attribute of the subscription to a new value.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_set_subscription_attributes/](https://www.paws-r-sdk.com/docs/sns_set_subscription_attributes/) for full documentation.
#'
#' @param SubscriptionArn &#91;required&#93; The ARN of the subscription to modify.
#' @param AttributeName &#91;required&#93; A map of attributes with their corresponding values.
#' 
#' The following lists the names, descriptions, and values of the special
#' request parameters that this action uses:
#' 
#' -   `DeliveryPolicy` – The policy that defines how Amazon SNS retries
#'     failed deliveries to HTTP/S endpoints.
#' 
#' -   `FilterPolicy` – The simple JSON object that lets your subscriber
#'     receive only a subset of messages, rather than receiving every
#'     message published to the topic.
#' 
#' -   `FilterPolicyScope` – This attribute lets you choose the filtering
#'     scope by using one of the following string value types:
#' 
#'     -   `MessageAttributes` (default) – The filter is applied on the
#'         message attributes.
#' 
#'     -   `MessageBody` – The filter is applied on the message body.
#' 
#' -   `RawMessageDelivery` – When set to `true`, enables raw message
#'     delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need
#'     for the endpoints to process JSON formatting, which is otherwise
#'     created for Amazon SNS metadata.
#' 
#' -   `RedrivePolicy` – When specified, sends undeliverable messages to
#'     the specified Amazon SQS dead-letter queue. Messages that can't be
#'     delivered due to client errors (for example, when the subscribed
#'     endpoint is unreachable) or server errors (for example, when the
#'     service that powers the subscribed endpoint becomes unavailable) are
#'     held in the dead-letter queue for further analysis or reprocessing.
#' 
#' The following attribute applies only to Amazon Kinesis Data Firehose
#' delivery stream subscriptions:
#' 
#' -   `SubscriptionRoleArn` – The ARN of the IAM role that has the
#'     following:
#' 
#'     -   Permission to write to the Kinesis Data Firehose delivery stream
#' 
#'     -   Amazon SNS listed as a trusted entity
#' 
#'     Specifying a valid ARN for this attribute is required for Kinesis
#'     Data Firehose delivery stream subscriptions. For more information,
#'     see [Fanout to Kinesis Data Firehose delivery
#'     streams](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html)
#'     in the *Amazon SNS Developer Guide*.
#' @param AttributeValue The new value for the attribute in JSON format.
#'
#' @keywords internal
#'
#' @rdname sns_set_subscription_attributes
sns_set_subscription_attributes <- function(SubscriptionArn, AttributeName, AttributeValue = NULL) {
  op <- new_operation(
    name = "SetSubscriptionAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$set_subscription_attributes_input(SubscriptionArn = SubscriptionArn, AttributeName = AttributeName, AttributeValue = AttributeValue)
  output <- .sns$set_subscription_attributes_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$set_subscription_attributes <- sns_set_subscription_attributes

#' Allows a topic owner to set an attribute of the topic to a new value
#'
#' @description
#' Allows a topic owner to set an attribute of the topic to a new value.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_set_topic_attributes/](https://www.paws-r-sdk.com/docs/sns_set_topic_attributes/) for full documentation.
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic to modify.
#' @param AttributeName &#91;required&#93; A map of attributes with their corresponding values.
#' 
#' The following lists the names, descriptions, and values of the special
#' request parameters that the
#' [`set_topic_attributes`][sns_set_topic_attributes] action uses:
#' 
#' -   `ApplicationSuccessFeedbackRoleArn` – Indicates failed message
#'     delivery status for an Amazon SNS topic that is subscribed to a
#'     platform application endpoint.
#' 
#' -   `DeliveryPolicy` – The policy that defines how Amazon SNS retries
#'     failed deliveries to HTTP/S endpoints.
#' 
#' -   `DisplayName` – The display name to use for a topic with SMS
#'     subscriptions.
#' 
#' -   `Policy` – The policy that defines who can access your topic. By
#'     default, only the topic owner can publish or subscribe to the topic.
#' 
#' -   `TracingConfig` – Tracing mode of an Amazon SNS topic. By default
#'     `TracingConfig` is set to `PassThrough`, and the topic passes
#'     through the tracing header it receives from an Amazon SNS publisher
#'     to its subscriptions. If set to `Active`, Amazon SNS will vend X-Ray
#'     segment data to topic owner account if the sampled flag in the
#'     tracing header is true. This is only supported on standard topics.
#' 
#' -   HTTP
#' 
#'     -   `HTTPSuccessFeedbackRoleArn` – Indicates successful message
#'         delivery status for an Amazon SNS topic that is subscribed to an
#'         HTTP endpoint.
#' 
#'     -   `HTTPSuccessFeedbackSampleRate` – Indicates percentage of
#'         successful messages to sample for an Amazon SNS topic that is
#'         subscribed to an HTTP endpoint.
#' 
#'     -   `HTTPFailureFeedbackRoleArn` – Indicates failed message delivery
#'         status for an Amazon SNS topic that is subscribed to an HTTP
#'         endpoint.
#' 
#' -   Amazon Kinesis Data Firehose
#' 
#'     -   `FirehoseSuccessFeedbackRoleArn` – Indicates successful message
#'         delivery status for an Amazon SNS topic that is subscribed to an
#'         Amazon Kinesis Data Firehose endpoint.
#' 
#'     -   `FirehoseSuccessFeedbackSampleRate` – Indicates percentage of
#'         successful messages to sample for an Amazon SNS topic that is
#'         subscribed to an Amazon Kinesis Data Firehose endpoint.
#' 
#'     -   `FirehoseFailureFeedbackRoleArn` – Indicates failed message
#'         delivery status for an Amazon SNS topic that is subscribed to an
#'         Amazon Kinesis Data Firehose endpoint.
#' 
#' -   Lambda
#' 
#'     -   `LambdaSuccessFeedbackRoleArn` – Indicates successful message
#'         delivery status for an Amazon SNS topic that is subscribed to an
#'         Lambda endpoint.
#' 
#'     -   `LambdaSuccessFeedbackSampleRate` – Indicates percentage of
#'         successful messages to sample for an Amazon SNS topic that is
#'         subscribed to an Lambda endpoint.
#' 
#'     -   `LambdaFailureFeedbackRoleArn` – Indicates failed message
#'         delivery status for an Amazon SNS topic that is subscribed to an
#'         Lambda endpoint.
#' 
#' -   Platform application endpoint
#' 
#'     -   `ApplicationSuccessFeedbackRoleArn` – Indicates successful
#'         message delivery status for an Amazon SNS topic that is
#'         subscribed to an Amazon Web Services application endpoint.
#' 
#'     -   `ApplicationSuccessFeedbackSampleRate` – Indicates percentage of
#'         successful messages to sample for an Amazon SNS topic that is
#'         subscribed to an Amazon Web Services application endpoint.
#' 
#'     -   `ApplicationFailureFeedbackRoleArn` – Indicates failed message
#'         delivery status for an Amazon SNS topic that is subscribed to an
#'         Amazon Web Services application endpoint.
#' 
#'     In addition to being able to configure topic attributes for message
#'     delivery status of notification messages sent to Amazon SNS
#'     application endpoints, you can also configure application attributes
#'     for the delivery status of push notification messages sent to push
#'     notification services.
#' 
#'     For example, For more information, see [Using Amazon SNS Application
#'     Attributes for Message Delivery
#'     Status](https://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html).
#' 
#' -   Amazon SQS
#' 
#'     -   `SQSSuccessFeedbackRoleArn` – Indicates successful message
#'         delivery status for an Amazon SNS topic that is subscribed to an
#'         Amazon SQS endpoint.
#' 
#'     -   `SQSSuccessFeedbackSampleRate` – Indicates percentage of
#'         successful messages to sample for an Amazon SNS topic that is
#'         subscribed to an Amazon SQS endpoint.
#' 
#'     -   `SQSFailureFeedbackRoleArn` – Indicates failed message delivery
#'         status for an Amazon SNS topic that is subscribed to an Amazon
#'         SQS endpoint.
#' 
#' The \<ENDPOINT\>SuccessFeedbackRoleArn and
#' \<ENDPOINT\>FailureFeedbackRoleArn attributes are used to give Amazon
#' SNS write access to use CloudWatch Logs on your behalf. The
#' \<ENDPOINT\>SuccessFeedbackSampleRate attribute is for specifying the
#' sample rate percentage (0-100) of successfully delivered messages. After
#' you configure the \<ENDPOINT\>FailureFeedbackRoleArn attribute, then all
#' failed message deliveries generate CloudWatch Logs.
#' 
#' The following attribute applies only to
#' [server-side-encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html):
#' 
#' -   `KmsMasterKeyId` – The ID of an Amazon Web Services managed customer
#'     master key (CMK) for Amazon SNS or a custom CMK. For more
#'     information, see [Key
#'     Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms).
#'     For more examples, see
#'     [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters)
#'     in the *Key Management Service API Reference*.
#' 
#' -   `SignatureVersion` – The signature version corresponds to the
#'     hashing algorithm used while creating the signature of the
#'     notifications, subscription confirmations, or unsubscribe
#'     confirmation messages sent by Amazon SNS. By default,
#'     `SignatureVersion` is set to `1`.
#' 
#' The following attribute applies only to [FIFO
#' topics](https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html):
#' 
#' -   `ContentBasedDeduplication` – Enables content-based deduplication
#'     for FIFO topics.
#' 
#'     -   By default, `ContentBasedDeduplication` is set to `false`. If
#'         you create a FIFO topic and this attribute is `false`, you must
#'         specify a value for the `MessageDeduplicationId` parameter for
#'         the [`publish`][sns_publish] action.
#' 
#'     -   When you set `ContentBasedDeduplication` to `true`, Amazon SNS
#'         uses a SHA-256 hash to generate the `MessageDeduplicationId`
#'         using the body of the message (but not the attributes of the
#'         message).
#' 
#'         (Optional) To override the generated value, you can specify a
#'         value for the `MessageDeduplicationId` parameter for the
#'         [`publish`][sns_publish] action.
#' @param AttributeValue The new value for the attribute.
#'
#' @keywords internal
#'
#' @rdname sns_set_topic_attributes
sns_set_topic_attributes <- function(TopicArn, AttributeName, AttributeValue = NULL) {
  op <- new_operation(
    name = "SetTopicAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$set_topic_attributes_input(TopicArn = TopicArn, AttributeName = AttributeName, AttributeValue = AttributeValue)
  output <- .sns$set_topic_attributes_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$set_topic_attributes <- sns_set_topic_attributes

#' Subscribes an endpoint to an Amazon SNS topic
#'
#' @description
#' Subscribes an endpoint to an Amazon SNS topic. If the endpoint type is HTTP/S or email, or if the endpoint and the topic are not in the same Amazon Web Services account, the endpoint owner must run the [`confirm_subscription`][sns_confirm_subscription] action to confirm the subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_subscribe/](https://www.paws-r-sdk.com/docs/sns_subscribe/) for full documentation.
#'
#' @param TopicArn &#91;required&#93; The ARN of the topic you want to subscribe to.
#' @param Protocol &#91;required&#93; The protocol that you want to use. Supported protocols include:
#' 
#' -   `http` – delivery of JSON-encoded message via HTTP POST
#' 
#' -   `https` – delivery of JSON-encoded message via HTTPS POST
#' 
#' -   `email` – delivery of message via SMTP
#' 
#' -   `email-json` – delivery of JSON-encoded message via SMTP
#' 
#' -   `sms` – delivery of message via SMS
#' 
#' -   `sqs` – delivery of JSON-encoded message to an Amazon SQS queue
#' 
#' -   `application` – delivery of JSON-encoded message to an EndpointArn
#'     for a mobile app and device
#' 
#' -   `lambda` – delivery of JSON-encoded message to an Lambda function
#' 
#' -   `firehose` – delivery of JSON-encoded message to an Amazon Kinesis
#'     Data Firehose delivery stream.
#' @param Endpoint The endpoint that you want to receive notifications. Endpoints vary by
#' protocol:
#' 
#' -   For the `http` protocol, the (public) endpoint is a URL beginning
#'     with `http://`.
#' 
#' -   For the `https` protocol, the (public) endpoint is a URL beginning
#'     with `https://`.
#' 
#' -   For the `email` protocol, the endpoint is an email address.
#' 
#' -   For the `email-json` protocol, the endpoint is an email address.
#' 
#' -   For the `sms` protocol, the endpoint is a phone number of an
#'     SMS-enabled device.
#' 
#' -   For the `sqs` protocol, the endpoint is the ARN of an Amazon SQS
#'     queue.
#' 
#' -   For the `application` protocol, the endpoint is the EndpointArn of a
#'     mobile app and device.
#' 
#' -   For the `lambda` protocol, the endpoint is the ARN of an Lambda
#'     function.
#' 
#' -   For the `firehose` protocol, the endpoint is the ARN of an Amazon
#'     Kinesis Data Firehose delivery stream.
#' @param Attributes A map of attributes with their corresponding values.
#' 
#' The following lists the names, descriptions, and values of the special
#' request parameters that the [`subscribe`][sns_subscribe] action uses:
#' 
#' -   `DeliveryPolicy` – The policy that defines how Amazon SNS retries
#'     failed deliveries to HTTP/S endpoints.
#' 
#' -   `FilterPolicy` – The simple JSON object that lets your subscriber
#'     receive only a subset of messages, rather than receiving every
#'     message published to the topic.
#' 
#' -   `FilterPolicyScope` – This attribute lets you choose the filtering
#'     scope by using one of the following string value types:
#' 
#'     -   `MessageAttributes` (default) – The filter is applied on the
#'         message attributes.
#' 
#'     -   `MessageBody` – The filter is applied on the message body.
#' 
#' -   `RawMessageDelivery` – When set to `true`, enables raw message
#'     delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need
#'     for the endpoints to process JSON formatting, which is otherwise
#'     created for Amazon SNS metadata.
#' 
#' -   `RedrivePolicy` – When specified, sends undeliverable messages to
#'     the specified Amazon SQS dead-letter queue. Messages that can't be
#'     delivered due to client errors (for example, when the subscribed
#'     endpoint is unreachable) or server errors (for example, when the
#'     service that powers the subscribed endpoint becomes unavailable) are
#'     held in the dead-letter queue for further analysis or reprocessing.
#' 
#' The following attribute applies only to Amazon Kinesis Data Firehose
#' delivery stream subscriptions:
#' 
#' -   `SubscriptionRoleArn` – The ARN of the IAM role that has the
#'     following:
#' 
#'     -   Permission to write to the Kinesis Data Firehose delivery stream
#' 
#'     -   Amazon SNS listed as a trusted entity
#' 
#'     Specifying a valid ARN for this attribute is required for Kinesis
#'     Data Firehose delivery stream subscriptions. For more information,
#'     see [Fanout to Kinesis Data Firehose delivery
#'     streams](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html)
#'     in the *Amazon SNS Developer Guide*.
#' 
#' The following attributes apply only to [FIFO
#' topics](https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html):
#' 
#' -   `ReplayPolicy` – Adds or updates an inline policy document for a
#'     subscription to replay messages stored in the specified Amazon SNS
#'     topic.
#' 
#' -   `ReplayStatus` – Retrieves the status of the subscription message
#'     replay, which can be one of the following:
#' 
#'     -   `Completed` – The replay has successfully redelivered all
#'         messages, and is now delivering newly published messages. If an
#'         ending point was specified in the `ReplayPolicy` then the
#'         subscription will no longer receive newly published messages.
#' 
#'     -   `In progress` – The replay is currently replaying the selected
#'         messages.
#' 
#'     -   `Failed` – The replay was unable to complete.
#' 
#'     -   `Pending` – The default state while the replay initiates.
#' @param ReturnSubscriptionArn Sets whether the response from the [`subscribe`][sns_subscribe] request
#' includes the subscription ARN, even if the subscription is not yet
#' confirmed.
#' 
#' If you set this parameter to `true`, the response includes the ARN in
#' all cases, even if the subscription is not yet confirmed. In addition to
#' the ARN for confirmed subscriptions, the response also includes the
#' `pending subscription` ARN value for subscriptions that aren't yet
#' confirmed. A subscription becomes confirmed when the subscriber calls
#' the [`confirm_subscription`][sns_confirm_subscription] action with a
#' confirmation token.
#' 
#' The default value is `false`.
#'
#' @keywords internal
#'
#' @rdname sns_subscribe
sns_subscribe <- function(TopicArn, Protocol, Endpoint = NULL, Attributes = NULL, ReturnSubscriptionArn = NULL) {
  op <- new_operation(
    name = "Subscribe",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$subscribe_input(TopicArn = TopicArn, Protocol = Protocol, Endpoint = Endpoint, Attributes = Attributes, ReturnSubscriptionArn = ReturnSubscriptionArn)
  output <- .sns$subscribe_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$subscribe <- sns_subscribe

#' Add tags to the specified Amazon SNS topic
#'
#' @description
#' Add tags to the specified Amazon SNS topic. For an overview, see [Amazon SNS Tags](https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html) in the *Amazon SNS Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_tag_resource/](https://www.paws-r-sdk.com/docs/sns_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the topic to which to add tags.
#' @param Tags &#91;required&#93; The tags to be added to the specified topic. A tag consists of a
#' required key and an optional value.
#'
#' @keywords internal
#'
#' @rdname sns_tag_resource
sns_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .sns$tag_resource_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$tag_resource <- sns_tag_resource

#' Deletes a subscription
#'
#' @description
#' Deletes a subscription. If the subscription requires authentication for deletion, only the owner of the subscription or the topic's owner can unsubscribe, and an Amazon Web Services signature is required. If the [`unsubscribe`][sns_unsubscribe] call does not require authentication and the requester is not the subscription owner, a final cancellation message is delivered to the endpoint, so that the endpoint owner can easily resubscribe to the topic if the [`unsubscribe`][sns_unsubscribe] request was unintended.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_unsubscribe/](https://www.paws-r-sdk.com/docs/sns_unsubscribe/) for full documentation.
#'
#' @param SubscriptionArn &#91;required&#93; The ARN of the subscription to be deleted.
#'
#' @keywords internal
#'
#' @rdname sns_unsubscribe
sns_unsubscribe <- function(SubscriptionArn) {
  op <- new_operation(
    name = "Unsubscribe",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$unsubscribe_input(SubscriptionArn = SubscriptionArn)
  output <- .sns$unsubscribe_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$unsubscribe <- sns_unsubscribe

#' Remove tags from the specified Amazon SNS topic
#'
#' @description
#' Remove tags from the specified Amazon SNS topic. For an overview, see [Amazon SNS Tags](https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html) in the *Amazon SNS Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_untag_resource/](https://www.paws-r-sdk.com/docs/sns_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the topic from which to remove tags.
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the specified topic.
#'
#' @keywords internal
#'
#' @rdname sns_untag_resource
sns_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .sns$untag_resource_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$untag_resource <- sns_untag_resource

#' Verifies a destination phone number with a one-time password (OTP) for
#' the calling Amazon Web Services account
#'
#' @description
#' Verifies a destination phone number with a one-time password (OTP) for the calling Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/sns_verify_sms_sandbox_phone_number/](https://www.paws-r-sdk.com/docs/sns_verify_sms_sandbox_phone_number/) for full documentation.
#'
#' @param PhoneNumber &#91;required&#93; The destination phone number to verify.
#' @param OneTimePassword &#91;required&#93; The OTP sent to the destination number from the
#' `CreateSMSSandBoxPhoneNumber` call.
#'
#' @keywords internal
#'
#' @rdname sns_verify_sms_sandbox_phone_number
sns_verify_sms_sandbox_phone_number <- function(PhoneNumber, OneTimePassword) {
  op <- new_operation(
    name = "VerifySMSSandboxPhoneNumber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sns$verify_sms_sandbox_phone_number_input(PhoneNumber = PhoneNumber, OneTimePassword = OneTimePassword)
  output <- .sns$verify_sms_sandbox_phone_number_output()
  config <- get_config()
  svc <- .sns$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sns$operations$verify_sms_sandbox_phone_number <- sns_verify_sms_sandbox_phone_number
