% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridgescheduler_operations.R
\name{eventbridgescheduler_delete_schedule_group}
\alias{eventbridgescheduler_delete_schedule_group}
\title{Deletes the specified schedule group}
\usage{
eventbridgescheduler_delete_schedule_group(ClientToken = NULL, Name)
}
\arguments{
\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. If you do not specify a client token, EventBridge
Scheduler uses a randomly generated token for the request to ensure
idempotency.}

\item{Name}{[required] The name of the schedule group to delete.}
}
\description{
Deletes the specified schedule group. Deleting a schedule group results in EventBridge Scheduler deleting all schedules associated with the group. When you delete a group, it remains in a \code{DELETING} state until all of its associated schedules are deleted. Schedules associated with the group that are set to run while the schedule group is in the process of being deleted might continue to invoke their targets until the schedule group and its associated schedules are deleted.

See \url{https://www.paws-r-sdk.com/docs/eventbridgescheduler_delete_schedule_group/} for full documentation.
}
\keyword{internal}
