% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_set_platform_application_attributes}
\alias{sns_set_platform_application_attributes}
\title{Sets the attributes of the platform application object for the supported
push notification services, such as APNS and GCM (Firebase Cloud
Messaging)}
\usage{
sns_set_platform_application_attributes(PlatformApplicationArn, Attributes)
}
\arguments{
\item{PlatformApplicationArn}{[required] \code{PlatformApplicationArn} for
\code{\link[=sns_set_platform_application_attributes]{set_platform_application_attributes}}
action.}

\item{Attributes}{[required] A map of the platform application attributes. Attributes in this map
include the following:
\itemize{
\item \code{PlatformCredential} – The credential received from the notification
service.
\itemize{
\item For ADM, \code{PlatformCredential}is client secret.
\item For Apple Services using certificate credentials,
\code{PlatformCredential} is private key.
\item For Apple Services using token credentials, \code{PlatformCredential}
is signing key.
\item For GCM (Firebase Cloud Messaging) using key credentials, there
is no \code{PlatformPrincipal}. The \code{PlatformCredential} is
\verb{API key}.
\item For GCM (Firebase Cloud Messaging) using token credentials,
there is no \code{PlatformPrincipal}. The \code{PlatformCredential} is a
JSON formatted private key file. When using the Amazon Web
Services CLI, the file must be in string format and special
characters must be ignored. To format the file correctly, Amazon
SNS recommends using the following command:
\code{SERVICE_JSON=`jq @json <<< cat service.json`}.
}
\item \code{PlatformPrincipal} – The principal received from the notification
service.
\itemize{
\item For ADM, \code{PlatformPrincipal}is client id.
\item For Apple Services using certificate credentials,
\code{PlatformPrincipal} is SSL certificate.
\item For Apple Services using token credentials, \code{PlatformPrincipal}
is signing key ID.
\item For GCM (Firebase Cloud Messaging), there is no
\code{PlatformPrincipal}.
}
\item \code{EventEndpointCreated} – Topic ARN to which \code{EndpointCreated} event
notifications are sent.
\item \code{EventEndpointDeleted} – Topic ARN to which \code{EndpointDeleted} event
notifications are sent.
\item \code{EventEndpointUpdated} – Topic ARN to which \code{EndpointUpdate} event
notifications are sent.
\item \code{EventDeliveryFailure} – Topic ARN to which \code{DeliveryFailure} event
notifications are sent upon Direct Publish delivery failure
(permanent) to one of the application's endpoints.
\item \code{SuccessFeedbackRoleArn} – IAM role ARN used to give Amazon SNS
write access to use CloudWatch Logs on your behalf.
\item \code{FailureFeedbackRoleArn} – IAM role ARN used to give Amazon SNS
write access to use CloudWatch Logs on your behalf.
\item \code{SuccessFeedbackSampleRate} – Sample rate percentage (0-100) of
successfully delivered messages.
}

The following attributes only apply to \code{APNs} token-based
authentication:
\itemize{
\item \code{ApplePlatformTeamID} – The identifier that's assigned to your Apple
developer account team.
\item \code{ApplePlatformBundleID} – The bundle identifier that's assigned to
your iOS app.
}}
}
\description{
Sets the attributes of the platform application object for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see \href{https://docs.aws.amazon.com/sns/latest/dg/sns-mobile-application-as-subscriber.html}{Using Amazon SNS Mobile Push Notifications}. For information on configuring attributes for message delivery status, see \href{https://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html}{Using Amazon SNS Application Attributes for Message Delivery Status}.

See \url{https://www.paws-r-sdk.com/docs/sns_set_platform_application_attributes/} for full documentation.
}
\keyword{internal}
