% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paginate.R
\name{paginate}
\alias{paginate}
\alias{paginate_lapply}
\alias{paginate_sapply}
\title{Paginate over an operation.}
\usage{
paginate(Operation, PageSize = NULL, MaxItems = NULL, StartingToken = NULL)

paginate_lapply(
  Operation,
  FUN,
  ...,
  PageSize = NULL,
  MaxItems = NULL,
  StartingToken = NULL
)

paginate_sapply(
  Operation,
  FUN,
  ...,
  simplify = TRUE,
  PageSize = NULL,
  MaxItems = NULL,
  StartingToken = NULL
)
}
\arguments{
\item{Operation}{The operation for example an s3 operation: \code{svc$list_buckets()}}

\item{PageSize}{The size of each page.}

\item{MaxItems}{Limits the maximum number of total returned items returned while paginating.}

\item{StartingToken}{Can be used to modify the starting marker or token of a paginator.
This argument if useful for resuming pagination from a previous token or starting pagination at a known position.}

\item{FUN}{the function to be applied to each response element of \code{operation}.}

\item{...}{optional arguments to \code{FUN}.}

\item{simplify}{See \link[base:sapply]{base::sapply()}.}
}
\value{
list of responses from the operation.
}
\description{
Some AWS operations return results that are incomplete and require subsequent
requests in order to attain the entire result set. The process of sending subsequent
requests to continue where a previous request left off is called pagination.
For example, the list_objects operation of Amazon S3 returns up to 1000 objects
at a time, and you must send subsequent requests with the appropriate Marker
in order to retrieve the next page of results.
}
\examples{
\dontrun{
# The following example retrieves object list. The request specifies max
# keys to limit response to include only 2 object keys.
paginate(
  svc$list_objects_v2(
    Bucket = "DOC-EXAMPLE-BUCKET"
  ),
  MaxItems = 50
)
}
}
