% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_put_account_setting_default}
\alias{ecs_put_account_setting_default}
\title{Modifies the ARN and resource ID format of a resource type for all IAM
users on an account for which no individual account setting has been set}
\usage{
ecs_put_account_setting_default(name, value)
}
\arguments{
\item{name}{[required] The resource type to enable the new format for. If
\code{serviceLongArnFormat} is specified, the ARN for your Amazon ECS
services is affected. If \code{taskLongArnFormat} is specified, the ARN and
resource ID for your Amazon ECS tasks are affected. If
\code{containerInstanceLongArnFormat} is specified, the ARN and resource ID
for your Amazon ECS container instances are affected.}

\item{value}{[required] The account setting value for the specified principal ARN. Accepted
values are \code{enabled} and \code{disabled}.}
}
\description{
Modifies the ARN and resource ID format of a resource type for all IAM
users on an account for which no individual account setting has been
set. Enabling this setting is required to use new Amazon ECS features
such as resource tagging.
}
\section{Request syntax}{
\preformatted{svc$put_account_setting_default(
  name = "serviceLongArnFormat"|"taskLongArnFormat"|"containerInstanceLongArnFormat",
  value = "string"
)
}
}

\examples{
# This example modifies the default account setting for the specified
# resource for all IAM users or roles on an account. These changes apply
# to the entire AWS account, unless an IAM user or role explicitly
# overrides these settings for themselves.
\donttest{svc$put_account_setting_default(
  name = "serviceLongArnFormat",
  value = "enabled"
)}

}
\keyword{internal}
