% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_client_vpn_endpoint}
\alias{ec2_create_client_vpn_endpoint}
\title{Creates a Client VPN endpoint}
\usage{
ec2_create_client_vpn_endpoint(ClientCidrBlock, ServerCertificateArn,
  AuthenticationOptions, ConnectionLogOptions, DnsServers,
  TransportProtocol, VpnPort, Description, SplitTunnel, DryRun,
  ClientToken, TagSpecifications, SecurityGroupIds, VpcId,
  SelfServicePortal, ClientConnectOptions)
}
\arguments{
\item{ClientCidrBlock}{[required] The IPv4 address range, in CIDR notation, from which to assign client IP
addresses. The address range cannot overlap with the local CIDR of the
VPC in which the associated subnet is located, or the routes that you
add manually. The address range cannot be changed after the Client VPN
endpoint has been created. The CIDR block should be /22 or greater.}

\item{ServerCertificateArn}{[required] The ARN of the server certificate. For more information, see the \href{https://docs.aws.amazon.com/acm/latest/userguide/}{AWS Certificate Manager User Guide}.}

\item{AuthenticationOptions}{[required] Information about the authentication method to be used to authenticate
clients.}

\item{ConnectionLogOptions}{[required] Information about the client connection logging options.

If you enable client connection logging, data about client connections
is sent to a Cloudwatch Logs log stream. The following information is
logged:
\itemize{
\item Client connection requests
\item Client connection results (successful and unsuccessful)
\item Reasons for unsuccessful client connection requests
\item Client connection termination time
}}

\item{DnsServers}{Information about the DNS servers to be used for DNS resolution. A
Client VPN endpoint can have up to two DNS servers. If no DNS server is
specified, the DNS address configured on the device is used for the DNS
server.}

\item{TransportProtocol}{The transport protocol to be used by the VPN session.

Default value: \code{udp}}

\item{VpnPort}{The port number to assign to the Client VPN endpoint for TCP and UDP
traffic.

Valid Values: \code{443} | \code{1194}

Default Value: \code{443}}

\item{Description}{A brief description of the Client VPN endpoint.}

\item{SplitTunnel}{Indicates whether split-tunnel is enabled on the AWS Client VPN
endpoint.

By default, split-tunnel on a VPN endpoint is disabled.

For information about split-tunnel VPN endpoints, see \href{https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html}{Split-Tunnel AWS Client VPN Endpoint}
in the \emph{AWS Client VPN Administrator Guide}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.}

\item{TagSpecifications}{The tags to apply to the Client VPN endpoint during creation.}

\item{SecurityGroupIds}{The IDs of one or more security groups to apply to the target network.
You must also specify the ID of the VPC that contains the security
groups.}

\item{VpcId}{The ID of the VPC to associate with the Client VPN endpoint. If no
security group IDs are specified in the request, the default security
group for the VPC is applied.}

\item{SelfServicePortal}{Specify whether to enable the self-service portal for the Client VPN
endpoint.

Default Value: \code{enabled}}

\item{ClientConnectOptions}{The options for managing connection authorization for new client
connections.}
}
\description{
Creates a Client VPN endpoint. A Client VPN endpoint is the resource you
create and configure to enable and manage client VPN sessions. It is the
destination endpoint at which all client VPN sessions are terminated.
}
\section{Request syntax}{
\preformatted{svc$create_client_vpn_endpoint(
  ClientCidrBlock = "string",
  ServerCertificateArn = "string",
  AuthenticationOptions = list(
    list(
      Type = "certificate-authentication"|"directory-service-authentication"|"federated-authentication",
      ActiveDirectory = list(
        DirectoryId = "string"
      ),
      MutualAuthentication = list(
        ClientRootCertificateChainArn = "string"
      ),
      FederatedAuthentication = list(
        SAMLProviderArn = "string",
        SelfServiceSAMLProviderArn = "string"
      )
    )
  ),
  ConnectionLogOptions = list(
    Enabled = TRUE|FALSE,
    CloudwatchLogGroup = "string",
    CloudwatchLogStream = "string"
  ),
  DnsServers = list(
    "string"
  ),
  TransportProtocol = "tcp"|"udp",
  VpnPort = 123,
  Description = "string",
  SplitTunnel = TRUE|FALSE,
  DryRun = TRUE|FALSE,
  ClientToken = "string",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  SecurityGroupIds = list(
    "string"
  ),
  VpcId = "string",
  SelfServicePortal = "enabled"|"disabled",
  ClientConnectOptions = list(
    Enabled = TRUE|FALSE,
    LambdaFunctionArn = "string"
  )
)
}
}

\keyword{internal}
