% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_load_balancer_tls_certificates}
\alias{lightsail_get_load_balancer_tls_certificates}
\title{Returns information about the TLS certificates that are associated with
the specified Lightsail load balancer}
\usage{
lightsail_get_load_balancer_tls_certificates(loadBalancerName)
}
\arguments{
\item{loadBalancerName}{[required] The name of the load balancer you associated with your SSL/TLS
certificate.}
}
\description{
Returns information about the TLS certificates that are associated with
the specified Lightsail load balancer.

TLS is just an updated, more secure version of Secure Socket Layer
(SSL).

You can have a maximum of 2 certificates associated with a Lightsail
load balancer. One is active and the other is inactive.
}
\section{Request syntax}{
\preformatted{svc$get_load_balancer_tls_certificates(
  loadBalancerName = "string"
)
}
}

\keyword{internal}
