% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_host_reservation_offerings}
\alias{ec2_describe_host_reservation_offerings}
\title{Describes the Dedicated Host reservations that are available to purchase}
\usage{
ec2_describe_host_reservation_offerings(Filter, MaxDuration, MaxResults,
  MinDuration, NextToken, OfferingId)
}
\arguments{
\item{Filter}{The filters.
\itemize{
\item \code{instance-family} - The instance family of the offering (for
example, \code{m4}).
\item \code{payment-option} - The payment option (\code{NoUpfront} |
\code{PartialUpfront} | \code{AllUpfront}).
}}

\item{MaxDuration}{This is the maximum duration of the reservation to purchase, specified
in seconds. Reservations are available in one-year and three-year terms.
The number of seconds specified must be the number of seconds in a year
(365x24x60x60) times one of the supported durations (1 or 3). For
example, specify 94608000 for three years.}

\item{MaxResults}{The maximum number of results to return for the request in a single
page. The remaining results can be seen by sending another request with
the returned \code{nextToken} value. This value can be between 5 and 500. If
\code{maxResults} is given a larger value than 500, you receive an error.}

\item{MinDuration}{This is the minimum duration of the reservation you'd like to purchase,
specified in seconds. Reservations are available in one-year and
three-year terms. The number of seconds specified must be the number of
seconds in a year (365x24x60x60) times one of the supported durations (1
or 3). For example, specify 31536000 for one year.}

\item{NextToken}{The token to use to retrieve the next page of results.}

\item{OfferingId}{The ID of the reservation offering.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  OfferingSet = list(
    list(
      CurrencyCode = "USD",
      Duration = 123,
      HourlyPrice = "string",
      InstanceFamily = "string",
      OfferingId = "string",
      PaymentOption = "AllUpfront"|"PartialUpfront"|"NoUpfront",
      UpfrontPrice = "string"
    )
  )
)
}
}
\description{
Describes the Dedicated Host reservations that are available to
purchase.

The results describe all of the Dedicated Host reservation offerings,
including offerings that might not match the instance family and Region
of your Dedicated Hosts. When purchasing an offering, ensure that the
instance family and Region of the offering matches that of the Dedicated
Hosts with which it is to be associated. For more information about
supported instance types, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html}{Dedicated Hosts Overview}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_host_reservation_offerings(
  Filter = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxDuration = 123,
  MaxResults = 123,
  MinDuration = 123,
  NextToken = "string",
  OfferingId = "string"
)
}
}

\keyword{internal}
