% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_create_function}
\alias{lambda_create_function}
\title{Creates a Lambda function}
\usage{
lambda_create_function(FunctionName, Runtime, Role, Handler, Code,
  Description, Timeout, MemorySize, Publish, VpcConfig, PackageType,
  DeadLetterConfig, Environment, KMSKeyArn, TracingConfig, Tags, Layers,
  FileSystemConfigs, ImageConfig, CodeSigningConfigArn)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{Runtime}{The identifier of the function's
\href{https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html}{runtime}.}

\item{Role}{[required] The Amazon Resource Name (ARN) of the function's execution role.}

\item{Handler}{The name of the method within your code that Lambda calls to execute
your function. The format includes the file name. It can also include
namespaces and other qualifiers, depending on the runtime. For more
information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-features.html}{Programming Model}.}

\item{Code}{[required] The code for the function.}

\item{Description}{A description of the function.}

\item{Timeout}{The amount of time that Lambda allows a function to run before stopping
it. The default is 3 seconds. The maximum allowed value is 900 seconds.}

\item{MemorySize}{The amount of memory available to the function at runtime. Increasing
the function's memory also increases its CPU allocation. The default
value is 128 MB. The value can be any multiple of 1 MB.}

\item{Publish}{Set to true to publish the first version of the function during
creation.}

\item{VpcConfig}{For network connectivity to AWS resources in a VPC, specify a list of
security groups and subnets in the VPC. When you connect a function to a
VPC, it can only access resources and the internet through that VPC. For
more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html}{VPC Settings}.}

\item{PackageType}{The type of deployment package. Set to \code{Image} for container image and
set \code{Zip} for ZIP archive.}

\item{DeadLetterConfig}{A dead letter queue configuration that specifies the queue or topic
where Lambda sends asynchronous events when they fail processing. For
more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq}{Dead Letter Queues}.}

\item{Environment}{Environment variables that are accessible from function code during
execution.}

\item{KMSKeyArn}{The ARN of the AWS Key Management Service (AWS KMS) key that's used to
encrypt your function's environment variables. If it's not provided, AWS
Lambda uses a default service key.}

\item{TracingConfig}{Set \code{Mode} to \code{Active} to sample and trace a subset of incoming requests
with AWS X-Ray.}

\item{Tags}{A list of
\href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-tags.html}{tags}
to apply to the function.}

\item{Layers}{A list of \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html}{function layers}
to add to the function's execution environment. Specify each layer by
its ARN, including the version.}

\item{FileSystemConfigs}{Connection settings for an Amazon EFS file system.}

\item{ImageConfig}{Configuration values that override the container image Dockerfile.}

\item{CodeSigningConfigArn}{To enable code signing for this function, specify the ARN of a
code-signing configuration. A code-signing configuration includes a set
of signing profiles, which define the trusted publishers for this
function.}
}
\value{
A list with the following syntax:\preformatted{list(
  FunctionName = "string",
  FunctionArn = "string",
  Runtime = "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"nodejs12.x"|"java8"|"java8.al2"|"java11"|"python2.7"|"python3.6"|"python3.7"|"python3.8"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"dotnetcore3.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"ruby2.7"|"provided"|"provided.al2",
  Role = "string",
  Handler = "string",
  CodeSize = 123,
  Description = "string",
  Timeout = 123,
  MemorySize = 123,
  LastModified = "string",
  CodeSha256 = "string",
  Version = "string",
  VpcConfig = list(
    SubnetIds = list(
      "string"
    ),
    SecurityGroupIds = list(
      "string"
    ),
    VpcId = "string"
  ),
  DeadLetterConfig = list(
    TargetArn = "string"
  ),
  Environment = list(
    Variables = list(
      "string"
    ),
    Error = list(
      ErrorCode = "string",
      Message = "string"
    )
  ),
  KMSKeyArn = "string",
  TracingConfig = list(
    Mode = "Active"|"PassThrough"
  ),
  MasterArn = "string",
  RevisionId = "string",
  Layers = list(
    list(
      Arn = "string",
      CodeSize = 123,
      SigningProfileVersionArn = "string",
      SigningJobArn = "string"
    )
  ),
  State = "Pending"|"Active"|"Inactive"|"Failed",
  StateReason = "string",
  StateReasonCode = "Idle"|"Creating"|"Restoring"|"EniLimitExceeded"|"InsufficientRolePermissions"|"InvalidConfiguration"|"InternalError"|"SubnetOutOfIPAddresses"|"InvalidSubnet"|"InvalidSecurityGroup"|"ImageDeleted"|"ImageAccessDenied"|"InvalidImage",
  LastUpdateStatus = "Successful"|"Failed"|"InProgress",
  LastUpdateStatusReason = "string",
  LastUpdateStatusReasonCode = "EniLimitExceeded"|"InsufficientRolePermissions"|"InvalidConfiguration"|"InternalError"|"SubnetOutOfIPAddresses"|"InvalidSubnet"|"InvalidSecurityGroup"|"ImageDeleted"|"ImageAccessDenied"|"InvalidImage",
  FileSystemConfigs = list(
    list(
      Arn = "string",
      LocalMountPath = "string"
    )
  ),
  PackageType = "Zip"|"Image",
  ImageConfigResponse = list(
    ImageConfig = list(
      EntryPoint = list(
        "string"
      ),
      Command = list(
        "string"
      ),
      WorkingDirectory = "string"
    ),
    Error = list(
      ErrorCode = "string",
      Message = "string"
    )
  ),
  SigningProfileVersionArn = "string",
  SigningJobArn = "string"
)
}
}
\description{
Creates a Lambda function. To create a function, you need a \href{https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html}{deployment package}
and an \href{https://docs.aws.amazon.com/lambda/latest/dg/lambda-permissions.html#lambda-intro-execution-role}{execution role}.
The deployment package is a .zip file archive or container image that
contains your function code. The execution role grants the function
permission to use AWS services, such as Amazon CloudWatch Logs for log
streaming and AWS X-Ray for request tracing.

When you create a function, Lambda provisions an instance of the
function and its supporting resources. If your function connects to a
VPC, this process can take a minute or so. During this time, you can't
invoke or modify the function. The \code{State}, \code{StateReason}, and
\code{StateReasonCode} fields in the response from
\code{\link[=lambda_get_function_configuration]{get_function_configuration}}
indicate when the function is ready to invoke. For more information, see
\href{https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html}{Function States}.

A function has an unpublished version, and can have published versions
and aliases. The unpublished version changes when you update your
function's code and configuration. A published version is a snapshot of
your function code and configuration that can't be changed. An alias is
a named resource that maps to a version, and can be changed to map to a
different version. Use the \code{Publish} parameter to create version \code{1} of
your function from its initial configuration.

The other parameters let you configure version-specific and
function-level settings. You can modify version-specific settings later
with
\code{\link[=lambda_update_function_configuration]{update_function_configuration}}.
Function-level settings apply to both the unpublished and published
versions of the function, and include tags
(\code{\link[=lambda_tag_resource]{tag_resource}}) and per-function concurrency
limits (\code{\link[=lambda_put_function_concurrency]{put_function_concurrency}}).

You can use code signing if your deployment package is a .zip file
archive. To enable code signing for this function, specify the ARN of a
code-signing configuration. When a user attempts to deploy a code
package with \code{\link[=lambda_update_function_code]{update_function_code}},
Lambda checks that the code package has a valid signature from a trusted
publisher. The code-signing configuration includes set set of signing
profiles, which define the trusted publishers for this function.

If another account or an AWS service invokes your function, use
\code{\link[=lambda_add_permission]{add_permission}} to grant permission by
creating a resource-based IAM policy. You can grant permissions at the
function level, on a version, or on an alias.

To invoke your function directly, use \code{\link[=lambda_invoke]{invoke}}. To
invoke your function in response to events in other AWS services, create
an event source mapping
(\code{\link[=lambda_create_event_source_mapping]{create_event_source_mapping}}),
or configure a function trigger in the other service. For more
information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/lambda-invocation.html}{Invoking Functions}.
}
\section{Request syntax}{
\preformatted{svc$create_function(
  FunctionName = "string",
  Runtime = "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"nodejs12.x"|"java8"|"java8.al2"|"java11"|"python2.7"|"python3.6"|"python3.7"|"python3.8"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"dotnetcore3.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"ruby2.7"|"provided"|"provided.al2",
  Role = "string",
  Handler = "string",
  Code = list(
    ZipFile = raw,
    S3Bucket = "string",
    S3Key = "string",
    S3ObjectVersion = "string",
    ImageUri = "string"
  ),
  Description = "string",
  Timeout = 123,
  MemorySize = 123,
  Publish = TRUE|FALSE,
  VpcConfig = list(
    SubnetIds = list(
      "string"
    ),
    SecurityGroupIds = list(
      "string"
    )
  ),
  PackageType = "Zip"|"Image",
  DeadLetterConfig = list(
    TargetArn = "string"
  ),
  Environment = list(
    Variables = list(
      "string"
    )
  ),
  KMSKeyArn = "string",
  TracingConfig = list(
    Mode = "Active"|"PassThrough"
  ),
  Tags = list(
    "string"
  ),
  Layers = list(
    "string"
  ),
  FileSystemConfigs = list(
    list(
      Arn = "string",
      LocalMountPath = "string"
    )
  ),
  ImageConfig = list(
    EntryPoint = list(
      "string"
    ),
    Command = list(
      "string"
    ),
    WorkingDirectory = "string"
  ),
  CodeSigningConfigArn = "string"
)
}
}

\examples{
\dontrun{
# The following example creates a function with a deployment package in
# Amazon S3 and enables X-Ray tracing and environment variable encryption.
svc$create_function(
  Code = list(
    S3Bucket = "my-bucket-1xpuxmplzrlbh",
    S3Key = "function.zip"
  ),
  Description = "Process image objects from Amazon S3.",
  Environment = list(
    Variables = list(
      BUCKET = "my-bucket-1xpuxmplzrlbh",
      PREFIX = "inbound"
    )
  ),
  FunctionName = "my-function",
  Handler = "index.handler",
  KMSKeyArn = "arn:aws:kms:us-west-2:123456789012:key/b0844d6c-xmpl-4463-97a4-d49f50839966",
  MemorySize = 256L,
  Publish = TRUE,
  Role = "arn:aws:iam::123456789012:role/lambda-role",
  Runtime = "nodejs12.x",
  Tags = list(
    DEPARTMENT = "Assets"
  ),
  Timeout = 15L,
  TracingConfig = list(
    Mode = "Active"
  )
)
}

}
\keyword{internal}
