% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_instance_snapshots}
\alias{lightsail_get_instance_snapshots}
\title{Returns all instance snapshots for the user's account}
\usage{
lightsail_get_instance_snapshots(pageToken)
}
\arguments{
\item{pageToken}{The token to advance to the next page of results from your request.

To get a page token, perform an initial
\code{\link[=lightsail_get_instance_snapshots]{get_instance_snapshots}} request. If
your results are paginated, the response will return a next page token
that you can specify as the page token in a subsequent request.}
}
\value{
A list with the following syntax:\preformatted{list(
  instanceSnapshots = list(
    list(
      name = "string",
      arn = "string",
      supportCode = "string",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      location = list(
        availabilityZone = "string",
        regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
      ),
      resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
      tags = list(
        list(
          key = "string",
          value = "string"
        )
      ),
      state = "pending"|"error"|"available",
      progress = "string",
      fromAttachedDisks = list(
        list(
          name = "string",
          arn = "string",
          supportCode = "string",
          createdAt = as.POSIXct(
            "2015-01-01"
          ),
          location = list(
            availabilityZone = "string",
            regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
          ),
          resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
          tags = list(
            list(
              key = "string",
              value = "string"
            )
          ),
          addOns = list(
            list(
              name = "string",
              status = "string",
              snapshotTimeOfDay = "string",
              nextSnapshotTimeOfDay = "string"
            )
          ),
          sizeInGb = 123,
          isSystemDisk = TRUE|FALSE,
          iops = 123,
          path = "string",
          state = "pending"|"error"|"available"|"in-use"|"unknown",
          attachedTo = "string",
          isAttached = TRUE|FALSE,
          attachmentState = "string",
          gbInUse = 123
        )
      ),
      fromInstanceName = "string",
      fromInstanceArn = "string",
      fromBlueprintId = "string",
      fromBundleId = "string",
      isFromAutoSnapshot = TRUE|FALSE,
      sizeInGb = 123
    )
  ),
  nextPageToken = "string"
)
}
}
\description{
Returns all instance snapshots for the user's account.
}
\section{Request syntax}{
\preformatted{svc$get_instance_snapshots(
  pageToken = "string"
)
}
}

\keyword{internal}
