% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_transit_gateway_connects}
\alias{ec2_describe_transit_gateway_connects}
\title{Describes one or more Connect attachments}
\usage{
ec2_describe_transit_gateway_connects(TransitGatewayAttachmentIds,
  Filters, MaxResults, NextToken, DryRun)
}
\arguments{
\item{TransitGatewayAttachmentIds}{The IDs of the attachments.}

\item{Filters}{One or more filters. The possible values are:
\itemize{
\item \code{options.protocol} - The tunnel protocol (\code{gre}).
\item \code{state} - The state of the attachment (\code{initiating} |
\code{initiatingRequest} | \code{pendingAcceptance} | \code{rollingBack} |
\code{pending} | \code{available} | \code{modifying} | \code{deleting} | \code{deleted} |
\code{failed} | \code{rejected} | \code{rejecting} | \code{failing}).
\item \code{transit-gateway-attachment-id} - The ID of the Connect attachment.
\item \code{transit-gateway-id} - The ID of the transit gateway.
\item \code{transport-transit-gateway-attachment-id} - The ID of the transit
gateway attachment from which the Connect attachment was created.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  TransitGatewayConnects = list(
    list(
      TransitGatewayAttachmentId = "string",
      TransportTransitGatewayAttachmentId = "string",
      TransitGatewayId = "string",
      State = "initiating"|"initiatingRequest"|"pendingAcceptance"|"rollingBack"|"pending"|"available"|"modifying"|"deleting"|"deleted"|"failed"|"rejected"|"rejecting"|"failing",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      Options = list(
        Protocol = "gre"
      ),
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes one or more Connect attachments.
}
\section{Request syntax}{
\preformatted{svc$describe_transit_gateway_connects(
  TransitGatewayAttachmentIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
