% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_describe_capacity_providers}
\alias{ecs_describe_capacity_providers}
\title{Describes one or more of your capacity providers}
\usage{
ecs_describe_capacity_providers(capacityProviders, include, maxResults,
  nextToken)
}
\arguments{
\item{capacityProviders}{The short name or full Amazon Resource Name (ARN) of one or more
capacity providers. Up to \code{100} capacity providers can be described in
an action.}

\item{include}{Specifies whether or not you want to see the resource tags for the
capacity provider. If \code{TAGS} is specified, the tags are included in the
response. If this field is omitted, tags are not included in the
response.}

\item{maxResults}{The maximum number of account setting results returned by
\code{\link[=ecs_describe_capacity_providers]{describe_capacity_providers}} in
paginated output. When this parameter is used,
\code{\link[=ecs_describe_capacity_providers]{describe_capacity_providers}} only
returns \code{maxResults} results in a single page along with a \code{nextToken}
response element. The remaining results of the initial request can be
seen by sending another
\code{\link[=ecs_describe_capacity_providers]{describe_capacity_providers}} request
with the returned \code{nextToken} value. This value can be between 1 and 10.
If this parameter is not used, then
\code{\link[=ecs_describe_capacity_providers]{describe_capacity_providers}} returns
up to 10 results and a \code{nextToken} value if applicable.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{\link[=ecs_describe_capacity_providers]{describe_capacity_providers}} request
where \code{maxResults} was used and the results exceeded the value of that
parameter. Pagination continues from the end of the previous results
that returned the \code{nextToken} value.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.}
}
\value{
A list with the following syntax:\preformatted{list(
  capacityProviders = list(
    list(
      capacityProviderArn = "string",
      name = "string",
      status = "ACTIVE"|"INACTIVE",
      autoScalingGroupProvider = list(
        autoScalingGroupArn = "string",
        managedScaling = list(
          status = "ENABLED"|"DISABLED",
          targetCapacity = 123,
          minimumScalingStepSize = 123,
          maximumScalingStepSize = 123,
          instanceWarmupPeriod = 123
        ),
        managedTerminationProtection = "ENABLED"|"DISABLED"
      ),
      updateStatus = "DELETE_IN_PROGRESS"|"DELETE_COMPLETE"|"DELETE_FAILED"|"UPDATE_IN_PROGRESS"|"UPDATE_COMPLETE"|"UPDATE_FAILED",
      updateStatusReason = "string",
      tags = list(
        list(
          key = "string",
          value = "string"
        )
      )
    )
  ),
  failures = list(
    list(
      arn = "string",
      reason = "string",
      detail = "string"
    )
  ),
  nextToken = "string"
)
}
}
\description{
Describes one or more of your capacity providers.
}
\section{Request syntax}{
\preformatted{svc$describe_capacity_providers(
  capacityProviders = list(
    "string"
  ),
  include = list(
    "TAGS"
  ),
  maxResults = 123,
  nextToken = "string"
)
}
}

\keyword{internal}
