% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_list_tags_for_resource}
\alias{ecs_list_tags_for_resource}
\title{List the tags for an Amazon ECS resource}
\usage{
ecs_list_tags_for_resource(resourceArn)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) that identifies the resource for which to
list the tags. Currently, the supported resources are Amazon ECS tasks,
services, task definitions, clusters, and container instances.}
}
\value{
A list with the following syntax:\preformatted{list(
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}
\description{
List the tags for an Amazon ECS resource.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  resourceArn = "string"
)
}
}

\examples{
\dontrun{
# This example lists the tags for the 'dev' cluster.
svc$list_tags_for_resource(
  resourceArn = "arn:aws:ecs:region:aws_account_id:cluster/dev"
)
}

}
\keyword{internal}
