% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_register_container_instance}
\alias{ecs_register_container_instance}
\title{This action is only used by the Amazon ECS agent, and it is not intended
for use outside of the agent}
\usage{
ecs_register_container_instance(cluster, instanceIdentityDocument,
  instanceIdentityDocumentSignature, totalResources, versionInfo,
  containerInstanceArn, attributes, platformDevices, tags)
}
\arguments{
\item{cluster}{The short name or full Amazon Resource Name (ARN) of the cluster with
which to register your container instance. If you do not specify a
cluster, the default cluster is assumed.}

\item{instanceIdentityDocument}{The instance identity document for the EC2 instance to register. This
document can be found by running the following command from the
instance:
\verb{curl http://169.254.169.254/latest/dynamic/instance-identity/document/}}

\item{instanceIdentityDocumentSignature}{The instance identity document signature for the EC2 instance to
register. This signature can be found by running the following command
from the instance:
\verb{curl http://169.254.169.254/latest/dynamic/instance-identity/signature/}}

\item{totalResources}{The resources available on the instance.}

\item{versionInfo}{The version information for the Amazon ECS container agent and Docker
daemon running on the container instance.}

\item{containerInstanceArn}{The ARN of the container instance (if it was previously registered).}

\item{attributes}{The container instance attributes that this container instance supports.}

\item{platformDevices}{The devices that are available on the container instance. The only
supported device type is a GPU.}

\item{tags}{The metadata that you apply to the container instance to help you
categorize and organize them. Each tag consists of a key and an optional
value, both of which you define.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8
\item Maximum value length - 256 Unicode characters in UTF-8
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case-sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for either keys or values as it is reserved for AWS
use. You cannot edit or delete tag keys or values with this prefix.
Tags with this prefix do not count against your tags per resource
limit.
}}
}
\value{
A list with the following syntax:\preformatted{list(
  containerInstance = list(
    containerInstanceArn = "string",
    ec2InstanceId = "string",
    capacityProviderName = "string",
    version = 123,
    versionInfo = list(
      agentVersion = "string",
      agentHash = "string",
      dockerVersion = "string"
    ),
    remainingResources = list(
      list(
        name = "string",
        type = "string",
        doubleValue = 123.0,
        longValue = 123,
        integerValue = 123,
        stringSetValue = list(
          "string"
        )
      )
    ),
    registeredResources = list(
      list(
        name = "string",
        type = "string",
        doubleValue = 123.0,
        longValue = 123,
        integerValue = 123,
        stringSetValue = list(
          "string"
        )
      )
    ),
    status = "string",
    statusReason = "string",
    agentConnected = TRUE|FALSE,
    runningTasksCount = 123,
    pendingTasksCount = 123,
    agentUpdateStatus = "PENDING"|"STAGING"|"STAGED"|"UPDATING"|"UPDATED"|"FAILED",
    attributes = list(
      list(
        name = "string",
        value = "string",
        targetType = "container-instance",
        targetId = "string"
      )
    ),
    registeredAt = as.POSIXct(
      "2015-01-01"
    ),
    attachments = list(
      list(
        id = "string",
        type = "string",
        status = "string",
        details = list(
          list(
            name = "string",
            value = "string"
          )
        )
      )
    ),
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    )
  )
)
}
}
\description{
This action is only used by the Amazon ECS agent, and it is not intended
for use outside of the agent.

Registers an EC2 instance into the specified cluster. This instance
becomes available to place containers on.
}
\section{Request syntax}{
\preformatted{svc$register_container_instance(
  cluster = "string",
  instanceIdentityDocument = "string",
  instanceIdentityDocumentSignature = "string",
  totalResources = list(
    list(
      name = "string",
      type = "string",
      doubleValue = 123.0,
      longValue = 123,
      integerValue = 123,
      stringSetValue = list(
        "string"
      )
    )
  ),
  versionInfo = list(
    agentVersion = "string",
    agentHash = "string",
    dockerVersion = "string"
  ),
  containerInstanceArn = "string",
  attributes = list(
    list(
      name = "string",
      value = "string",
      targetType = "container-instance",
      targetId = "string"
    )
  ),
  platformDevices = list(
    list(
      id = "string",
      type = "GPU"
    )
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
