% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_instances}
\alias{lightsail_create_instances}
\title{Creates one or more Amazon Lightsail instances}
\usage{
lightsail_create_instances(instanceNames, availabilityZone,
  customImageName, blueprintId, bundleId, userData, keyPairName, tags,
  addOns)
}
\arguments{
\item{instanceNames}{[required] The names to use for your new Lightsail instances. Separate multiple
values using quotation marks and commas, for example:
\verb{["MyFirstInstance","MySecondInstance"]}}

\item{availabilityZone}{[required] The Availability Zone in which to create your instance. Use the
following format: \verb{us-east-2a} (case sensitive). You can get a list of
Availability Zones by using the \href{https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html}{get regions}
operation. Be sure to add the \verb{include Availability Zones} parameter to
your request.}

\item{customImageName}{(Deprecated) The name for your custom image.

In releases prior to June 12, 2017, this parameter was ignored by the
API. It is now deprecated.}

\item{blueprintId}{[required] The ID for a virtual private server image (e.g., \code{app_wordpress_4_4} or
\code{app_lamp_7_0}). Use the \verb{get blueprints} operation to return a list of
available images (or \emph{blueprints}).

Use active blueprints when creating new instances. Inactive blueprints
are listed to support customers with existing instances and are not
necessarily available to create new instances. Blueprints are marked
inactive when they become outdated due to operating system updates or
new application releases.}

\item{bundleId}{[required] The bundle of specification information for your virtual private server
(or \emph{instance}), including the pricing plan (e.g., \code{micro_1_0}).}

\item{userData}{A launch script you can create that configures a server with additional
user data. For example, you might want to run \verb{apt-get -y update}.

Depending on the machine image you choose, the command to get software
on your instance varies. Amazon Linux and CentOS use \code{yum}, Debian and
Ubuntu use \code{apt-get}, and FreeBSD uses \code{pkg}. For a complete list, see
the Dev Guide.}

\item{keyPairName}{The name of your key pair.}

\item{tags}{The tag keys and optional values to add to the resource during create.

Use the \code{\link[=lightsail_tag_resource]{tag_resource}} action to tag a
resource after it's created.}

\item{addOns}{An array of objects representing the add-ons to enable for the new
instance.}
}
\value{
A list with the following syntax:\preformatted{list(
  operations = list(
    list(
      id = "string",
      resourceName = "string",
      resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      location = list(
        availabilityZone = "string",
        regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
      ),
      isTerminal = TRUE|FALSE,
      operationDetails = "string",
      operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
      status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
      statusChangedAt = as.POSIXct(
        "2015-01-01"
      ),
      errorCode = "string",
      errorDetails = "string"
    )
  )
)
}
}
\description{
Creates one or more Amazon Lightsail instances.

The \verb{create instances} operation supports tag-based access control via
request tags. For more information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$create_instances(
  instanceNames = list(
    "string"
  ),
  availabilityZone = "string",
  customImageName = "string",
  blueprintId = "string",
  bundleId = "string",
  userData = "string",
  keyPairName = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  addOns = list(
    list(
      addOnType = "AutoSnapshot",
      autoSnapshotAddOnRequest = list(
        snapshotTimeOfDay = "string"
      )
    )
  )
)
}
}

\keyword{internal}
