% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_instance_port_states}
\alias{lightsail_get_instance_port_states}
\title{Returns the firewall port states for a specific Amazon Lightsail
instance, the IP addresses allowed to connect to the instance through
the ports, and the protocol}
\usage{
lightsail_get_instance_port_states(instanceName)
}
\arguments{
\item{instanceName}{[required] The name of the instance for which to return firewall port states.}
}
\value{
A list with the following syntax:\preformatted{list(
  portStates = list(
    list(
      fromPort = 123,
      toPort = 123,
      protocol = "tcp"|"all"|"udp"|"icmp",
      state = "open"|"closed",
      cidrs = list(
        "string"
      ),
      cidrListAliases = list(
        "string"
      )
    )
  )
)
}
}
\description{
Returns the firewall port states for a specific Amazon Lightsail
instance, the IP addresses allowed to connect to the instance through
the ports, and the protocol.
}
\section{Request syntax}{
\preformatted{svc$get_instance_port_states(
  instanceName = "string"
)
}
}

\keyword{internal}
