# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include lightsail_service.R
NULL

#' Allocates a static IP address
#'
#' Allocates a static IP address.
#'
#' @usage
#' lightsail_allocate_static_ip(staticIpName)
#'
#' @param staticIpName &#91;required&#93; The name of the static IP address.
#'
#' @section Request syntax:
#' ```
#' svc$allocate_static_ip(
#'   staticIpName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_allocate_static_ip
lightsail_allocate_static_ip <- function(staticIpName) {
  op <- new_operation(
    name = "AllocateStaticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$allocate_static_ip_input(staticIpName = staticIpName)
  output <- .lightsail$allocate_static_ip_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$allocate_static_ip <- lightsail_allocate_static_ip

#' Attaches a block storage disk to a running or stopped Lightsail instance
#' and exposes it to the instance with the specified disk name
#'
#' Attaches a block storage disk to a running or stopped Lightsail instance
#' and exposes it to the instance with the specified disk name.
#' 
#' The `attach disk` operation supports tag-based access control via
#' resource tags applied to the resource identified by diskName. For more
#' information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_attach_disk(diskName, instanceName, diskPath)
#'
#' @param diskName &#91;required&#93; The unique Lightsail disk name (e.g., `my-disk`).
#' @param instanceName &#91;required&#93; The name of the Lightsail instance where you want to utilize the storage
#' disk.
#' @param diskPath &#91;required&#93; The disk path to expose to the instance (e.g., `/dev/xvdf`).
#'
#' @section Request syntax:
#' ```
#' svc$attach_disk(
#'   diskName = "string",
#'   instanceName = "string",
#'   diskPath = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_attach_disk
lightsail_attach_disk <- function(diskName, instanceName, diskPath) {
  op <- new_operation(
    name = "AttachDisk",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$attach_disk_input(diskName = diskName, instanceName = instanceName, diskPath = diskPath)
  output <- .lightsail$attach_disk_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$attach_disk <- lightsail_attach_disk

#' Attaches one or more Lightsail instances to a load balancer
#'
#' Attaches one or more Lightsail instances to a load balancer.
#' 
#' After some time, the instances are attached to the load balancer and the
#' health check status is available.
#' 
#' The `attach instances to load balancer` operation supports tag-based
#' access control via resource tags applied to the resource identified by
#' loadBalancerName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_attach_instances_to_load_balancer(loadBalancerName,
#'   instanceNames)
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer.
#' @param instanceNames &#91;required&#93; An array of strings representing the instance name(s) you want to attach
#' to your load balancer.
#' 
#' An instance must be `running` before you can attach it to your load
#' balancer.
#' 
#' There are no additional limits on the number of instances you can attach
#' to your load balancer, aside from the limit of Lightsail instances you
#' can create in your account (20).
#'
#' @section Request syntax:
#' ```
#' svc$attach_instances_to_load_balancer(
#'   loadBalancerName = "string",
#'   instanceNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_attach_instances_to_load_balancer
lightsail_attach_instances_to_load_balancer <- function(loadBalancerName, instanceNames) {
  op <- new_operation(
    name = "AttachInstancesToLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$attach_instances_to_load_balancer_input(loadBalancerName = loadBalancerName, instanceNames = instanceNames)
  output <- .lightsail$attach_instances_to_load_balancer_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$attach_instances_to_load_balancer <- lightsail_attach_instances_to_load_balancer

#' Attaches a Transport Layer Security (TLS) certificate to your load
#' balancer
#'
#' Attaches a Transport Layer Security (TLS) certificate to your load
#' balancer. TLS is just an updated, more secure version of Secure Socket
#' Layer (SSL).
#' 
#' Once you create and validate your certificate, you can attach it to your
#' load balancer. You can also use this API to rotate the certificates on
#' your account. Use the `AttachLoadBalancerTlsCertificate` operation with
#' the non-attached certificate, and it will replace the existing one and
#' become the attached certificate.
#' 
#' The `attach load balancer tls certificate` operation supports tag-based
#' access control via resource tags applied to the resource identified by
#' loadBalancerName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_attach_load_balancer_tls_certificate(loadBalancerName,
#'   certificateName)
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer to which you want to associate the SSL/TLS
#' certificate.
#' @param certificateName &#91;required&#93; The name of your SSL/TLS certificate.
#'
#' @section Request syntax:
#' ```
#' svc$attach_load_balancer_tls_certificate(
#'   loadBalancerName = "string",
#'   certificateName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_attach_load_balancer_tls_certificate
lightsail_attach_load_balancer_tls_certificate <- function(loadBalancerName, certificateName) {
  op <- new_operation(
    name = "AttachLoadBalancerTlsCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$attach_load_balancer_tls_certificate_input(loadBalancerName = loadBalancerName, certificateName = certificateName)
  output <- .lightsail$attach_load_balancer_tls_certificate_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$attach_load_balancer_tls_certificate <- lightsail_attach_load_balancer_tls_certificate

#' Attaches a static IP address to a specific Amazon Lightsail instance
#'
#' Attaches a static IP address to a specific Amazon Lightsail instance.
#'
#' @usage
#' lightsail_attach_static_ip(staticIpName, instanceName)
#'
#' @param staticIpName &#91;required&#93; The name of the static IP.
#' @param instanceName &#91;required&#93; The instance name to which you want to attach the static IP address.
#'
#' @section Request syntax:
#' ```
#' svc$attach_static_ip(
#'   staticIpName = "string",
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_attach_static_ip
lightsail_attach_static_ip <- function(staticIpName, instanceName) {
  op <- new_operation(
    name = "AttachStaticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$attach_static_ip_input(staticIpName = staticIpName, instanceName = instanceName)
  output <- .lightsail$attach_static_ip_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$attach_static_ip <- lightsail_attach_static_ip

#' Closes the public ports on a specific Amazon Lightsail instance
#'
#' Closes the public ports on a specific Amazon Lightsail instance.
#' 
#' The `close instance public ports` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' instanceName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_close_instance_public_ports(portInfo, instanceName)
#'
#' @param portInfo &#91;required&#93; Information about the public port you are trying to close.
#' @param instanceName &#91;required&#93; The name of the instance on which you\'re attempting to close the public
#' ports.
#'
#' @section Request syntax:
#' ```
#' svc$close_instance_public_ports(
#'   portInfo = list(
#'     fromPort = 123,
#'     toPort = 123,
#'     protocol = "tcp"|"all"|"udp"
#'   ),
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_close_instance_public_ports
lightsail_close_instance_public_ports <- function(portInfo, instanceName) {
  op <- new_operation(
    name = "CloseInstancePublicPorts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$close_instance_public_ports_input(portInfo = portInfo, instanceName = instanceName)
  output <- .lightsail$close_instance_public_ports_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$close_instance_public_ports <- lightsail_close_instance_public_ports

#' Copies an instance or disk snapshot from one AWS Region to another in
#' Amazon Lightsail
#'
#' Copies an instance or disk snapshot from one AWS Region to another in
#' Amazon Lightsail.
#'
#' @usage
#' lightsail_copy_snapshot(sourceSnapshotName, targetSnapshotName,
#'   sourceRegion)
#'
#' @param sourceSnapshotName &#91;required&#93; The name of the source instance or disk snapshot to be copied.
#' @param targetSnapshotName &#91;required&#93; The name of the new instance or disk snapshot to be created as a copy.
#' @param sourceRegion &#91;required&#93; The AWS Region where the source snapshot is located.
#'
#' @section Request syntax:
#' ```
#' svc$copy_snapshot(
#'   sourceSnapshotName = "string",
#'   targetSnapshotName = "string",
#'   sourceRegion = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_copy_snapshot
lightsail_copy_snapshot <- function(sourceSnapshotName, targetSnapshotName, sourceRegion) {
  op <- new_operation(
    name = "CopySnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$copy_snapshot_input(sourceSnapshotName = sourceSnapshotName, targetSnapshotName = targetSnapshotName, sourceRegion = sourceRegion)
  output <- .lightsail$copy_snapshot_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$copy_snapshot <- lightsail_copy_snapshot

#' Creates an AWS CloudFormation stack, which creates a new Amazon EC2
#' instance from an exported Amazon Lightsail snapshot
#'
#' Creates an AWS CloudFormation stack, which creates a new Amazon EC2
#' instance from an exported Amazon Lightsail snapshot. This operation
#' results in a CloudFormation stack record that can be used to track the
#' AWS CloudFormation stack created. Use the
#' `get cloud formation stack records` operation to get a list of the
#' CloudFormation stacks created.
#' 
#' Wait until after your new Amazon EC2 instance is created before running
#' the `create cloud formation stack` operation again with the same export
#' snapshot record.
#'
#' @usage
#' lightsail_create_cloud_formation_stack(instances)
#'
#' @param instances &#91;required&#93; An array of parameters that will be used to create the new Amazon EC2
#' instance. You can only pass one instance entry at a time in this array.
#' You will get an invalid parameter error if you pass more than one
#' instance entry in this array.
#'
#' @section Request syntax:
#' ```
#' svc$create_cloud_formation_stack(
#'   instances = list(
#'     list(
#'       sourceName = "string",
#'       instanceType = "string",
#'       portInfoSource = "DEFAULT"|"INSTANCE"|"NONE"|"CLOSED",
#'       userData = "string",
#'       availabilityZone = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_cloud_formation_stack
lightsail_create_cloud_formation_stack <- function(instances) {
  op <- new_operation(
    name = "CreateCloudFormationStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_cloud_formation_stack_input(instances = instances)
  output <- .lightsail$create_cloud_formation_stack_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_cloud_formation_stack <- lightsail_create_cloud_formation_stack

#' Creates a block storage disk that can be attached to a Lightsail
#' instance in the same Availability Zone (e
#'
#' Creates a block storage disk that can be attached to a Lightsail
#' instance in the same Availability Zone (e.g., `us-east-2a`). The disk is
#' created in the regional endpoint that you send the HTTP request to. For
#' more information, see [Regions and Availability Zones in
#' Lightsail](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail).
#' 
#' The `create disk` operation supports tag-based access control via
#' request tags. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_create_disk(diskName, availabilityZone, sizeInGb, tags)
#'
#' @param diskName &#91;required&#93; The unique Lightsail disk name (e.g., `my-disk`).
#' @param availabilityZone &#91;required&#93; The Availability Zone where you want to create the disk (e.g.,
#' `us-east-2a`). Choose the same Availability Zone as the Lightsail
#' instance where you want to create the disk.
#' 
#' Use the GetRegions operation to list the Availability Zones where
#' Lightsail is currently available.
#' @param sizeInGb &#91;required&#93; The size of the disk in GB (e.g., `32`).
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' To tag a resource after it has been created, see the `tag resource`
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_disk(
#'   diskName = "string",
#'   availabilityZone = "string",
#'   sizeInGb = 123,
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_disk
lightsail_create_disk <- function(diskName, availabilityZone, sizeInGb, tags = NULL) {
  op <- new_operation(
    name = "CreateDisk",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_disk_input(diskName = diskName, availabilityZone = availabilityZone, sizeInGb = sizeInGb, tags = tags)
  output <- .lightsail$create_disk_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_disk <- lightsail_create_disk

#' Creates a block storage disk from a disk snapshot that can be attached
#' to a Lightsail instance in the same Availability Zone (e
#'
#' Creates a block storage disk from a disk snapshot that can be attached
#' to a Lightsail instance in the same Availability Zone (e.g.,
#' `us-east-2a`). The disk is created in the regional endpoint that you
#' send the HTTP request to. For more information, see [Regions and
#' Availability Zones in
#' Lightsail](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail).
#' 
#' The `create disk from snapshot` operation supports tag-based access
#' control via request tags and resource tags applied to the resource
#' identified by diskSnapshotName. For more information, see the [Lightsail
#' Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_create_disk_from_snapshot(diskName, diskSnapshotName,
#'   availabilityZone, sizeInGb, tags)
#'
#' @param diskName &#91;required&#93; The unique Lightsail disk name (e.g., `my-disk`).
#' @param diskSnapshotName &#91;required&#93; The name of the disk snapshot (e.g., `my-snapshot`) from which to create
#' the new storage disk.
#' @param availabilityZone &#91;required&#93; The Availability Zone where you want to create the disk (e.g.,
#' `us-east-2a`). Choose the same Availability Zone as the Lightsail
#' instance where you want to create the disk.
#' 
#' Use the GetRegions operation to list the Availability Zones where
#' Lightsail is currently available.
#' @param sizeInGb &#91;required&#93; The size of the disk in GB (e.g., `32`).
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' To tag a resource after it has been created, see the `tag resource`
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_disk_from_snapshot(
#'   diskName = "string",
#'   diskSnapshotName = "string",
#'   availabilityZone = "string",
#'   sizeInGb = 123,
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_disk_from_snapshot
lightsail_create_disk_from_snapshot <- function(diskName, diskSnapshotName, availabilityZone, sizeInGb, tags = NULL) {
  op <- new_operation(
    name = "CreateDiskFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_disk_from_snapshot_input(diskName = diskName, diskSnapshotName = diskSnapshotName, availabilityZone = availabilityZone, sizeInGb = sizeInGb, tags = tags)
  output <- .lightsail$create_disk_from_snapshot_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_disk_from_snapshot <- lightsail_create_disk_from_snapshot

#' Creates a snapshot of a block storage disk
#'
#' Creates a snapshot of a block storage disk. You can use snapshots for
#' backups, to make copies of disks, and to save data before shutting down
#' a Lightsail instance.
#' 
#' You can take a snapshot of an attached disk that is in use; however,
#' snapshots only capture data that has been written to your disk at the
#' time the snapshot command is issued. This may exclude any data that has
#' been cached by any applications or the operating system. If you can
#' pause any file systems on the disk long enough to take a snapshot, your
#' snapshot should be complete. Nevertheless, if you cannot pause all file
#' writes to the disk, you should unmount the disk from within the
#' Lightsail instance, issue the create disk snapshot command, and then
#' remount the disk to ensure a consistent and complete snapshot. You may
#' remount and use your disk while the snapshot status is pending.
#' 
#' You can also use this operation to create a snapshot of an instance\'s
#' system volume. You might want to do this, for example, to recover data
#' from the system volume of a botched instance or to create a backup of
#' the system volume like you would for a block storage disk. To create a
#' snapshot of a system volume, just define the `instance name` parameter
#' when issuing the snapshot command, and a snapshot of the defined
#' instance\'s system volume will be created. After the snapshot is
#' available, you can create a block storage disk from the snapshot and
#' attach it to a running instance to access the data on the disk.
#' 
#' The `create disk snapshot` operation supports tag-based access control
#' via request tags. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_create_disk_snapshot(diskName, diskSnapshotName, instanceName,
#'   tags)
#'
#' @param diskName The unique name of the source disk (e.g., `Disk-Virginia-1`).
#' 
#' This parameter cannot be defined together with the `instance name`
#' parameter. The `disk name` and `instance name` parameters are mutually
#' exclusive.
#' @param diskSnapshotName &#91;required&#93; The name of the destination disk snapshot (e.g., `my-disk-snapshot`)
#' based on the source disk.
#' @param instanceName The unique name of the source instance (e.g.,
#' `Amazon_Linux-512MB-Virginia-1`). When this is defined, a snapshot of
#' the instance\'s system volume is created.
#' 
#' This parameter cannot be defined together with the `disk name`
#' parameter. The `instance name` and `disk name` parameters are mutually
#' exclusive.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' To tag a resource after it has been created, see the `tag resource`
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_disk_snapshot(
#'   diskName = "string",
#'   diskSnapshotName = "string",
#'   instanceName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_disk_snapshot
lightsail_create_disk_snapshot <- function(diskName = NULL, diskSnapshotName, instanceName = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateDiskSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_disk_snapshot_input(diskName = diskName, diskSnapshotName = diskSnapshotName, instanceName = instanceName, tags = tags)
  output <- .lightsail$create_disk_snapshot_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_disk_snapshot <- lightsail_create_disk_snapshot

#' Creates a domain resource for the specified domain (e
#'
#' Creates a domain resource for the specified domain (e.g., example.com).
#' 
#' The `create domain` operation supports tag-based access control via
#' request tags. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_create_domain(domainName, tags)
#'
#' @param domainName &#91;required&#93; The domain name to manage (e.g., `example.com`).
#' 
#' You cannot register a new domain name using Lightsail. You must register
#' a domain name using Amazon Route 53 or another domain name registrar. If
#' you have already registered your domain, you can enter its name in this
#' parameter to manage the DNS records for that domain.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' To tag a resource after it has been created, see the `tag resource`
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_domain(
#'   domainName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_domain
lightsail_create_domain <- function(domainName, tags = NULL) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_domain_input(domainName = domainName, tags = tags)
  output <- .lightsail$create_domain_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_domain <- lightsail_create_domain

#' Creates one of the following entry records associated with the domain:
#' Address (A), canonical name (CNAME), mail exchanger (MX), name server
#' (NS), start of authority (SOA), service locator (SRV), or text (TXT)
#'
#' Creates one of the following entry records associated with the domain:
#' Address (A), canonical name (CNAME), mail exchanger (MX), name server
#' (NS), start of authority (SOA), service locator (SRV), or text (TXT).
#' 
#' The `create domain entry` operation supports tag-based access control
#' via resource tags applied to the resource identified by domainName. For
#' more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_create_domain_entry(domainName, domainEntry)
#'
#' @param domainName &#91;required&#93; The domain name (e.g., `example.com`) for which you want to create the
#' domain entry.
#' @param domainEntry &#91;required&#93; An array of key-value pairs containing information about the domain
#' entry request.
#'
#' @section Request syntax:
#' ```
#' svc$create_domain_entry(
#'   domainName = "string",
#'   domainEntry = list(
#'     id = "string",
#'     name = "string",
#'     target = "string",
#'     isAlias = TRUE|FALSE,
#'     type = "string",
#'     options = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_domain_entry
lightsail_create_domain_entry <- function(domainName, domainEntry) {
  op <- new_operation(
    name = "CreateDomainEntry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_domain_entry_input(domainName = domainName, domainEntry = domainEntry)
  output <- .lightsail$create_domain_entry_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_domain_entry <- lightsail_create_domain_entry

#' Creates a snapshot of a specific virtual private server, or _instance_
#'
#' Creates a snapshot of a specific virtual private server, or *instance*.
#' You can use a snapshot to create a new instance that is based on that
#' snapshot.
#' 
#' The `create instance snapshot` operation supports tag-based access
#' control via request tags. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_create_instance_snapshot(instanceSnapshotName, instanceName,
#'   tags)
#'
#' @param instanceSnapshotName &#91;required&#93; The name for your new snapshot.
#' @param instanceName &#91;required&#93; The Lightsail instance on which to base your snapshot.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' To tag a resource after it has been created, see the `tag resource`
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_instance_snapshot(
#'   instanceSnapshotName = "string",
#'   instanceName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_instance_snapshot
lightsail_create_instance_snapshot <- function(instanceSnapshotName, instanceName, tags = NULL) {
  op <- new_operation(
    name = "CreateInstanceSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_instance_snapshot_input(instanceSnapshotName = instanceSnapshotName, instanceName = instanceName, tags = tags)
  output <- .lightsail$create_instance_snapshot_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_instance_snapshot <- lightsail_create_instance_snapshot

#' Creates one or more Amazon Lightsail virtual private servers, or
#' _instances_
#'
#' Creates one or more Amazon Lightsail virtual private servers, or
#' *instances*. Create instances using active blueprints. Inactive
#' blueprints are listed to support customers with existing instances but
#' are not necessarily available for launch of new instances. Blueprints
#' are marked inactive when they become outdated due to operating system
#' updates or new application releases. Use the get blueprints operation to
#' return a list of available blueprints.
#' 
#' The `create instances` operation supports tag-based access control via
#' request tags. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_create_instances(instanceNames, availabilityZone,
#'   customImageName, blueprintId, bundleId, userData, keyPairName, tags)
#'
#' @param instanceNames &#91;required&#93; The names to use for your new Lightsail instances. Separate multiple
#' values using quotation marks and commas, for example:
#' `\\["MyFirstInstance","MySecondInstance"\\]`
#' @param availabilityZone &#91;required&#93; The Availability Zone in which to create your instance. Use the
#' following format: `us-east-2a` (case sensitive). You can get a list of
#' Availability Zones by using the [get
#' regions](http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html)
#' operation. Be sure to add the `include Availability Zones` parameter to
#' your request.
#' @param customImageName (Deprecated) The name for your custom image.
#' 
#' In releases prior to June 12, 2017, this parameter was ignored by the
#' API. It is now deprecated.
#' @param blueprintId &#91;required&#93; The ID for a virtual private server image (e.g., `app_wordpress_4_4` or
#' `app_lamp_7_0`). Use the get blueprints operation to return a list of
#' available images (or *blueprints*).
#' @param bundleId &#91;required&#93; The bundle of specification information for your virtual private server
#' (or *instance*), including the pricing plan (e.g., `micro_1_0`).
#' @param userData A launch script you can create that configures a server with additional
#' user data. For example, you might want to run `apt-get -y update`.
#' 
#' Depending on the machine image you choose, the command to get software
#' on your instance varies. Amazon Linux and CentOS use `yum`, Debian and
#' Ubuntu use `apt-get`, and FreeBSD uses `pkg`. For a complete list, see
#' the [Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/compare-options-choose-lightsail-instance-image).
#' @param keyPairName The name of your key pair.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' To tag a resource after it has been created, see the `tag resource`
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_instances(
#'   instanceNames = list(
#'     "string"
#'   ),
#'   availabilityZone = "string",
#'   customImageName = "string",
#'   blueprintId = "string",
#'   bundleId = "string",
#'   userData = "string",
#'   keyPairName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_instances
lightsail_create_instances <- function(instanceNames, availabilityZone, customImageName = NULL, blueprintId, bundleId, userData = NULL, keyPairName = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_instances_input(instanceNames = instanceNames, availabilityZone = availabilityZone, customImageName = customImageName, blueprintId = blueprintId, bundleId = bundleId, userData = userData, keyPairName = keyPairName, tags = tags)
  output <- .lightsail$create_instances_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_instances <- lightsail_create_instances

#' Uses a specific snapshot as a blueprint for creating one or more new
#' instances that are based on that identical configuration
#'
#' Uses a specific snapshot as a blueprint for creating one or more new
#' instances that are based on that identical configuration.
#' 
#' The `create instances from snapshot` operation supports tag-based access
#' control via request tags and resource tags applied to the resource
#' identified by instanceSnapshotName. For more information, see the
#' [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_create_instances_from_snapshot(instanceNames,
#'   attachedDiskMapping, availabilityZone, instanceSnapshotName, bundleId,
#'   userData, keyPairName, tags)
#'
#' @param instanceNames &#91;required&#93; The names for your new instances.
#' @param attachedDiskMapping An object containing information about one or more disk mappings.
#' @param availabilityZone &#91;required&#93; The Availability Zone where you want to create your instances. Use the
#' following formatting: `us-east-2a` (case sensitive). You can get a list
#' of Availability Zones by using the [get
#' regions](http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html)
#' operation. Be sure to add the `include Availability Zones` parameter to
#' your request.
#' @param instanceSnapshotName &#91;required&#93; The name of the instance snapshot on which you are basing your new
#' instances. Use the get instance snapshots operation to return
#' information about your existing snapshots.
#' @param bundleId &#91;required&#93; The bundle of specification information for your virtual private server
#' (or *instance*), including the pricing plan (e.g., `micro_1_0`).
#' @param userData You can create a launch script that configures a server with additional
#' user data. For example, `apt-get -y update`.
#' 
#' Depending on the machine image you choose, the command to get software
#' on your instance varies. Amazon Linux and CentOS use `yum`, Debian and
#' Ubuntu use `apt-get`, and FreeBSD uses `pkg`. For a complete list, see
#' the [Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/compare-options-choose-lightsail-instance-image).
#' @param keyPairName The name for your key pair.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' To tag a resource after it has been created, see the `tag resource`
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_instances_from_snapshot(
#'   instanceNames = list(
#'     "string"
#'   ),
#'   attachedDiskMapping = list(
#'     list(
#'       list(
#'         originalDiskPath = "string",
#'         newDiskName = "string"
#'       )
#'     )
#'   ),
#'   availabilityZone = "string",
#'   instanceSnapshotName = "string",
#'   bundleId = "string",
#'   userData = "string",
#'   keyPairName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_instances_from_snapshot
lightsail_create_instances_from_snapshot <- function(instanceNames, attachedDiskMapping = NULL, availabilityZone, instanceSnapshotName, bundleId, userData = NULL, keyPairName = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateInstancesFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_instances_from_snapshot_input(instanceNames = instanceNames, attachedDiskMapping = attachedDiskMapping, availabilityZone = availabilityZone, instanceSnapshotName = instanceSnapshotName, bundleId = bundleId, userData = userData, keyPairName = keyPairName, tags = tags)
  output <- .lightsail$create_instances_from_snapshot_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_instances_from_snapshot <- lightsail_create_instances_from_snapshot

#' Creates an SSH key pair
#'
#' Creates an SSH key pair.
#' 
#' The `create key pair` operation supports tag-based access control via
#' request tags. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_create_key_pair(keyPairName, tags)
#'
#' @param keyPairName &#91;required&#93; The name for your new key pair.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' To tag a resource after it has been created, see the `tag resource`
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_key_pair(
#'   keyPairName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_key_pair
lightsail_create_key_pair <- function(keyPairName, tags = NULL) {
  op <- new_operation(
    name = "CreateKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_key_pair_input(keyPairName = keyPairName, tags = tags)
  output <- .lightsail$create_key_pair_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_key_pair <- lightsail_create_key_pair

#' Creates a Lightsail load balancer
#'
#' Creates a Lightsail load balancer. To learn more about deciding whether
#' to load balance your application, see [Configure your Lightsail
#' instances for load
#' balancing](https://lightsail.aws.amazon.com/ls/docs/how-to/article/configure-lightsail-instances-for-load-balancing).
#' You can create up to 5 load balancers per AWS Region in your account.
#' 
#' When you create a load balancer, you can specify a unique name and port
#' settings. To change additional load balancer settings, use the
#' `UpdateLoadBalancerAttribute` operation.
#' 
#' The `create load balancer` operation supports tag-based access control
#' via request tags. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_create_load_balancer(loadBalancerName, instancePort,
#'   healthCheckPath, certificateName, certificateDomainName,
#'   certificateAlternativeNames, tags)
#'
#' @param loadBalancerName &#91;required&#93; The name of your load balancer.
#' @param instancePort &#91;required&#93; The instance port where you\'re creating your load balancer.
#' @param healthCheckPath The path you provided to perform the load balancer health check. If you
#' didn\'t specify a health check path, Lightsail uses the root path of
#' your website (e.g., `"/"`).
#' 
#' You may want to specify a custom health check path other than the root
#' of your application if your home page loads slowly or has a lot of media
#' or scripting on it.
#' @param certificateName The name of the SSL/TLS certificate.
#' 
#' If you specify `certificateName`, then `certificateDomainName` is
#' required (and vice-versa).
#' @param certificateDomainName The domain name with which your certificate is associated (e.g.,
#' `example.com`).
#' 
#' If you specify `certificateDomainName`, then `certificateName` is
#' required (and vice-versa).
#' @param certificateAlternativeNames The optional alternative domains and subdomains to use with your SSL/TLS
#' certificate (e.g., `www.example.com`, `example.com`, `m.example.com`,
#' `blog.example.com`).
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' To tag a resource after it has been created, see the `tag resource`
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_load_balancer(
#'   loadBalancerName = "string",
#'   instancePort = 123,
#'   healthCheckPath = "string",
#'   certificateName = "string",
#'   certificateDomainName = "string",
#'   certificateAlternativeNames = list(
#'     "string"
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_load_balancer
lightsail_create_load_balancer <- function(loadBalancerName, instancePort, healthCheckPath = NULL, certificateName = NULL, certificateDomainName = NULL, certificateAlternativeNames = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_load_balancer_input(loadBalancerName = loadBalancerName, instancePort = instancePort, healthCheckPath = healthCheckPath, certificateName = certificateName, certificateDomainName = certificateDomainName, certificateAlternativeNames = certificateAlternativeNames, tags = tags)
  output <- .lightsail$create_load_balancer_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_load_balancer <- lightsail_create_load_balancer

#' Creates a Lightsail load balancer TLS certificate
#'
#' Creates a Lightsail load balancer TLS certificate.
#' 
#' TLS is just an updated, more secure version of Secure Socket Layer
#' (SSL).
#' 
#' The `create load balancer tls certificate` operation supports tag-based
#' access control via resource tags applied to the resource identified by
#' loadBalancerName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_create_load_balancer_tls_certificate(loadBalancerName,
#'   certificateName, certificateDomainName, certificateAlternativeNames,
#'   tags)
#'
#' @param loadBalancerName &#91;required&#93; The load balancer name where you want to create the SSL/TLS certificate.
#' @param certificateName &#91;required&#93; The SSL/TLS certificate name.
#' 
#' You can have up to 10 certificates in your account at one time. Each
#' Lightsail load balancer can have up to 2 certificates associated with it
#' at one time. There is also an overall limit to the number of
#' certificates that can be issue in a 365-day period. For more
#' information, see
#' [Limits](http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html).
#' @param certificateDomainName &#91;required&#93; The domain name (e.g., `example.com`) for your SSL/TLS certificate.
#' @param certificateAlternativeNames An array of strings listing alternative domains and subdomains for your
#' SSL/TLS certificate. Lightsail will de-dupe the names for you. You can
#' have a maximum of 9 alternative names (in addition to the 1 primary
#' domain). We do not support wildcards (e.g., `*.example.com`).
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' To tag a resource after it has been created, see the `tag resource`
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_load_balancer_tls_certificate(
#'   loadBalancerName = "string",
#'   certificateName = "string",
#'   certificateDomainName = "string",
#'   certificateAlternativeNames = list(
#'     "string"
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_load_balancer_tls_certificate
lightsail_create_load_balancer_tls_certificate <- function(loadBalancerName, certificateName, certificateDomainName, certificateAlternativeNames = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateLoadBalancerTlsCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_load_balancer_tls_certificate_input(loadBalancerName = loadBalancerName, certificateName = certificateName, certificateDomainName = certificateDomainName, certificateAlternativeNames = certificateAlternativeNames, tags = tags)
  output <- .lightsail$create_load_balancer_tls_certificate_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_load_balancer_tls_certificate <- lightsail_create_load_balancer_tls_certificate

#' Creates a new database in Amazon Lightsail
#'
#' Creates a new database in Amazon Lightsail.
#' 
#' The `create relational database` operation supports tag-based access
#' control via request tags. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_create_relational_database(relationalDatabaseName,
#'   availabilityZone, relationalDatabaseBlueprintId,
#'   relationalDatabaseBundleId, masterDatabaseName, masterUsername,
#'   masterUserPassword, preferredBackupWindow, preferredMaintenanceWindow,
#'   publiclyAccessible, tags)
#'
#' @param relationalDatabaseName &#91;required&#93; The name to use for your new database.
#' 
#' Constraints:
#' 
#' -   Must contain from 2 to 255 alphanumeric characters, or hyphens.
#' 
#' -   The first and last character must be a letter or number.
#' @param availabilityZone The Availability Zone in which to create your new database. Use the
#' `us-east-2a` case-sensitive format.
#' 
#' You can get a list of Availability Zones by using the `get regions`
#' operation. Be sure to add the
#' `include relational database Availability Zones` parameter to your
#' request.
#' @param relationalDatabaseBlueprintId &#91;required&#93; The blueprint ID for your new database. A blueprint describes the major
#' engine version of a database.
#' 
#' You can get a list of database blueprints IDs by using the
#' `get relational database blueprints` operation.
#' @param relationalDatabaseBundleId &#91;required&#93; The bundle ID for your new database. A bundle describes the performance
#' specifications for your database.
#' 
#' You can get a list of database bundle IDs by using the
#' `get relational database bundles` operation.
#' @param masterDatabaseName &#91;required&#93; The name of the master database created when the Lightsail database
#' resource is created.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 64 alphanumeric characters.
#' 
#' -   Cannot be a word reserved by the specified database engine
#' @param masterUsername &#91;required&#93; The master user name for your new database.
#' 
#' Constraints:
#' 
#' -   Master user name is required.
#' 
#' -   Must contain from 1 to 16 alphanumeric characters.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot be a reserved word for the database engine you choose.
#' 
#'     For more information about reserved words in MySQL 5.6 or 5.7, see
#'     the Keywords and Reserved Words articles for [MySQL
#'     5.6](https://dev.mysql.com/doc/refman/5.6/en/keywords.html) or
#'     [MySQL 5.7](https://dev.mysql.com/doc/refman/5.7/en/keywords.html)
#'     respectively.
#' @param masterUserPassword The password for the master user of your new database. The password can
#' include any printable ASCII character except \"/\", \"\"\", or \"@\".
#' 
#' Constraints: Must contain 8 to 41 characters.
#' @param preferredBackupWindow The daily time range during which automated backups are created for your
#' new database if automated backups are enabled.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region. For more information about the
#' preferred backup window time blocks for each region, see the [Working
#' With
#' Backups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow)
#' guide in the Amazon Relational Database Service (Amazon RDS)
#' documentation.
#' 
#' Constraints:
#' 
#' -   Must be in the `hh24:mi-hh24:mi` format.
#' 
#'     Example: `16:00-16:30`
#' 
#' -   Specified in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur on your
#' new database.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week.
#' 
#' Constraints:
#' 
#' -   Must be in the `ddd:hh24:mi-ddd:hh24:mi` format.
#' 
#' -   Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' -   Must be at least 30 minutes.
#' 
#' -   Specified in Universal Coordinated Time (UTC).
#' 
#' -   Example: `Tue:17:00-Tue:17:30`
#' @param publiclyAccessible Specifies the accessibility options for your new database. A value of
#' `true` specifies a database that is available to resources outside of
#' your Lightsail account. A value of `false` specifies a database that is
#' available only to your Lightsail resources in the same region as your
#' database.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' To tag a resource after it has been created, see the `tag resource`
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_relational_database(
#'   relationalDatabaseName = "string",
#'   availabilityZone = "string",
#'   relationalDatabaseBlueprintId = "string",
#'   relationalDatabaseBundleId = "string",
#'   masterDatabaseName = "string",
#'   masterUsername = "string",
#'   masterUserPassword = "string",
#'   preferredBackupWindow = "string",
#'   preferredMaintenanceWindow = "string",
#'   publiclyAccessible = TRUE|FALSE,
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_relational_database
lightsail_create_relational_database <- function(relationalDatabaseName, availabilityZone = NULL, relationalDatabaseBlueprintId, relationalDatabaseBundleId, masterDatabaseName, masterUsername, masterUserPassword = NULL, preferredBackupWindow = NULL, preferredMaintenanceWindow = NULL, publiclyAccessible = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_relational_database_input(relationalDatabaseName = relationalDatabaseName, availabilityZone = availabilityZone, relationalDatabaseBlueprintId = relationalDatabaseBlueprintId, relationalDatabaseBundleId = relationalDatabaseBundleId, masterDatabaseName = masterDatabaseName, masterUsername = masterUsername, masterUserPassword = masterUserPassword, preferredBackupWindow = preferredBackupWindow, preferredMaintenanceWindow = preferredMaintenanceWindow, publiclyAccessible = publiclyAccessible, tags = tags)
  output <- .lightsail$create_relational_database_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_relational_database <- lightsail_create_relational_database

#' Creates a new database from an existing database snapshot in Amazon
#' Lightsail
#'
#' Creates a new database from an existing database snapshot in Amazon
#' Lightsail.
#' 
#' You can create a new database from a snapshot in if something goes wrong
#' with your original database, or to change it to a different plan, such
#' as a high availability or standard plan.
#' 
#' The `create relational database from snapshot` operation supports
#' tag-based access control via request tags and resource tags applied to
#' the resource identified by relationalDatabaseSnapshotName. For more
#' information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_create_relational_database_from_snapshot(
#'   relationalDatabaseName, availabilityZone, publiclyAccessible,
#'   relationalDatabaseSnapshotName, relationalDatabaseBundleId,
#'   sourceRelationalDatabaseName, restoreTime, useLatestRestorableTime,
#'   tags)
#'
#' @param relationalDatabaseName &#91;required&#93; The name to use for your new database.
#' 
#' Constraints:
#' 
#' -   Must contain from 2 to 255 alphanumeric characters, or hyphens.
#' 
#' -   The first and last character must be a letter or number.
#' @param availabilityZone The Availability Zone in which to create your new database. Use the
#' `us-east-2a` case-sensitive format.
#' 
#' You can get a list of Availability Zones by using the `get regions`
#' operation. Be sure to add the
#' `include relational database Availability Zones` parameter to your
#' request.
#' @param publiclyAccessible Specifies the accessibility options for your new database. A value of
#' `true` specifies a database that is available to resources outside of
#' your Lightsail account. A value of `false` specifies a database that is
#' available only to your Lightsail resources in the same region as your
#' database.
#' @param relationalDatabaseSnapshotName The name of the database snapshot from which to create your new
#' database.
#' @param relationalDatabaseBundleId The bundle ID for your new database. A bundle describes the performance
#' specifications for your database.
#' 
#' You can get a list of database bundle IDs by using the
#' `get relational database bundles` operation.
#' 
#' When creating a new database from a snapshot, you cannot choose a bundle
#' that is smaller than the bundle of the source database.
#' @param sourceRelationalDatabaseName The name of the source database.
#' @param restoreTime The date and time to restore your database from.
#' 
#' Constraints:
#' 
#' -   Must be before the latest restorable time for the database.
#' 
#' -   Cannot be specified if the `use latest restorable time` parameter is
#'     `true`.
#' 
#' -   Specified in Universal Coordinated Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use a restore time of October 1, 2018,
#'     at 8 PM UTC, then you input `1538424000` as the restore time.
#' @param useLatestRestorableTime Specifies whether your database is restored from the latest backup time.
#' A value of `true` restores from the latest backup time.
#' 
#' Default: `false`
#' 
#' Constraints: Cannot be specified if the `restore time` parameter is
#' provided.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' To tag a resource after it has been created, see the `tag resource`
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_relational_database_from_snapshot(
#'   relationalDatabaseName = "string",
#'   availabilityZone = "string",
#'   publiclyAccessible = TRUE|FALSE,
#'   relationalDatabaseSnapshotName = "string",
#'   relationalDatabaseBundleId = "string",
#'   sourceRelationalDatabaseName = "string",
#'   restoreTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   useLatestRestorableTime = TRUE|FALSE,
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_relational_database_from_snapshot
lightsail_create_relational_database_from_snapshot <- function(relationalDatabaseName, availabilityZone = NULL, publiclyAccessible = NULL, relationalDatabaseSnapshotName = NULL, relationalDatabaseBundleId = NULL, sourceRelationalDatabaseName = NULL, restoreTime = NULL, useLatestRestorableTime = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateRelationalDatabaseFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_relational_database_from_snapshot_input(relationalDatabaseName = relationalDatabaseName, availabilityZone = availabilityZone, publiclyAccessible = publiclyAccessible, relationalDatabaseSnapshotName = relationalDatabaseSnapshotName, relationalDatabaseBundleId = relationalDatabaseBundleId, sourceRelationalDatabaseName = sourceRelationalDatabaseName, restoreTime = restoreTime, useLatestRestorableTime = useLatestRestorableTime, tags = tags)
  output <- .lightsail$create_relational_database_from_snapshot_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_relational_database_from_snapshot <- lightsail_create_relational_database_from_snapshot

#' Creates a snapshot of your database in Amazon Lightsail
#'
#' Creates a snapshot of your database in Amazon Lightsail. You can use
#' snapshots for backups, to make copies of a database, and to save data
#' before deleting a database.
#' 
#' The `create relational database snapshot` operation supports tag-based
#' access control via request tags. For more information, see the
#' [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_create_relational_database_snapshot(relationalDatabaseName,
#'   relationalDatabaseSnapshotName, tags)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of the database on which to base your new snapshot.
#' @param relationalDatabaseSnapshotName &#91;required&#93; The name for your new database snapshot.
#' 
#' Constraints:
#' 
#' -   Must contain from 2 to 255 alphanumeric characters, or hyphens.
#' 
#' -   The first and last character must be a letter or number.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' To tag a resource after it has been created, see the `tag resource`
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_relational_database_snapshot(
#'   relationalDatabaseName = "string",
#'   relationalDatabaseSnapshotName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_relational_database_snapshot
lightsail_create_relational_database_snapshot <- function(relationalDatabaseName, relationalDatabaseSnapshotName, tags = NULL) {
  op <- new_operation(
    name = "CreateRelationalDatabaseSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_relational_database_snapshot_input(relationalDatabaseName = relationalDatabaseName, relationalDatabaseSnapshotName = relationalDatabaseSnapshotName, tags = tags)
  output <- .lightsail$create_relational_database_snapshot_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_relational_database_snapshot <- lightsail_create_relational_database_snapshot

#' Deletes the specified block storage disk
#'
#' Deletes the specified block storage disk. The disk must be in the
#' `available` state (not attached to a Lightsail instance).
#' 
#' The disk may remain in the `deleting` state for several minutes.
#' 
#' The `delete disk` operation supports tag-based access control via
#' resource tags applied to the resource identified by diskName. For more
#' information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_delete_disk(diskName)
#'
#' @param diskName &#91;required&#93; The unique name of the disk you want to delete (e.g., `my-disk`).
#'
#' @section Request syntax:
#' ```
#' svc$delete_disk(
#'   diskName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_disk
lightsail_delete_disk <- function(diskName) {
  op <- new_operation(
    name = "DeleteDisk",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_disk_input(diskName = diskName)
  output <- .lightsail$delete_disk_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_disk <- lightsail_delete_disk

#' Deletes the specified disk snapshot
#'
#' Deletes the specified disk snapshot.
#' 
#' When you make periodic snapshots of a disk, the snapshots are
#' incremental, and only the blocks on the device that have changed since
#' your last snapshot are saved in the new snapshot. When you delete a
#' snapshot, only the data not needed for any other snapshot is removed. So
#' regardless of which prior snapshots have been deleted, all active
#' snapshots will have access to all the information needed to restore the
#' disk.
#' 
#' The `delete disk snapshot` operation supports tag-based access control
#' via resource tags applied to the resource identified by
#' diskSnapshotName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_delete_disk_snapshot(diskSnapshotName)
#'
#' @param diskSnapshotName &#91;required&#93; The name of the disk snapshot you want to delete (e.g.,
#' `my-disk-snapshot`).
#'
#' @section Request syntax:
#' ```
#' svc$delete_disk_snapshot(
#'   diskSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_disk_snapshot
lightsail_delete_disk_snapshot <- function(diskSnapshotName) {
  op <- new_operation(
    name = "DeleteDiskSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_disk_snapshot_input(diskSnapshotName = diskSnapshotName)
  output <- .lightsail$delete_disk_snapshot_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_disk_snapshot <- lightsail_delete_disk_snapshot

#' Deletes the specified domain recordset and all of its domain records
#'
#' Deletes the specified domain recordset and all of its domain records.
#' 
#' The `delete domain` operation supports tag-based access control via
#' resource tags applied to the resource identified by domainName. For more
#' information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_delete_domain(domainName)
#'
#' @param domainName &#91;required&#93; The specific domain name to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_domain(
#'   domainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_domain
lightsail_delete_domain <- function(domainName) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_domain_input(domainName = domainName)
  output <- .lightsail$delete_domain_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_domain <- lightsail_delete_domain

#' Deletes a specific domain entry
#'
#' Deletes a specific domain entry.
#' 
#' The `delete domain entry` operation supports tag-based access control
#' via resource tags applied to the resource identified by domainName. For
#' more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_delete_domain_entry(domainName, domainEntry)
#'
#' @param domainName &#91;required&#93; The name of the domain entry to delete.
#' @param domainEntry &#91;required&#93; An array of key-value pairs containing information about your domain
#' entries.
#'
#' @section Request syntax:
#' ```
#' svc$delete_domain_entry(
#'   domainName = "string",
#'   domainEntry = list(
#'     id = "string",
#'     name = "string",
#'     target = "string",
#'     isAlias = TRUE|FALSE,
#'     type = "string",
#'     options = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_domain_entry
lightsail_delete_domain_entry <- function(domainName, domainEntry) {
  op <- new_operation(
    name = "DeleteDomainEntry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_domain_entry_input(domainName = domainName, domainEntry = domainEntry)
  output <- .lightsail$delete_domain_entry_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_domain_entry <- lightsail_delete_domain_entry

#' Deletes a specific Amazon Lightsail virtual private server, or
#' _instance_
#'
#' Deletes a specific Amazon Lightsail virtual private server, or
#' *instance*.
#' 
#' The `delete instance` operation supports tag-based access control via
#' resource tags applied to the resource identified by instanceName. For
#' more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_delete_instance(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the instance to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_instance(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_instance
lightsail_delete_instance <- function(instanceName) {
  op <- new_operation(
    name = "DeleteInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_instance_input(instanceName = instanceName)
  output <- .lightsail$delete_instance_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_instance <- lightsail_delete_instance

#' Deletes a specific snapshot of a virtual private server (or _instance_)
#'
#' Deletes a specific snapshot of a virtual private server (or *instance*).
#' 
#' The `delete instance snapshot` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' instanceSnapshotName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_delete_instance_snapshot(instanceSnapshotName)
#'
#' @param instanceSnapshotName &#91;required&#93; The name of the snapshot to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_instance_snapshot(
#'   instanceSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_instance_snapshot
lightsail_delete_instance_snapshot <- function(instanceSnapshotName) {
  op <- new_operation(
    name = "DeleteInstanceSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_instance_snapshot_input(instanceSnapshotName = instanceSnapshotName)
  output <- .lightsail$delete_instance_snapshot_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_instance_snapshot <- lightsail_delete_instance_snapshot

#' Deletes a specific SSH key pair
#'
#' Deletes a specific SSH key pair.
#' 
#' The `delete key pair` operation supports tag-based access control via
#' resource tags applied to the resource identified by keyPairName. For
#' more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_delete_key_pair(keyPairName)
#'
#' @param keyPairName &#91;required&#93; The name of the key pair to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_key_pair(
#'   keyPairName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_key_pair
lightsail_delete_key_pair <- function(keyPairName) {
  op <- new_operation(
    name = "DeleteKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_key_pair_input(keyPairName = keyPairName)
  output <- .lightsail$delete_key_pair_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_key_pair <- lightsail_delete_key_pair

#' Deletes the known host key or certificate used by the Amazon Lightsail
#' browser-based SSH or RDP clients to authenticate an instance
#'
#' Deletes the known host key or certificate used by the Amazon Lightsail
#' browser-based SSH or RDP clients to authenticate an instance. This
#' operation enables the Lightsail browser-based SSH or RDP clients to
#' connect to the instance after a host key mismatch.
#' 
#' Perform this operation only if you were expecting the host key or
#' certificate mismatch or if you are familiar with the new host key or
#' certificate on the instance. For more information, see [Troubleshooting
#' connection issues when using the Amazon Lightsail browser-based SSH or
#' RDP
#' client](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-troubleshooting-browser-based-ssh-rdp-client-connection).
#'
#' @usage
#' lightsail_delete_known_host_keys(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the instance for which you want to reset the host key or
#' certificate.
#'
#' @section Request syntax:
#' ```
#' svc$delete_known_host_keys(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_known_host_keys
lightsail_delete_known_host_keys <- function(instanceName) {
  op <- new_operation(
    name = "DeleteKnownHostKeys",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_known_host_keys_input(instanceName = instanceName)
  output <- .lightsail$delete_known_host_keys_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_known_host_keys <- lightsail_delete_known_host_keys

#' Deletes a Lightsail load balancer and all its associated SSL/TLS
#' certificates
#'
#' Deletes a Lightsail load balancer and all its associated SSL/TLS
#' certificates. Once the load balancer is deleted, you will need to create
#' a new load balancer, create a new certificate, and verify domain
#' ownership again.
#' 
#' The `delete load balancer` operation supports tag-based access control
#' via resource tags applied to the resource identified by
#' loadBalancerName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_delete_load_balancer(loadBalancerName)
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_load_balancer(
#'   loadBalancerName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_load_balancer
lightsail_delete_load_balancer <- function(loadBalancerName) {
  op <- new_operation(
    name = "DeleteLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_load_balancer_input(loadBalancerName = loadBalancerName)
  output <- .lightsail$delete_load_balancer_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_load_balancer <- lightsail_delete_load_balancer

#' Deletes an SSL/TLS certificate associated with a Lightsail load balancer
#'
#' Deletes an SSL/TLS certificate associated with a Lightsail load
#' balancer.
#' 
#' The `delete load balancer tls certificate` operation supports tag-based
#' access control via resource tags applied to the resource identified by
#' loadBalancerName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_delete_load_balancer_tls_certificate(loadBalancerName,
#'   certificateName, force)
#'
#' @param loadBalancerName &#91;required&#93; The load balancer name.
#' @param certificateName &#91;required&#93; The SSL/TLS certificate name.
#' @param force When `true`, forces the deletion of an SSL/TLS certificate.
#' 
#' There can be two certificates associated with a Lightsail load balancer:
#' the primary and the backup. The `force` parameter is required when the
#' primary SSL/TLS certificate is in use by an instance attached to the
#' load balancer.
#'
#' @section Request syntax:
#' ```
#' svc$delete_load_balancer_tls_certificate(
#'   loadBalancerName = "string",
#'   certificateName = "string",
#'   force = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_load_balancer_tls_certificate
lightsail_delete_load_balancer_tls_certificate <- function(loadBalancerName, certificateName, force = NULL) {
  op <- new_operation(
    name = "DeleteLoadBalancerTlsCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_load_balancer_tls_certificate_input(loadBalancerName = loadBalancerName, certificateName = certificateName, force = force)
  output <- .lightsail$delete_load_balancer_tls_certificate_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_load_balancer_tls_certificate <- lightsail_delete_load_balancer_tls_certificate

#' Deletes a database in Amazon Lightsail
#'
#' Deletes a database in Amazon Lightsail.
#' 
#' The `delete relational database` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' relationalDatabaseName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_delete_relational_database(relationalDatabaseName,
#'   skipFinalSnapshot, finalRelationalDatabaseSnapshotName)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of the database that you are deleting.
#' @param skipFinalSnapshot Determines whether a final database snapshot is created before your
#' database is deleted. If `true` is specified, no database snapshot is
#' created. If `false` is specified, a database snapshot is created before
#' your database is deleted.
#' 
#' You must specify the `final relational database snapshot name` parameter
#' if the `skip final snapshot` parameter is `false`.
#' 
#' Default: `false`
#' @param finalRelationalDatabaseSnapshotName The name of the database snapshot created if `skip final snapshot` is
#' `false`, which is the default value for that parameter.
#' 
#' Specifying this parameter and also specifying the `skip final snapshot`
#' parameter to `true` results in an error.
#' 
#' Constraints:
#' 
#' -   Must contain from 2 to 255 alphanumeric characters, or hyphens.
#' 
#' -   The first and last character must be a letter or number.
#'
#' @section Request syntax:
#' ```
#' svc$delete_relational_database(
#'   relationalDatabaseName = "string",
#'   skipFinalSnapshot = TRUE|FALSE,
#'   finalRelationalDatabaseSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_relational_database
lightsail_delete_relational_database <- function(relationalDatabaseName, skipFinalSnapshot = NULL, finalRelationalDatabaseSnapshotName = NULL) {
  op <- new_operation(
    name = "DeleteRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_relational_database_input(relationalDatabaseName = relationalDatabaseName, skipFinalSnapshot = skipFinalSnapshot, finalRelationalDatabaseSnapshotName = finalRelationalDatabaseSnapshotName)
  output <- .lightsail$delete_relational_database_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_relational_database <- lightsail_delete_relational_database

#' Deletes a database snapshot in Amazon Lightsail
#'
#' Deletes a database snapshot in Amazon Lightsail.
#' 
#' The `delete relational database snapshot` operation supports tag-based
#' access control via resource tags applied to the resource identified by
#' relationalDatabaseName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_delete_relational_database_snapshot(
#'   relationalDatabaseSnapshotName)
#'
#' @param relationalDatabaseSnapshotName &#91;required&#93; The name of the database snapshot that you are deleting.
#'
#' @section Request syntax:
#' ```
#' svc$delete_relational_database_snapshot(
#'   relationalDatabaseSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_relational_database_snapshot
lightsail_delete_relational_database_snapshot <- function(relationalDatabaseSnapshotName) {
  op <- new_operation(
    name = "DeleteRelationalDatabaseSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_relational_database_snapshot_input(relationalDatabaseSnapshotName = relationalDatabaseSnapshotName)
  output <- .lightsail$delete_relational_database_snapshot_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_relational_database_snapshot <- lightsail_delete_relational_database_snapshot

#' Detaches a stopped block storage disk from a Lightsail instance
#'
#' Detaches a stopped block storage disk from a Lightsail instance. Make
#' sure to unmount any file systems on the device within your operating
#' system before stopping the instance and detaching the disk.
#' 
#' The `detach disk` operation supports tag-based access control via
#' resource tags applied to the resource identified by diskName. For more
#' information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_detach_disk(diskName)
#'
#' @param diskName &#91;required&#93; The unique name of the disk you want to detach from your instance (e.g.,
#' `my-disk`).
#'
#' @section Request syntax:
#' ```
#' svc$detach_disk(
#'   diskName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_detach_disk
lightsail_detach_disk <- function(diskName) {
  op <- new_operation(
    name = "DetachDisk",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$detach_disk_input(diskName = diskName)
  output <- .lightsail$detach_disk_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$detach_disk <- lightsail_detach_disk

#' Detaches the specified instances from a Lightsail load balancer
#'
#' Detaches the specified instances from a Lightsail load balancer.
#' 
#' This operation waits until the instances are no longer needed before
#' they are detached from the load balancer.
#' 
#' The `detach instances from load balancer` operation supports tag-based
#' access control via resource tags applied to the resource identified by
#' loadBalancerName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_detach_instances_from_load_balancer(loadBalancerName,
#'   instanceNames)
#'
#' @param loadBalancerName &#91;required&#93; The name of the Lightsail load balancer.
#' @param instanceNames &#91;required&#93; An array of strings containing the names of the instances you want to
#' detach from the load balancer.
#'
#' @section Request syntax:
#' ```
#' svc$detach_instances_from_load_balancer(
#'   loadBalancerName = "string",
#'   instanceNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_detach_instances_from_load_balancer
lightsail_detach_instances_from_load_balancer <- function(loadBalancerName, instanceNames) {
  op <- new_operation(
    name = "DetachInstancesFromLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$detach_instances_from_load_balancer_input(loadBalancerName = loadBalancerName, instanceNames = instanceNames)
  output <- .lightsail$detach_instances_from_load_balancer_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$detach_instances_from_load_balancer <- lightsail_detach_instances_from_load_balancer

#' Detaches a static IP from the Amazon Lightsail instance to which it is
#' attached
#'
#' Detaches a static IP from the Amazon Lightsail instance to which it is
#' attached.
#'
#' @usage
#' lightsail_detach_static_ip(staticIpName)
#'
#' @param staticIpName &#91;required&#93; The name of the static IP to detach from the instance.
#'
#' @section Request syntax:
#' ```
#' svc$detach_static_ip(
#'   staticIpName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_detach_static_ip
lightsail_detach_static_ip <- function(staticIpName) {
  op <- new_operation(
    name = "DetachStaticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$detach_static_ip_input(staticIpName = staticIpName)
  output <- .lightsail$detach_static_ip_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$detach_static_ip <- lightsail_detach_static_ip

#' Downloads the default SSH key pair from the user's account
#'
#' Downloads the default SSH key pair from the user\'s account.
#'
#' @usage
#' lightsail_download_default_key_pair()
#'
#' @section Request syntax:
#' ```
#' svc$download_default_key_pair()
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_download_default_key_pair
lightsail_download_default_key_pair <- function() {
  op <- new_operation(
    name = "DownloadDefaultKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$download_default_key_pair_input()
  output <- .lightsail$download_default_key_pair_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$download_default_key_pair <- lightsail_download_default_key_pair

#' Exports an Amazon Lightsail instance or block storage disk snapshot to
#' Amazon Elastic Compute Cloud (Amazon EC2)
#'
#' Exports an Amazon Lightsail instance or block storage disk snapshot to
#' Amazon Elastic Compute Cloud (Amazon EC2). This operation results in an
#' export snapshot record that can be used with the
#' `create cloud formation stack` operation to create new Amazon EC2
#' instances.
#' 
#' Exported instance snapshots appear in Amazon EC2 as Amazon Machine
#' Images (AMIs), and the instance system disk appears as an Amazon Elastic
#' Block Store (Amazon EBS) volume. Exported disk snapshots appear in
#' Amazon EC2 as Amazon EBS volumes. Snapshots are exported to the same
#' Amazon Web Services Region in Amazon EC2 as the source Lightsail
#' snapshot.
#' 
#' The `export snapshot` operation supports tag-based access control via
#' resource tags applied to the resource identified by sourceSnapshotName.
#' For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#' 
#' Use the `get instance snapshots` or `get disk snapshots` operations to
#' get a list of snapshots that you can export to Amazon EC2.
#'
#' @usage
#' lightsail_export_snapshot(sourceSnapshotName)
#'
#' @param sourceSnapshotName &#91;required&#93; The name of the instance or disk snapshot to be exported to Amazon EC2.
#'
#' @section Request syntax:
#' ```
#' svc$export_snapshot(
#'   sourceSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_export_snapshot
lightsail_export_snapshot <- function(sourceSnapshotName) {
  op <- new_operation(
    name = "ExportSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$export_snapshot_input(sourceSnapshotName = sourceSnapshotName)
  output <- .lightsail$export_snapshot_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$export_snapshot <- lightsail_export_snapshot

#' Returns the names of all active (not deleted) resources
#'
#' Returns the names of all active (not deleted) resources.
#'
#' @usage
#' lightsail_get_active_names(pageToken)
#'
#' @param pageToken A token used for paginating results from your get active names request.
#'
#' @section Request syntax:
#' ```
#' svc$get_active_names(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_active_names
lightsail_get_active_names <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetActiveNames",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_active_names_input(pageToken = pageToken)
  output <- .lightsail$get_active_names_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_active_names <- lightsail_get_active_names

#' Returns the list of available instance images, or _blueprints_
#'
#' Returns the list of available instance images, or *blueprints*. You can
#' use a blueprint to create a new virtual private server already running a
#' specific operating system, as well as a preinstalled app or development
#' stack. The software each instance is running depends on the blueprint
#' image you choose.
#'
#' @usage
#' lightsail_get_blueprints(includeInactive, pageToken)
#'
#' @param includeInactive A Boolean value indicating whether to include inactive results in your
#' request.
#' @param pageToken A token used for advancing to the next page of results from your get
#' blueprints request.
#'
#' @section Request syntax:
#' ```
#' svc$get_blueprints(
#'   includeInactive = TRUE|FALSE,
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_blueprints
lightsail_get_blueprints <- function(includeInactive = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetBlueprints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_blueprints_input(includeInactive = includeInactive, pageToken = pageToken)
  output <- .lightsail$get_blueprints_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_blueprints <- lightsail_get_blueprints

#' Returns the list of bundles that are available for purchase
#'
#' Returns the list of bundles that are available for purchase. A bundle
#' describes the specs for your virtual private server (or *instance*).
#'
#' @usage
#' lightsail_get_bundles(includeInactive, pageToken)
#'
#' @param includeInactive A Boolean value that indicates whether to include inactive bundle
#' results in your request.
#' @param pageToken A token used for advancing to the next page of results from your get
#' bundles request.
#'
#' @section Request syntax:
#' ```
#' svc$get_bundles(
#'   includeInactive = TRUE|FALSE,
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_bundles
lightsail_get_bundles <- function(includeInactive = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetBundles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_bundles_input(includeInactive = includeInactive, pageToken = pageToken)
  output <- .lightsail$get_bundles_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_bundles <- lightsail_get_bundles

#' Returns the CloudFormation stack record created as a result of the
#' create cloud formation stack operation
#'
#' Returns the CloudFormation stack record created as a result of the
#' `create cloud formation stack` operation.
#' 
#' An AWS CloudFormation stack is used to create a new Amazon EC2 instance
#' from an exported Lightsail snapshot.
#'
#' @usage
#' lightsail_get_cloud_formation_stack_records(pageToken)
#'
#' @param pageToken A token used for advancing to a specific page of results for your
#' `get cloud formation stack records` request.
#'
#' @section Request syntax:
#' ```
#' svc$get_cloud_formation_stack_records(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_cloud_formation_stack_records
lightsail_get_cloud_formation_stack_records <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetCloudFormationStackRecords",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_cloud_formation_stack_records_input(pageToken = pageToken)
  output <- .lightsail$get_cloud_formation_stack_records_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_cloud_formation_stack_records <- lightsail_get_cloud_formation_stack_records

#' Returns information about a specific block storage disk
#'
#' Returns information about a specific block storage disk.
#'
#' @usage
#' lightsail_get_disk(diskName)
#'
#' @param diskName &#91;required&#93; The name of the disk (e.g., `my-disk`).
#'
#' @section Request syntax:
#' ```
#' svc$get_disk(
#'   diskName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_disk
lightsail_get_disk <- function(diskName) {
  op <- new_operation(
    name = "GetDisk",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_disk_input(diskName = diskName)
  output <- .lightsail$get_disk_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_disk <- lightsail_get_disk

#' Returns information about a specific block storage disk snapshot
#'
#' Returns information about a specific block storage disk snapshot.
#'
#' @usage
#' lightsail_get_disk_snapshot(diskSnapshotName)
#'
#' @param diskSnapshotName &#91;required&#93; The name of the disk snapshot (e.g., `my-disk-snapshot`).
#'
#' @section Request syntax:
#' ```
#' svc$get_disk_snapshot(
#'   diskSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_disk_snapshot
lightsail_get_disk_snapshot <- function(diskSnapshotName) {
  op <- new_operation(
    name = "GetDiskSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_disk_snapshot_input(diskSnapshotName = diskSnapshotName)
  output <- .lightsail$get_disk_snapshot_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_disk_snapshot <- lightsail_get_disk_snapshot

#' Returns information about all block storage disk snapshots in your AWS
#' account and region
#'
#' Returns information about all block storage disk snapshots in your AWS
#' account and region.
#' 
#' If you are describing a long list of disk snapshots, you can paginate
#' the output to make the list more manageable. You can use the pageToken
#' and nextPageToken values to retrieve the next items in the list.
#'
#' @usage
#' lightsail_get_disk_snapshots(pageToken)
#'
#' @param pageToken A token used for advancing to the next page of results from your
#' GetDiskSnapshots request.
#'
#' @section Request syntax:
#' ```
#' svc$get_disk_snapshots(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_disk_snapshots
lightsail_get_disk_snapshots <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetDiskSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_disk_snapshots_input(pageToken = pageToken)
  output <- .lightsail$get_disk_snapshots_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_disk_snapshots <- lightsail_get_disk_snapshots

#' Returns information about all block storage disks in your AWS account
#' and region
#'
#' Returns information about all block storage disks in your AWS account
#' and region.
#' 
#' If you are describing a long list of disks, you can paginate the output
#' to make the list more manageable. You can use the pageToken and
#' nextPageToken values to retrieve the next items in the list.
#'
#' @usage
#' lightsail_get_disks(pageToken)
#'
#' @param pageToken A token used for advancing to the next page of results from your
#' GetDisks request.
#'
#' @section Request syntax:
#' ```
#' svc$get_disks(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_disks
lightsail_get_disks <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetDisks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_disks_input(pageToken = pageToken)
  output <- .lightsail$get_disks_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_disks <- lightsail_get_disks

#' Returns information about a specific domain recordset
#'
#' Returns information about a specific domain recordset.
#'
#' @usage
#' lightsail_get_domain(domainName)
#'
#' @param domainName &#91;required&#93; The domain name for which your want to return information about.
#'
#' @section Request syntax:
#' ```
#' svc$get_domain(
#'   domainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_domain
lightsail_get_domain <- function(domainName) {
  op <- new_operation(
    name = "GetDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_domain_input(domainName = domainName)
  output <- .lightsail$get_domain_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_domain <- lightsail_get_domain

#' Returns a list of all domains in the user's account
#'
#' Returns a list of all domains in the user\'s account.
#'
#' @usage
#' lightsail_get_domains(pageToken)
#'
#' @param pageToken A token used for advancing to the next page of results from your get
#' domains request.
#'
#' @section Request syntax:
#' ```
#' svc$get_domains(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_domains
lightsail_get_domains <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetDomains",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_domains_input(pageToken = pageToken)
  output <- .lightsail$get_domains_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_domains <- lightsail_get_domains

#' Returns the export snapshot record created as a result of the export
#' snapshot operation
#'
#' Returns the export snapshot record created as a result of the
#' `export snapshot` operation.
#' 
#' An export snapshot record can be used to create a new Amazon EC2
#' instance and its related resources with the
#' `create cloud formation stack` operation.
#'
#' @usage
#' lightsail_get_export_snapshot_records(pageToken)
#'
#' @param pageToken A token used for advancing to a specific page of results for your
#' `get export snapshot records` request.
#'
#' @section Request syntax:
#' ```
#' svc$get_export_snapshot_records(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_export_snapshot_records
lightsail_get_export_snapshot_records <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetExportSnapshotRecords",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_export_snapshot_records_input(pageToken = pageToken)
  output <- .lightsail$get_export_snapshot_records_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_export_snapshot_records <- lightsail_get_export_snapshot_records

#' Returns information about a specific Amazon Lightsail instance, which is
#' a virtual private server
#'
#' Returns information about a specific Amazon Lightsail instance, which is
#' a virtual private server.
#'
#' @usage
#' lightsail_get_instance(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the instance.
#'
#' @section Request syntax:
#' ```
#' svc$get_instance(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance
lightsail_get_instance <- function(instanceName) {
  op <- new_operation(
    name = "GetInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instance_input(instanceName = instanceName)
  output <- .lightsail$get_instance_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance <- lightsail_get_instance

#' Returns temporary SSH keys you can use to connect to a specific virtual
#' private server, or _instance_
#'
#' Returns temporary SSH keys you can use to connect to a specific virtual
#' private server, or *instance*.
#' 
#' The `get instance access details` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' instanceName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_get_instance_access_details(instanceName, protocol)
#'
#' @param instanceName &#91;required&#93; The name of the instance to access.
#' @param protocol The protocol to use to connect to your instance. Defaults to `ssh`.
#'
#' @section Request syntax:
#' ```
#' svc$get_instance_access_details(
#'   instanceName = "string",
#'   protocol = "ssh"|"rdp"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_access_details
lightsail_get_instance_access_details <- function(instanceName, protocol = NULL) {
  op <- new_operation(
    name = "GetInstanceAccessDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instance_access_details_input(instanceName = instanceName, protocol = protocol)
  output <- .lightsail$get_instance_access_details_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_access_details <- lightsail_get_instance_access_details

#' Returns the data points for the specified Amazon Lightsail instance
#' metric, given an instance name
#'
#' Returns the data points for the specified Amazon Lightsail instance
#' metric, given an instance name.
#'
#' @usage
#' lightsail_get_instance_metric_data(instanceName, metricName, period,
#'   startTime, endTime, unit, statistics)
#'
#' @param instanceName &#91;required&#93; The name of the instance for which you want to get metrics data.
#' @param metricName &#91;required&#93; The metric name to get data about.
#' @param period &#91;required&#93; The granularity, in seconds, of the returned data points.
#' @param startTime &#91;required&#93; The start time of the time period.
#' @param endTime &#91;required&#93; The end time of the time period.
#' @param unit &#91;required&#93; The unit. The list of valid values is below.
#' @param statistics &#91;required&#93; The instance statistics.
#'
#' @section Request syntax:
#' ```
#' svc$get_instance_metric_data(
#'   instanceName = "string",
#'   metricName = "CPUUtilization"|"NetworkIn"|"NetworkOut"|"StatusCheckFailed"|"StatusCheckFailed_Instance"|"StatusCheckFailed_System",
#'   period = 123,
#'   startTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   endTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
#'   statistics = list(
#'     "Minimum"|"Maximum"|"Sum"|"Average"|"SampleCount"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_metric_data
lightsail_get_instance_metric_data <- function(instanceName, metricName, period, startTime, endTime, unit, statistics) {
  op <- new_operation(
    name = "GetInstanceMetricData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instance_metric_data_input(instanceName = instanceName, metricName = metricName, period = period, startTime = startTime, endTime = endTime, unit = unit, statistics = statistics)
  output <- .lightsail$get_instance_metric_data_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_metric_data <- lightsail_get_instance_metric_data

#' Returns the port states for a specific virtual private server, or
#' _instance_
#'
#' Returns the port states for a specific virtual private server, or
#' *instance*.
#'
#' @usage
#' lightsail_get_instance_port_states(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the instance.
#'
#' @section Request syntax:
#' ```
#' svc$get_instance_port_states(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_port_states
lightsail_get_instance_port_states <- function(instanceName) {
  op <- new_operation(
    name = "GetInstancePortStates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instance_port_states_input(instanceName = instanceName)
  output <- .lightsail$get_instance_port_states_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_port_states <- lightsail_get_instance_port_states

#' Returns information about a specific instance snapshot
#'
#' Returns information about a specific instance snapshot.
#'
#' @usage
#' lightsail_get_instance_snapshot(instanceSnapshotName)
#'
#' @param instanceSnapshotName &#91;required&#93; The name of the snapshot for which you are requesting information.
#'
#' @section Request syntax:
#' ```
#' svc$get_instance_snapshot(
#'   instanceSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_snapshot
lightsail_get_instance_snapshot <- function(instanceSnapshotName) {
  op <- new_operation(
    name = "GetInstanceSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instance_snapshot_input(instanceSnapshotName = instanceSnapshotName)
  output <- .lightsail$get_instance_snapshot_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_snapshot <- lightsail_get_instance_snapshot

#' Returns all instance snapshots for the user's account
#'
#' Returns all instance snapshots for the user\'s account.
#'
#' @usage
#' lightsail_get_instance_snapshots(pageToken)
#'
#' @param pageToken A token used for advancing to the next page of results from your get
#' instance snapshots request.
#'
#' @section Request syntax:
#' ```
#' svc$get_instance_snapshots(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_snapshots
lightsail_get_instance_snapshots <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetInstanceSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instance_snapshots_input(pageToken = pageToken)
  output <- .lightsail$get_instance_snapshots_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_snapshots <- lightsail_get_instance_snapshots

#' Returns the state of a specific instance
#'
#' Returns the state of a specific instance. Works on one instance at a
#' time.
#'
#' @usage
#' lightsail_get_instance_state(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the instance to get state information about.
#'
#' @section Request syntax:
#' ```
#' svc$get_instance_state(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_state
lightsail_get_instance_state <- function(instanceName) {
  op <- new_operation(
    name = "GetInstanceState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instance_state_input(instanceName = instanceName)
  output <- .lightsail$get_instance_state_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_state <- lightsail_get_instance_state

#' Returns information about all Amazon Lightsail virtual private servers,
#' or _instances_
#'
#' Returns information about all Amazon Lightsail virtual private servers,
#' or *instances*.
#'
#' @usage
#' lightsail_get_instances(pageToken)
#'
#' @param pageToken A token used for advancing to the next page of results from your get
#' instances request.
#'
#' @section Request syntax:
#' ```
#' svc$get_instances(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instances
lightsail_get_instances <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instances_input(pageToken = pageToken)
  output <- .lightsail$get_instances_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instances <- lightsail_get_instances

#' Returns information about a specific key pair
#'
#' Returns information about a specific key pair.
#'
#' @usage
#' lightsail_get_key_pair(keyPairName)
#'
#' @param keyPairName &#91;required&#93; The name of the key pair for which you are requesting information.
#'
#' @section Request syntax:
#' ```
#' svc$get_key_pair(
#'   keyPairName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_key_pair
lightsail_get_key_pair <- function(keyPairName) {
  op <- new_operation(
    name = "GetKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_key_pair_input(keyPairName = keyPairName)
  output <- .lightsail$get_key_pair_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_key_pair <- lightsail_get_key_pair

#' Returns information about all key pairs in the user's account
#'
#' Returns information about all key pairs in the user\'s account.
#'
#' @usage
#' lightsail_get_key_pairs(pageToken)
#'
#' @param pageToken A token used for advancing to the next page of results from your get key
#' pairs request.
#'
#' @section Request syntax:
#' ```
#' svc$get_key_pairs(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_key_pairs
lightsail_get_key_pairs <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetKeyPairs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_key_pairs_input(pageToken = pageToken)
  output <- .lightsail$get_key_pairs_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_key_pairs <- lightsail_get_key_pairs

#' Returns information about the specified Lightsail load balancer
#'
#' Returns information about the specified Lightsail load balancer.
#'
#' @usage
#' lightsail_get_load_balancer(loadBalancerName)
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer.
#'
#' @section Request syntax:
#' ```
#' svc$get_load_balancer(
#'   loadBalancerName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_load_balancer
lightsail_get_load_balancer <- function(loadBalancerName) {
  op <- new_operation(
    name = "GetLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_load_balancer_input(loadBalancerName = loadBalancerName)
  output <- .lightsail$get_load_balancer_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_load_balancer <- lightsail_get_load_balancer

#' Returns information about health metrics for your Lightsail load
#' balancer
#'
#' Returns information about health metrics for your Lightsail load
#' balancer.
#'
#' @usage
#' lightsail_get_load_balancer_metric_data(loadBalancerName, metricName,
#'   period, startTime, endTime, unit, statistics)
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer.
#' @param metricName &#91;required&#93; The metric about which you want to return information. Valid values are
#' listed below, along with the most useful `statistics` to include in your
#' request.
#' 
#' -   **`ClientTLSNegotiationErrorCount`** - The number of TLS connections
#'     initiated by the client that did not establish a session with the
#'     load balancer. Possible causes include a mismatch of ciphers or
#'     protocols.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#' -   **`HealthyHostCount`** - The number of target instances that are
#'     considered healthy.
#' 
#'     `Statistics`: The most useful statistic are `Average`, `Minimum`,
#'     and `Maximum`.
#' 
#' -   **`UnhealthyHostCount`** - The number of target instances that are
#'     considered unhealthy.
#' 
#'     `Statistics`: The most useful statistic are `Average`, `Minimum`,
#'     and `Maximum`.
#' 
#' -   **`HTTPCode_LB_4XX_Count`** - The number of HTTP 4XX client error
#'     codes that originate from the load balancer. Client errors are
#'     generated when requests are malformed or incomplete. These requests
#'     have not been received by the target instance. This count does not
#'     include any response codes generated by the target instances.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#' -   **`HTTPCode_LB_5XX_Count`** - The number of HTTP 5XX server error
#'     codes that originate from the load balancer. This count does not
#'     include any response codes generated by the target instances.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#' -   **`HTTPCode_Instance_2XX_Count`** - The number of HTTP response
#'     codes generated by the target instances. This does not include any
#'     response codes generated by the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#' -   **`HTTPCode_Instance_3XX_Count`** - The number of HTTP response
#'     codes generated by the target instances. This does not include any
#'     response codes generated by the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#' -   **`HTTPCode_Instance_4XX_Count`** - The number of HTTP response
#'     codes generated by the target instances. This does not include any
#'     response codes generated by the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#' -   **`HTTPCode_Instance_5XX_Count`** - The number of HTTP response
#'     codes generated by the target instances. This does not include any
#'     response codes generated by the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#' -   **`InstanceResponseTime`** - The time elapsed, in seconds, after the
#'     request leaves the load balancer until a response from the target
#'     instance is received.
#' 
#'     `Statistics`: The most useful statistic is `Average`.
#' 
#' -   **`RejectedConnectionCount`** - The number of connections that were
#'     rejected because the load balancer had reached its maximum number of
#'     connections.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#' -   **`RequestCount`** - The number of requests processed over IPv4.
#'     This count includes only the requests with a response generated by a
#'     target instance of the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' @param period &#91;required&#93; The granularity, in seconds, of the returned data points.
#' @param startTime &#91;required&#93; The start time of the period.
#' @param endTime &#91;required&#93; The end time of the period.
#' @param unit &#91;required&#93; The unit for the time period request. Valid values are listed below.
#' @param statistics &#91;required&#93; An array of statistics that you want to request metrics for. Valid
#' values are listed below.
#' 
#' -   **`SampleCount`** - The count (number) of data points used for the
#'     statistical calculation.
#' 
#' -   **`Average`** - The value of Sum / SampleCount during the specified
#'     period. By comparing this statistic with the Minimum and Maximum,
#'     you can determine the full scope of a metric and how close the
#'     average use is to the Minimum and Maximum. This comparison helps you
#'     to know when to increase or decrease your resources as needed.
#' 
#' -   **`Sum`** - All values submitted for the matching metric added
#'     together. This statistic can be useful for determining the total
#'     volume of a metric.
#' 
#' -   **`Minimum`** - The lowest value observed during the specified
#'     period. You can use this value to determine low volumes of activity
#'     for your application.
#' 
#' -   **`Maximum`** - The highest value observed during the specified
#'     period. You can use this value to determine high volumes of activity
#'     for your application.
#'
#' @section Request syntax:
#' ```
#' svc$get_load_balancer_metric_data(
#'   loadBalancerName = "string",
#'   metricName = "ClientTLSNegotiationErrorCount"|"HealthyHostCount"|"UnhealthyHostCount"|"HTTPCode_LB_4XX_Count"|"HTTPCode_LB_5XX_Count"|"HTTPCode_Instance_2XX_Count"|"HTTPCode_Instance_3XX_Count"|"HTTPCode_Instance_4XX_Count"|"HTTPCode_Instance_5XX_Count"|"InstanceResponseTime"|"RejectedConnectionCount"|"RequestCount",
#'   period = 123,
#'   startTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   endTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
#'   statistics = list(
#'     "Minimum"|"Maximum"|"Sum"|"Average"|"SampleCount"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_load_balancer_metric_data
lightsail_get_load_balancer_metric_data <- function(loadBalancerName, metricName, period, startTime, endTime, unit, statistics) {
  op <- new_operation(
    name = "GetLoadBalancerMetricData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_load_balancer_metric_data_input(loadBalancerName = loadBalancerName, metricName = metricName, period = period, startTime = startTime, endTime = endTime, unit = unit, statistics = statistics)
  output <- .lightsail$get_load_balancer_metric_data_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_load_balancer_metric_data <- lightsail_get_load_balancer_metric_data

#' Returns information about the TLS certificates that are associated with
#' the specified Lightsail load balancer
#'
#' Returns information about the TLS certificates that are associated with
#' the specified Lightsail load balancer.
#' 
#' TLS is just an updated, more secure version of Secure Socket Layer
#' (SSL).
#' 
#' You can have a maximum of 2 certificates associated with a Lightsail
#' load balancer. One is active and the other is inactive.
#'
#' @usage
#' lightsail_get_load_balancer_tls_certificates(loadBalancerName)
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer you associated with your SSL/TLS
#' certificate.
#'
#' @section Request syntax:
#' ```
#' svc$get_load_balancer_tls_certificates(
#'   loadBalancerName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_load_balancer_tls_certificates
lightsail_get_load_balancer_tls_certificates <- function(loadBalancerName) {
  op <- new_operation(
    name = "GetLoadBalancerTlsCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_load_balancer_tls_certificates_input(loadBalancerName = loadBalancerName)
  output <- .lightsail$get_load_balancer_tls_certificates_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_load_balancer_tls_certificates <- lightsail_get_load_balancer_tls_certificates

#' Returns information about all load balancers in an account
#'
#' Returns information about all load balancers in an account.
#' 
#' If you are describing a long list of load balancers, you can paginate
#' the output to make the list more manageable. You can use the pageToken
#' and nextPageToken values to retrieve the next items in the list.
#'
#' @usage
#' lightsail_get_load_balancers(pageToken)
#'
#' @param pageToken A token used for paginating the results from your GetLoadBalancers
#' request.
#'
#' @section Request syntax:
#' ```
#' svc$get_load_balancers(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_load_balancers
lightsail_get_load_balancers <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetLoadBalancers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_load_balancers_input(pageToken = pageToken)
  output <- .lightsail$get_load_balancers_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_load_balancers <- lightsail_get_load_balancers

#' Returns information about a specific operation
#'
#' Returns information about a specific operation. Operations include
#' events such as when you create an instance, allocate a static IP, attach
#' a static IP, and so on.
#'
#' @usage
#' lightsail_get_operation(operationId)
#'
#' @param operationId &#91;required&#93; A GUID used to identify the operation.
#'
#' @section Request syntax:
#' ```
#' svc$get_operation(
#'   operationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_operation
lightsail_get_operation <- function(operationId) {
  op <- new_operation(
    name = "GetOperation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_operation_input(operationId = operationId)
  output <- .lightsail$get_operation_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_operation <- lightsail_get_operation

#' Returns information about all operations
#'
#' Returns information about all operations.
#' 
#' Results are returned from oldest to newest, up to a maximum of 200.
#' Results can be paged by making each subsequent call to `GetOperations`
#' use the maximum (last) `statusChangedAt` value from the previous
#' request.
#'
#' @usage
#' lightsail_get_operations(pageToken)
#'
#' @param pageToken A token used for advancing to the next page of results from your get
#' operations request.
#'
#' @section Request syntax:
#' ```
#' svc$get_operations(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_operations
lightsail_get_operations <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetOperations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_operations_input(pageToken = pageToken)
  output <- .lightsail$get_operations_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_operations <- lightsail_get_operations

#' Gets operations for a specific resource (e
#'
#' Gets operations for a specific resource (e.g., an instance or a static
#' IP).
#'
#' @usage
#' lightsail_get_operations_for_resource(resourceName, pageToken)
#'
#' @param resourceName &#91;required&#93; The name of the resource for which you are requesting information.
#' @param pageToken A token used for advancing to the next page of results from your get
#' operations for resource request.
#'
#' @section Request syntax:
#' ```
#' svc$get_operations_for_resource(
#'   resourceName = "string",
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_operations_for_resource
lightsail_get_operations_for_resource <- function(resourceName, pageToken = NULL) {
  op <- new_operation(
    name = "GetOperationsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_operations_for_resource_input(resourceName = resourceName, pageToken = pageToken)
  output <- .lightsail$get_operations_for_resource_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_operations_for_resource <- lightsail_get_operations_for_resource

#' Returns a list of all valid regions for Amazon Lightsail
#'
#' Returns a list of all valid regions for Amazon Lightsail. Use the
#' `include availability zones` parameter to also return the Availability
#' Zones in a region.
#'
#' @usage
#' lightsail_get_regions(includeAvailabilityZones,
#'   includeRelationalDatabaseAvailabilityZones)
#'
#' @param includeAvailabilityZones A Boolean value indicating whether to also include Availability Zones in
#' your get regions request. Availability Zones are indicated with a
#' letter: e.g., `us-east-2a`.
#' @param includeRelationalDatabaseAvailabilityZones \\>A Boolean value indicating whether to also include Availability Zones
#' for databases in your get regions request. Availability Zones are
#' indicated with a letter (e.g., `us-east-2a`).
#'
#' @section Request syntax:
#' ```
#' svc$get_regions(
#'   includeAvailabilityZones = TRUE|FALSE,
#'   includeRelationalDatabaseAvailabilityZones = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_regions
lightsail_get_regions <- function(includeAvailabilityZones = NULL, includeRelationalDatabaseAvailabilityZones = NULL) {
  op <- new_operation(
    name = "GetRegions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_regions_input(includeAvailabilityZones = includeAvailabilityZones, includeRelationalDatabaseAvailabilityZones = includeRelationalDatabaseAvailabilityZones)
  output <- .lightsail$get_regions_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_regions <- lightsail_get_regions

#' Returns information about a specific database in Amazon Lightsail
#'
#' Returns information about a specific database in Amazon Lightsail.
#'
#' @usage
#' lightsail_get_relational_database(relationalDatabaseName)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of the database that you are looking up.
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database(
#'   relationalDatabaseName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database
lightsail_get_relational_database <- function(relationalDatabaseName) {
  op <- new_operation(
    name = "GetRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_input(relationalDatabaseName = relationalDatabaseName)
  output <- .lightsail$get_relational_database_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database <- lightsail_get_relational_database

#' Returns a list of available database blueprints in Amazon Lightsail
#'
#' Returns a list of available database blueprints in Amazon Lightsail. A
#' blueprint describes the major engine version of a database.
#' 
#' You can use a blueprint ID to create a new database that runs a specific
#' database engine.
#'
#' @usage
#' lightsail_get_relational_database_blueprints(pageToken)
#'
#' @param pageToken A token used for advancing to a specific page of results for your
#' `get relational database blueprints` request.
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_blueprints(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_blueprints
lightsail_get_relational_database_blueprints <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseBlueprints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_blueprints_input(pageToken = pageToken)
  output <- .lightsail$get_relational_database_blueprints_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_blueprints <- lightsail_get_relational_database_blueprints

#' Returns the list of bundles that are available in Amazon Lightsail
#'
#' Returns the list of bundles that are available in Amazon Lightsail. A
#' bundle describes the performance specifications for a database.
#' 
#' You can use a bundle ID to create a new database with explicit
#' performance specifications.
#'
#' @usage
#' lightsail_get_relational_database_bundles(pageToken)
#'
#' @param pageToken A token used for advancing to a specific page of results for your
#' `get relational database bundles` request.
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_bundles(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_bundles
lightsail_get_relational_database_bundles <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseBundles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_bundles_input(pageToken = pageToken)
  output <- .lightsail$get_relational_database_bundles_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_bundles <- lightsail_get_relational_database_bundles

#' Returns a list of events for a specific database in Amazon Lightsail
#'
#' Returns a list of events for a specific database in Amazon Lightsail.
#'
#' @usage
#' lightsail_get_relational_database_events(relationalDatabaseName,
#'   durationInMinutes, pageToken)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of the database from which to get events.
#' @param durationInMinutes The number of minutes in the past from which to retrieve events. For
#' example, to get all events from the past 2 hours, enter 120.
#' 
#' Default: `60`
#' 
#' The minimum is 1 and the maximum is 14 days (20160 minutes).
#' @param pageToken A token used for advancing to a specific page of results from for get
#' relational database events request.
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_events(
#'   relationalDatabaseName = "string",
#'   durationInMinutes = 123,
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_events
lightsail_get_relational_database_events <- function(relationalDatabaseName, durationInMinutes = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_events_input(relationalDatabaseName = relationalDatabaseName, durationInMinutes = durationInMinutes, pageToken = pageToken)
  output <- .lightsail$get_relational_database_events_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_events <- lightsail_get_relational_database_events

#' Returns a list of log events for a database in Amazon Lightsail
#'
#' Returns a list of log events for a database in Amazon Lightsail.
#'
#' @usage
#' lightsail_get_relational_database_log_events(relationalDatabaseName,
#'   logStreamName, startTime, endTime, startFromHead, pageToken)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to get log events.
#' @param logStreamName &#91;required&#93; The name of the log stream.
#' 
#' Use the `get relational database log streams` operation to get a list of
#' available log streams.
#' @param startTime The start of the time interval from which to get log events.
#' 
#' Constraints:
#' 
#' -   Specified in Universal Coordinated Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use a start time of October 1, 2018, at
#'     8 PM UTC, then you input `1538424000` as the start time.
#' @param endTime The end of the time interval from which to get log events.
#' 
#' Constraints:
#' 
#' -   Specified in Universal Coordinated Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use an end time of October 1, 2018, at 8
#'     PM UTC, then you input `1538424000` as the end time.
#' @param startFromHead Parameter to specify if the log should start from head or tail. If
#' `true` is specified, the log event starts from the head of the log. If
#' `false` is specified, the log event starts from the tail of the log.
#' 
#' Default: `false`
#' @param pageToken A token used for advancing to a specific page of results for your
#' `get relational database log events` request.
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_log_events(
#'   relationalDatabaseName = "string",
#'   logStreamName = "string",
#'   startTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   endTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   startFromHead = TRUE|FALSE,
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_log_events
lightsail_get_relational_database_log_events <- function(relationalDatabaseName, logStreamName, startTime = NULL, endTime = NULL, startFromHead = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseLogEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_log_events_input(relationalDatabaseName = relationalDatabaseName, logStreamName = logStreamName, startTime = startTime, endTime = endTime, startFromHead = startFromHead, pageToken = pageToken)
  output <- .lightsail$get_relational_database_log_events_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_log_events <- lightsail_get_relational_database_log_events

#' Returns a list of available log streams for a specific database in
#' Amazon Lightsail
#'
#' Returns a list of available log streams for a specific database in
#' Amazon Lightsail.
#'
#' @usage
#' lightsail_get_relational_database_log_streams(relationalDatabaseName)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to get log streams.
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_log_streams(
#'   relationalDatabaseName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_log_streams
lightsail_get_relational_database_log_streams <- function(relationalDatabaseName) {
  op <- new_operation(
    name = "GetRelationalDatabaseLogStreams",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_log_streams_input(relationalDatabaseName = relationalDatabaseName)
  output <- .lightsail$get_relational_database_log_streams_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_log_streams <- lightsail_get_relational_database_log_streams

#' Returns the current, previous, or pending versions of the master user
#' password for a Lightsail database
#'
#' Returns the current, previous, or pending versions of the master user
#' password for a Lightsail database.
#' 
#' The `asdf` operation GetRelationalDatabaseMasterUserPassword supports
#' tag-based access control via resource tags applied to the resource
#' identified by relationalDatabaseName.
#'
#' @usage
#' lightsail_get_relational_database_master_user_password(
#'   relationalDatabaseName, passwordVersion)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to get the master user password.
#' @param passwordVersion The password version to return.
#' 
#' Specifying `CURRENT` or `PREVIOUS` returns the current or previous
#' passwords respectively. Specifying `PENDING` returns the newest version
#' of the password that will rotate to `CURRENT`. After the `PENDING`
#' password rotates to `CURRENT`, the `PENDING` password is no longer
#' available.
#' 
#' Default: `CURRENT`
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_master_user_password(
#'   relationalDatabaseName = "string",
#'   passwordVersion = "CURRENT"|"PREVIOUS"|"PENDING"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_master_user_password
lightsail_get_relational_database_master_user_password <- function(relationalDatabaseName, passwordVersion = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseMasterUserPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_master_user_password_input(relationalDatabaseName = relationalDatabaseName, passwordVersion = passwordVersion)
  output <- .lightsail$get_relational_database_master_user_password_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_master_user_password <- lightsail_get_relational_database_master_user_password

#' Returns the data points of the specified metric for a database in Amazon
#' Lightsail
#'
#' Returns the data points of the specified metric for a database in Amazon
#' Lightsail.
#'
#' @usage
#' lightsail_get_relational_database_metric_data(relationalDatabaseName,
#'   metricName, period, startTime, endTime, unit, statistics)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database from which to get metric data.
#' @param metricName &#91;required&#93; The name of the metric data to return.
#' @param period &#91;required&#93; The granularity, in seconds, of the returned data points.
#' @param startTime &#91;required&#93; The start of the time interval from which to get metric data.
#' 
#' Constraints:
#' 
#' -   Specified in Universal Coordinated Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use a start time of October 1, 2018, at
#'     8 PM UTC, then you input `1538424000` as the start time.
#' @param endTime &#91;required&#93; The end of the time interval from which to get metric data.
#' 
#' Constraints:
#' 
#' -   Specified in Universal Coordinated Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use an end time of October 1, 2018, at 8
#'     PM UTC, then you input `1538424000` as the end time.
#' @param unit &#91;required&#93; The unit for the metric data request.
#' @param statistics &#91;required&#93; The array of statistics for your metric data request.
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_metric_data(
#'   relationalDatabaseName = "string",
#'   metricName = "CPUUtilization"|"DatabaseConnections"|"DiskQueueDepth"|"FreeStorageSpace"|"NetworkReceiveThroughput"|"NetworkTransmitThroughput",
#'   period = 123,
#'   startTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   endTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
#'   statistics = list(
#'     "Minimum"|"Maximum"|"Sum"|"Average"|"SampleCount"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_metric_data
lightsail_get_relational_database_metric_data <- function(relationalDatabaseName, metricName, period, startTime, endTime, unit, statistics) {
  op <- new_operation(
    name = "GetRelationalDatabaseMetricData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_metric_data_input(relationalDatabaseName = relationalDatabaseName, metricName = metricName, period = period, startTime = startTime, endTime = endTime, unit = unit, statistics = statistics)
  output <- .lightsail$get_relational_database_metric_data_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_metric_data <- lightsail_get_relational_database_metric_data

#' Returns all of the runtime parameters offered by the underlying database
#' software, or engine, for a specific database in Amazon Lightsail
#'
#' Returns all of the runtime parameters offered by the underlying database
#' software, or engine, for a specific database in Amazon Lightsail.
#' 
#' In addition to the parameter names and values, this operation returns
#' other information about each parameter. This information includes
#' whether changes require a reboot, whether the parameter is modifiable,
#' the allowed values, and the data types.
#'
#' @usage
#' lightsail_get_relational_database_parameters(relationalDatabaseName,
#'   pageToken)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to get parameters.
#' @param pageToken A token used for advancing to a specific page of results for your
#' `get relational database parameters` request.
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_parameters(
#'   relationalDatabaseName = "string",
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_parameters
lightsail_get_relational_database_parameters <- function(relationalDatabaseName, pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_parameters_input(relationalDatabaseName = relationalDatabaseName, pageToken = pageToken)
  output <- .lightsail$get_relational_database_parameters_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_parameters <- lightsail_get_relational_database_parameters

#' Returns information about a specific database snapshot in Amazon
#' Lightsail
#'
#' Returns information about a specific database snapshot in Amazon
#' Lightsail.
#'
#' @usage
#' lightsail_get_relational_database_snapshot(
#'   relationalDatabaseSnapshotName)
#'
#' @param relationalDatabaseSnapshotName &#91;required&#93; The name of the database snapshot for which to get information.
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_snapshot(
#'   relationalDatabaseSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_snapshot
lightsail_get_relational_database_snapshot <- function(relationalDatabaseSnapshotName) {
  op <- new_operation(
    name = "GetRelationalDatabaseSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_snapshot_input(relationalDatabaseSnapshotName = relationalDatabaseSnapshotName)
  output <- .lightsail$get_relational_database_snapshot_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_snapshot <- lightsail_get_relational_database_snapshot

#' Returns information about all of your database snapshots in Amazon
#' Lightsail
#'
#' Returns information about all of your database snapshots in Amazon
#' Lightsail.
#'
#' @usage
#' lightsail_get_relational_database_snapshots(pageToken)
#'
#' @param pageToken A token used for advancing to a specific page of results for your
#' `get relational database snapshots` request.
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_snapshots(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_snapshots
lightsail_get_relational_database_snapshots <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_snapshots_input(pageToken = pageToken)
  output <- .lightsail$get_relational_database_snapshots_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_snapshots <- lightsail_get_relational_database_snapshots

#' Returns information about all of your databases in Amazon Lightsail
#'
#' Returns information about all of your databases in Amazon Lightsail.
#'
#' @usage
#' lightsail_get_relational_databases(pageToken)
#'
#' @param pageToken A token used for advancing to a specific page of results for your
#' `get relational database` request.
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_databases(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_databases
lightsail_get_relational_databases <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_databases_input(pageToken = pageToken)
  output <- .lightsail$get_relational_databases_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_databases <- lightsail_get_relational_databases

#' Returns information about a specific static IP
#'
#' Returns information about a specific static IP.
#'
#' @usage
#' lightsail_get_static_ip(staticIpName)
#'
#' @param staticIpName &#91;required&#93; The name of the static IP in Lightsail.
#'
#' @section Request syntax:
#' ```
#' svc$get_static_ip(
#'   staticIpName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_static_ip
lightsail_get_static_ip <- function(staticIpName) {
  op <- new_operation(
    name = "GetStaticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_static_ip_input(staticIpName = staticIpName)
  output <- .lightsail$get_static_ip_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_static_ip <- lightsail_get_static_ip

#' Returns information about all static IPs in the user's account
#'
#' Returns information about all static IPs in the user\'s account.
#'
#' @usage
#' lightsail_get_static_ips(pageToken)
#'
#' @param pageToken A token used for advancing to the next page of results from your get
#' static IPs request.
#'
#' @section Request syntax:
#' ```
#' svc$get_static_ips(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_static_ips
lightsail_get_static_ips <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetStaticIps",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_static_ips_input(pageToken = pageToken)
  output <- .lightsail$get_static_ips_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_static_ips <- lightsail_get_static_ips

#' Imports a public SSH key from a specific key pair
#'
#' Imports a public SSH key from a specific key pair.
#'
#' @usage
#' lightsail_import_key_pair(keyPairName, publicKeyBase64)
#'
#' @param keyPairName &#91;required&#93; The name of the key pair for which you want to import the public key.
#' @param publicKeyBase64 &#91;required&#93; A base64-encoded public key of the `ssh-rsa` type.
#'
#' @section Request syntax:
#' ```
#' svc$import_key_pair(
#'   keyPairName = "string",
#'   publicKeyBase64 = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_import_key_pair
lightsail_import_key_pair <- function(keyPairName, publicKeyBase64) {
  op <- new_operation(
    name = "ImportKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$import_key_pair_input(keyPairName = keyPairName, publicKeyBase64 = publicKeyBase64)
  output <- .lightsail$import_key_pair_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$import_key_pair <- lightsail_import_key_pair

#' Returns a Boolean value indicating whether your Lightsail VPC is peered
#'
#' Returns a Boolean value indicating whether your Lightsail VPC is peered.
#'
#' @usage
#' lightsail_is_vpc_peered()
#'
#' @section Request syntax:
#' ```
#' svc$is_vpc_peered()
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_is_vpc_peered
lightsail_is_vpc_peered <- function() {
  op <- new_operation(
    name = "IsVpcPeered",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$is_vpc_peered_input()
  output <- .lightsail$is_vpc_peered_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$is_vpc_peered <- lightsail_is_vpc_peered

#' Adds public ports to an Amazon Lightsail instance
#'
#' Adds public ports to an Amazon Lightsail instance.
#' 
#' The `open instance public ports` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' instanceName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_open_instance_public_ports(portInfo, instanceName)
#'
#' @param portInfo &#91;required&#93; An array of key-value pairs containing information about the port
#' mappings.
#' @param instanceName &#91;required&#93; The name of the instance for which you want to open the public ports.
#'
#' @section Request syntax:
#' ```
#' svc$open_instance_public_ports(
#'   portInfo = list(
#'     fromPort = 123,
#'     toPort = 123,
#'     protocol = "tcp"|"all"|"udp"
#'   ),
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_open_instance_public_ports
lightsail_open_instance_public_ports <- function(portInfo, instanceName) {
  op <- new_operation(
    name = "OpenInstancePublicPorts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$open_instance_public_ports_input(portInfo = portInfo, instanceName = instanceName)
  output <- .lightsail$open_instance_public_ports_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$open_instance_public_ports <- lightsail_open_instance_public_ports

#' Tries to peer the Lightsail VPC with the user's default VPC
#'
#' Tries to peer the Lightsail VPC with the user\'s default VPC.
#'
#' @usage
#' lightsail_peer_vpc()
#'
#' @section Request syntax:
#' ```
#' svc$peer_vpc()
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_peer_vpc
lightsail_peer_vpc <- function() {
  op <- new_operation(
    name = "PeerVpc",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$peer_vpc_input()
  output <- .lightsail$peer_vpc_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$peer_vpc <- lightsail_peer_vpc

#' Sets the specified open ports for an Amazon Lightsail instance, and
#' closes all ports for every protocol not included in the current request
#'
#' Sets the specified open ports for an Amazon Lightsail instance, and
#' closes all ports for every protocol not included in the current request.
#' 
#' The `put instance public ports` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' instanceName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_put_instance_public_ports(portInfos, instanceName)
#'
#' @param portInfos &#91;required&#93; Specifies information about the public port(s).
#' @param instanceName &#91;required&#93; The Lightsail instance name of the public port(s) you are setting.
#'
#' @section Request syntax:
#' ```
#' svc$put_instance_public_ports(
#'   portInfos = list(
#'     list(
#'       fromPort = 123,
#'       toPort = 123,
#'       protocol = "tcp"|"all"|"udp"
#'     )
#'   ),
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_put_instance_public_ports
lightsail_put_instance_public_ports <- function(portInfos, instanceName) {
  op <- new_operation(
    name = "PutInstancePublicPorts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$put_instance_public_ports_input(portInfos = portInfos, instanceName = instanceName)
  output <- .lightsail$put_instance_public_ports_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$put_instance_public_ports <- lightsail_put_instance_public_ports

#' Restarts a specific instance
#'
#' Restarts a specific instance.
#' 
#' The `reboot instance` operation supports tag-based access control via
#' resource tags applied to the resource identified by instanceName. For
#' more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_reboot_instance(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the instance to reboot.
#'
#' @section Request syntax:
#' ```
#' svc$reboot_instance(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_reboot_instance
lightsail_reboot_instance <- function(instanceName) {
  op <- new_operation(
    name = "RebootInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$reboot_instance_input(instanceName = instanceName)
  output <- .lightsail$reboot_instance_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$reboot_instance <- lightsail_reboot_instance

#' Restarts a specific database in Amazon Lightsail
#'
#' Restarts a specific database in Amazon Lightsail.
#' 
#' The `reboot relational database` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' relationalDatabaseName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_reboot_relational_database(relationalDatabaseName)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database to reboot.
#'
#' @section Request syntax:
#' ```
#' svc$reboot_relational_database(
#'   relationalDatabaseName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_reboot_relational_database
lightsail_reboot_relational_database <- function(relationalDatabaseName) {
  op <- new_operation(
    name = "RebootRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$reboot_relational_database_input(relationalDatabaseName = relationalDatabaseName)
  output <- .lightsail$reboot_relational_database_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$reboot_relational_database <- lightsail_reboot_relational_database

#' Deletes a specific static IP from your account
#'
#' Deletes a specific static IP from your account.
#'
#' @usage
#' lightsail_release_static_ip(staticIpName)
#'
#' @param staticIpName &#91;required&#93; The name of the static IP to delete.
#'
#' @section Request syntax:
#' ```
#' svc$release_static_ip(
#'   staticIpName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_release_static_ip
lightsail_release_static_ip <- function(staticIpName) {
  op <- new_operation(
    name = "ReleaseStaticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$release_static_ip_input(staticIpName = staticIpName)
  output <- .lightsail$release_static_ip_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$release_static_ip <- lightsail_release_static_ip

#' Starts a specific Amazon Lightsail instance from a stopped state
#'
#' Starts a specific Amazon Lightsail instance from a stopped state. To
#' restart an instance, use the `reboot instance` operation.
#' 
#' When you start a stopped instance, Lightsail assigns a new public IP
#' address to the instance. To use the same IP address after stopping and
#' starting an instance, create a static IP address and attach it to the
#' instance. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/lightsail-create-static-ip).
#' 
#' The `start instance` operation supports tag-based access control via
#' resource tags applied to the resource identified by instanceName. For
#' more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_start_instance(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the instance (a virtual private server) to start.
#'
#' @section Request syntax:
#' ```
#' svc$start_instance(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_start_instance
lightsail_start_instance <- function(instanceName) {
  op <- new_operation(
    name = "StartInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$start_instance_input(instanceName = instanceName)
  output <- .lightsail$start_instance_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$start_instance <- lightsail_start_instance

#' Starts a specific database from a stopped state in Amazon Lightsail
#'
#' Starts a specific database from a stopped state in Amazon Lightsail. To
#' restart a database, use the `reboot relational database` operation.
#' 
#' The `start relational database` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' relationalDatabaseName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_start_relational_database(relationalDatabaseName)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database to start.
#'
#' @section Request syntax:
#' ```
#' svc$start_relational_database(
#'   relationalDatabaseName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_start_relational_database
lightsail_start_relational_database <- function(relationalDatabaseName) {
  op <- new_operation(
    name = "StartRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$start_relational_database_input(relationalDatabaseName = relationalDatabaseName)
  output <- .lightsail$start_relational_database_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$start_relational_database <- lightsail_start_relational_database

#' Stops a specific Amazon Lightsail instance that is currently running
#'
#' Stops a specific Amazon Lightsail instance that is currently running.
#' 
#' When you start a stopped instance, Lightsail assigns a new public IP
#' address to the instance. To use the same IP address after stopping and
#' starting an instance, create a static IP address and attach it to the
#' instance. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/lightsail-create-static-ip).
#' 
#' The `stop instance` operation supports tag-based access control via
#' resource tags applied to the resource identified by instanceName. For
#' more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_stop_instance(instanceName, force)
#'
#' @param instanceName &#91;required&#93; The name of the instance (a virtual private server) to stop.
#' @param force When set to `True`, forces a Lightsail instance that is stuck in a
#' `stopping` state to stop.
#' 
#' Only use the `force` parameter if your instance is stuck in the
#' `stopping` state. In any other state, your instance should stop normally
#' without adding this parameter to your API request.
#'
#' @section Request syntax:
#' ```
#' svc$stop_instance(
#'   instanceName = "string",
#'   force = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_stop_instance
lightsail_stop_instance <- function(instanceName, force = NULL) {
  op <- new_operation(
    name = "StopInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$stop_instance_input(instanceName = instanceName, force = force)
  output <- .lightsail$stop_instance_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$stop_instance <- lightsail_stop_instance

#' Stops a specific database that is currently running in Amazon Lightsail
#'
#' Stops a specific database that is currently running in Amazon Lightsail.
#' 
#' The `stop relational database` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' relationalDatabaseName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_stop_relational_database(relationalDatabaseName,
#'   relationalDatabaseSnapshotName)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database to stop.
#' @param relationalDatabaseSnapshotName The name of your new database snapshot to be created before stopping
#' your database.
#'
#' @section Request syntax:
#' ```
#' svc$stop_relational_database(
#'   relationalDatabaseName = "string",
#'   relationalDatabaseSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_stop_relational_database
lightsail_stop_relational_database <- function(relationalDatabaseName, relationalDatabaseSnapshotName = NULL) {
  op <- new_operation(
    name = "StopRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$stop_relational_database_input(relationalDatabaseName = relationalDatabaseName, relationalDatabaseSnapshotName = relationalDatabaseSnapshotName)
  output <- .lightsail$stop_relational_database_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$stop_relational_database <- lightsail_stop_relational_database

#' Adds one or more tags to the specified Amazon Lightsail resource
#'
#' Adds one or more tags to the specified Amazon Lightsail resource. Each
#' resource can have a maximum of 50 tags. Each tag consists of a key and
#' an optional value. Tag keys must be unique per resource. For more
#' information about tags, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags).
#' 
#' The `tag resource` operation supports tag-based access control via
#' request tags and resource tags applied to the resource identified by
#' resourceName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_tag_resource(resourceName, tags)
#'
#' @param resourceName &#91;required&#93; The name of the resource to which you are adding tags.
#' @param tags &#91;required&#93; The tag key and optional value.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   resourceName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_tag_resource
lightsail_tag_resource <- function(resourceName, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$tag_resource_input(resourceName = resourceName, tags = tags)
  output <- .lightsail$tag_resource_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$tag_resource <- lightsail_tag_resource

#' Attempts to unpeer the Lightsail VPC from the user's default VPC
#'
#' Attempts to unpeer the Lightsail VPC from the user\'s default VPC.
#'
#' @usage
#' lightsail_unpeer_vpc()
#'
#' @section Request syntax:
#' ```
#' svc$unpeer_vpc()
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_unpeer_vpc
lightsail_unpeer_vpc <- function() {
  op <- new_operation(
    name = "UnpeerVpc",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$unpeer_vpc_input()
  output <- .lightsail$unpeer_vpc_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$unpeer_vpc <- lightsail_unpeer_vpc

#' Deletes the specified set of tag keys and their values from the
#' specified Amazon Lightsail resource
#'
#' Deletes the specified set of tag keys and their values from the
#' specified Amazon Lightsail resource.
#' 
#' The `untag resource` operation supports tag-based access control via
#' request tags and resource tags applied to the resource identified by
#' resourceName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_untag_resource(resourceName, tagKeys)
#'
#' @param resourceName &#91;required&#93; The name of the resource from which you are removing a tag.
#' @param tagKeys &#91;required&#93; The tag keys to delete from the specified resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   resourceName = "string",
#'   tagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_untag_resource
lightsail_untag_resource <- function(resourceName, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$untag_resource_input(resourceName = resourceName, tagKeys = tagKeys)
  output <- .lightsail$untag_resource_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$untag_resource <- lightsail_untag_resource

#' Updates a domain recordset after it is created
#'
#' Updates a domain recordset after it is created.
#' 
#' The `update domain entry` operation supports tag-based access control
#' via resource tags applied to the resource identified by domainName. For
#' more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_update_domain_entry(domainName, domainEntry)
#'
#' @param domainName &#91;required&#93; The name of the domain recordset to update.
#' @param domainEntry &#91;required&#93; An array of key-value pairs containing information about the domain
#' entry.
#'
#' @section Request syntax:
#' ```
#' svc$update_domain_entry(
#'   domainName = "string",
#'   domainEntry = list(
#'     id = "string",
#'     name = "string",
#'     target = "string",
#'     isAlias = TRUE|FALSE,
#'     type = "string",
#'     options = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_update_domain_entry
lightsail_update_domain_entry <- function(domainName, domainEntry) {
  op <- new_operation(
    name = "UpdateDomainEntry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$update_domain_entry_input(domainName = domainName, domainEntry = domainEntry)
  output <- .lightsail$update_domain_entry_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_domain_entry <- lightsail_update_domain_entry

#' Updates the specified attribute for a load balancer
#'
#' Updates the specified attribute for a load balancer. You can only update
#' one attribute at a time.
#' 
#' The `update load balancer attribute` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' loadBalancerName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_update_load_balancer_attribute(loadBalancerName,
#'   attributeName, attributeValue)
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer that you want to modify (e.g.,
#' `my-load-balancer`.
#' @param attributeName &#91;required&#93; The name of the attribute you want to update. Valid values are below.
#' @param attributeValue &#91;required&#93; The value that you want to specify for the attribute name.
#'
#' @section Request syntax:
#' ```
#' svc$update_load_balancer_attribute(
#'   loadBalancerName = "string",
#'   attributeName = "HealthCheckPath"|"SessionStickinessEnabled"|"SessionStickiness_LB_CookieDurationSeconds",
#'   attributeValue = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_update_load_balancer_attribute
lightsail_update_load_balancer_attribute <- function(loadBalancerName, attributeName, attributeValue) {
  op <- new_operation(
    name = "UpdateLoadBalancerAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$update_load_balancer_attribute_input(loadBalancerName = loadBalancerName, attributeName = attributeName, attributeValue = attributeValue)
  output <- .lightsail$update_load_balancer_attribute_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_load_balancer_attribute <- lightsail_update_load_balancer_attribute

#' Allows the update of one or more attributes of a database in Amazon
#' Lightsail
#'
#' Allows the update of one or more attributes of a database in Amazon
#' Lightsail.
#' 
#' Updates are applied immediately, or in cases where the updates could
#' result in an outage, are applied during the database\'s predefined
#' maintenance window.
#' 
#' The `update relational database` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' relationalDatabaseName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_update_relational_database(relationalDatabaseName,
#'   masterUserPassword, rotateMasterUserPassword, preferredBackupWindow,
#'   preferredMaintenanceWindow, enableBackupRetention,
#'   disableBackupRetention, publiclyAccessible, applyImmediately)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database to update.
#' @param masterUserPassword The password for the master user of your database. The password can
#' include any printable ASCII character except \"/\", \"\"\", or \"@\".
#' 
#' Constraints: Must contain 8 to 41 characters.
#' @param rotateMasterUserPassword When `true`, the master user password is changed to a new strong
#' password generated by Lightsail.
#' 
#' Use the `get relational database master user password` operation to get
#' the new password.
#' @param preferredBackupWindow The daily time range during which automated backups are created for your
#' database if automated backups are enabled.
#' 
#' Constraints:
#' 
#' -   Must be in the `hh24:mi-hh24:mi` format.
#' 
#'     Example: `16:00-16:30`
#' 
#' -   Specified in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur on your
#' database.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week.
#' 
#' Constraints:
#' 
#' -   Must be in the `ddd:hh24:mi-ddd:hh24:mi` format.
#' 
#' -   Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' -   Must be at least 30 minutes.
#' 
#' -   Specified in Universal Coordinated Time (UTC).
#' 
#' -   Example: `Tue:17:00-Tue:17:30`
#' @param enableBackupRetention When `true`, enables automated backup retention for your database.
#' 
#' Updates are applied during the next maintenance window because this can
#' result in an outage.
#' @param disableBackupRetention When `true`, disables automated backup retention for your database.
#' 
#' Disabling backup retention deletes all automated database backups.
#' Before disabling this, you may want to create a snapshot of your
#' database using the `create relational database snapshot` operation.
#' 
#' Updates are applied during the next maintenance window because this can
#' result in an outage.
#' @param publiclyAccessible Specifies the accessibility options for your database. A value of `true`
#' specifies a database that is available to resources outside of your
#' Lightsail account. A value of `false` specifies a database that is
#' available only to your Lightsail resources in the same region as your
#' database.
#' @param applyImmediately When `true`, applies changes immediately. When `false`, applies changes
#' during the preferred maintenance window. Some changes may cause an
#' outage.
#' 
#' Default: `false`
#'
#' @section Request syntax:
#' ```
#' svc$update_relational_database(
#'   relationalDatabaseName = "string",
#'   masterUserPassword = "string",
#'   rotateMasterUserPassword = TRUE|FALSE,
#'   preferredBackupWindow = "string",
#'   preferredMaintenanceWindow = "string",
#'   enableBackupRetention = TRUE|FALSE,
#'   disableBackupRetention = TRUE|FALSE,
#'   publiclyAccessible = TRUE|FALSE,
#'   applyImmediately = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_update_relational_database
lightsail_update_relational_database <- function(relationalDatabaseName, masterUserPassword = NULL, rotateMasterUserPassword = NULL, preferredBackupWindow = NULL, preferredMaintenanceWindow = NULL, enableBackupRetention = NULL, disableBackupRetention = NULL, publiclyAccessible = NULL, applyImmediately = NULL) {
  op <- new_operation(
    name = "UpdateRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$update_relational_database_input(relationalDatabaseName = relationalDatabaseName, masterUserPassword = masterUserPassword, rotateMasterUserPassword = rotateMasterUserPassword, preferredBackupWindow = preferredBackupWindow, preferredMaintenanceWindow = preferredMaintenanceWindow, enableBackupRetention = enableBackupRetention, disableBackupRetention = disableBackupRetention, publiclyAccessible = publiclyAccessible, applyImmediately = applyImmediately)
  output <- .lightsail$update_relational_database_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_relational_database <- lightsail_update_relational_database

#' Allows the update of one or more parameters of a database in Amazon
#' Lightsail
#'
#' Allows the update of one or more parameters of a database in Amazon
#' Lightsail.
#' 
#' Parameter updates don\'t cause outages; therefore, their application is
#' not subject to the preferred maintenance window. However, there are two
#' ways in which paramater updates are applied: `dynamic` or
#' `pending-reboot`. Parameters marked with a `dynamic` apply type are
#' applied immediately. Parameters marked with a `pending-reboot` apply
#' type are applied only after the database is rebooted using the
#' `reboot relational database` operation.
#' 
#' The `update relational database parameters` operation supports tag-based
#' access control via resource tags applied to the resource identified by
#' relationalDatabaseName. For more information, see the [Lightsail Dev
#' Guide](https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
#'
#' @usage
#' lightsail_update_relational_database_parameters(relationalDatabaseName,
#'   parameters)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to update parameters.
#' @param parameters &#91;required&#93; The database parameters to update.
#'
#' @section Request syntax:
#' ```
#' svc$update_relational_database_parameters(
#'   relationalDatabaseName = "string",
#'   parameters = list(
#'     list(
#'       allowedValues = "string",
#'       applyMethod = "string",
#'       applyType = "string",
#'       dataType = "string",
#'       description = "string",
#'       isModifiable = TRUE|FALSE,
#'       parameterName = "string",
#'       parameterValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_update_relational_database_parameters
lightsail_update_relational_database_parameters <- function(relationalDatabaseName, parameters) {
  op <- new_operation(
    name = "UpdateRelationalDatabaseParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$update_relational_database_parameters_input(relationalDatabaseName = relationalDatabaseName, parameters = parameters)
  output <- .lightsail$update_relational_database_parameters_output()
  svc <- .lightsail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_relational_database_parameters <- lightsail_update_relational_database_parameters
