% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serverlessapplicationrepository_operations.R
\name{serverlessapplicationrepository_create_cloud_formation_change_set}
\alias{serverlessapplicationrepository_create_cloud_formation_change_set}
\title{Creates an AWS CloudFormation change set for the given application}
\usage{
serverlessapplicationrepository_create_cloud_formation_change_set(
  ApplicationId, Capabilities, ChangeSetName, ClientToken, Description,
  NotificationArns, ParameterOverrides, ResourceTypes,
  RollbackConfiguration, SemanticVersion, StackName, Tags, TemplateId)
}
\arguments{
\item{ApplicationId}{[required] The Amazon Resource Name (ARN) of the application.}

\item{Capabilities}{A list of values that you must specify before you can deploy certain
applications. Some applications might include resources that can affect
permissions in your AWS account, for example, by creating new AWS
Identity and Access Management (IAM) users. For those applications, you
must explicitly acknowledge their capabilities by specifying this
parameter.

The only valid values are CAPABILITY\_IAM, CAPABILITY\_NAMED\_IAM,
CAPABILITY\_RESOURCE\_POLICY, and CAPABILITY\_AUTO\_EXPAND.

The following resources require you to specify CAPABILITY\_IAM or
CAPABILITY\_NAMED\_IAM:
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html}{AWS::IAM::Group},
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html}{AWS::IAM::InstanceProfile},
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html}{AWS::IAM::Policy},
and
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html}{AWS::IAM::Role}.
If the application contains IAM resources, you can specify either
CAPABILITY\_IAM or CAPABILITY\_NAMED\_IAM. If the application contains
IAM resources with custom names, you must specify
CAPABILITY\_NAMED\_IAM.

The following resources require you to specify
CAPABILITY\_RESOURCE\_POLICY:
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html}{AWS::Lambda::Permission},
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html}{AWS::IAM:Policy},
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html}{AWS::ApplicationAutoScaling::ScalingPolicy},
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html}{AWS::S3::BucketPolicy},
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html}{AWS::SQS::QueuePolicy},
and
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html}{AWS::SNS:TopicPolicy}.

Applications that contain one or more nested applications require you to
specify CAPABILITY\_AUTO\_EXPAND.

If your application template contains any of the above resources, we
recommend that you review all permissions associated with the
application before deploying. If you don't specify this parameter for
an application that requires capabilities, the call will fail.}

\item{ChangeSetName}{This property corresponds to the parameter of the same name for the \emph{AWS
CloudFormation
\href{https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet}{CreateChangeSet}}
API.}

\item{ClientToken}{This property corresponds to the parameter of the same name for the \emph{AWS
CloudFormation
\href{https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet}{CreateChangeSet}}
API.}

\item{Description}{This property corresponds to the parameter of the same name for the \emph{AWS
CloudFormation
\href{https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet}{CreateChangeSet}}
API.}

\item{NotificationArns}{This property corresponds to the parameter of the same name for the \emph{AWS
CloudFormation
\href{https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet}{CreateChangeSet}}
API.}

\item{ParameterOverrides}{A list of parameter values for the parameters of the application.}

\item{ResourceTypes}{This property corresponds to the parameter of the same name for the \emph{AWS
CloudFormation
\href{https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet}{CreateChangeSet}}
API.}

\item{RollbackConfiguration}{This property corresponds to the parameter of the same name for the \emph{AWS
CloudFormation
\href{https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet}{CreateChangeSet}}
API.}

\item{SemanticVersion}{The semantic version of the application:

\url{https://semver.org/}}

\item{StackName}{[required] This property corresponds to the parameter of the same name for the \emph{AWS
CloudFormation
\href{https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet}{CreateChangeSet}}
API.}

\item{Tags}{This property corresponds to the parameter of the same name for the \emph{AWS
CloudFormation
\href{https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet}{CreateChangeSet}}
API.}

\item{TemplateId}{The UUID returned by CreateCloudFormationTemplate.

Pattern:
[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}}
}
\description{
Creates an AWS CloudFormation change set for the given application.
}
\section{Request syntax}{
\preformatted{svc$create_cloud_formation_change_set(
  ApplicationId = "string",
  Capabilities = list(
    "string"
  ),
  ChangeSetName = "string",
  ClientToken = "string",
  Description = "string",
  NotificationArns = list(
    "string"
  ),
  ParameterOverrides = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  ResourceTypes = list(
    "string"
  ),
  RollbackConfiguration = list(
    MonitoringTimeInMinutes = 123,
    RollbackTriggers = list(
      list(
        Arn = "string",
        Type = "string"
      )
    )
  ),
  SemanticVersion = "string",
  StackName = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  TemplateId = "string"
)
}
}

\keyword{internal}
