% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_add_layer_version_permission}
\alias{lambda_add_layer_version_permission}
\title{Adds permissions to the resource-based policy of a version of an AWS
Lambda layer}
\usage{
lambda_add_layer_version_permission(LayerName, VersionNumber,
  StatementId, Action, Principal, OrganizationId, RevisionId)
}
\arguments{
\item{LayerName}{[required] The name or Amazon Resource Name (ARN) of the layer.}

\item{VersionNumber}{[required] The version number.}

\item{StatementId}{[required] An identifier that distinguishes the policy from others on the same
layer version.}

\item{Action}{[required] The API action that grants access to the layer. For example,
\code{lambda:GetLayerVersion}.}

\item{Principal}{[required] An account ID, or \code{*} to grant permission to all AWS accounts.}

\item{OrganizationId}{With the principal set to \code{*}, grant permission to all accounts in the
specified organization.}

\item{RevisionId}{Only update the policy if the revision ID matches the ID specified. Use
this option to avoid modifying a policy that has changed since you last
read it.}
}
\description{
Adds permissions to the resource-based policy of a version of an \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html}{AWS Lambda layer}.
Use this action to grant layer usage permission to other accounts. You
can grant permission to a single account, all AWS accounts, or all
accounts in an organization.
}
\details{
To revoke permission, call RemoveLayerVersionPermission with the
statement ID that you specified when you added it.
}
\section{Request syntax}{
\preformatted{svc$add_layer_version_permission(
  LayerName = "string",
  VersionNumber = 123,
  StatementId = "string",
  Action = "string",
  Principal = "string",
  OrganizationId = "string",
  RevisionId = "string"
)
}
}

\keyword{internal}
