% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_subnet_attribute}
\alias{ec2_modify_subnet_attribute}
\title{Modifies a subnet attribute}
\usage{
ec2_modify_subnet_attribute(AssignIpv6AddressOnCreation,
  MapPublicIpOnLaunch, SubnetId)
}
\arguments{
\item{AssignIpv6AddressOnCreation}{Specify \code{true} to indicate that network interfaces created in the
specified subnet should be assigned an IPv6 address. This includes a
network interface that\'s created when launching an instance into the
subnet (the instance therefore receives an IPv6 address).

If you enable the IPv6 addressing feature for your subnet, your network
interface or instance only receives an IPv6 address if it\'s created
using version \code{2016-11-15} or later of the Amazon EC2 API.}

\item{MapPublicIpOnLaunch}{Specify \code{true} to indicate that ENIs attached to instances created in
the specified subnet should be assigned a public IPv4 address.}

\item{SubnetId}{[required] The ID of the subnet.}
}
\description{
Modifies a subnet attribute. You can only modify one attribute at a
time.
}
\section{Request syntax}{
\preformatted{svc$modify_subnet_attribute(
  AssignIpv6AddressOnCreation = list(
    Value = TRUE|FALSE
  ),
  MapPublicIpOnLaunch = list(
    Value = TRUE|FALSE
  ),
  SubnetId = "string"
)
}
}

\examples{
# This example modifies the specified subnet so that all instances
# launched into this subnet are assigned a public IP address.
\donttest{svc$modify_subnet_attribute(
  MapPublicIpOnLaunch = list(
    Value = TRUE
  ),
  SubnetId = "subnet-1a2b3c4d"
)}

}
\keyword{internal}
