% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_list_jobs}
\alias{batch_list_jobs}
\title{Returns a list of AWS Batch jobs}
\usage{
batch_list_jobs(jobQueue, arrayJobId, multiNodeJobId, jobStatus,
  maxResults, nextToken)
}
\arguments{
\item{jobQueue}{The name or full Amazon Resource Name (ARN) of the job queue with which
to list jobs.}

\item{arrayJobId}{The job ID for an array job. Specifying an array job ID with this
parameter lists all child jobs from within the specified array.}

\item{multiNodeJobId}{The job ID for a multi-node parallel job. Specifying a multi-node
parallel job ID with this parameter lists all nodes that are associated
with the specified job.}

\item{jobStatus}{The job status with which to filter jobs in the specified queue. If you
do not specify a status, only \code{RUNNING} jobs are returned.}

\item{maxResults}{The maximum number of results returned by \code{ListJobs} in paginated
output. When this parameter is used, \code{ListJobs} only returns
\code{maxResults} results in a single page along with a \code{nextToken} response
element. The remaining results of the initial request can be seen by
sending another \code{ListJobs} request with the returned \code{nextToken} value.
This value can be between 1 and 100. If this parameter is not used, then
\code{ListJobs} returns up to 100 results and a \code{nextToken} value if
applicable.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated \code{ListJobs}
request where \code{maxResults} was used and the results exceeded the value
of that parameter. Pagination continues from the end of the previous
results that returned the \code{nextToken} value. This value is \code{null} when
there are no more results to return.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.}
}
\description{
Returns a list of AWS Batch jobs.
}
\details{
You must specify only one of the following:
\itemize{
\item a job queue ID to return a list of jobs in that job queue
\item a multi-node parallel job ID to return a list of that job\'s nodes
\item an array job ID to return a list of that job\'s children
}

You can filter the results by job status with the \code{jobStatus} parameter.
If you do not specify a status, only \code{RUNNING} jobs are returned.
}
\section{Request syntax}{
\preformatted{svc$list_jobs(
  jobQueue = "string",
  arrayJobId = "string",
  multiNodeJobId = "string",
  jobStatus = "SUBMITTED"|"PENDING"|"RUNNABLE"|"STARTING"|"RUNNING"|"SUCCEEDED"|"FAILED",
  maxResults = 123,
  nextToken = "string"
)
}
}

\examples{
\dontrun{
# This example lists the running jobs in the HighPriority job queue.
svc$list_jobs(
  jobQueue = "HighPriority"
)

# This example lists jobs in the HighPriority job queue that are in the
# SUBMITTED job status.
svc$list_jobs(
  jobQueue = "HighPriority",
  jobStatus = "SUBMITTED"
)
}

}
\keyword{internal}
