% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_update_job_queue}
\alias{batch_update_job_queue}
\title{Updates a job queue}
\usage{
batch_update_job_queue(jobQueue, state, priority,
  computeEnvironmentOrder)
}
\arguments{
\item{jobQueue}{[required] The name or the Amazon Resource Name (ARN) of the job queue.}

\item{state}{Describes the queue\'s ability to accept new jobs.}

\item{priority}{The priority of the job queue. Job queues with a higher priority (or a
higher integer value for the \code{priority} parameter) are evaluated first
when associated with the same compute environment. Priority is
determined in descending order, for example, a job queue with a priority
value of \code{10} is given scheduling preference over a job queue with a
priority value of \code{1}.}

\item{computeEnvironmentOrder}{Details the set of compute environments mapped to a job queue and their
order relative to each other. This is one of the parameters used by the
job scheduler to determine which compute environment should execute a
given job.}
}
\description{
Updates a job queue.
}
\section{Request syntax}{
\preformatted{svc$update_job_queue(
  jobQueue = "string",
  state = "ENABLED"|"DISABLED",
  priority = 123,
  computeEnvironmentOrder = list(
    list(
      order = 123,
      computeEnvironment = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# This example disables a job queue so that it can be deleted.
svc$update_job_queue(
  jobQueue = "GPGPU",
  state = "DISABLED"
)
}

}
\keyword{internal}
