% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_key_pair}
\alias{ec2_create_key_pair}
\title{Creates a 2048-bit RSA key pair with the specified name}
\usage{
ec2_create_key_pair(KeyName, DryRun)
}
\arguments{
\item{KeyName}{[required] A unique name for the key pair.

Constraints: Up to 255 ASCII characters}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a 2048-bit RSA key pair with the specified name. Amazon EC2
stores the public key and displays the private key for you to save to a
file. The private key is returned as an unencrypted PEM encoded PKCS\\#1
private key. If a key with the specified name already exists, Amazon EC2
returns an error.
}
\details{
You can have up to five thousand key pairs per Region.

The key pair returned to you is available only in the Region in which
you create it. If you prefer, you can create your own key pair using a
third-party tool and upload it to any Region using ImportKeyPair.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html}{Key Pairs}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_key_pair(
  KeyName = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example creates a key pair named my-key-pair.
svc$create_key_pair(
  KeyName = "my-key-pair"
)
}

}
\keyword{internal}
