% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_put_account_setting}
\alias{ecs_put_account_setting}
\title{Modifies an account setting}
\usage{
ecs_put_account_setting(name, value, principalArn)
}
\arguments{
\item{name}{[required] The Amazon ECS resource name for which to modify the account setting. If
\code{serviceLongArnFormat} is specified, the ARN for your Amazon ECS
services is affected. If \code{taskLongArnFormat} is specified, the ARN and
resource ID for your Amazon ECS tasks is affected. If
\code{containerInstanceLongArnFormat} is specified, the ARN and resource ID
for your Amazon ECS container instances is affected. If \code{awsvpcTrunking}
is specified, the elastic network interface (ENI) limit for your Amazon
ECS container instances is affected. If \code{containerInsights} is
specified, the default setting for CloudWatch Container Insights for
your clusters is affected.}

\item{value}{[required] The account setting value for the specified principal ARN. Accepted
values are \code{enabled} and \code{disabled}.}

\item{principalArn}{The ARN of the principal, which can be an IAM user, IAM role, or the
root user. If you specify the root user, it modifies the account setting
for all IAM users, IAM roles, and the root user of the account unless an
IAM user or role explicitly overrides these settings. If this field is
omitted, the setting is changed only for the authenticated user.}
}
\description{
Modifies an account setting. Account settings are set on a per-Region
basis.
}
\details{
If you change the account setting for the root user, the default
settings for all of the IAM users and roles for which no individual
account setting has been specified are reset. For more information, see
\href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html}{Account Settings}
in the \emph{Amazon Elastic Container Service Developer Guide}.

When \code{serviceLongArnFormat}, \code{taskLongArnFormat}, or
\code{containerInstanceLongArnFormat} are specified, the Amazon Resource Name
(ARN) and resource ID format of the resource type for a specified IAM
user, IAM role, or the root user for an account is affected. The opt-in
and opt-out account setting must be set for each Amazon ECS resource
separately. The ARN and resource ID format of a resource will be defined
by the opt-in status of the IAM user or role that created the resource.
You must enable this setting to use Amazon ECS features such as resource
tagging.

When \code{awsvpcTrunking} is specified, the elastic network interface (ENI)
limit for any new container instances that support the feature is
changed. If \code{awsvpcTrunking} is enabled, any new container instances
that support the feature are launched have the increased ENI limits
available to them. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-eni.html}{Elastic Network Interface Trunking}
in the \emph{Amazon Elastic Container Service Developer Guide}.

When \code{containerInsights} is specified, the default setting indicating
whether CloudWatch Container Insights is enabled for your clusters is
changed. If \code{containerInsights} is enabled, any new clusters that are
created will have Container Insights enabled unless you disable it
during cluster creation. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html}{CloudWatch Container Insights}
in the \emph{Amazon Elastic Container Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$put_account_setting(
  name = "serviceLongArnFormat"|"taskLongArnFormat"|"containerInstanceLongArnFormat"|"awsvpcTrunking"|"containerInsights",
  value = "string",
  principalArn = "string"
)
}
}

\examples{
\dontrun{
# This example modifies your account settings to opt in to the new ARN and
# resource ID format for Amazon ECS services. If youâ€™re using this command
# as the root user, then changes apply to the entire AWS account, unless
# an IAM user or role explicitly overrides these settings for themselves.
svc$put_account_setting(
  name = "serviceLongArnFormat",
  value = "enabled"
)

# This example modifies the account setting for a specific IAM user or IAM
# role to opt in to the new ARN and resource ID format for Amazon ECS
# container instances. If youâ€™re using this command as the root user, then
# changes apply to the entire AWS account, unless an IAM user or role
# explicitly overrides these settings for themselves.
svc$put_account_setting(
  name = "containerInstanceLongArnFormat",
  value = "enabled",
  principalArn = "arn:aws:iam::<aws_account_id>:user/principalName"
)
}

}
\keyword{internal}
