% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_nat_gateway}
\alias{ec2_create_nat_gateway}
\title{Creates a NAT gateway in the specified public subnet}
\usage{
ec2_create_nat_gateway(AllocationId, ClientToken, DryRun, SubnetId,
  TagSpecifications)
}
\arguments{
\item{AllocationId}{[required] The allocation ID of an Elastic IP address to associate with the NAT
gateway. If the Elastic IP address is associated with another resource,
you must first disassociate it.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.

Constraint: Maximum 64 ASCII characters.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SubnetId}{[required] The subnet in which to create the NAT gateway.}

\item{TagSpecifications}{The tags to assign to the NAT gateway.}
}
\description{
Creates a NAT gateway in the specified public subnet. This action
creates a network interface in the specified subnet with a private IP
address from the IP address range of the subnet. Internet-bound traffic
from a private subnet can be routed to the NAT gateway, therefore
enabling instances in the private subnet to connect to the internet. For
more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html}{NAT Gateways}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_nat_gateway(
  AllocationId = "string",
  ClientToken = "string",
  DryRun = TRUE|FALSE,
  SubnetId = "string",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\examples{
\dontrun{
# This example creates a NAT gateway in subnet subnet-1a2b3c4d and
# associates an Elastic IP address with the allocation ID
# eipalloc-37fc1a52 with the NAT gateway.
svc$create_nat_gateway(
  AllocationId = "eipalloc-37fc1a52",
  SubnetId = "subnet-1a2b3c4d"
)
}

}
\keyword{internal}
