% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_traffic_mirror_target}
\alias{ec2_create_traffic_mirror_target}
\title{Creates a target for your Traffic Mirror session}
\usage{
ec2_create_traffic_mirror_target(NetworkInterfaceId,
  NetworkLoadBalancerArn, Description, TagSpecifications, DryRun,
  ClientToken)
}
\arguments{
\item{NetworkInterfaceId}{The network interface ID that is associated with the target.}

\item{NetworkLoadBalancerArn}{The Amazon Resource Name (ARN) of the Network Load Balancer that is
associated with the target.}

\item{Description}{The description of the Traffic Mirror target.}

\item{TagSpecifications}{The tags to assign to the Traffic Mirror target.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.}
}
\description{
Creates a target for your Traffic Mirror session.
}
\details{
A Traffic Mirror target is the destination for mirrored traffic. The
Traffic Mirror source and the Traffic Mirror target (monitoring
appliances) can be in the same VPC, or in different VPCs connected via
VPC peering or a transit gateway.

A Traffic Mirror target can be a network interface, or a Network Load
Balancer.

To use the target in a Traffic Mirror session, use
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm}{CreateTrafficMirrorSession}.
}
\section{Request syntax}{
\preformatted{svc$create_traffic_mirror_target(
  NetworkInterfaceId = "string",
  NetworkLoadBalancerArn = "string",
  Description = "string",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  DryRun = TRUE|FALSE,
  ClientToken = "string"
)
}
}

\keyword{internal}
