% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_vpc_endpoint_service_configuration}
\alias{ec2_create_vpc_endpoint_service_configuration}
\title{Creates a VPC endpoint service configuration to which service consumers
(AWS accounts, IAM users, and IAM roles) can connect}
\usage{
ec2_create_vpc_endpoint_service_configuration(DryRun,
  AcceptanceRequired, PrivateDnsName, NetworkLoadBalancerArns,
  ClientToken, TagSpecifications)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{AcceptanceRequired}{Indicates whether requests from service consumers to create an endpoint
to your service must be accepted. To accept a request, use
AcceptVpcEndpointConnections.}

\item{PrivateDnsName}{The private DNS name to assign to the VPC endpoint service.}

\item{NetworkLoadBalancerArns}{[required] The Amazon Resource Names (ARNs) of one or more Network Load Balancers
for your service.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.}

\item{TagSpecifications}{The tags to associate with the service.}
}
\description{
Creates a VPC endpoint service configuration to which service consumers
(AWS accounts, IAM users, and IAM roles) can connect. Service consumers
can create an interface VPC endpoint to connect to your service.
}
\details{
To create an endpoint service configuration, you must first create a
Network Load Balancer for your service. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html}{VPC Endpoint Services}
in the \emph{Amazon Virtual Private Cloud User Guide}.

If you set the private DNS name, you must prove that you own the private
DNS domain name. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html}{VPC Endpoint Service Private DNS Name Verification}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_vpc_endpoint_service_configuration(
  DryRun = TRUE|FALSE,
  AcceptanceRequired = TRUE|FALSE,
  PrivateDnsName = "string",
  NetworkLoadBalancerArns = list(
    "string"
  ),
  ClientToken = "string",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
