% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_enable_vgw_route_propagation}
\alias{ec2_enable_vgw_route_propagation}
\title{Enables a virtual private gateway (VGW) to propagate routes to the
specified route table of a VPC}
\usage{
ec2_enable_vgw_route_propagation(GatewayId, RouteTableId, DryRun)
}
\arguments{
\item{GatewayId}{[required] The ID of the virtual private gateway that is attached to a VPC. The
virtual private gateway must be attached to the same VPC that the
routing tables are associated with.}

\item{RouteTableId}{[required] The ID of the route table. The routing table must be associated with the
same VPC that the virtual private gateway is attached to.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Enables a virtual private gateway (VGW) to propagate routes to the
specified route table of a VPC.
}
\section{Request syntax}{
\preformatted{svc$enable_vgw_route_propagation(
  GatewayId = "string",
  RouteTableId = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example enables the specified virtual private gateway to propagate
# static routes to the specified route table.
svc$enable_vgw_route_propagation(
  GatewayId = "vgw-9a4cacf3",
  RouteTableId = "rtb-22574640"
)
}

}
\keyword{internal}
