% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_withdraw_byoip_cidr}
\alias{ec2_withdraw_byoip_cidr}
\title{Stops advertising an address range that is provisioned as an address
pool}
\usage{
ec2_withdraw_byoip_cidr(Cidr, DryRun)
}
\arguments{
\item{Cidr}{[required] The address range, in CIDR notation.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Stops advertising an address range that is provisioned as an address
pool.
}
\details{
You can perform this operation at most once every 10 seconds, even if
you specify different address ranges each time.

It can take a few minutes before traffic to the specified addresses
stops routing to AWS because of BGP propagation delays.
}
\section{Request syntax}{
\preformatted{svc$withdraw_byoip_cidr(
  Cidr = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
