% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_managed_prefix_lists}
\alias{ec2_describe_managed_prefix_lists}
\title{Describes your managed prefix lists and any Amazon Web Services-managed
prefix lists}
\usage{
ec2_describe_managed_prefix_lists(
  DryRun = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  PrefixListIds = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{One or more filters.
\itemize{
\item \code{owner-id} - The ID of the prefix list owner.
\item \code{prefix-list-id} - The ID of the prefix list.
\item \code{prefix-list-name} - The name of the prefix list.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{PrefixListIds}{One or more prefix list IDs.}
}
\description{
Describes your managed prefix lists and any Amazon Web Services-managed prefix lists.

See \url{https://paws-r.github.io/docs/ec2/describe_managed_prefix_lists.html} for full documentation.
}
\keyword{internal}
