% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_vpc_endpoint_service_permissions}
\alias{ec2_describe_vpc_endpoint_service_permissions}
\title{Describes the principals (service consumers) that are permitted to
discover your VPC endpoint service}
\usage{
ec2_describe_vpc_endpoint_service_permissions(
  DryRun = NULL,
  ServiceId,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ServiceId}{[required] The ID of the service.}

\item{Filters}{One or more filters.
\itemize{
\item \code{principal} - The ARN of the principal.
\item \code{principal-type} - The principal type (\code{All} | \code{Service} |
\code{OrganizationUnit} | \code{Account} | \code{User} | \code{Role}).
}}

\item{MaxResults}{The maximum number of results to return for the request in a single
page. The remaining results of the initial request can be seen by
sending another request with the returned \code{NextToken} value. This value
can be between 5 and 1,000; if \code{MaxResults} is given a value larger than
1,000, only 1,000 results are returned.}

\item{NextToken}{The token to retrieve the next page of results.}
}
\description{
Describes the principals (service consumers) that are permitted to discover your VPC endpoint service.

See \url{https://paws-r.github.io/docs/ec2/describe_vpc_endpoint_service_permissions.html} for full documentation.
}
\keyword{internal}
