% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_start_network_insights_analysis}
\alias{ec2_start_network_insights_analysis}
\title{Starts analyzing the specified path}
\usage{
ec2_start_network_insights_analysis(
  NetworkInsightsPathId,
  FilterInArns = NULL,
  DryRun = NULL,
  TagSpecifications = NULL,
  ClientToken
)
}
\arguments{
\item{NetworkInsightsPathId}{[required] The ID of the path.}

\item{FilterInArns}{The Amazon Resource Names (ARN) of the resources that the path must
traverse.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{TagSpecifications}{The tags to apply.}

\item{ClientToken}{[required] Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to ensure idempotency}.}
}
\description{
Starts analyzing the specified path. If the path is reachable, the operation returns the shortest feasible path.

See \url{https://paws-r.github.io/docs/ec2/start_network_insights_analysis.html} for full documentation.
}
\keyword{internal}
