% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_stop_instances}
\alias{ec2_stop_instances}
\title{Stops an Amazon EBS-backed instance}
\usage{
ec2_stop_instances(InstanceIds, Hibernate = NULL, DryRun = NULL, Force = NULL)
}
\arguments{
\item{InstanceIds}{[required] The IDs of the instances.}

\item{Hibernate}{Hibernates the instance if the instance was enabled for hibernation at
launch. If the instance cannot hibernate successfully, a normal shutdown
occurs. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html}{Hibernate your instance}
in the \emph{Amazon EC2 User Guide}.

Default: \code{false}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Force}{Forces the instances to stop. The instances do not have an opportunity
to flush file system caches or file system metadata. If you use this
option, you must perform file system check and repair procedures. This
option is not recommended for Windows instances.

Default: \code{false}}
}
\description{
Stops an Amazon EBS-backed instance. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html}{Stop and start your instance} in the \emph{Amazon EC2 User Guide}.

See \url{https://paws-r.github.io/docs/ec2/stop_instances.html} for full documentation.
}
\keyword{internal}
