% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_tag_resource}
\alias{eks_tag_resource}
\title{Associates the specified tags to a resource with the specified
resourceArn}
\usage{
eks_tag_resource(resourceArn, tags)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the resource to which to add tags.
Currently, the supported resources are Amazon EKS clusters and managed
node groups.}

\item{tags}{[required] The tags to add to the resource. A tag is an array of key-value pairs.}
}
\description{
Associates the specified tags to a resource with the specified \code{resourceArn}. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well. Tags that you create for Amazon EKS resources do not propagate to any other resources associated with the cluster. For example, if you tag a cluster with this operation, that tag does not automatically propagate to the subnets and nodes associated with the cluster.

See \url{https://paws-r.github.io/docs/eks/tag_resource.html} for full documentation.
}
\keyword{internal}
