% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_list_platform_branches}
\alias{elasticbeanstalk_list_platform_branches}
\title{Lists the platform branches available for your account in an AWS Region}
\usage{
elasticbeanstalk_list_platform_branches(
  Filters = NULL,
  MaxRecords = NULL,
  NextToken = NULL
)
}
\arguments{
\item{Filters}{Criteria for restricting the resulting list of platform branches. The
filter is evaluated as a logical conjunction (AND) of the separate
\code{SearchFilter} terms.

The following list shows valid attribute values for each of the
\code{SearchFilter} terms. Most operators take a single value. The \verb{in} and
\code{not_in} operators can take multiple values.
\itemize{
\item \code{Attribute = BranchName}:
\itemize{
\item \code{Operator}: \code{=} | \code{!=} | \code{begins_with} | \code{ends_with} |
\code{contains} | \verb{in} | \code{not_in}
}
\item \code{Attribute = LifecycleState}:
\itemize{
\item \code{Operator}: \code{=} | \code{!=} | \verb{in} | \code{not_in}
\item \code{Values}: \code{beta} | \code{supported} | \code{deprecated} | \code{retired}
}
\item \code{Attribute = PlatformName}:
\itemize{
\item \code{Operator}: \code{=} | \code{!=} | \code{begins_with} | \code{ends_with} |
\code{contains} | \verb{in} | \code{not_in}
}
\item \code{Attribute = TierType}:
\itemize{
\item \code{Operator}: \code{=} | \code{!=}
\item \code{Values}: \code{WebServer/Standard} | \code{Worker/SQS/HTTP}
}
}

Array size: limited to 10 \code{SearchFilter} objects.

Within each \code{SearchFilter} item, the \code{Values} array is limited to 10
items.}

\item{MaxRecords}{The maximum number of platform branch values returned in one call.}

\item{NextToken}{For a paginated request. Specify a token from a previous response page
to retrieve the next response page. All other parameter values must be
identical to the ones specified in the initial request.

If no \code{NextToken} is specified, the first page is retrieved.}
}
\description{
Lists the platform branches available for your account in an AWS Region. Provides summary information about each platform branch.

See \url{https://paws-r.github.io/docs/elasticbeanstalk/list_platform_branches.html} for full documentation.
}
\keyword{internal}
