% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_list_event_source_mappings}
\alias{lambda_list_event_source_mappings}
\title{Lists event source mappings}
\usage{
lambda_list_event_source_mappings(
  EventSourceArn = NULL,
  FunctionName = NULL,
  Marker = NULL,
  MaxItems = NULL
)
}
\arguments{
\item{EventSourceArn}{The Amazon Resource Name (ARN) of the event source.
\itemize{
\item \strong{Amazon Kinesis} - The ARN of the data stream or a stream
consumer.
\item \strong{Amazon DynamoDB Streams} - The ARN of the stream.
\item \strong{Amazon Simple Queue Service} - The ARN of the queue.
\item \strong{Amazon Managed Streaming for Apache Kafka} - The ARN of the
cluster.
}}

\item{FunctionName}{The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{MyFunction}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Version or Alias ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD}.
\item \strong{Partial ARN} - \verb{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it's limited to 64 characters in length.}

\item{Marker}{A pagination token returned by a previous call.}

\item{MaxItems}{The maximum number of event source mappings to return. Note that
ListEventSourceMappings returns a maximum of 100 items in each response,
even if you set the number higher.}
}
\description{
Lists event source mappings. Specify an \code{EventSourceArn} to only show event source mappings for a single event source.

See \url{https://paws-r.github.io/docs/lambda/list_event_source_mappings.html} for full documentation.
}
\keyword{internal}
