% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_publish_layer_version}
\alias{lambda_publish_layer_version}
\title{Creates an Lambda layer from a ZIP archive}
\usage{
lambda_publish_layer_version(
  LayerName,
  Description = NULL,
  Content,
  CompatibleRuntimes = NULL,
  LicenseInfo = NULL,
  CompatibleArchitectures = NULL
)
}
\arguments{
\item{LayerName}{[required] The name or Amazon Resource Name (ARN) of the layer.}

\item{Description}{The description of the version.}

\item{Content}{[required] The function layer archive.}

\item{CompatibleRuntimes}{A list of compatible \href{https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html}{function runtimes}.
Used for filtering with \code{\link[=lambda_list_layers]{list_layers}} and
\code{\link[=lambda_list_layer_versions]{list_layer_versions}}.}

\item{LicenseInfo}{The layer's software license. It can be any of the following:
\itemize{
\item An \href{https://spdx.org/licenses/}{SPDX license identifier}. For
example, \code{MIT}.
\item The URL of a license hosted on the internet. For example,
\verb{https://opensource.org/licenses/MIT}.
\item The full text of the license.
}}

\item{CompatibleArchitectures}{A list of compatible \href{https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html}{instruction set architectures}.}
}
\description{
Creates an \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html}{Lambda layer} from a ZIP archive. Each time you call \code{\link[=lambda_publish_layer_version]{publish_layer_version}} with the same layer name, a new version is created.

See \url{https://paws-r.github.io/docs/lambda/publish_layer_version.html} for full documentation.
}
\keyword{internal}
