% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apprunner_operations.R
\name{apprunner_update_service}
\alias{apprunner_update_service}
\title{Update an App Runner service}
\usage{
apprunner_update_service(
  ServiceArn,
  SourceConfiguration = NULL,
  InstanceConfiguration = NULL,
  AutoScalingConfigurationArn = NULL,
  HealthCheckConfiguration = NULL,
  NetworkConfiguration = NULL,
  ObservabilityConfiguration = NULL
)
}
\arguments{
\item{ServiceArn}{[required] The Amazon Resource Name (ARN) of the App Runner service that you want
to update.}

\item{SourceConfiguration}{The source configuration to apply to the App Runner service.

You can change the configuration of the code or image repository that
the service uses. However, you can't switch from code to image or the
other way around. This means that you must provide the same structure
member of \code{SourceConfiguration} that you originally included when you
created the service. Specifically, you can include either
\code{CodeRepository} or \code{ImageRepository}. To update the source
configuration, set the values to members of the structure that you
include.}

\item{InstanceConfiguration}{The runtime configuration to apply to instances (scaling units) of your
service.}

\item{AutoScalingConfigurationArn}{The Amazon Resource Name (ARN) of an App Runner automatic scaling
configuration resource that you want to associate with the App Runner
service.}

\item{HealthCheckConfiguration}{The settings for the health check that App Runner performs to monitor
the health of the App Runner service.}

\item{NetworkConfiguration}{Configuration settings related to network traffic of the web application
that the App Runner service runs.}

\item{ObservabilityConfiguration}{The observability configuration of your service.}
}
\description{
Update an App Runner service. You can update the source configuration and instance configuration of the service. You can also update the ARN of the auto scaling configuration resource that's associated with the service. However, you can't change the name or the encryption configuration of the service. These can be set only when you create the service.

See \url{https://www.paws-r-sdk.com/docs/apprunner_update_service/} for full documentation.
}
\keyword{internal}
