% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_verified_access_group}
\alias{ec2_modify_verified_access_group}
\title{Modifies the specified Amazon Web Services Verified Access group
configuration}
\usage{
ec2_modify_verified_access_group(
  VerifiedAccessGroupId,
  VerifiedAccessInstanceId = NULL,
  Description = NULL,
  ClientToken = NULL,
  DryRun = NULL
)
}
\arguments{
\item{VerifiedAccessGroupId}{[required] The ID of the Verified Access group.}

\item{VerifiedAccessInstanceId}{The ID of the Verified Access instance.}

\item{Description}{A description for the Verified Access group.}

\item{ClientToken}{A unique, case-sensitive token that you provide to ensure idempotency of
your modification request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Modifies the specified Amazon Web Services Verified Access group configuration.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_verified_access_group/} for full documentation.
}
\keyword{internal}
